; CHARACTER BITMAP I/O MODULE
extrn _CHRPAL:DWORD
      ; pointer to the 12 RGB palette entries describing the values
      ; of the 12 "character set palette entries" the loaded character set
      ; will use.
      ; The palette entries uses the indexes from BRIGHT1_TEXT to BRIGHT6_TEXT
      ; and from DARK1_TEXT to DARK6_TEXT
      ;

extrn _CHRFNT:DWORD
      ; pointer to the current character bitmap buffer
      ; (a block of 8Kbytes containing the bitmaps of 128 ascii chars)

extrn _CHRMENU1:DWORD
      ; first character set
extrn _CHRMENU2:DWORD
      ; second character set (derived from the first set)

extrn _LoadCharSet:near
        ; esi = pointer to filename containing the "base" character set
        ; it sets _CHRFONT,_CHRMENU1,_CHRMENU2,and the text color palette
        ; entries.

extrn _PutString:near
         ; edi = screen base
         ; eax = x in pixels
         ; edx = y in pixels
         ; ebx = stringz

extrn _PutHex: near
         ; scrive il numero BCD a 32 bit
         ; contenuto in ebx
         ; edi = screen dest
         ; eax = x in pixels
         ; edx = y in pixels
         ; ecx = digits to use
         ; ebx = number to write

extrn _PutInt: near
         ; scrive il numero BCD a 32 bit
         ; contenuto in ebx
         ; edi = screen dest
         ; eax = x in pixels
         ; edx = y in pixels
         ; ecx = digits to use
         ; ebx = integer number to write

extrn _PutUnsigned: near
         ; scrive il numero BCD a 32 bit
         ; contenuto in ebx
         ; edi = screen dest
         ; eax = x in pixels
         ; edx = y in pixels
         ; ecx = digits to use
         ; ebx = unsigned integer number to write
         
extrn _GetString: near
        ; edi= scr dest
        ; eax= x in pixels
        ; edx= y in pixels
        ; ecx= max. string size (excluding terminal NUL )
        ; ebx= stringz (gets automatically truncated to NUL on entry)
        ;      must point to a sequence of at least ecx+1 bytes

extrn _GetInt: near
        ; in:
        ; edi= scr dest
        ; eax= x in pixels
        ; edx= y in pixels
        ; ecx= max. digits including sign (cut to 11 digits if bigger)
        ; out:
        ; ebx= returned value , in the range +/- 1999999999
        ;      if you enter values out of range, the procedure
        ;      will retry automatically

extrn _GetUnsigned: near
        ; in:
        ; edi= scr dest
        ; eax= x in pixels
        ; edx= y in pixels
        ; ecx= max. digits (cut to 10 if bigger)
        ; out:
        ; ebx= returned value , in the range 0..3999999999
        ;      if you enter values out of range, the procedure
        ;      will retry automatically


; special codes for XGE character bitmaps

; BAR display
BAR1=1
BAR2=2
BAR3=3
BAR4=4
BAR5=5
BAR6=6
BAR7=7
BAR8=8
ARROW_MINUS=9
ARROW_PLUS=10

; ON/OFF flags
FLAG_OFF=11
FLAG_ON=12

; various symbols
COPYRIGHT=13
YEN=14
LIRA=15
BAR0=16
CROSS=17
MARINE_CROSS=18
HALFMOON=19
YINGYANG=20
DAVID_STAR=21
MILITARY_STAR=22
USSR_SIGN=23

SKULL=24
SAD_FACE=25
NORMAL_FACE=26
HAPPY_FACE=27
WINKY_FACE=28
ANGRY_FACE=29

POINT0=30  ;  the "->" pointer is composed of POINT0 and POINT1
POINT1=31  ;

CURSOR=127 ; text cursor

