; modulo per la visualizzazione di bitmap Pcx 320x200
; a 256 colori
.386P

code32 segment para public use32
       assume cs:code32,ds:code32
       
include 386power.inc
include 386video.inc
include 386file.inc
include palette.inc

        public _Pcx2Scr
        public _PcxDecoded,_PcxHasPalette
        public _PcxLoad        
        align byte
; Palette extracted from last Pcx file read       
PicPal        db 768 dup(0)

_PcxDecoded    db 0
_PcxHasPalette db 0

Pcx_len   dd 0
Pcx_start dd 0
Pcx_buf   dd 80 dup(0)

_Pcx2Scr:
        ; esi = Pcx data buffer base for a 320x200 Pcx image
        ; eax = Pcx file lenght
        ; expands the 320x200 Pcx image to _ActivePage
        ; starting from coordinates (0,0) to (319,181)
        ; [ Yeah! it cuts it to 320x182 !!!]
        ; remeber to set _DisplayStart to (0,0) before calling this
        pushad
        
        mov Pcx_len,eax
        mov Pcx_start,esi
        mov _PcxDecoded,0    ; still have to decode it
        mov _PcxHasPalette,0 ; still have to read palette
        cmp dword ptr [esi],0801050Ah ; 8 bit/pix, RLE, Ver. 5, Pcx ???
        jne Pcx_err  ; no, get out!
        cmp byte ptr [esi+ 65],01     ; one plane ?
        jne Pcx_err  ; no, get out!
        
        movzx eax,word ptr [esi+66] ; bytes * scanline
        cmp eax,320
        jne Pcx_err ; image too big
        
        movsx eax, word ptr [esi+10] ; ymax
        movsx ebx, word ptr [esi+6 ] ; ymin
        sub eax,ebx
        inc eax
        cmp eax,200
        jne Pcx_err
        
        xor ecx,ecx
        add esi,128  ; go to Pcx data block
        mov edx,0
@yPcx:  mov edi,offset Pcx_buf
        mov eax,0
@xPcx:
        mov bl,[esi]
        mov cl,bl
        inc esi
        cmp bl,0C0h   ; last 64 colors ?
        jnb @Pcxburst ; then this is a RLE burst
        ; else it is a single byte
        mov [edi],cl
        inc eax
        inc edi
        cmp eax,320
        jb @xPcx
        jmp @linne
                
@Pcxburst:
        mov cl,[esi]
        and ebx,03Fh    ; get count value
        inc esi
        add ebx,eax     ; x value to stop at
buurst: mov [edi],cl
        inc eax
        inc edi
        cmp eax,ebx
        jb buurst
        cmp eax,320
        jb @xPcx
@linne: ; new line of Pcx file

        pushad
        ; blit the line buffered into Pcx_buf
        ; edx =  y in pixels
        mov ebx,_ActiveBase
        mov ebp,offset Pcx_buf
        add ebx,[edx*4+_RowStart]
        BLITMODE BLITPLANE
        mov ax,WP0
        mov cl,bl
        mov dx,SEQUENCER
        
        out dx,ax
        mov esi,ebp
        mov edi,ebx
        mov ecx,80
pcx0:
        lodsd
        stosb
        loop pcx0
        
        mov ax,WP1
        out dx,ax
        mov esi,ebp
        mov edi,ebx
        mov ecx,80
pcx1:
        lodsd
        mov al,ah
        stosb
        loop pcx1
        
        mov ax,WP2
        out dx,ax        
        mov esi,ebp
        mov edi,ebx
        mov ecx,80
pcx2:
        lodsd
        shr eax,16
        stosb
        loop pcx2
        
        mov ax,WP3
        out dx,ax
        mov esi,ebp
        mov edi,ebx
        mov ecx,80
pcx3:
        lodsd
        rol eax,8
        stosb
        loop pcx3
        
        popad
        ; now go to next line
        
        inc edx
        cmp edx,182
        jb @yPcx
        
        ; now look for palette data and extract it
        mov esi,Pcx_start
        add esi,Pcx_len
        sub esi,769
        cmp byte ptr [esi],12
        jne @paldone
        mov _PcxHasPalette,1
        inc esi
        mov edi,offset PicPal
        mov ecx,192
  pcx2vgapal:    
        lodsd
        and eax,0FCFCFCFCh ; "cut" the lower bits
        shr eax,2
        stosd
        loop pcx2vgapal
        mov esi, offset PicPal
        call _Set256Palette
@paldone:
        ; Pcx file fully decode
        mov _PcxDecoded,1      
Pcx_err:
        popad
        ret
                
_PcxLoad: ; DS:ESI == ASCIIZ name of Pcx file to load
          ;
          pushad
          call _FLoad
          jc loaderr
          push eax
          mov eax,0
          mov edx,0
          call _DisplayStart
          call _PageFlip
          pop eax
          mov esi,_HiMemBase
          call _Pcx2Scr
   loaderr:       
          popad
          ret
          
code32 ends

 END
