#ifndef __VEC3_HEADER__
#define __VEC3_HEADER__

#include <iostream>

typedef struct { double x,y,z; } vec3;


inline vec3 operator - (const vec3& a)	//-a
{ vec3 c = { -a.x, -a.y, -a.z }; return c; }

inline vec3 operator + (const vec3& a, const vec3& b)	//a+b
{ vec3 c = { a.x+b.x, a.y+b.y, a.z+b.z }; return c; }

inline vec3 operator - (const vec3& a, const vec3& b) //a-b
{ vec3 c = {a.x-b.x, a.y-b.y, a.z-b.z }; return c; }

inline vec3 operator * (const vec3& a, const double b) //a*3.0
{ vec3 c = { a.x*b, a.y*b, a.z*b }; return c; }

inline vec3 operator * (const double a, const vec3& b) //3.0*b
{ return b*a; }

inline double operator * (const vec3& a, const vec3& b) //dot(a,b)
{ return a.x*b.x + a.y*b.y + a.z*b.z; }

inline vec3 operator / (const vec3& a, const double b) //a/3.0
{ vec3 c = { a.x/b, a.y/b, a.z/b }; return c; }

inline int operator == (const vec3& a, const vec3& b) //a==b ?
{ return (a.x==b.x)&&(a.y==b.y)&&(a.z==b.z); }

inline int operator != (const vec3& a, const vec3& b) // a!=b ?
{ return !(a==b); }

inline double length2 (const vec3& a)
{ return a.x*a.x + a.y*a.y + a.z*a.z; }

inline double length (const vec3& a)
{ return sqrt(length2(a)); }

inline vec3 normalize (const vec3& a)
{ double c = length(a); return a/c; }
	
inline vec3 cross (const vec3& a, const vec3& b)
{
	vec3 c = { a.y * b.z - a.z * b.y,
               a.z * b.x - a.x * b.z,
               a.x * b.y - a.y * b.x };
	return c;
}
              
inline ostream& operator << (ostream& s, const vec3 a)
{ return s << "| " << a.x << ' ' << a.y << ' ' << a.z << " |"; }

inline void operator += (vec3& a, const vec3& b)	// a+=b
{ a.x+=b.x; a.y+=b.y; a.z+=b.z; }

inline void operator -= (vec3& a, const vec3& b) //a-=b
{ a.x-=b.x;	a.y-=b.y; a.z-=b.z; }

inline void operator *= (vec3& a, const double b)	//a*=3.0
{ a.x*=b; a.y*=b; a.z*=b; }

#endif
