#!/usr/bin/python3

import os
from time import sleep
import datetime
import requests
from bs4 import BeautifulSoup
import sqlite3
import countries

#countries = [ 'GR','Greece']

dbconn = None

def connect(filename):
  conn = None
  try:
    conn = sqlite3.connect(filename)
    return conn
  except Error as e:
    print(e)
 
  return conn
  
def create_table(conn, create_table_sql):
  """ create a table from the create_table_sql statement
  :param conn: Connection object
  :param create_table_sql: a CREATE TABLE statement
  :return:
  """
  try:
    c = conn.cursor()
    c.execute(create_table_sql)
  except Error as e:
    print(e)
    
def country_table(conn,code):
  sql_country = """CREATE TABLE IF NOT EXISTS """+code+""" (
                                        id varchar(10) PRIMARY KEY,
                                        call varchar(12) NOT NULL,
                                        commands varchar(100),
                                        uplink varchar(20),
                                        echolink varchar(30),
                                        node varchar(10),
                                        widenet varchar(20),
                                        ipsc varchar(20),
                                        dmrid varchar(10),
                                        color_code varchar(4),
                                        notes varchar(100),
                                        mode varchar(20),
                                        weblinks varchar(200),
                                        uplink_tone varchar(20),
                                        downlink varchar(20),
                                        downlink_tone varchar(20),
                                        features varchar(30),
                                        offset varchar(20),
                                        coverage varchar(50),
                                        affiliate varchar(50),
                                        use varchar(10),
                                        status varchar(12),
                                        city varchar(30),
                                        long varchar(15),
                                        lat varchar(15),
                                        date varchar(20));
  """
  if conn is not None:
    create_table(conn, sql_country)
  else:
    print("Error! cannot create the database connection.")    

def getcountry(country):
  global dbconn
  rid = ''
  call = ''
  commands = ''
  uplink = ''
  echolink = ''
  node = ''
  widenet = ''
  ipsc = ''
  dmrid = ''
  color_code = ''
  notes = ''
  mode = ''
  weblinks = ''
  uplink_tone = ''
  downlink = ''
  downlink_tone = ''
  features = ''
  offset = ''
  coverage = ''
  affiliate = ''
  use = ''
  status = ''
  location = ''
  longt = ''
  lat = ''
  url = "https://www.repeaterbook.com/row_repeaters/Display_SS.php?state_id="+country+"&band=%&freq=%&band6=%&loc=%&call=%&status_id=%&features=%&system=%&coverage=%&use=%"
  page = requests.get(url)
  print('.')
  if page.status_code != 200:
    print('Could not retrieve webpage...')
    return -1
  
  country_table(dbconn, country)
  soup = BeautifulSoup(page.text, 'html.parser')
  page = soup.prettify()
  page= page.split('\n')
  i = len(page)-1
  while i>0:
    if page[i].find('details.php') > -1:
      s = page[i]
      s = s.split('"')
      rep = 'https://www.repeaterbook.com/row_repeaters/'+s[1]
      rep = rep.replace('&amp;','&')
      rid = country+'-'+"".join(s[1].split('=')[-1:])
      rpage = requests.get(rep)
      print(rid)
      if rpage.status_code == 200:
        
        rsoup = BeautifulSoup(rpage.text, 'html.parser')
        location = rsoup.find('h1').get_text()
        
        cells = rsoup.find_all('script')
        for k in range(len(cells)):
          if 'CENTER: [' in cells[k].get_text().upper():
            lat = cells[k].get_text().split(',')[1].split('[')[1].strip()
            longt = cells[k].get_text().split(',')[2].split(']')[0].strip()
        cells = rsoup.find_all('td')
        mode = ""
        k = -1
        while k<len(cells)-1:
          k+=1
          if 'UPLINK:' in cells[k].get_text().upper():
            uplink =cells[k+1].get_text().strip()
          if 'UPLINK TONE:' in cells[k].get_text().upper():
            uplink_tone = cells[k+1].get_text().strip()
          if 'DOWNLINK:' in cells[k].get_text().upper():
            downlink = cells[k+1].get_text().strip()
          if 'DOWNLINK TONE:' in cells[k].get_text().upper():
            downlink_tone = cells[k+1].get_text().strip()
          if 'OFFSET:' in cells[k].get_text().upper():
            offset = cells[k+1].get_text().strip()
          if 'FEATURES:' in cells[k].get_text().upper():
            features = cells[k+1].get_text().strip()
          if 'CALL:' in cells[k].get_text().upper():
            call = cells[k+1].get_text().strip()
          if 'USE:' in cells[k].get_text().upper():
            use=cells[k+1].get_text().strip()
          if 'OP STATUS:' in cells[k].get_text().upper():
            status = cells[k+1].get_text().strip()
          if 'COVERAGE:' in cells[k].get_text().upper():
            coverage = cells[k+1].get_text().strip()
          if 'AFFILIATE:' in cells[k].get_text().upper():
            affiliate = cells[k+1].get_text().strip()
          if 'COMMANDS:' in cells[k].get_text().upper():
            commands = cells[k+1].get_text().strip()
          if 'WEB LINKS:' in cells[k].get_text().upper():
            weblinks = cells[k+1].get_text().strip()
          if 'NOTES:' in cells[k].get_text().upper():
            notes = cells[k+1].get_text().strip()
          if 'DMR Enabled' in cells[k].get_text():
            mode += " DMR"
          if 'COLOR CODE:' in cells[k].get_text().upper():
            color_code = cells[k+1].get_text().strip()
          if 'DMR ID:' in cells[k].get_text().upper():
            dmrid = cells[k+1].get_text().strip()
          if 'IPSC NETWORK:' in cells[k].get_text().upper():
            ipsc = cells[k+1].get_text().strip()
          if 'WIDE NETWORK:' in cells[k].get_text().upper():
            wide = cells[k+1].get_text().strip()
          if 'D-STAR Enabled' in cells[k].get_text():
            mode += " DSTAR"
          if 'NODE:' in cells[k].get_text().upper():
            node = cells[k+1].get_text().strip()
          if 'ECHOLINK:' in cells[k].get_text().upper():
            echolink = cells[k+1].get_text().strip()
        sql = ''' INSERT INTO '''+country+'''(id,call,commands,uplink,echolink,
              node,widenet,ipsc,dmrid,color_code,notes,mode,weblinks,
              uplink_tone,downlink,downlink_tone,features,offset,coverage,
              affiliate,use,status,city,long,lat,date)
              VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) '''
        repeater = []
        repeater.append(rid)
        repeater.append(call)
        repeater.append(commands)
        repeater.append(uplink)
        repeater.append(echolink)
        repeater.append(node)
        repeater.append(widenet)
        repeater.append(ipsc)
        repeater.append(dmrid)
        repeater.append(color_code)
        repeater.append(notes)
        repeater.append(mode)
        repeater.append(weblinks)
        repeater.append(uplink_tone)
        repeater.append(downlink)
        repeater.append(downlink_tone)
        repeater.append(features)
        repeater.append(offset)
        repeater.append(coverage)
        repeater.append(affiliate)
        repeater.append(use)
        repeater.append(status)
        repeater.append(location)
        repeater.append(longt)
        repeater.append(lat)
        repeater.append(datetime.date.today().strftime("%Y%m%d"))
        cur = dbconn.cursor()
        cur.execute(sql, repeater)
        cur.close()
        
    i -= 1
  return 0

database = datetime.date.today().strftime("%Y%m%d")+".sq3"
if os.path.isfile(database):
  os.remove(database)
  
dbconn = connect(database)

for i in range(len(countries.countries) // 2):
  print(countries.countries[i*2+1])
  getcountry(countries.countries[i*2])
  print('')
  sleep(2)
dbconn.commit()
dbconn.close()
print('')
print('Done.')