#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAXLINELENGTH 512

FILE *fp, *fp2;
char line[MAXLINELENGTH];
char orig[MAXLINELENGTH];
int numcmds;

void main()
{
    void GetAns(char *inst, char *def);
    void PrintKeywords(void);
    void DumpInstructions(FILE *foo);

    char *filename = "EFLAG.CFG";
    char tmpstr[MAXLINELENGTH];
    char tmpstr2[MAXLINELENGTH];
    int i;


    if ((fp=fopen(filename, "r")) == NULL)
    {
        if ((fp = fopen(filename, "w+")) == NULL)
        {
            fprintf(stderr, "Error: could not open and/or create\n");
            fprintf(stderr, "Report this to Drew at once or edit\n");
            fprintf(stderr, "the %s by hand\n", filename);
            exit(-1);
        }
    }
    else
    {
        if ((fp2 = fopen("TEMP.CFG", "w+")) == NULL)
        {
            fprintf(stderr, "Error: could not open and/or create\n");
            fprintf(stderr, "Report this to Drew at once or edit\n");
            fprintf(stderr, "the %s by hand\n", filename);
            exit(-1);
        }
    }

    system("cls");

    printf("\
This is the CONFIG program for Enhanced Flag v1.0 by Drew [PWA]\n\n\
There will be exactly FIVE questions plus FOUR for questions for each of\n\
the commands you want to make available while flagging files.  You can run\n\
this program to configure everything, or you can just edit the sample config\n\
file that came with this PPE.\n");

    printf("\n----- Hit Enter to START or Ctrl-C to exit -----\n");
    fgets(line, MAXLINELENGTH, stdin);
    system("cls");

    GetAns("\
OPTION #1\n\n\
Enter the text for your main \"More\" prompt.  This is the first prompt\n\
the user sees when he reaches a page-full when doing a file listing.\n\
It prompts the user to use the arrow keys to select a file, hit RETURN\n\
to continue the listing, or \"N\" to stop.  This text may contain\n\
PCBoard Color Codes.\n\n\
Enter the text or hit RETURN for the default.\n",
"@X0A(@X0C@MINLEFT@@X0A min left), (H)elp, (V)iew, (@X0FSPACE, , @X0A)=Mark, More? @X0A(@X0FESC@X0A)=exit, @X0A(@X0F @X0A)=select, @X07");

    printf("\n----- Hit Enter to CONTINUE or Ctrl-C to exit -----\n");
    fgets(line, MAXLINELENGTH, stdin);
    system("cls");

    GetAns("\
OPTION #2\n\n\
Enter the prompt displayed when using is in \"flag\" (or \"mark\") mode.\n\
When this prompt is displayed, the user has highlighted a file, and usually,\n\
has the options of flagging the file for download, viewing the contents of\n\
the file, and quitting back to the file listing.\n\n\
This text may contain PCBoard Color Codes.  You probably will not want to\n\
specify the text for \"Flag\", \"View\", and other available commands since\n\
that will be entered as part of the configuration for available commands.\n\
(If that was unclear to you, just hit return and you can take a look at the\n\
sample config file after you are done.)\n\n\
Enter the text or hit RETURN for the default.\n",
"@X0A(@X0FESC@X0A)=exit, @X0A(@X0F @X0A)=select, @X07");

    printf("\n----- Hit Enter to CONTINUE or Ctrl-C to exit -----\n");
    fgets(line, MAXLINELENGTH, stdin);
    system("cls");

    GetAns("\
OPTION #3\n\n\
Enter the default PCBoard Color Code for a highlighted file.  Highlighted\n\
files will be highlighted in this color, so you will want to make it stand\n\
out on the screen.\n\n\
Enter the color code or hit RETURN for the default.\n",
"@X78");

    printf("\n----- Hit Enter to CONTINUE or Ctrl-C to exit -----\n");
    fgets(line, MAXLINELENGTH, stdin);
    system("cls");

    GetAns("\
OPTION #4\n\n\
Enter the number of blank spaces you want printed between commands that\n\
that are available while flagging files.  For example, the three default\n\
commands are: \"Flag\", \"View\", and \"Quit\".  This will be printed\n\
after the flag prompt (OPTION #2), with spaces between each one.\n\n\
Enter the number of spaces or hit RETURN for the default.\n",
"2");

    printf("\n----- Hit Enter to CONTINUE or Ctrl-C to exit -----\n");
    fgets(line, MAXLINELENGTH, stdin);
    system("cls");

    GetAns("\
OPTION #5\n\n\
Enter the number of commands you want available at the flag prompt.\n\
The default is 3 commands: \"Flag\", \"View\", and \"Quit\".\n\n\
After this question, for each command you will be prompted FOUR\n\
questions:\n\n\
\t1. The unhighlighted text for the command\n\
\t2. The highlighted text for the command\n\
\t3. A single hotkey character for the command\n\
\t4. What file to display, ppe to run, etc.\n\n\
Enter the number of commands or hit RETURN for the default.\n",
"3");

if (orig != "")
{
    if (line[0] == '\n')
        numcmds = atoi(orig);
    else
        numcmds = atoi(line);
}
else
{
    if (line[0] == '\n')
        numcmds = 3;
    else
        numcmds = atoi(line);
}
if (numcmds <= 0) numcmds = 3;

    printf("\n----- Hit Enter to CONTINUE or Ctrl-C to exit -----\n");
    fgets(line, MAXLINELENGTH, stdin);
    system("cls");


    printf("\
You will now be prompted 4 questions times the number of commands you have\n\
entered in the last question.  These 4 questions consist of:\n\n\
\t1. The unhighlighted text for the command\n\
\t2. The highlighted text for the command\n\
\t3. A single hotkey character for the command\n\
\t4. What file to display, ppe to run, etc.\n\n");

    printf("\n----- Hit Enter to CONTINUE or Ctrl-C to exit -----\n");
    fgets(line, MAXLINELENGTH, stdin);
    system("cls");

    for (i= 0; i< numcmds; i++)
    {
        switch (i+1)
        {
            case 1: sprintf(tmpstr, "%s", "@X0FFlag@X07"); break;
            case 2: sprintf(tmpstr, "%s", "@X0FView@X07"); break;
            case 3: sprintf(tmpstr, "%s", "@X0FQuit@X07"); break;
            default: sprintf(tmpstr, "%s", "@X0FCmd:@X07"); break;
        }

        printf("COMMAND #%d (out of %d)\tQUESTION #1\n\n", i+1, numcmds);
    GetAns("\
Enter the UNHIGHLIGHTED text for the first command.  This text may include\n\
PCBoard Color Codes.\n\n\
Enter text or hit RETURN for the default.\n", tmpstr);

        printf("\n----- Hit Enter to continue or Ctrl-C to exit -----\n");
        fgets(line, MAXLINELENGTH, stdin);
        system("cls");

        switch (i+1)
        {
            case 1: sprintf(tmpstr, "%s", "@X2FFlag@X07"); break;
            case 2: sprintf(tmpstr, "%s", "@X2FView@X07"); break;
            case 3: sprintf(tmpstr, "%s", "@X2FQuit@X07"); break;
            default: sprintf(tmpstr, "%s", "@X2FCmd:@X07"); break;
        }

        printf("COMMAND #%d (out of %d)\tQUESTION #2\n\n", i+1, numcmds);
    GetAns("\
Enter the HIGHLIGHTED text for the first command.  This text may include\n\
PCBoard Color Codes.\n\n\
Enter text or hit RETURN for the default.\n", tmpstr);

        printf("\n----- Hit Enter to continue or Ctrl-C to exit -----\n");
        fgets(line, MAXLINELENGTH, stdin);
        system("cls");

        switch (i+1)
        {
            case 1: sprintf(tmpstr, "%s", "F"); break;
            case 2: sprintf(tmpstr, "%s", "V"); break;
            case 3: sprintf(tmpstr, "%s", "Q"); break;
            default: sprintf(tmpstr, "%s", "C"); break;
        }

        printf("COMMAND #%d (out of %d)\tQUESTION #3\n\n", i+1, numcmds);
    GetAns("\
Enter one letter for the HOTKEY for this command or hit RETURN for the\n\
default.\n", tmpstr);

        printf("\n----- Hit Enter to continue or Ctrl-C to exit -----\n");
        fgets(line, MAXLINELENGTH, stdin);
        system("cls");

        switch (i+1)
        {
            case 1: sprintf(tmpstr, "%s", "internal"); break;
            case 2: sprintf(tmpstr, "%s", "internal"); break;
            case 3: sprintf(tmpstr, "%s", "internal"); break;
            default: sprintf(tmpstr, "%s", "external"); break;
        }

        printf("COMMAND #%d (out of %d)\tQUESTION #4\n\n", i+1, numcmds);
    GetAns("\
Now enter the file to display, the ppe to run, etc. for this command.\n\
If this is an internal command (default internal commands are \"F\", \"V\",\n\
and \"Q\"), then this line is ignored.\n\n\
For displaying a file, include a \"%\" at the beginning.  For executing a\n\
a ppe, include a \"!\" at the beginning.  Otherwise, whatever text you\n\
specify will be printed.  For example:\n\n\
\tDisplay a file:  %C:\PCB\PPE\EFLAG\FOO.TXT\n\
\tExecute a ppe :  !C:\PCB\PPE\NUKE\NUKE.PPE\n\
\tPrint text    :  Hello world!\n\n\
Enter the information or hit RETURN for the default\n", tmpstr);

        printf("\n----- Hit Enter to continue or Ctrl-C to exit -----\n");
        fgets(line, MAXLINELENGTH, stdin);
        system("cls");

    }

    if (fp2)
    {
        DumpInstructions(fp2);
        fclose(fp2);
        fclose(fp);
        sprintf(line, "del %s", filename);
        system(line);
        sprintf(line, "rename %s %s", "TEMP.CFG", filename);
        system(line);
    }
    else
    {
        DumpInstructions(fp);
        fclose(fp);
    }

    printf("\
Remember, you can always edit the %s by hand\n\n\
        --Drew\n\n", filename);
}




void GetAns(char *inst, char *def)
{

    printf("%s", inst);

    if (fgets(orig, MAXLINELENGTH, fp) != NULL)
    {
        printf("\tExisting: %s\t--> ", orig);
        fgets(line, MAXLINELENGTH, stdin);

        if (line[0] == '\n')
        {
            fprintf(fp2, "%s", orig);
            printf("\n\tUsing: %s\n", orig);
        }
        else
        {
            fprintf(fp2, "%s", line);
            printf("\n\tUsing: %s\n", line);
        }
        fflush(fp2);
    }
    else
    {
        printf("\tDefault: [%s]\n\t--> ", def);
        fgets(line, MAXLINELENGTH, stdin);
        if (line[0] == '\n')
        {
            fprintf(fp, "%s\n", def);
            printf("\n\tUsing: %s\n", def);
        }
        else
        {
            fprintf(fp, "%s", line);
            printf("\n\tUsing: %s\n", line);
        }
        fflush(fp);
    }

}



void DumpInstructions(FILE *foo)
{
    fprintf(foo, "\n\n\
@X07------------------------------------------------------------------------\n\
Enhanced FLAG v1.0 by Drew [PWA]\n\n\
Line 1: The main \"more\" prompt\n\
Line 2: The prompt displayed while in \"flag\" or \"mark\" mode. This should\n\
\tnot contain the text for the actual commands available in this mode.\n\
Line 3: Number of spaces to print between commands at flag prompt\n");
    fflush(foo);

    fprintf(foo, "\
Line 4: Number of commands at flag prompt (max = 8)\n\
Line 5: Unhighlighted text for command #1\n\
Line 6: Highlighted text for command #1 (lines 4 & 5 should be same length)\n\
Line 7: The \"hot-key\" for this command\n\
Line 8: What to do if command #1 is selected\n\n");
    fflush(foo);

    fprintf(foo, "\
\tIf the command is an internal command, this line is ignored.\n\
\tThe default internal commands are:\n\n\
\t\tFlag:  File is flagged regularly as if \"F\" was entered\n\
\t\tView:  File is viewed using PCBVIEW.BAT\n\
\t\tQuit:  Quit out of this file marking mode (ie: ESCape was hit)\n\n");
    fflush(foo);

    fprintf(foo, "\
\tFor displaying a file, include a \"%\" at the beginning.  For executing a\n\
\ta ppe, include a \"!\" at the beginning.  Otherwise, whatever text you\n\
\tspecify will be printed.  For example:\n\n\
\t\tDisplay a file:  %C:\PCB\PPE\EFLAG\FOO.TXT\n\
\t\tExecute a ppe :  !C:\PCB\PPE\NUKE\NUKE.PPE\n\
\t\tPrint text    :  Hello world!\n\n\
Repeat Lines 5-8 for each command.\n\n");
    fflush(foo);
}

