# imdb info (ppx edition) v1.0 by phillie
# based on the original imdb info script released by bounty
#
# this script is based on bounty's imdb info script which is, as
# far as i known, distributed via www.ioftpd.com's forum.
# ive added various features that ive missed in his version, so here
# is mine.
#
# added:
#
# - "-h" style command options
# - releasename parsing
# - blowcrypt support
# - two different outputs: limited and extended
#
# removed:
#
# - randomized output since it sucks
#
# usage:
#
# !imdb [-hPrx] <releasename/moviename>
#
# -h   show help
# -P   just parse releasename and return it (debug-mode only)
# -r   use releasename parsing
# -x   use extended output
#
# if -x is not given, the limited output will be used.
#
# cookies for output configuration:
#
# title      = %title
# url        = %url
# director   = %name
# genre      = %genre
# synopsis   = %plot
# rating     = %rating
# votes      = %votes
# runtime    = %time
# budget     = %budget
# screens    = %screens 
#
# cookies for output format:
#
# bold       = %bold
# underline  = %uline
# colors     = %color#,#
# new line   = \n
#
# to reset colors, just use %color without any arguments.
#
# output configuration preset:
#
# limited: <bot> [iMDB] moviename (2003) (action) -> rating 9.6/10 (1,000 votes)
#
# extended:
#
# <bot> [iMDB] moviename (2003) (action) -> rating 9.6/10 (1,000 votes) -> runtime 98 mins.
# <bot> [iMDB] plot: this movie is about how much perplex rocks.
# <bot> [iMDB] screens: 5,000 Screens -> director: phillie -> budget: $10,000,000,000
# <bot> [iMDB] url: http://perplex.home.page.is.coming.soon.org/
#
# config:
# -------

# define your limited output here:
set announce(limited) "\[%boldiMDB%bold] %title (%genre) -> rating %rating (%votes votes)"

# define your extended output here:
set announce(extended) "\[%boldiMDB%bold] %title (%genre) -> rating %rating (%votes votes) -> runtime %time mins.\n\[%boldiMDB%bold] plot: %plot\n\[%boldiMDB%bold] screens: %screens -> director: %name -> budget: %budget\n\[%boldiMDB%bold] url: %url"

# debug mode?
set DEBUG 0

# trigger you want to use
set IMDBtrigger "!imdb"

# userflags needed to use this script
set IMDBrights "-|-"

# use +imdb chan-mode
set IMDBperm 0

# 0 for response via notice to $nick, 1 for msg to $chan
set pub_or_not 1

# blowfish encryption [0/1]
set imdbblow 0

#blowfish key
set imdbblowkey "perplexisgood"

#################################################################

setudef flag imdb
package require http 2.3

bind pub $IMDBrights $IMDBtrigger imdb_proc
bind pub n|n &imdbparsetest imdb_parse
bind pub - +OK imdbencryptedincominghandler

set CUTer(langs) "german english spanish dutch frensh polish swedub swedish swesub"
set CUTer(types) "xxx dvdrip ld ts dl subbed line dubbed dubbed mic screener dvdscreener tvrip dtv proper limited custom crypted repack uncut internal unsubbed ws dvdscr satrip"
set CUTer(forms) "xvid divx vcd svcd dvdr"

proc htmlcodes {tempfile} {
	set mapfile [string map {&#34; ' &#38; & &#91; ( &#92; / &#93; ) &#123; ( &#125; ) &#163;  &#168;  &#169;  &#171;  &#173;  &#174;  } $tempfile]
	set mapfile [string map {&#180;  &#183;  &#185;  &#187;  &#188;  &#189;  &#190;  &#192;  &#193;  &#194;  } $mapfile]
	set mapfile [string map {&#195;  &#196;  &#197;  &#198;  &#199;  &#200;  &#201;  &#202;  &#203;  &#204;  &#205;  &#206;  &#207;  &#208;  &#209;  &#210;  &#211;  &#212;  &#213;  &#214;  } $mapfile]
	set mapfile [string map {&#215;  &#216;  &#217;  &#218;  &#219;  &#220;  &#221;  &#222;  &#223;  &#224;  &#225;  &#226;  &#227;  &#228;  &#229;  &#230;  &#231;  &#232;  &#233;  &#234;  } $mapfile]
	set mapfile [string map {&#235;  &#236;  &#237;  &#238;  &#239;  &#240;  &#241;  &#242;  &#243;  &#244;  &#245;  &#246;  &#247;  &#248;  &#249;  &#250;  &#251;  &#252;  &#253;  &#254;  } $mapfile]
	return $mapfile
}

proc channel_check { chan } {
        foreach setting [channel info $chan] {
                if {[regexp -- {^[\+-]} $setting]} {
                        if {![string compare "+imdb" $setting]} {
                                set permission 1
                        } else {
                                set permission 0
                        }
                }
        }
        return $permission
}

proc replacevar {strin what withwhat} {
        set output $strin
        set replacement $withwhat
        set cutpos 0
        while { [string first $what $output] != -1 } {
                set cutstart [expr [string first $what $output] - 1]
                set cutstop  [expr $cutstart + [string length $what] + 1]
                set output [string range $output 0 $cutstart]$replacement[string range $output $cutstop end]
        }
        return $output
}

proc imdb_parse_rel {rel} {
  global CUTer
  set rel [lreplace [string map {. " " _ " "} $rel] end end]
  foreach LANG $CUTer(langs) { set Ls [lsearch [string tolower $rel] [string tolower $LANG]]; if {$Ls != "-1"} { set rel [lreplace $rel $Ls $Ls] } }
  foreach TYPE $CUTer(types) { set Ts [lsearch [string tolower $rel] [string tolower $TYPE]]; if {$Ts != "-1"} { set rel [lreplace $rel $Ts $Ts] } }
  foreach FORM $CUTer(forms) { set Fs [lsearch [string tolower $rel] [string tolower $FORM]]; if {$Fs != "-1"} { set rel [lreplace $rel $Fs $Fs] } }
  return "$rel"
}

proc imdb_parse { nick uhost handle chan arg } {
	global imdbblow
	set output [imdb_parse_rel $arg]
	if {$imdbblow == 0} {
		putserv "PRIVMSG $chan :$output"
	} else {
		imdbputblow "PRIVMSG $chan :$output"
	}
	return
}

proc imdb_proc { nick uhost handle chan argv } {
	global DEBUG IMDBtrigger announce pub_or_not IMDBperm imdbblow
        # channel_check permission
	if {$IMDBperm == 1} {
	        set permission_result [channel_check $chan]
	        if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG permission_result == $permission_result" }
	        if { $permission_result == 0 } { return }
	}
        if {$pub_or_not == 1 } { set toput "PRIVMSG $chan" } else { set toput "NOTICE $nick" }
	set start 0
	set extended 0
	if {$argv == ""} {
		if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG no argv passed, show help notice" }
		if {$imdbblow == 0} {
			putserv "PRIVMSG $chan :\[\002iMDB\002\] try $IMDBtrigger -h"
		} else {
			imdbputblow "PRIVMSG $chan :\[\002iMDB\002\] try $IMDBtrigger -h"
		}
		return
	}
	if {[lindex $argv 0] == "-h" || [lindex $argv 1] == "-h" || [lindex $argv 2] == "-h" || [lindex $argv 3] == "-h"} {
		if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG argv == help, show help" }
		putserv "PRIVMSG $nick :IMDB INFO (PPX EDITION) V1.0 BY PHILLIE/PPX - ORIGINAL BY BOUNTY"
		putserv "PRIVMSG $nick :----------------------------------------------------------------"
		putserv "PRIVMSG $nick :$IMDBtrigger \[-hPrx\] <moviename/releasename>"
		putserv "PRIVMSG $nick :     "
		putserv "PRIVMSG $nick :\002options\002:"
		putserv "PRIVMSG $nick :\002-x\002    use detailed output"
		putserv "PRIVMSG $nick :\002-r\002    convert releasename to moviename"
		putserv "PRIVMSG $nick :\002-P\002    releasename parsing test (debug-mode only)"
		putserv "PRIVMSG $nick :\002-h\002    show help"
		return
	}

	# check for commands
	if {[lindex $argv 0] == "-x" || [lindex $argv 1] == "-x" || [lindex $argv 2] == "-x" || [lindex $argv 3] == "-x"} {
		incr start
		incr extended
	}
	if {[lindex $argv 0] == "-r" || [lindex $argv 1] == "-r" || [lindex $argv 2] == "-r" || [lindex $argv 3] == "-r"} {incr start}
	if {[lindex $argv 0] == "-P" || [lindex $argv 1] == "-P" || [lindex $argv 2] == "-P" || [lindex $argv 4] == "-P"} {
		if {$DEBUG == 1} {
			incr start
			if {$imdbblow == 0} {
				putserv "PRIVMSG $chan :\[\002iMDB\002\] \002DEBUG\002: [imdb_parse_rel [lrange $argv $start end]]"
			} else {
				imdbputblow "PRIVMSG $chan :\[\002iMDB\002\] \002DEBUG\002: [imdb_parse_rel [lrange $argv $start end]]"
			}
			return
		} else {
			if {$imdbblow == 0} {
				putserv "PRIVMSG $chan :\[\002iMDB\002\] debug mode is disabled."
			} else {
				imdbputblow "PRIVMSG $chan :\[\002iMDB\002\] debug mode is disabled."
			}
			return
		}
	}
	# create moviename using $start
	if {[lindex $argv 0] == "-r" || [lindex $argv 1] == "-r" || [lindex $argv 2] == "-r" || [lindex $argv 3] == "-r"} {
		if {$DEBUG == 1} { putserv "NOTICE $nick :releasename parsing [lrange $argv $start end] -> [imdb_parse_rel [lrange $argv $start end]]" }
		set moviename [imdb_parse_rel [lrange $argv $start end]]
	} else {
		set moviename [lrange $argv $start end]
	}
	# initial search
	set imdburl "http://us.imdb.com"
	set imdbsearchurl "http://akas.imdb.com/find?tt=on;nm=on;mx=3;"
	set searchString [::http::formatQuery $moviename]
	set searchString [string trimleft $searchString "+"]
	if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG searchString: \"$searchString\"" }
	set page [::http::config -useragent "MSIE 6.0"]
	if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG ${imdbsearchurl}q=$searchString" }
	set page [::http::geturl ${imdbsearchurl}q=$searchString]
	set html [::http::data $page]
	::http::Finish $page
	#if redirect necessary, find first link and redirect
	if { [regexp {<title>IMDb name and title search</title>} $html] == 1 } {
		if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG redirect 1" }
		set ttcode "0000001"
		if [regexp {/title/tt[0-9]+} $html ttcode] {
			set pos [string last / $ttcode] ; incr pos
			set ttcode [string range $ttcode $pos end]
		}
		# for bogus ttcode
		if { $ttcode == "0000001" } {
			putserv "$toput :No no no! I can't find that!"
			if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG bogus ttcode" }
			return
		}
		set newurl "$imdburl/title/$ttcode/"
		if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG redirect 1 = $newurl" }
		# get the page redirected to
		unset html
		set page [::http::config -useragent "MSIE 6.0"]
		set page [::http::geturl $newurl]
		set html [::http::data $page]
		::http::Finish $page
	# if no redirect happened, then get first page on match
	} else {
		if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG redirect 0" }
		upvar 0 $page oldpage
		regexp {title/tt[0-9]+/} $oldpage(meta) location
		if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG redirect 0 Location == $location" }
		set newurl "$imdburl/$location"
		if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG redirect 0 = $newurl" }
		unset html
		set page [::http::config -useragent "MSIE 6.0"]
		set page [::http::geturl $newurl]
		set html [::http::data $page]
		::http::Finish $page
	}
	# for bogus searches
	if {[string length $newurl] == 0} {
		putserv "$toput :No no no! I can't find that!"
		if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG bogus searches" }
		return
	}
	set title "N/A" ; set name "N/A" ; set genre "N/A" 
	set plot "N/A" ; set rating "N/A" ; set votes "N/A"
	set runtime "N/A" ; set budget "N/A" ; set screens "N/A"
	## get title
	if [regexp {<title>[^<]+} $html title] {
		set pos [expr [string last > $title] + 1]
		set title [string range $title $pos end]
		set title [htmlcodes $title]
	}
	if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG title == $title" }
	## get director
	if [regexp {Directed by</b><br>\n<[^>]+>[^<]+} $html name] {
		set pos [string last > $name] ; incr pos
		set name [string range $name $pos end]
		set name [htmlcodes $name]
	}
	if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG director == $name" }
	## get genre
	if [regexp {<b class=\"ch\">Genre:</b>[\s\n]?<[^>]+>[\w-]+} $html genre] {
		set pos [string last > $genre] ; incr pos
		set genre [string range $genre $pos end]
	}
	if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG genre == $genre" }
	## get plot
	if [regexp {<b class=\"ch\">Plot (Summary|Outline):</b>[\s\n]+[^<]+} $html plot] {
		set pos [string last > $plot] ; incr pos
		set plot [string range $plot $pos end]
		regsub -all {[\n\s]+} [string map "&#34; {} {\"} '" $plot] { } plot
		set plot [string trim $plot]
		set plot [htmlcodes $plot]
	}
	if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG plot == $plot" }
	## get iMDb rating
	if [regexp {<b>\d.\d/10</b> \([\w\s\d,]+\)} $html rating] {
		set pos [string last ( $rating]
		set pos1 [string first { } $rating $pos]
		incr pos ; incr pos1 -1
		set votes [string range $rating $pos $pos1]
		set rating [string range $rating 3 8]
	}
	if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG rating == $rating | votes == $votes" }
	## get runtime
	if [regexp {<b class=\"ch\">Runtime:</b>([\n\s]+)([\w:]+)(\d+)} $html runtime] {
		regsub -all {[\n\s]+} $runtime {} runtime
		set pos [string last > $runtime] ; incr pos
		set runtime [string range $runtime $pos end]
		set pos [string last : $runtime]
		if {$pos != -1} {incr pos ; set runtime [string range $runtime $pos end]}
	}
	if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG runtime == $runtime" }
	unset html
	set page2 [::http::config -useragent "MSIE 6.0"]
	set page2 [::http::geturl ${newurl}business]
	set html [::http::data $page2]
	::http::Finish $page2
	## get budget
	if [regexp {<b>Budget</b></dt>[\s\n]?<dd><[^>]+>[^<]+} $html budget] {
		set pos [string last > $budget] ; incr pos
		set budget [string range $budget $pos end]
		set budget [string map {&#8364;  &#163;  } $budget]
	}
	if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG budget == $budget" }
	## get screens
	if [regexp {<b>Opening Weekend</b></dt>[\s\n]?[^\n]+} $html opweek] {
		if [regexp {\(USA\) \([^)]+\) \([^)]+\)} $opweek screens] {
			set pos [string last ( $screens]
			set pos1 [string last ) $screens]
			incr pos ; incr pos1 -1
			set screens [string range $screens $pos $pos1]
		}
	}
	if {$DEBUG == 1} { putserv "NOTICE $nick :DEBUG screens == $screens" }
	if {$extended == 1} {
		set output $announce(extended)
	} else {
		set output $announce(limited)
	}
        set output [replacevar $output "%bold" "\002"]
        set output [replacevar $output "%color" "\003"]
        set output [replacevar $output "%uline" "\037"]
        set output [replacevar $output "%title" $title]
        set output [replacevar $output "%url" $newurl]
        set output [replacevar $output "%name" $name]
        set output [replacevar $output "%genre" $genre]
        set output [replacevar $output "%plot" $plot]
        set output [replacevar $output "%rating" $rating]
        set output [replacevar $output "%votes" $votes]
        set output [replacevar $output "%time" $runtime]
        set output [replacevar $output "%budget" $budget]
        set output [replacevar $output "%screens" $screens]
        foreach line [split $output "\n"] {
		if {$imdbblow == 0} {
	                putserv "$toput :$line"
		} else {
	                imdbputblow "$toput :$line"
		}
        }
}

# blowcrypt code

proc imdbputblow {text {option ""}} {
        global imdbblowkey
        if {$option==""} {
                if {[lindex $text 0]=="PRIVMSG" && [info exists $imdbblowkey]} {
                        putserv "PRIVMSG [lindex $text 1] :+OK [encrypt $imdbblowkey [string trimleft [join [lrange $text 2 end]] :]]"
                } else {
                        putserv $text
                }
        } else {
                if {[lindex $text 0]=="PRIVMSG" && [info exists $imdbblowkey} {
                        putserv "PRIVMSG [lindex $text 1] :+OK [encrypt $imdbblowkey [string trimleft [join [lrange $text 2 end]] :]]" $option
                } else {
                        putserv $text $option
                }
        }
}

proc imdbencryptedincominghandler {nick host hand chan arg} {
        global imdbblowkey
        if {![info exists $imdbblowkey]} {return}
        set tmp [decrypt $imdbblowkey $arg]
        foreach item [binds pub] {
                if {[lindex $item 2]=="+OK"} {continue}
                if {[lindex $item 1]!="-|-"} {
                        if {![matchattr $hand [lindex $item 1] $chan]} {continue}
                }
                if {[lindex $item 2]==[lindex $tmp 0]} {[lindex $item 4] $nick $host $hand $chan [lrange $tmp 1 end]}
         }
}

putlog "imdb info ppx edition v1.0 by phillie loaded ..."
