/* tScan by Whodini for Daydream/Unix.*/

#include <stdio.h>
#include "../lib/ddlib.h"

struct dif *d;
int oldloc;
int uploc=10;
int key;
int i;
int a;


void main(int argc, char *argv[]) {
	if (argc==1) {	
		printf("This program requires DD/Unix!\n");
		exit(1);
	}
	d=dd_initdoor(argv[1]);
	if (d==0) {
		
		printf("Couldn't find socket!\n");
		exit(1);
	}
	
	dd_typefile(d,"tScan",TYPE_WARN|TYPE_MAKE);
	dd_sendstring(d,"[10;24H");
	while (1) {
		key = dd_hotkey(d, HOT_CURSOR);
		switch (key) {
		 case 250:
		 case '8':
			up();
			i=1;
			break;
		 case 251:
		 case '2':
			down();
			i=1;
			break;
		 case 'G':
		 case 'g':
			gscan();
			kscan();
		 case 'E':
		 case 'e':
			escan();
			kscan();
		 case 'M':
		 case 'm':
			mscan();
			kscan();
		 case 'F':
		 case 'f':
			fscan();
			kscan();
		 case 'Q':
		 case 'q':
		 case 3:
		 case 27:
			dd_sendstring(d,"Quit\n");
			kscan();
		 case 13:
			go();
		}
		if (i==1) draw();
	}
}

int down(void) {
	oldloc=uploc;
	uploc=uploc+2;
	if (uploc==20) uploc=10;
}

int up(void) {
	oldloc=uploc;
	uploc=uploc-2;
	if (uploc==8) uploc=18;
}

int draw(void) {
	char buf[128];
	
	sprintf(buf,"[%d;24H   [%d;24H[0m>>>",oldloc,uploc);
	dd_sendstring(d,buf);
}

int fscan(void) {
	dd_sendstring(d,"[2J[H");
	dd_docmd(d,"NS");
}

int escan(void) {
	a=1;
	dd_sendstring(d,"[2J[H");
	dd_docmd(d,"MS");
}

int gscan(void) {
	dd_sendstring(d,"[2J[H");
	dd_docmd(d,"MS");
	dd_docmd(d,"GR");
	dd_docmd(d,"NS");
}

int mscan(void) {
	dd_sendstring(d,"[2J[H");
	dd_docmd(d,"GR");
}

int kscan(void) {
	if (a!=1) dd_sendstring(d,"[2J[H");
	dd_close(d);
	exit(0);
}

int go(void) {
	switch(uploc){
	 case 10:
		gscan();
		kscan();
		break;
	 case 12:
		escan();
		kscan();
		break;
	 case 14:
		mscan();
		kscan();
		break;
	 case 16:
		fscan();
		kscan();
		break;
	 case 18:
		kscan();
	}
	
}
