/*
* tbapi.h  - Header file for the TriBBS API
* Copyright (c) 1994 By TriSoft
*/
#ifndef __TBAPIH__
#define __TBAPIH__

#include <stdio.h>

/* definitions for portability across platforms */
 
#ifndef SHORT
typedef short int SHORT;
#endif

#ifndef USHORT
typedef unsigned short int USHORT;
#endif

#ifndef LONG
typedef long LONG;
#endif

#ifndef ULONG
typedef unsigned long ULONG;
#endif

#define TRUE 1
#define FALSE 0
#define UNCOMPRESSED 0
#define COMPRESSED 1

typedef unsigned char BASICSINGLE[4];

typedef union {
	double Value;
	unsigned char Byte[8];
} IEEEDOUBLE;

typedef struct _SYSDAT1DATA {
	char BoardName[41];
	char SysopName[41];
	char BoardStartDate[9];
	char DefaultArchiveExtension[4];
	SHORT TotalNodes;
	SHORT CallsToday;
	SHORT MessagesToday;
	SHORT UploadsToday;
	SHORT DownloadsToday;
	SHORT DefaultDailyTimeLimit;
	SHORT DefaultDailyLogons;
	SHORT DefaultTimePerLogon;
	SHORT MinimumSysopSecurityLevel;
	SHORT NewUserSecurityLevel;
	SHORT NewUserTimeTimeLimit;
	SHORT UploadTimeCompensationRatio;
	SHORT MaximumKeyboardIdleTime;
	LONG TotalCalls;
	SHORT PhoneNumberFlag;
	SHORT TestUploadsFlag;
	SHORT AutoANSIDetectFlag;
	SHORT CheckForWaitingMessagesFlag;
	char SystemPassword[16];
	SHORT ULDLRatioTypeFlag;
	SHORT PhoneOnHookDuringMaintenanceFlag;
	SHORT NoOneWordNamesFlag;
	SHORT NoBulletinMenuAtLogonFlag;
	SHORT AllowAliasesFlag;
	SHORT ClearScreenBeforeMenusFlag;
	SHORT ExactFileNameMatchingForDupesFlag;
	SHORT DisableNewUserBirthdayPrompt;
	SHORT DetailedCallerLogFlag;
	SHORT MajorVersionNumber;
	SHORT MinorVersionNumber;
	SHORT EnableRIPScripEmulationFlag;
	SHORT MinimumFileAttachmentSecurityLevel;
	SHORT MinimumAtVariableSecurityLevel;
	SHORT FastLogonSecurityLevel;
	SHORT UseAliasOrRealNamesFlag;
	SHORT ClearUploadsAndDownloadsFlag;
	SHORT ClearPrivateMessageAreasFlag;
	SHORT ClearPrivateFileAreasFlag;
	char ReservedDataArea[69];
} SYSDAT1DATA;

typedef struct _SYSDAT2DATA {
	char Node1sMainDirectory[81];
	char ReservedDataArea[175];
} SYSDAT2DATA;

typedef struct _NODEDATA {
	char InitializationString[81];
	char ErrorCorrectingConnectionMessage[5];
	char DateOfLastCall[9];
	SHORT NodeNumber;
	USHORT MaximumBaudRate;
	SHORT SerialPort;
	SHORT No300BaudCallersFlag;
	SHORT No1200BaudCallersFlag;
	SHORT RTSCTSHandshakingFlag;
	SHORT LockSerialPortFlag;
	SHORT DirectScreenWriteFlag;
	SHORT DelayBeforeATA;
	SHORT NumberOfRings;
	SHORT PageBellOnFlag;
	SHORT UseNodeDISPLAYDirectoryFlag;
	SHORT NodeSecurityLevel;
	SHORT No2400BaudCallersFlag;
	SHORT PhoneOffHookDuringEventsFlag;
	SHORT NonStandardIRQNumber;
	char ReservedDataArea[129];
} NODEDATA;

typedef struct _USERSDATA {
	char Name[31];
	char Password[16];
	char CityAndState[31];
	char PhoneNumber[13];
	char Birthday[9];
	char DateOfFirstCall[9];
	char DateAndTimeOfLastCall[15];
	char DateOfLastFileCheck[9];
	SHORT SecurityLevel;
	SHORT NumberOfCalls;
	SHORT TimeLeftForToday;
	SHORT LastMessageConference;
	SHORT LastFileArea;
	SHORT DefaultProtocol;
	SHORT ExpertModeFlag;
	SHORT LockedOutFlag;
	SHORT MarkedForDeletionFlag;
	SHORT NumberOfCallsToday;
	SHORT IncludeLOGON1InQWKFlag;
	SHORT IncludeGOODBYEInQWKFlag;
	SHORT IncludeBulletinsInQWKFlag;
	SHORT IncludeNewFilesInQWKFlag;
	SHORT IncludeNewsletterInQWKFlag;
	SHORT QWKNetworkNode;
	LONG NumberOfFilesUploaded;
	LONG NumberOfFilesDownloaded;
	LONG NumberOfKBytesUploaded;
	LONG NumberOfKBytesDownloaded;
	LONG NumberOfMessagesPosted;
	SHORT DefaultEditor;
	SHORT InitialChatStatus;
	SHORT CheckForWaitingMessagesFlag;
	char SubscriptionExpirationDate[9];
	char Alias[31];
	SHORT NumberOfFilesDownloadedToday;
	LONG NumberOfBytesDownloadedToday;
	char ReservedDataArea[19];
} USERSDATA;

typedef struct _USERSINDEX {
	ULONG Crc;
	SHORT RecordNumber;
} USERSINDEX;

typedef struct _USERSSUPMESSAGES {
	SHORT QueuedConferenceFlag;
	SHORT PrivateConferenceFlag;
	LONG LastMessageRead;
	SHORT WaitingMessageCounter;
} USERSSUPMESSAGES;

typedef struct _USERSSUPFILES {
	SHORT PrivateAreaFlag;
} USERSSUPFILES;

typedef struct _MCONFDATA{
	SHORT ReadSecurityLevel;
	SHORT NetworkedConferenceFlag;
	SHORT UserDeleteFlag;
	SHORT TriPackBackupFlag;
	SHORT TriPackNumberOfDaysToSave;
	SHORT PrivateConferenceFlag;
	SHORT FidoStyleNetMailFlag;
	SHORT AliasConferenceFlag;
	SHORT PostSecurityLevel;
	SHORT DisablePrivateMessagesFlag;
	char ConferenceName[41];
	char NetworkName[41];
	LONG HighestMessageNumber;
	SHORT DisablePublicMessagesFlag;
	char  ReservedDataArea[148];
} MCONFDATA;

typedef struct MPTRDATA {
	char DateAndTime[15];
	char From[31];
	char To[31];
	char Subject[41];
	SHORT EchoMessageFlag;
	SHORT ThreadedMessageFlag;
	SHORT PrivateMessageFlag;
	SHORT DeletedMessageFlag;
	SHORT ReceivedMessageFlag;
	SHORT PermanentMessageFlag;
	SHORT NetMailFromZone;
	SHORT NetMailFromNet;
	SHORT NetMailFromNode;
	SHORT NetMailFromPoint;
	SHORT NetMailToZone;
	SHORT NetMailToNet;
	SHORT NetMailToNode;
	SHORT NetMailToPoint;
	LONG OffsetIntoTextFile;
	LONG Number;
	LONG NumberOfMessageThisRepliesTo;
	char NameOfAttachedFile[81];
} MPTRDATA;

typedef struct _MIDXDATA {
	ULONG FromCRC;
	ULONG ToCRC;
	LONG Number;
	LONG NumberOfMessageThisRepliesTo;
} MIDXDATA;

typedef struct _FAREADATA{
	SHORT SecurityLevel;
	SHORT SortType;
	SHORT PrivateAreaFlag;
	char Name[41];
	char FileAreaPath[81];
	char FileAreaUploadPath[81];
	char FileAreaFileList[81];
	char FileAreaUploadList[81];
	SHORT CDROMFileAreaFlag;
	SHORT AliasAreaFlag;
	char FileAreaIndexFile[81];
	char AdditionalFileAreaPaths[10][81];
	char ReservedDataArea[14];
} FAREADATA;

typedef struct _DOORSTMPDATA {
	USHORT BaudRate;
	SHORT ErrorCorrectingConnection;
	SHORT UserRecordNumber;
	SHORT TimeLeftAtLogon;
	SHORT ANSIFlag;
	SHORT CurrentFileArea;
	SHORT CurrentMessageConference;
	LONG TimeWhenUserLoggedOn;
	SHORT FrontEnd;
	USHORT FrontEndBaudRate;
	SHORT FrontEndHangUpFlag;
	SHORT UserWindowFlag;
	SHORT FrontEndTime;
	SHORT WhereTheDoorWasCalledFrom;
	SHORT ChatRequested;
	SHORT EventPendingFlag;
	SHORT GoodbyeFromDoorFlag;
	SHORT ForceBoardDownAfterCallFlag;
	SHORT LanguageNumber;
	SHORT RIPScripFlag;
	SHORT NumberOfFilesFlagged;
	SHORT DOORSYSFlag;
	SHORT TimeInDOORSYS;
	char ReservedDataArea[208];
} DOORSTMPDATA;

/* function prototypes */
#ifdef __cplusplus
extern "C" {
#endif
double TBBasicSingleToDouble(BASICSINGLE OldNumber);
SHORT TBCheckForShareExe(void);
LONG TBCompress(unsigned char *cib, SHORT cil,
	unsigned char *cob, unsigned char *wb);
void TBDoubleToBasicSingle(BASICSINGLE *New, double Old);
SHORT TBGetNextMnnnnIDX(LONG n);
char *TBInitialCaps(char *s);
void TBInitialize(void);
char *TBMakePathName(char *buffer, char *path, char *file);
SHORT TBNumberInFAREADAT(void);
SHORT TBNumberInMCONFDAT(void);
SHORT TBNumberInMnnnnIDX(void);
SHORT TBNumberInMnnnnPTR(void);
SHORT TBNumberInUSERSDAT(void);
void TBOpenFAREADAT(void);
void TBOpenMCONFDAT(void);
void TBOpenMnnnnIDX(SHORT n);
void TBOpenMnnnnPTR(SHORT n);
void TBOpenMnnnnTXT(SHORT n);
void TBOpenUSERSDAT(void);
void TBOpenUSERSSUP(void);
void TBReadDOORSTMP(char *s);
void TBReadFAREADAT(SHORT n);
void TBReadMCONFDAT(SHORT n);
void TBReadMnnnnIDX(SHORT n);
void TBReadMnnnnPTR(SHORT n);
void TBReadNODEDAT(void);
void TBReadSYSDAT1DAT(void);
void TBReadSYSDAT2DAT(void);
void TBReadUSERSDAT(SHORT n);
void TBReadUSERSSUP(SHORT n);
SHORT TBSearchMnnnnIDX(LONG n);
SHORT TBSearchUSERSIDX(ULONG n);
ULONG TBStrCrc32(char *s);
void TBStripNewline(char *s);
void TBStripSpaces(char *s);
ULONG TBStrNCrc32(char *s, USHORT l);
LONG TBUncompress(unsigned char *cib, SHORT cil,
	unsigned char *cob, unsigned char *wb);
void TBUpdateFromAndTo(ULONG f, ULONG t, SHORT c);
void TBWriteDOORSTMP(char *s);
void TBWriteFAREADAT(SHORT n);
void TBWriteMCONFDAT(SHORT n);
void TBWriteMnnnnIDX(SHORT n);
void TBWriteMnnnnPTR(SHORT n);
void TBWriteNODEDAT(void);
void TBWriteSYSDAT1DAT(void);
void TBWriteUSERSDAT(SHORT n);
void TBWriteUSERSSUP(SHORT n);

/* file sharing versions of the C runtime file routines */
FILE *fsopen(const char *filename, const char *mode, int shflg);
size_t fswrite(const void *ptr, size_t size, size_t n, FILE *stream);
size_t fsread(void *ptr, size_t size, size_t n, FILE *stream);
int fsgetc(FILE *stream);
int fsputc(int c, FILE *stream);
char *fsgets(char *s, int n, FILE *stream);
int fsputs(char *s, FILE *stream);
int fsprintf(FILE *stream, char *f, ...);
char *fsgetstring(char *s, int n, FILE *stream);

/* global variables */
extern SHORT IsShare;
extern char Node1sMainDirectory[81];
extern SYSDAT1DATA SysDat1Data;
extern SYSDAT2DATA SysDat2Data;
extern NODEDATA NodeData;
extern USERSDATA UsersData;
extern USERSSUPMESSAGES *UsersSupMessages;
extern USERSSUPFILES *UsersSupFiles;
extern USERSINDEX *UsersIndex;
extern USERSINDEX *AliasIndex;
extern MCONFDATA MConfData;
extern MPTRDATA  MPtrData;
extern MIDXDATA MIdxData;
extern FAREADATA FAreaData;
extern DOORSTMPDATA DoorsTmpData;
extern FILE *MConfFile, *MPtrFile, *MIdxFile, *MTxtFile, *UsersFile;
extern FILE *UsersSupFile, *FAreaFile;
extern SHORT NumberOfMessageAreas, NumberOfFileAreas, SupplementalLength;
extern SHORT NumberOfUsers;
extern void (*TBErrorRoutine)(char *f, ...);
#ifdef __cplusplus
}
#endif

#endif

