/*
	demo2.c - TriBBS API Demo Program
	Copyright (c) 1994 By TriSoft
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <share.h>
#include "tbapi.h"

void main(int argc, char **argv)
{
	SHORT i, privateflag, conferencenumber, nlines, cflag;
	USHORT ilength, olength;
	char line[256], recipientsname[81], filename[81];
	unsigned char *inbuffer, *outbuffer, *workbuffer, *ibuffer;
	FILE *file;

	/* Display opening screen */
	printf("TBAPI Demo Program No. 2 1.0\n");
	printf("Copyright (c) 1994 By TriSoft\n\n");

	if (argc < 5) {
		printf("Use as:\n\n");
		printf("DEMO2 \"name\" privateflag conferencenumber file\n\n");
		printf("Where:\n\n");
		printf("\"name\"               is the name of the recipient.\n");
		printf("privateflag          is 'Y' for a private message, 'N' for a\n");
		printf("                     public message.\n");
		printf("conference number    is the number of the conference the message is\n");
		printf("                     to be posted to.\n");
		printf("file                 name of the file to be imported.\n");
		exit(1);
	}
	strcpy(recipientsname, argv[1]);
	TBStripSpaces(recipientsname);
	TBInitialCaps(recipientsname);
	if (toupper(*argv[2]) == 'Y')
		privateflag = TRUE;
	else
		privateflag = FALSE;
	conferencenumber = atoi(argv[3]);
	strcpy(filename, argv[4]);

	/* Open SYSDAT2.DAT and point the API to Node 1's main directory */
	TBReadSYSDAT2DAT();
	strcpy(Node1sMainDirectory, SysDat2Data.Node1sMainDirectory);

	/* Initialize the TriBBS API */
	TBInitialize();

	/* Abort if invalid message conference */
	if (conferencenumber < 1 || conferencenumber > NumberOfMessageAreas)
		TBErrorRoutine("Invalid conference number!\n");

	/* Allocate the buffers needed for compression */
	inbuffer = (unsigned char *)malloc(40000U);
	outbuffer = (unsigned char *)malloc(40000U);
	workbuffer = (unsigned char *)malloc(40000U);

	if ((file = fopen(filename, "rt")) == NULL)
		TBErrorRoutine("Unable to open: %s\n", strupr(filename));

	ilength = 0;
	ibuffer = inbuffer;
	*ibuffer = 0;
	nlines = 0;
	while (!feof(file)) {
		if (fgets(line, 256, file) == NULL)
			break;
		TBStripNewline(line);
		if (!(*line))
			strcpy(line, " ");
		if (ilength + strlen(line) + 1 >= 40000U)
			break;
		strcpy((char *)ibuffer, line);
		ibuffer += strlen(line) + 1;
		ilength += strlen(line) + 1;
		nlines++;
		if (nlines == 200)
			break;
	}
	fclose(file);
	olength = TBCompress(inbuffer, ilength, outbuffer, workbuffer);
	TBOpenMnnnnTXT(conferencenumber);
	fseek(MTxtFile, 0L, SEEK_END);
	MPtrData.OffsetIntoTextFile = ftell(file);
	if (olength < ilength) {
		fswrite(&olength, sizeof(olength), 1, MTxtFile);
		cflag = COMPRESSED;
		fswrite(&cflag, sizeof(cflag), 1, MTxtFile);
		fswrite(outbuffer, olength, 1, MTxtFile);
	}
	else {
		fswrite(&ilength, sizeof(ilength), 1, MTxtFile);
		cflag = UNCOMPRESSED;
		fswrite(&cflag, sizeof(cflag), 1, MTxtFile);
		fswrite(inbuffer, ilength, 1, MTxtFile);
	}
	fclose(MTxtFile);			
	TBOpenMCONFDAT();
	TBReadMCONFDAT(conferencenumber);
	MConfData.HighestMessageNumber++;
	TBWriteMCONFDAT(conferencenumber);
	fclose(MConfFile);
	_strdate(line);
	strcpy(MPtrData.DateAndTime, line);
	strcat(MPtrData.DateAndTime, " ");
	_strtime(line);
	line[5] = 0;
	strcat(MPtrData.DateAndTime, line);
	strcpy(MPtrData.From, "Cdemo2");
	strcpy(MPtrData.To, recipientsname);
	strcpy(MPtrData.Subject, "A Sample of CDEMO2");
	MPtrData.EchoMessageFlag = MConfData.NetworkedConferenceFlag;
	MPtrData.ThreadedMessageFlag = FALSE;
	MPtrData.PrivateMessageFlag = privateflag;
	MPtrData.DeletedMessageFlag = FALSE;
	MPtrData.ReceivedMessageFlag = FALSE;
	MPtrData.PermanentMessageFlag = FALSE;
	MPtrData.NetMailFromZone = 0;
	MPtrData.NetMailFromNet = 0;
	MPtrData.NetMailFromNode = 0;
	MPtrData.NetMailFromPoint = 0;
	MPtrData.NetMailToZone = 0;
	MPtrData.NetMailToNet = 0;
	MPtrData.NetMailToNode = 0;
	MPtrData.NetMailToPoint = 0;
	MPtrData.Number = MConfData.HighestMessageNumber;
	MPtrData.NumberOfMessageThisRepliesTo = 0;
	*MPtrData.NameOfAttachedFile = 0;
	MIdxData.FromCRC = TBStrCrc32(MPtrData.From);
	MIdxData.ToCRC = TBStrCrc32(MPtrData.To);
	MIdxData.Number = MPtrData.Number;
	MIdxData.NumberOfMessageThisRepliesTo = 0;
	TBOpenMnnnnPTR(conferencenumber);
	TBOpenMnnnnIDX(conferencenumber);
	i = TBNumberInMnnnnPTR() + 1;
	TBWriteMnnnnPTR(i);
	TBWriteMnnnnIDX(i);
	fclose(MPtrFile);
	fclose(MIdxFile);
	TBUpdateFromAndTo(MIdxData.FromCRC, MIdxData.ToCRC, conferencenumber);
	TBReadSYSDAT1DAT();
	SysDat1Data.MessagesToday++;
	TBWriteSYSDAT1DAT();
	fcloseall();
	printf("Message Inserted into Message Base!\n");
	exit(0);
}


