PROGRAM ColorPCBoardDirfile;
{$M 4096,0,655360}  { 4k reserved for data, remainder allowed for pointers }
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}

USES DOS;
CONST
  cursorState : BYTE = 1;  {0..3}
  cursorData : ARRAY [0..3] OF CHAR = (#179, #47, #196, #92);
TYPE
  Colors = (CLRname, CLRsize, CLRdate, CLRdesc, CLRinfo);
VAR
  ColorARRAY : ARRAY [Colors] OF STRING [15];
PROCEDURE cursorOn; FORWARD;

PROCEDURE showhelp (problem : BYTE);
CONST
  NL = #13#10;
VAR
  message : STRING [79];
BEGIN
  WriteLn ('PCBColor v1.10 - Free DOS utility: PCBoard filelist colorizer.');
  WriteLn ('September 29, 1995. Copyright (c) 1995 by David Daniel Anderson - Reign Ware.' + NL);
  WriteLn ('Usage: PCBColor file(s)_to_colorize' + NL);
  IF problem > 0 THEN BEGIN
    CASE problem OF
      1 : message := 'Invalid parameter on command line or parameter missing.';
      2 : message := 'Configuration file not found with executable.  Consult the documentation.';
      7 : message := 'File handling error.  File may have been corrupted or deleted!';
      ELSE  message := 'Unknown error.';
    END;
    WriteLn (#7, 'Error encountered (#', ExitCode, '):'); WriteLn (message);
  END;
  cursorOn;
  Halt (problem);
END;

PROCEDURE CheckIO;
BEGIN
  IF IOResult <> 0 THEN ShowHelp (7);
END;

PROCEDURE updateCursor;
BEGIN
  cursorState := Succ (cursorState) AND 3;
  Write (cursorData [cursorState], ^H);
END;

PROCEDURE cursorOn; ASSEMBLER; ASM
  mov AH, 3; mov BH, 0; Int $10; AND CH, NOT $20; mov AH, 1; Int $10;
END;

PROCEDURE cursorOff; ASSEMBLER; ASM
  mov AH, 3; mov BH, 0; Int $10; OR CH, $20; mov AH, 1; Int $10;
END;

FUNCTION RTrim (InStr: STRING): STRING;
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [Length (InStr)] IN [#0, #9, #32]) DO
    system. Dec (InStr [0]);
  RTrim := InStr;
END;

FUNCTION LTrim (InStr: STRING): STRING;
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [1] IN [#0, #9, #32]) DO
    Delete (InStr, 1, 1);
  LTrim := InStr;
END;

FUNCTION Trim (InStr: STRING): STRING;
BEGIN
  Trim := RTrim (LTrim (InStr));
END;

PROCEDURE UpFast (VAR Str: STRING);  {** from SWAG **}
INLINE ($8C/$DA/$5E/$1F/$FC/$AC/$30/$E4/$89/$C1/$E3/$12/$BB/Ord('a')/Ord('z')/
        $AC/$38/$D8/$72/$08/$38/$F8/$77/$04/$80/$6C/$FF/$20/$E2/$F1/$8E/$DA);

FUNCTION Upper (lstr : STRING): STRING;
BEGIN
  upfast (lstr);
  Upper := lstr;
END;

FUNCTION IsFile (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) <> Directory)
    THEN IsFile := TRUE
    ELSE IsFile := FALSE;
END;

FUNCTION IsDir (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) = Directory)
    THEN IsDir := TRUE
    ELSE IsDir := FALSE;
END;

FUNCTION GetFilePath (CONST PSTR: STRING; VAR sDir: DIRSTR): PATHSTR;
VAR
  jPath     : PATHSTR;  { file path,       }
  jDir      : DIRSTR;   {      directory,  }
  jName     : NAMESTR;  {      name,       }
  jExt      : EXTSTR;   {      extension.  }
BEGIN
  jPath := PSTR;
  IF jPath = '' THEN jPath := '*.*';
  IF (NOT (jPath [Length (jPath)] IN [':', '\'])) AND IsDir (jPath) THEN
    jPath := jPath + '\';
  IF (jPath [Length (jPath)] IN [':', '\']) THEN
    jPath := jPath + '*.*';

  FSplit (FExpand (jPath), jDir, jName, jExt);
  jPath := jDir + jName+ jExt;

  sDir := jDir;
  GetFilePath := jPath;
END;

FUNCTION extractCode (CONST colorline: STRING): STRING;
VAR
  p1, p2 : BYTE;
BEGIN
  p1 := Pos ('[', colorline)+1;
  p2 := Pos (']', colorline);
  extractCode := Trim (Copy (colorline, p1, p2 - p1));
END;

PROCEDURE InitColors;
VAR
  cpath : PATHSTR; {cpath, etc fully qualified pathnames of *.cfg files}
  cdir  : DIRSTR;
  cname : NAMESTR;
  cext  : EXTSTR;
  CfgFile: TEXT;
  CfgLine,
  CfgVar, CfgVal: PATHSTR;

BEGIN
  FSplit (FExpand (ParamStr(0)), cdir, cname, cext); { break up path into components }
  cpath := cdir + cname + '.cfg';

  IF IsFile (cpath) THEN
  BEGIN
    Assign (CfgFile, cpath);
    Reset (CfgFile);
    CheckIO;
  END
  ELSE
    showhelp (2);

  ColorARRAY [CLRname] := '';
  ColorARRAY [CLRsize] := '';
  ColorARRAY [CLRdate] := '';
  ColorARRAY [CLRdesc] := '';
  ColorARRAY [CLRinfo] := '';

  WHILE NOT SeekEoF (CfgFile) DO
  BEGIN { readColorArray }
    ReadLn (CfgFile, CfgLine);
    CfgVar := Upper (Copy (CfgLine, 1, 7));
    IF Copy (CfgVar, 1, 3) = 'CLR' THEN
    BEGIN
      CfgVal := extractCode (CfgLine);
      IF CfgVar = 'CLRNAME' THEN ColorARRAY [CLRname] := CfgVal ELSE
      IF CfgVar = 'CLRSIZE' THEN ColorARRAY [CLRsize] := CfgVal ELSE
      IF CfgVar = 'CLRDATE' THEN ColorARRAY [CLRdate] := CfgVal ELSE
      IF CfgVar = 'CLRDESC' THEN ColorARRAY [CLRdesc] := CfgVal ELSE
      IF CfgVar = 'CLRINFO' THEN ColorARRAY [CLRinfo] := CfgVal
    END;
  END;                                    { loop back to read another line }
  Close (CfgFile);
END;

FUNCTION IsNewDesc (CONST currentline : STRING) : BOOLEAN;
CONST
  hyphen = #45; space = #32;  { simple ways of minimizing typing errors  }

VAR
  IsNew   : BOOLEAN;    { is this the first line of a file desc?   }
  valsize : LONGINT;    { filesize }
  vErr    : INTEGER;    { will give error if filesize not a number }
BEGIN
  {----
  Determine a valid first line by looking for a non-space/ control char in
  the first position, and verifying file size, date, and proper spacing
  between the size and date (file size is a number in columns 15-21).
  ----}
  IsNew := FALSE;
  IF ((Length (currentline) > 30) AND (currentline [1] > space)) THEN BEGIN
    Val (Copy (currentline, 15, 7), valsize, vErr);
    IF (vErr = 0) THEN  {if there is a filesize where expected...}
      IsNew := ((currentline [26] = hyphen) AND (currentline [29] = hyphen)
            AND (currentline [22] = space)  AND (currentline [23] = space));
  END;
  IsNewDesc := IsNew;
END;

PROCEDURE ColorizeFile (VAR source, dest : TEXT); {actually rewrite the file }
VAR
  NewLine  : STRING;   { the line just read, now being processed       }
  InDesc   : BOOLEAN;  { have we found a first line of a description ? }
  DescLine : BYTE;     { if second line of description, then colorize  }
                       { with CLRinfo color code                       }
BEGIN
  InDesc := FALSE;     { Initialize vars ... }
  DescLine := 1;
  WHILE NOT EoF (source) DO
  BEGIN
    FillChar (NewLine [1], SizeOf (NewLine), 0); { clear out old line !!! }
    ReadLn (source, NewLine);
    UpdateCursor;

    IF InDesc AND (NewLine [1] = #32) THEN   {Process description line }
    BEGIN
      Inc (DescLine);
      IF DescLine = 2 THEN
        NewLine := ColorARRAY [CLRinfo] + NewLine
    END
    ELSE
    BEGIN    { First char not a space, or not processing a description, }
      InDesc := IsNewDesc (NewLine); { Perhaps it starts a new filedesc?}
      IF InDesc THEN               { YES!, we are in a new description! }
      BEGIN
        NewLine :=
          ColorARRAY [CLRname] + Copy (NewLine, 1, 12) +
          ColorARRAY [CLRsize] + Copy (NewLine, 13 + (Length (ColorARRAY [CLRsize]) MOD 4), 10) +
          ColorARRAY [CLRdate] + Copy (NewLine, 24, 10) +
          ColorARRAY [CLRdesc] + Copy (NewLine, 34, (Length (NewLine) - 33));
        DescLine := 1;
      END
    END;
    WriteLn (dest, NewLine);
  END;             { loop back to read another line - PHEW! }
END;

{---- TYPEs, CONSTs and VARs for "main" program ----}
TYPE
  FileList = ^FILEREC;
  FILEREC = RECORD
              Name : STRING [12];
              next : FileList;
            END;

CONST
  outname = 'pcbc!#$!.out';
  tmpname = 'pcbc!#$!.tmp';

VAR
  dirinfo : SEARCHREC;
  spath   : PATHSTR;
  sdir    : DIRSTR;
  sfn, dfn, tfn : PATHSTR;
  infile, outfile : TEXT;

  anchor, chain : FileList;
  done    : BOOLEAN;
  numdone : WORD;

  FileDateTime : LONGINT;

BEGIN
  IF ParamCount <> 1 THEN ShowHelp (1);
  InitColors;
  sPath := GetFilePath (ParamStr (1), sDir);
  dfn := sdir + outname;
  tfn := sdir + tmpname;

  numdone := 0;
  anchor := NIL;

  FindFirst (spath, Archive, dirinfo);

{---- Okay, let's go! ----}

  cursorOff;
  WHILE DosError = 0 DO
  BEGIN
    sfn := sdir + dirinfo. Name;
    done := FALSE;
    chain := anchor;            { check if file was processed file already }
    WHILE (chain <> NIL) AND (NOT done) DO
      IF (chain^. Name = dirinfo. Name)
        THEN done := TRUE
        ELSE chain := chain^. next;

{---- Only process if not processed before ----}

    IF (NOT done) THEN BEGIN
      Inc (numdone);
      New (chain);
      chain^. Name := dirinfo. Name; { add current name to beginning of list }
      chain^. next := anchor;
      anchor := chain;

{---- Process the file! ----}

      Write ('Colorizing ', sfn, ', ');  { tell user file is being processed }

      Assign (infile, sfn); Reset (infile); CheckIO;
      Assign (outfile, dfn); Rewrite (outfile); CheckIO;

      ColorizeFile (infile, outfile);
      WriteLn ('done!');     { tell user this file has been processed }

      GetFTime (infile, FileDateTime);
      SetFTime (outfile, FileDateTime);

{---- Close files, then find next file to process ----}

      Close (infile);        CheckIO;
      Close (outfile);       CheckIO;
      Rename (infile, tfn);  CheckIO;
      Rename (outfile, sfn); CheckIO;
      Erase (infile);        CheckIO;
    END;
    FindNext (dirinfo);
  END;     { now loop back with name of next file to process }

{---- dispose of pointers - not necessary at end, but good practice ----}

  WHILE chain <> NIL DO BEGIN
    anchor := chain;
    chain := chain^. next;
    Dispose (anchor);
  END;

  WriteLn ('Processed ', numdone, ' file(s).');
  cursorOn;
END. {main}
