#!/usr/bin/php
<?php
  require_once( 'mystic_library.php' );

  echo "********************************\n";
  echo "** mystic_library demo script **\n";
  echo "********************************\n";
  echo "\n";

  $mystic = new mystic( './data/', 1.12 );
  
  echo "\nLast callers:\n";
  var_dump( $mystic->lastcallers() );

  echo "\nOneliner:\n";
  var_dump( $mystic->oneliner() );

  echo "\nChat:\n";
  var_dump( $mystic->chat( 10 ) );

  echo "\nHistory:\n";
  var_dump( $mystic->history( 2 ) );
  
  echo "\nUserlist:\n";
  var_dump( $mystic->userlist() );

  echo "\nFilebases:\n";
  var_dump( $mystic->fbases() );

  echo "\nFiles:\n";

  $days = 100;
  $bases = true;
  $count = 0;
  while ( $bases != false ) {
    $bases = $mystic->fbases( 10, $count*10 );
    if ( $bases != false ) {
      foreach ( $bases as $base ) {
        $files = true;
        $count2 = 0;
        $title = false;
        while ( $files != false ) {
          $files = $mystic->files( $base['filename'], 10, $count2*10 );
          if ( $files != false ) {
            foreach ( $files as $file ) {
              if ( $file['datetime'] >= time()-(86400*$days) ) {
                if ( $title == false ) {
                  echo "\n\n\n". $base['name'] ."\n";
                  echo str_repeat( '=', strlen( $base['name'] ) ) ."\n\n";
                  echo "Filename  Size  Date        Description\n";
                  echo str_repeat( '-', 78 ) ."\n";
                  $title = true;
                }
                echo str_pad( $file['filename'], 14, ' ' ) ."\n";
                echo str_pad( round( $file['size']/1024 ) ."KB", 14, ' ', STR_PAD_LEFT ) ."  ";
                echo str_pad( date ( 'Y-m-d', $file['datetime'] ), 12, ' ' );
                $count3 = 0;
                foreach ( $file['desc'] as $d ) {
                  if ( $count3 > 0 ) {
                    echo str_repeat( ' ', 28 );
                  }
                  echo $d ."\n";
                  $count3++;
                }
              }
            }
          }
          $count2++;
        }
      }
    }
    $count++;
  }
