#include <io.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <process.h>
#include <share.h>
#include <string.h>

typedef struct {
  char    FullPath[66];
  char    Other[63];
} Namestype;     // Record length (129 bytes)
Namestype *Names;

int   SortName(const void *l, const void *r);
//***************************************************************************
int main(int argc, char **argv)
{
    int       Handle, Bytes, Length;
    char      Filename[10];

    Length=300*sizeof(Namestype);
    Names = malloc(Length);

    memset(Filename, 0, 10);
    memcpy(Filename, argv[1], strlen(argv[1]));

    Handle = sopen(Filename, O_RDWR, SH_DENYNO, S_IREAD | S_IWRITE);
    if (Handle<0) {
        printf("\nError opening FLIST.# for reading/writing.\n");
        return 1;
    }
    if ((Bytes = _read(Handle, Names, Length)) == -1) {
        printf("\nError reading FLIST.#\n");
        return 1;
    }
    qsort(Names, Bytes/sizeof(Namestype), sizeof(Namestype), SortName);
    lseek(Handle, 0L, SEEK_SET);
    _write(Handle, Names, Bytes);
    return 0;
}
// **************************************************************************
int  SortName(const void *l, const void *r)
{
   Namestype *lp = (Namestype *) l;
   Namestype *rp = (Namestype *) r;
   return strcmp(lp->FullPath, rp->FullPath);
}
