''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'FrontDoor Statistics Generator              Copyright (C) 1996 Scott Hall   '
'-------------------------------------------------------------------------   '
'This program is Copyright (C) 1996 Scott Hall. I grant permission for any   '
'person or company to use any of this program of portions thereof for any    '
'purpose EXCEPT WHERE the subsequent product:                                '
'                                                                            '
' a) is not available to the public free of charge.                          '
' b) is called "FrontDoor Statistics Generator" or "FDSTAT"                  '
'                                                                            '
'If you use this program, or portions thereof, you accept the above condions.'                                                         '
'                                                                            '
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
DECLARE SUB PressEnter (Pause AS INTEGER, Beeps AS INTEGER)
DECLARE SUB ASCIItoASL (X%)
DECLARE FUNCTION AnsiColor$ (Attr AS INTEGER)
DECLARE SUB SaveAscScrn (FileNum AS INTEGER, Title AS INTEGER)
DECLARE SUB SaveAslScrn (FileNum AS INTEGER)
DECLARE SUB SaveAnsiScrn (FileNum AS INTEGER)
DECLARE SUB BBSScreens (FDStatOut AS INTEGER, BBS AS STRING, Node AS STRING)
DECLARE SUB DrawScreen (VERSION$)
Copyright1$ = "FrontDoor Statistics Generator Copyright (C) Scott Hall 1996"
Copyright2$ = "FDStat Copyright (C) Scott Hall 1996"

'*********************************************************************
'*******************  DON'T FORGET TO TURN ON  ***********************
'*******************     "ON ERROR..."         ***********************
'*********************************************************************
ON ERROR GOTO ErrorProc

'---------------------------------------------------------------------
CONST VERSION$ = "2.11"
'---------------------------------------------------------------------
DIM Pause AS INTEGER
DIM Beeps AS INTEGER
DIM BBS AS STRING
DIM Node AS STRING
DIM FDStatOut AS INTEGER

' Detect present screen colors
CLS
DosAttr = SCREEN(CSRLIN, POS(0), 1)
DosForeClr = (DosAttr AND &H7)
DosBackClr = (DosAttr AND &H70) / 16

' Declare symbolic constants used in program:

FieldsFore = 2
FieldsBack = 0
CONST DATEFORE = 14
CONST DATEBACK = 0
CONST FALSE = 0, True = NOT FALSE
Beeps = 1  'Default BEEP On
Pause = 1  'Default PAUSE On

'--------------------------------------------------------------------------
'                           Australian Date Format
'--------------------------------------------------------------------------
D$ = MID$(DATE$, 4, 2)
M$ = MID$(DATE$, 1, 2)
Y$ = MID$(DATE$, 7, 4)
IF M$ = "01" THEN M$ = "Jan"
IF M$ = "02" THEN M$ = "Feb"
IF M$ = "03" THEN M$ = "Mar"
IF M$ = "04" THEN M$ = "Apr"
IF M$ = "05" THEN M$ = "May"
IF M$ = "06" THEN M$ = "Jun"
IF M$ = "07" THEN M$ = "Jul"
IF M$ = "08" THEN M$ = "Aug"
IF M$ = "09" THEN M$ = "Sep"
IF M$ = "10" THEN M$ = "Oct"
IF M$ = "11" THEN M$ = "Nov"
IF M$ = "12" THEN M$ = "Dec"
ADATE$ = D$ + "-" + M$ + "-" + Y$

'--------------------------------------------------------------------------
'                              Get FDStat Switches
'--------------------------------------------------------------------------
DIM Switch$(5)

Log$ = "FD.LOG"
IF COMMAND$ <> "" THEN
  
   'Convert Switches to variables
   CmdLength = LEN(COMMAND$)
    
   Switch = 1
   FOR Letter = 1 TO CmdLength
         
       IF MID$(COMMAND$, Letter, 1) = " " THEN
            
          'Don't increment to the Next Word variable if the previous
          'Word variable has not been used. This would happen in the
          'case of a double space being encountered.
          'NewSwitch is set to 1 when the present Word variable has been
          'used.
          IF NewSwitch = 0 THEN
             Switch$ = ""
             Switch = Switch + 1
             NewSwitch = 1
          END IF
       ELSE
          Switch$ = Switch$ + MID$(COMMAND$, Letter, 1)
          NewSwitch = 0
       END IF

       ' /? -? ?

       IF INSTR(Switch$, "?") THEN
         
          PRINT
          PRINT " FDStat [/LOG={ [Path] Log File}]  [/OUT={ [Path] Output File }] "
          PRINT "        [/BBS={BBS Screen Path}] [/NODE={Node}] [/NoPause] [/NoBeep] "
          PRINT
          PRINT " /LOG=  is used to specify the path & file name of the FD log to be"
          PRINT "        processed. If /LOG is not used it will default to FD.LOG in"
          PRINT "        the FD directory. If only a file name is supplied it will"
          PRINT "        look for it in the FD directory. If a full path and file name"
          PRINT "        is supplied it will process that log file. "
          PRINT
          PRINT " /OUT=  is used to direct the output to a path & filename."
          PRINT "        If /OUT is not used it will default to FDSTAT.LOG in the FD "
          PRINT "        directory (See /NODE). If only a file name is supplied it will "
          PRINT "        place it in the FD directory. If a full path and file name is "
          PRINT "        supplied it will place the output there. "
          PRINT
          PRINT " /BBS=  Causes BBS style FDSTAT.ANS/ASC/ASL screens from statistics"
          PRINT "        screen to be placed in the supplied directory. (See /NODE)"
          PRINT "        ie. /BBS=C:\BBS\SCREENS\"
          PRINT
          PRINT " /NODE= is used to modify the the filenames FDSTAT.LOG and FDSTAT.ANS/"
          PRINT "        ASC/ASL (BBS Screens) to include a node number."
          PRINT "        ie /NODE=1 will produce FDSTAT1.xxx  Other names not modified."
          PRINT "more..."
          DO WHILE ik$ = ""
             ik$ = INKEY$
          LOOP
          PRINT
          PRINT " /NoPause   means that the program will not pause and wait for you "
          PRINT " /NP        to acknowledge the error message found in the FD log "
          PRINT "            being processed."
          PRINT
          PRINT " /NoBeep    is used to stop the program from beeping when an an error "
          PRINT " /NB        message was found in the FD log being processed."
          PRINT
          PRINT " Note: You can use path '.\{filename}' to indicate the current directory"
          PRINT "       for /OUT= and /LOG= parameters."
          PRINT
          END
       END IF

       ' was /DIR=[<Drive>:]<Path>

       IF UCASE$(LEFT$(Switch$, 5)) = "/DIR=" THEN
          PRINT
          PRINT "FrontDoor Statistics Generator "; VERSION$
          BEEP
          PRINT
          PRINT "/DIR= is no longer a valid parameter as /LOG= can now"
          PRINT "handle full paths. See documentation or type FDSTAT /?"
          PRINT
          END
       END IF


       ' /LOG=<FileName>

       IF UCASE$(LEFT$(Switch$, 5)) = "/LOG=" THEN
          Log$ = MID$(Switch$, 6, LEN(Switch$))
       END IF


       ' /OUT=<FileName>

       IF UCASE$(LEFT$(Switch$, 5)) = "/OUT=" THEN
          Out$ = MID$(Switch$, 6, LEN(Switch$))
       END IF


       ' /NOBEEP

       IF UCASE$(LEFT$(Switch$, 7)) = "/NOBEEP" OR UCASE$(LEFT$(Switch$, 3)) = "/NB" THEN
          Beeps = 0
       END IF


       ' /NOPAUSE

       IF UCASE$(LEFT$(Switch$, 8)) = "/NOPAUSE" OR UCASE$(LEFT$(Switch$, 3)) = "/NP" THEN
          Pause = 0
       END IF
   
       ' /BBS=  Produce BBS Screens FDSTAT.ANS, FDSTAT.ASC and FDSTAT.ASL

       IF UCASE$(LEFT$(Switch$, 5)) = "/BBS=" THEN
          BBS = MID$(Switch$, 6, LEN(Switch$))
       END IF
   
       ' /NODE=  Produce BBS Screens FDSTAT.ANS, FDSTAT.ASC and FDSTAT.ASL

       IF UCASE$(LEFT$(Switch$, 6)) = "/NODE=" THEN
          Node = MID$(Switch$, 7, LEN(Switch$))
       END IF
       IF LEN(Node) > 2 THEN
          PRINT
          PRINT "FrontDoor Statistics Generator "; VERSION$
          BEEP
          PRINT
          PRINT "The /NODE parameter can only be 2 characters in length."
          PRINT "You have supplied /NODE="; Node
          PRINT
          END
       END IF


    NEXT
END IF


'------------------------------------------------------------------------
'    If Log location is not supplied Check for FD Environment variable
'------------------------------------------------------------------------
IF FDDir$ = "" THEN

   Env = Env + 1
   DO WHILE ENVIRON$(Env) <> ""
      IF LEFT$(ENVIRON$(Env), 3) = "FD=" THEN EXIT DO
      Env = Env + 1
   LOOP

   IF ENVIRON$(Env) = "" THEN
      CLS
      PRINT "Oh No! FD environment variable has not been set!"
      PRINT
      PRINT "       Typically you should have 'FD=C:\FD' in your AUTOEXEC.BAT"
      PRINT "       Please read the FrontDoor documentation for help."
      PRINT
      PRINT "       OR you may use the /LOG and /OUT switch with full paths."
      PRINT
      PRINT "Ending FDStat! "; VERSION$; "    :("
      END
   END IF

   Env$ = MID$(ENVIRON$(Env), 4, LEN(ENVIRON$(Env)))
   FDDir$ = Env$

END IF

IF Env$ = "" THEN
   IF FDDir$ = "" THEN
      Env$ = "* FD Environment variable not found *"
   ELSE
      Env$ = "* /LOG=<dir> or /BBS=<dir> invalid, or /LOG=<log file> not found *"
   END IF
END IF

'--------------------------------------------------------------------------
'              Set input and output file variables
'--------------------------------------------------------------------------
IF Log$ = "" THEN Log$ = "FD.LOG"
IF Out$ = "" THEN Out$ = "FDSTAT" + Node$ + ".LOG"

IF RIGHT$(FDDir$, 1) <> "\" THEN FDDir$ = FDDir$ + "\"

IF (INSTR(Log$, ":") <> 2) AND (INSTR(Log$, "\") = 0) THEN
   FDLog$ = UCASE$(FDDir$ + Log$)       ' Log File
ELSE
   FDLog$ = UCASE$(Log$)                ' Log File
END IF


IF (INSTR(Out$, ":") <> 2) AND (INSTR(Out$, "\") = 0) THEN
   FDStatFile$ = UCASE$(FDDir$ + Out$)       ' Output File
ELSE
   FDStatFile$ = UCASE$(Out$)              ' Output File
END IF

IF RIGHT$(BBS, 1) <> "\" THEN BBS = BBS + "\"

 
'--------------------------------------------------------------------------
'                      Draw Screen for Stats
'--------------------------------------------------------------------------

CALL DrawScreen(VERSION$)

Processing$ = "Processing Log... " + UCASE$(FDLog$) + " into " + FDStatFile$
LOCATE 25, 80 - LEN(Processing$)
COLOR 11, 0
PRINT Processing$;

MaxUnexPass = 50
DIM UnexPass(50) AS STRING
MaxAKA = 50
DIM AKAStr(50) AS STRING
DIM ConnPoll(14)

DIM ConnInHuman(16)               'Human Connections per CONNECT speed
DIM ConnInComp(14)                'Comp  Connections per CONNECT speed
DIM ConnOutComp(14)
DIM FilesOutBytesTotal(14) AS LONG        '
DIM FilesOutBytesSession AS LONG        '
DIM FilesOutSecs(14)
DIM FilesOutCPS(14)
DIM FilesOut(14)
DIM FilesInBytesTotal(14) AS LONG
DIM FilesInBytesSession AS LONG
DIM FilesInSecs(14)
DIM FilesInCPS(14)
DIM FilesIn(14)
DIM ConnInHumanRow%(16)
DIM ConnInHumanCol%(16)
DIM ConnInCompRow%(14)
DIM ConnInCompCol%(14)
DIM ConnOutCompRow%(14)
DIM ConnOutCompCol%(14)
DIM FilesRow%(14)
DIM FilesInConnCol%(14)         ''was files sent recieved in in/out file box
DIM FilesOutConnCol%(14)        ''
DIM FilesInKbCol%(14)
DIM FilesOutKbCol%(14)
DIM FilesInCPSCol%(14)
DIM FilesOutCPSCol%(14)
DIM KbOut AS LONG
DIM KbIn AS LONG
DIM LogLine AS LONG
DIM TossStartInSecs AS LONG
DIM TossEndInSecs AS LONG
DIM TossTime AS LONG
ConnInHumanRow%(1) = 16: ConnInHumanRow%(2) = 17: ConnInHumanRow%(3) = 18: ConnInHumanRow%(4) = 19:
ConnInHumanRow%(5) = 16: ConnInHumanRow%(6) = 17: ConnInHumanRow%(7) = 18: ConnInHumanRow%(8) = 19:
ConnInHumanRow%(9) = 16: ConnInHumanRow%(10) = 17: ConnInHumanRow%(11) = 18: ConnInHumanRow%(12) = 19:
ConnInHumanRow%(13) = 16: ConnInHumanRow%(14) = 17: ConnInHumanRow%(15) = 18: ConnInHumanRow%(16) = 19:

ConnInHumanCol%(1) = 7: ConnInHumanCol%(2) = 7: ConnInHumanCol%(3) = 7: ConnInHumanCol%(4) = 7:
ConnInHumanCol%(5) = 16: ConnInHumanCol%(6) = 16: ConnInHumanCol%(7) = 16: ConnInHumanCol%(8) = 16:
ConnInHumanCol%(9) = 26: ConnInHumanCol%(10) = 26: ConnInHumanCol%(11) = 26: ConnInHumanCol%(12) = 26:
ConnInHumanCol%(13) = 36: ConnInHumanCol%(14) = 36: ConnInHumanCol%(15) = 36: ConnInHumanCol%(16) = 36:

ConnInCompRow%(1) = 8: ConnInCompRow%(2) = 9: ConnInCompRow%(3) = 10:
ConnInCompRow%(4) = 11: ConnInCompRow%(5) = 12: ConnInCompRow%(6) = 13: ConnInCompRow%(7) = 14
ConnInCompRow%(8) = 8: ConnInCompRow%(9) = 9: ConnInCompRow%(10) = 10:
ConnInCompRow%(11) = 11: ConnInCompRow%(12) = 12: ConnInCompRow%(13) = 13: ConnInCompRow%(14) = 14

ConnOutCompCol%(1) = 8: ConnOutCompCol%(2) = 8: ConnOutCompCol%(3) = 8:
ConnOutCompCol%(4) = 8: ConnOutCompCol%(5) = 8: ConnOutCompCol%(6) = 8: ConnOutCompCol%(7) = 8:
ConnOutCompCol%(8) = 47: ConnOutCompCol%(9) = 47: ConnOutCompCol%(10) = 47:
ConnOutCompCol%(11) = 47: ConnOutCompCol%(12) = 47: ConnOutCompCol%(13) = 47: ConnOutCompCol%(14) = 47:

ConnOutCompRow%(1) = 8: ConnOutCompRow%(2) = 9: ConnOutCompRow%(3) = 10:
ConnOutCompRow%(4) = 11: ConnOutCompRow%(5) = 12: ConnOutCompRow%(6) = 13: ConnOutCompRow%(7) = 14
ConnOutCompRow%(8) = 8: ConnOutCompRow%(9) = 9: ConnOutCompRow%(10) = 10:
ConnOutCompRow%(11) = 11: ConnOutCompRow%(12) = 12: ConnOutCompRow%(13) = 13: ConnOutCompRow%(14) = 14

ConnInCompCol%(1) = 12: ConnInCompCol%(2) = 12: ConnInCompCol%(3) = 12:
ConnInCompCol%(4) = 12: ConnInCompCol%(5) = 12: ConnInCompCol%(6) = 12: ConnInCompCol%(7) = 12:
ConnInCompCol%(8) = 51: ConnInCompCol%(9) = 51: ConnInCompCol%(10) = 51:
ConnInCompCol%(11) = 51: ConnInCompCol%(12) = 51: ConnInCompCol%(13) = 51: ConnInCompCol%(14) = 51:

FilesRow%(1) = 8: FilesRow%(2) = 9: FilesRow%(3) = 10:
FilesRow%(4) = 11: FilesRow%(5) = 12: FilesRow%(6) = 13: FilesRow%(7) = 14:
FilesRow%(8) = 8: FilesRow%(9) = 9: FilesRow%(10) = 10:
FilesRow%(11) = 11: FilesRow%(12) = 12: FilesRow%(13) = 13: FilesRow%(14) = 14

FilesInKbCol%(1) = 16: FilesInKbCol%(2) = 16: FilesInKbCol%(3) = 16:
FilesInKbCol%(4) = 16: FilesInKbCol%(5) = 16: FilesInKbCol%(6) = 16: FilesInKbCol%(7) = 16:
FilesInKbCol%(8) = 55: FilesInKbCol%(9) = 55: FilesInKbCol%(10) = 55:
FilesInKbCol%(11) = 55: FilesInKbCol%(12) = 55: FilesInKbCol%(13) = 55: FilesInKbCol%(14) = 55:

FilesOutKbCol%(1) = 22: FilesOutKbCol%(2) = 22: FilesOutKbCol%(3) = 22:
FilesOutKbCol%(4) = 22: FilesOutKbCol%(5) = 22: FilesOutKbCol%(6) = 22: FilesOutKbCol%(7) = 22:
FilesOutKbCol%(8) = 61: FilesOutKbCol%(9) = 61: FilesOutKbCol%(10) = 61:
FilesOutKbCol%(11) = 61: FilesOutKbCol%(12) = 61: FilesOutKbCol%(13) = 61: FilesOutKbCol%(14) = 61:

FilesOutCPSCol%(1) = 28: FilesOutCPSCol%(2) = 28: FilesOutCPSCol%(3) = 28:
FilesOutCPSCol%(4) = 28: FilesOutCPSCol%(5) = 28: FilesOutCPSCol%(6) = 28: FilesOutCPSCol%(7) = 28:
FilesOutCPSCol%(8) = 67: FilesOutCPSCol%(9) = 67: FilesOutCPSCol%(10) = 67:
FilesOutCPSCol%(11) = 67: FilesOutCPSCol%(12) = 67: FilesOutCPSCol%(13) = 67: FilesOutCPSCol%(14) = 67:

FilesInCPSCol%(1) = 33: FilesInCPSCol%(2) = 33: FilesInCPSCol%(3) = 33:
FilesInCPSCol%(4) = 33: FilesInCPSCol%(5) = 33: FilesInCPSCol%(6) = 33: FilesInCPSCol%(7) = 33:
FilesInCPSCol%(8) = 72: FilesInCPSCol%(9) = 72: FilesInCPSCol%(10) = 72:
FilesInCPSCol%(11) = 72: FilesInCPSCol%(12) = 72: FilesInCPSCol%(13) = 72: FilesInCPSCol%(14) = 72:

DO
   Restart = FALSE
  
   IF FDLog$ = "" OR FDStatFile$ = "" THEN
      PRINT "One or more files could not be found!"
      END
   ELSE

      ' Otherwise, open the file, assigning it the
      ' next available file number:
      FDLogFile = FREEFILE
      OPEN FDLog$ FOR INPUT AS FDLogFile
      FDStatOut = FREEFILE
      OPEN FDStatFile$ FOR OUTPUT AS FDStatOut
      PRINT #FDStatOut, "Ŀ"
      PRINT #FDStatOut, " FrontDoor Statistics Generator "; VERSION$; TAB(41); " Scott Hall 3:712/393 shall@world.net "
      PRINT #FDStatOut, ""
      PRINT #FDStatOut, " Produced on: "; ADATE$; " at "; TIME$; " from "; FDLog$;
      IF Node <> "" THEN PRINT #FDStatOut, " for Node "; Node;
      PRINT #FDStatOut,
   END IF

   IF NOT Restart THEN

      ' *** Process FrontDoor Log ***
   
      LineNum = 1
      DO WHILE NOT EOF(FDLogFile)
         InsidePoll = 0
         DIM Word$(30)
         PollingBBS$ = " <Unknown> "
         FilesInBytesSession = 0
         FilesOutBytesSession = 0
         FilesInSecsSession = 0
         FilesOutSecsSession = 0
         FilesInCPSSession = 0
         FilesOutCPSSession = 0
         ConnBaud = 0
         Secs = 0
         CPS = 0

         IF NoLineGet = 0 THEN GOSUB FDLine
         NoLineGet = 0
        
         '-----------------------------------------------------------
         'Process each line of FD.LOG according to Words encountered!
         '-----------------------------------------------------------

         GOSUB Date
         GOSUB Time
         IF Word$(3) = "RING" THEN GOSUB ring
         IF Word$(3) = "Calling" THEN GOSUB Calling
        
         IF MID$(LineBuffer$, 13, 26) = "Mail received, errorlevel=" THEN
            TossTimeMin = 0
            TossTimeSecs = 0
            TossStart$ = TimeCurrent$
            IF LEN(TossStart$) = 7 THEN TossStart$ = "0" + TossStart$
            GOSUB FDLine
            DO UNTIL INSTR(Word$(2), ":")
               GOSUB FDLine
            LOOP
            IF LEN(Word$(2)) = 7 THEN Word$(2) = "0" + Word$(2)
            TossStartInSecs = VAL(RIGHT$(TossStart$, 2)) + (60 * VAL(MID$(TossStart$, 4, 2))) + (3600 * VAL(LEFT$(TossStart$, 2)))
            TossEndInSecs = VAL(RIGHT$(Word$(2), 2)) + (60 * VAL(MID$(Word$(2), 4, 2))) + (3600 * VAL(LEFT$(Word$(2), 2)))
            TossTimeSecs = TossEndInSecs - TossStartInSecs
            IF TossTimeSecs < 0 THEN TossTimeSecs = (60 * 24) - TossTimeSecs
            DO UNTIL TossTimeSecs < 60
               TossTimeMin = TossTimeMin + 1
               TossTimeSecs = TossTimeSecs - 60
            LOOP
            TTSec$ = LTRIM$(STR$(TossTimeSecs))
            IF LEN(TTSec$) = 1 THEN TTSec$ = "0" + TTSec$
            PRINT #FDStatOut, "                     Toss:   "; LTRIM$(STR$(TossTimeMin)); ":"; TTSec$; ", ("; TossStart$; " - "; Word$(2); ")"
         END IF
         '-----------------------------------------------------------

       LOOP
       CLOSE FileNum             ' Close the file.

   END IF
LOOP WHILE Restart = True

' ------------------------------------------------------------------------
' EOF Proceedures
' ------------------------------------------------------------------------
EndOfFile:
COLOR DATEFORE, DATEBACK
LOCATE 23, 45
PRINT DateCurrent$; "  ";
LOCATE 23, 60
IF LEN(TimeCurrent$) = 7 THEN PRINT "0";
PRINT TimeCurrent$;
LOCATE 24, 69
COLOR 3, 0
PRINT "  Writing...";
LOCATE 24, 80
PRINT #FDStatOut,

BBSScreens FDStatOut, BBS, Node

CLOSE FDLogFile, FDStatOut
LOCATE 24, 69
COLOR 3, 0
PRINT "  Completed!";
COLOR DosForeClr, DosBackClr
END

'===========================================================================
'==================================== EXIT =================================
'===========================================================================

                                                                            
' FrontDoor Log individual line proceedures. Each is executed depending on
' the words encountered on each line of the LOG.
                                                                          

'--------------------------------------------------------------------------
' Obtain opening log date & current date being processed. Current date
' will be used to find end of log date when EOF is found.
'--------------------------------------------------------------------------
Date:
 
IF DateBegin = 0 AND Word$(1) = "----------" THEN
   IF Word$(2) = "" THEN GOSUB FDLine
   DateBegin$ = Word$(2) + " " + Word$(3) + " " + Word$(4) + " " + Word$(5)
   DateBegin = 1
   LOCATE 24, 1
   COLOR DATEFORE, DATEBACK
   PRINT SPACE$(80);
   LOCATE 23, 12
   PRINT DateBegin$
END IF
IF Word$(1) = "----------" THEN
   DateCurrent$ = Word$(2) + " " + Word$(3) + " " + Word$(4) + " " + Word$(5)
   IF DateCurrent$ <> DateOld$ THEN
      PRINT #FDStatOut,
      PRINT #FDStatOut, LineBuffer$
   END IF
   DateOld$ = DateCurrent$
END IF
COLOR NORMALFORE, NORMALBACK
RETURN

'---------------------------------------------------------------------------
' Obtain opening log time & current time being processed. Current time
' will be used to find end of log time when EOF is found.
'---------------------------------------------------------------------------
Time:
IF LEFT$(Word$(2), 1) = "0" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "1" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "2" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "3" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "4" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "5" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "6" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "7" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "8" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "9" THEN TimeCurrent$ = Word$(2)
IF TimeBegin = 0 AND TimeCurrent$ <> "" THEN
   TimeBegin$ = TimeCurrent$
   TimeBegin = 1
   COLOR DATEFORE, DATEBACK
   LOCATE 23, 27
   IF LEN(TimeBegin$) = 7 THEN PRINT "0";
   PRINT TimeBegin$
   LOCATE 23, 45
   PRINT "Processing line:"
   COLOR NORMALFORE, NORMALBACK
END IF
RETURN

'---------------------------------------------------------------------------
' Incoming caller/poller detected (RING). Process stats on transaction
'---------------------------------------------------------------------------
ring:
InsidePoll = -1
AKA = 1
GOSUB FDLine

IF Word$(3) = "RING" OR Word$(3) = "DFRS:" THEN GOTO ring

' Get CONNECT baud Rate
' Determine if Human or Computer Caller and total calls

' IF NOT CONNECT RECIEVED SEE AFTER THE ELSE COMMAND BELOW!!!

IF Word$(3) = "CONNECT" THEN
  IF VAL(LEFT$(Word$(4), 5)) >= 0 THEN ConnPoll = 1
  IF VAL(LEFT$(Word$(4), 5)) >= 4800 THEN ConnPoll = 2
  IF VAL(LEFT$(Word$(4), 5)) >= 7200 THEN ConnPoll = 3
  IF VAL(LEFT$(Word$(4), 5)) >= 9600 THEN ConnPoll = 4
  IF VAL(LEFT$(Word$(4), 6)) >= 12000 THEN ConnPoll = 5
  IF VAL(LEFT$(Word$(4), 6)) >= 14400 THEN ConnPoll = 6
  IF VAL(LEFT$(Word$(4), 6)) >= 16800 THEN ConnPoll = 7
  IF VAL(LEFT$(Word$(4), 6)) >= 19200 THEN ConnPoll = 8
  IF VAL(LEFT$(Word$(4), 6)) >= 21600 THEN ConnPoll = 9
  IF VAL(LEFT$(Word$(4), 6)) >= 24000 THEN ConnPoll = 10
  IF VAL(LEFT$(Word$(4), 6)) >= 26400 THEN ConnPoll = 11
  IF VAL(LEFT$(Word$(4), 6)) >= 28800 THEN ConnPoll = 12
  IF VAL(LEFT$(Word$(4), 6)) >= 31200 THEN ConnPoll = 13
  IF VAL(LEFT$(Word$(4), 6)) >= 33600 THEN ConnPoll = 14
  IF VAL(LEFT$(Word$(4), 4)) >= 300 THEN ConnHuman = 1
  IF VAL(LEFT$(Word$(4), 5)) >= 1200 THEN ConnHuman = 2
  IF VAL(LEFT$(Word$(4), 5)) >= 2400 THEN ConnHuman = 3
  IF VAL(LEFT$(Word$(4), 5)) >= 4800 THEN ConnHuman = 4
  IF VAL(LEFT$(Word$(4), 5)) >= 7200 THEN ConnHuman = 5
  IF VAL(LEFT$(Word$(4), 5)) >= 9600 THEN ConnHuman = 6
  IF VAL(LEFT$(Word$(4), 6)) >= 12000 THEN ConnHuman = 7
  IF VAL(LEFT$(Word$(4), 6)) >= 14400 THEN ConnHuman = 8
  IF VAL(LEFT$(Word$(4), 6)) >= 16800 THEN ConnHuman = 9
  IF VAL(LEFT$(Word$(4), 6)) >= 19200 THEN ConnHuman = 10
  IF VAL(LEFT$(Word$(4), 6)) >= 21600 THEN ConnHuman = 11
  IF VAL(LEFT$(Word$(4), 6)) >= 24000 THEN ConnHuman = 12
  IF VAL(LEFT$(Word$(4), 6)) >= 26400 THEN ConnHuman = 13
  IF VAL(LEFT$(Word$(4), 6)) >= 28800 THEN ConnHuman = 14
  IF VAL(LEFT$(Word$(4), 6)) >= 31200 THEN ConnHuman = 15
  IF VAL(LEFT$(Word$(4), 6)) >= 33600 THEN ConnHuman = 16

  'IF ConnHuman >= 9 THEN FieldsFore = 2 ELSE FieldsFore = 3

  ConnPoll$ = Word$(4) + " " + Word$(5) + " " + Word$(6) + " " + Word$(7)
  ConnBaud = 1
  GOSUB FDLine
       
  IF MID$(LineBuffer$, 13, 15) = "Sending text in" THEN
     REM do nothing... because we want Rejecting.. Incoming.. Unexpected
     REM or BBS Name
     GOSUB FDLine
  END IF

  'If = or ! found for first word then exit Caller Processing because
  ' = means that the modem got RING, NO CARRIER, BUSY etc. and
  ' and - means user hit Func key or "- HH:MM:SS Preparing outbound mail"
  ' so the caller must have been lost without error message
  ' being produced in the log.
  IF Word$(1) = "=" OR Word$(1) = "-" OR Word$(1) = "!" OR Word$(1) = "" OR Word$(3) = "Calling" OR (Word$(3) = "Preparing" AND Word$(4) = "outbound" AND Word$(5) = "mail") THEN
ConnInFail:
     NoLineGet = 1
     HumanInFailed = HumanInFailed + 1
     LOCATE 21, 29
     COLOR 12, 0
     PRINT USING "####"; HumanInFailed
     COLOR FieldsFore, FILELDSBACK
     PRINT #FDStatOut,
     IF CommentFail$ = "" THEN CommentFail$ = " (unable to process)"
     PRINT #FDStatOut, LEFT$(LineBuffer2$, 12); "   Lost: "; MID$(LineBuffer2$, 13, 38); CommentFail$
     LOCATE 24, 1
     PRINT "                                                                                ";
     LOCATE 24, 1
     COLOR 12, 0
     PRINT DateCurrent$; " "; LEFT$(LineBuffer2$, 45); CommentFail$;
     CommentFail$ = ""
     IF Beeps = 1 THEN BEEP
     IF Pause = 1 THEN
        PressEnter Pause, Beeps
     END IF
     RETURN
  END IF

  IF Word$(3) = "Rejecting" THEN
      HumanReject = HumanReject + 1
      COLOR 11
      LOCATE 21, 17
      PRINT USING "####"; HumanReject
         
  ELSE
      IF Word$(3) = "Incoming" THEN
         ConnInHuman(ConnHuman) = ConnInHuman(ConnHuman) + 1
         LOCATE ConnInHumanRow%(ConnHuman), ConnInHumanCol%(ConnHuman)
         PRINT USING "###"; ConnInHuman(ConnHuman)
         ConnInHuman = ConnInHuman + 1
         LOCATE 20, 29
         COLOR 10
         PRINT USING "####"; ConnInHuman
      ELSE
           
         '******  Process Computer Connection (ConnPoll) *********************

         ConnInComp(ConnPoll) = ConnInComp(ConnPoll) + 1
         LOCATE ConnInCompRow%(ConnPoll), ConnInCompCol%(ConnPoll)
         PRINT USING "###"; ConnInComp(ConnPoll)

         PRINT #FDStatOut,
        
         DO
        
          'Test if we lost connection!
          IF (Word$(3) = "Calling" AND INSTR(LineBuffer$, ",") > 1 AND INSTR(LineBuffer$, ":") > 1 AND INSTR(LineBuffer$, "/") > 1) OR (Word$(1) = "+" AND Word$(3) = "RING") OR (Word$(1) = "----------") OR (Word$(3) = "Event" AND MID$(Word$(4), 2, 1 _
) = "-") THEN
             NoLineGet = 1
             IF UnexPass > 1 OR BBSNameFound = 1 THEN
                ConnInFailed = ConnInFailed + 1
                LOCATE 20, 50
                COLOR 12, 0
                PRINT USING "####"; ConnInFailed
                COLOR FieldsFore, FILELDSBACK
                LOCATE 24, 1
                PRINT "                                                                                ";
                LOCATE 24, 1
                COLOR 12, 0
                PRINT DateCurrent$; SPACE$(11 - LEN(TimeCurrent$)); TimeCurrent$; "  > Poll ended abnormally! <";
                PRINT #FDStatOut, "              ERROR: > Poll ended abnormally! <"
                IF Beeps = 1 THEN BEEP
                IF Pause = 1 THEN
                   PressEnter Pause, Beeps
                END IF
             ELSE
                HumanInFailed = HumanInFailed + 1
                LOCATE 21, 29
                COLOR 12, 0
                PRINT USING "####"; HumanInFailed
                COLOR FieldsFore, FILELDSBACK
                LOCATE 24, 1
                PRINT "                                                                                ";
                LOCATE 24, 1
                COLOR 12, 0
                'PRINT DateCurrent$; SPACE$(11 - LEN(TimeCurrent2$)); TimeCurrent2$; "  Lost: "; MID$(LineBuffer2$, 13)
                PRINT LEFT$(LineBuffer2$, 45); " (unable to process)";
                PRINT #FDStatOut, LEFT$(LineBuffer2$, 12); "   Lost: "; MID$(LineBuffer2$, 13, 38); " (unable to process)"
                'PRINT #FDStatOut, "              ERROR: > Poll ended abnormally! <"
                IF Beeps = 1 THEN BEEP
                IF Pause = 1 THEN
                   PressEnter Pause, Beeps
                END IF
             END IF
             EXIT DO
          END IF
        
          'Constantly Process computer connection data until
          ' "From <Node>, <Time>, <Cost>" encountered indicating end of poll info.
         
          IF Word$(3) = "From" THEN
               COLOR 2, 0
               TimeInPollersSecs = TimeInPollersSecs + (VAL(RIGHT$(Word$(5), 3)) + 60 * VAL(Word$(5)))
               DO WHILE TimeInPollersSecs > 59
                  TimeInPollersMins = TimeInPollersMins + 1
                  TimeInPollersSecs = TimeInPollersSecs - 60
               LOOP
               LOCATE 18, 49
               PRINT USING "###"; TimeInPollersMins
               LOCATE 18, 52: PRINT ":";
               LOCATE 18, 53
               IF TimeInPollersSecs > 9 THEN
                  PRINT USING "##"; TimeInPollersSecs
               ELSE
                  PRINT "0"; LTRIM$(STR$(TimeInPollersSecs))
               END IF
               EXIT DO: REM Exit the Major Do for Polling/Poller processing.
          END IF

          DO WHILE Word$(3) = "Unexpected" AND Word$(4) = "password,"
               UnexPass = UnexPass + 1          ''''''
               UnexPass(UnexPass) = Word$(7)
               GOSUB FDLine
            LOOP
            IF Word$(3) = "Password" AND Word$(4) = "error:" THEN
               ErrorPassword = ErrorPassword + 1
               ErrorOther = ErrorOther - 1
               LOCATE 20, 75
               COLOR 12, 0
               PRINT USING "###"; ErrorPassword
               COLOR FieldsFore, FieldsBack
            END IF
            IF Word$(3) = "Session" AND Word$(4) = "handshake" AND Word$(5) = "failure" THEN
               ErrorPoller = ErrorPoller + 1
               ErrorOther = ErrorOther - 1
               LOCATE 20, 50
               COLOR 12, 0
               PRINT USING "####"; ErrorPoller
               COLOR FieldsFore, FieldsBack
            END IF
            IF Word$(1) = "?" OR (Word$(3) = "Terminating" AND Word$(4) = "call") THEN
               COLOR 12, 0
               ErrorOther = ErrorOther + 1
              
               ' Process Sent incomplete error
           
               IF Word$(6) = "(incomplete)" THEN
                  IF Word$(3) = "Send" THEN FileOutError = FileOutError + 1
                  IF Word$(3) = "Rcvd" THEN FileInError = FileInError + 1
                  ErrorOther = ErrorOther - 1
                  LOCATE 21, 64
                  IF FileOutError > 0 THEN PRINT USING "###"; FileOutError
                  LOCATE 20, 64
                  IF FileInError > 0 THEN PRINT USING "###"; FileInError
               END IF

               LOCATE 21, 75
               IF ErrorOther <> 0 THEN PRINT USING "###"; ErrorOther
              
               'Print error except for passwords in password error
               IF Word$(3) = "Password" AND Word$(4) = "error:" THEN
                  PRINT #FDStatOut, LEFT$(LineBuffer$, 12); "  ERROR: Password error from "; Word$(10)
               ELSE
                  PRINT #FDStatOut, LEFT$(LineBuffer$, 12); "  ERROR: "; MID$(LineBuffer$, 13, LEN(LineBuffer$) - 12)
               END IF
              
               LOCATE 24, 1
               PRINT "                                                                                ";
               LOCATE 24, 1
               COLOR 12, 0
               PRINT DateCurrent$; " "; LEFT$(LineBuffer$, 65);
               IF Beeps = 1 THEN BEEP
               IF Pause = 1 THEN
                  PressEnter Pause, Beeps
               END IF
               
               IF Word$(3) = "Session" AND Word$(4) = "handshake" AND Word$(5) = "failure" THEN
                  BBSNameFound = 0
                  PrtConn = 0
                  UnexPass = 0
                  UnexPassTest = 0
                  ERASE UnexPass
                  ERASE AKAStr
                  InString = 0
                  PollingBBS$ = " <Unknown> "
                  'PRINT #FDStatOut,
                  RETURN
                  'EXIT DO
               END IF
            END IF
            
            IF BBSNameFound = 0 AND Word$(1) = "+" THEN
               IF MID$(LineBuffer$, 13) = "Rescan requested" THEN GOTO ConnInFail ' 1.66
               IF MID$(LineBuffer$, 13, 7) = "Event 0" THEN GOTO ConnInFail
               IF MID$(LineBuffer$, 13, 7) = "Event 1" THEN GOTO ConnInFail
               IF MID$(LineBuffer$, 13, 7) = "Event 2" THEN GOTO ConnInFail
               IF MID$(LineBuffer$, 13, 7) = "Event 3" THEN GOTO ConnInFail
               IF MID$(LineBuffer$, 13, 7) = "Event 4" THEN GOTO ConnInFail
               IF MID$(LineBuffer$, 13, 7) = "Event 5" THEN GOTO ConnInFail
               IF MID$(LineBuffer$, 13, 7) = "Event 6" THEN GOTO ConnInFail
               IF MID$(LineBuffer$, 13, 7) = "Event 7" THEN GOTO ConnInFail
               IF MID$(LineBuffer$, 13, 7) = "Event 8" THEN GOTO ConnInFail
               IF MID$(LineBuffer$, 13, 7) = "Event 9" THEN GOTO ConnInFail
               'Line$ = LEFT$(LineBuffer$, INSTR(LineBuffer$, ","))
               'IF Line$ = "" THEN Line$ = LineBuffer$ + CHR$(13) + CHR$(10)    'Handles FTS-1 protocol
               'PRINT #FDStatOut,
               PRINT #FDStatOut, LEFT$(LineBuffer$, 12); " Poller:"; 'MID$(LineBuffer$, 13, INSTR(1, LineBuffer$, ",")); ", ";
              
               FOR n = 3 TO 30
                   IF Word$(n) <> "" THEN
                      IF Comma = 0 THEN
                         PRINT #FDStatOut, " "; Word$(n);
                      ELSE
                         IF INSTR(Word$(n), ":") > 1 AND INSTR(Word$(n), "/") > 1 THEN
                            PRINT #FDStatOut, " "; Word$(n); ", ";
                            Comma = 0
                            EXIT FOR
                         END IF
                      END IF
                      IF RIGHT$(Word$(n), 1) = "," THEN
                         Comma = 1
                      END IF
                   ELSE
                      EXIT FOR
                   END IF
               NEXT
              
               BBSNameFound = 1
              
               IF PrtConn = 0 THEN
                  PRINT #FDStatOut, RTRIM$(ConnPoll$)
                  PrtConn = 1
               END IF

               'Obtain Main Address from <The BBS Name>, <Main Address>
               DO WHILE AKAStr(0) = ""
                  InString = InString + 1
                  IF Word$(InString) = "" THEN EXIT DO
                  IF INSTR(Word$(InString), "/") > 0 AND INSTR(Word$(InString), ":") > 0 THEN
                     AKAStr(0) = Word$(InString)
                  END IF
               LOOP
            END IF
         
            'Get Other AKAs

            IF Word$(3) = "AKA:" THEN
               AKAStr(AKA) = Word$(4)
               AKAStr(AKA + 1) = Word$(5)
               AKAStr(AKA + 2) = Word$(6)
               AKA = AKA + 3
            END IF
         
            'Compare Unexpected AKAs with AKAs presented to obtain
            'addresses recognised at this site.

            IF Word$(3) = "SysOp:" THEN
               PRINT #FDStatOut, "                     SysOp:  "; MID$(LineBuffer$, 20, LEN(LineBuffer$))
              
               FOR MaxAKATest = 0 TO MaxAKA             '1.65c - Set MaxAKATest
                   IF AKAStr(MaxAKATest) = "" THEN        'to number of presented
                      MaxAKATest = MaxAKATest - 1       'AKAs for speedy testing
                      EXIT FOR                          'against Unexpected
                   END IF                               'passwords.   <--+
               NEXT                                     '                |
               
               FOR MaxUnexPassTest = 0 TO MaxUnexPass             '1.65c - Set MaxUnexPassTest
                   IF AKAStr(MaxUnexPassTest) = "" THEN             'to number of presented
                      MaxUnexPassTest = MaxUnexPassTest - 1       'Unexpected passwords for
                      EXIT FOR                                    'speedy testing against AKAs
                   END IF
               NEXT
                   
               FOR AKATest = 0 TO MaxAKATest
                   FOR UnexPassTest = 0 TO MaxUnexPassTest
                       'AKA are shown as "AKA: <Node>, <Node>, <Node> therefore testing
                       'must account for comma as part of the word.
                       IF RIGHT$(AKAStr(AKATest), 1) = "," THEN AKAStr(AKATest) = LEFT$(AKAStr(AKATest), LEN(AKAStr(AKATest)) - 1)
                       IF AKAStr(AKATest) = UnexPass(UnexPassTest) THEN
                          AKAStr(AKATest) = ""
                       END IF
                   NEXT UnexPassTest
               NEXT AKATest
               IF AKAStr(1) <> "" THEN
                  PRINT #FDStatOut, "                     AKAs:   ";
                  AKALine = 0
                  FOR AKATest = 1 TO MaxAKA
                      IF AKAStr(AKATest) <> "" THEN
                         IF AKALine MOD 4 = 0 AND AKALine <> 0 THEN
                            PRINT #FDStatOut,
                            PRINT #FDStatOut, "                             ";
                         END IF
                         PRINT #FDStatOut, AKAStr(AKATest); " ";
                         AKALine = AKALine + 1
                      END IF
                  NEXT
                  PRINT
                  PRINT #FDStatOut,
               END IF
            END IF

            '**********  Poller Sent Files ***********************
            IF Word$(3) = "Sent" THEN
               
               ' Process Amount, Bytes & CPS Rate per Baud if Send completed

               IF Word$(6) <> "(incomplete)" THEN
                  Bytes = VAL(Word$(5))
                  CPS = VAL(Word$(6))
                  IF CPS <> 0 THEN
                     Secs = Bytes / CPS
                  ELSE
                     Secs = 1
                  END IF
                  FilesOutBytesTotal(ConnPoll) = FilesOutBytesTotal(ConnPoll) + Bytes
                  FilesOutSecs(ConnPoll) = FilesOutSecs(ConnPoll) + Secs
                 
                  FilesOutTotal = FilesOutTotal + 1
                  FilesOutBytesTotal = FilesOutBytesTotal + Bytes
                  FilesOutBytesSession = FilesOutBytesSession + Bytes
                  FilesOutSecsSession = FilesOutSecsSession + Secs
                  IF FilesOutSecsSession <> 0 THEN FilesOutCPSSession = INT(FilesOutBytesSession / FilesOutSecsSession)
                  
                  IF FilesOutSecs(ConnPoll) <> 0 THEN FilesOutCPS(ConnPoll) = FilesOutBytesTotal(ConnPoll) / FilesOutSecs(ConnPoll)
                  FilesOut(ConnPoll) = FilesOut(ConnPoll) + 1
                  LOCATE FilesRow%(ConnPoll), FilesOutKbCol%(ConnPoll)
                  KbOut = (FilesOutBytesTotal(ConnPoll) / 1024)
                  IF KbOut < 9999 THEN PRINT USING "####"; KbOut
                  IF KbOut > 9999 AND KbOut < 99999 THEN PRINT USING "##.#"; KbOut / 1024; : COLOR 15, 0: PRINT "M"
                  IF KbOut > 99999 AND KbOut < 999999 THEN PRINT USING "###"; KbOut / 1024; : COLOR 15, 0: PRINT "M"
                  IF KbOut > 999999 AND KbOut < 9999999 THEN PRINT USING "####"; KbOut / 1024; : COLOR 15, 0: PRINT "M"
                  IF KbOut > 9999999 AND KbOut < 99999999 THEN PRINT USING "##.#"; (KbOut / 1024) / 1024; : COLOR 14, 0: PRINT "G"
                  IF KbOut > 99999999 AND KbOut < 999999999 THEN PRINT USING "###"; (KbOut / 1024) / 1024; : COLOR 14, 0: PRINT "G"
                  IF KbOut > 999999999 AND KbOut < 9999999999# THEN PRINT USING "####"; (KbOut / 1024) / 1024; : COLOR 14, 0: PRINT "G"
                  IF KbOut > 9999999999# THEN PRINT "*****"
                  COLOR FieldsFore, FieldsBack
                  LOCATE FilesRow%(ConnPoll), FilesOutCPSCol%(ConnPoll)
                  IF FilesOutCPS(ConnPoll) <> 0 THEN PRINT USING "####"; FilesOutCPS(ConnPoll)
               END IF

               ' increment 'Other' files and then decrement if it is a TIC
               ' ??# (ie WE3) or PKT.
               
               FilesOutOther = FilesOutOther + 1
               EXT$ = RIGHT$(Word$(4), 4)
               EXT$ = LEFT$(EXT$, 3)
               IF LEFT$(EXT$, 2) = "SU" OR LEFT$(EXT$, 2) = "MO" OR LEFT$(EXT$, 2) = "TU" OR LEFT$(EXT$, 2) = "WE" OR LEFT$(EXT$, 2) = "TH" OR LEFT$(EXT$, 2) = "FR" OR LEFT$(EXT$, 2) = "SA" THEN
                  IF RIGHT$(EXT$, 1) = "0" OR RIGHT$(EXT$, 1) = "1" OR RIGHT$(EXT$, 1) = "2" OR RIGHT$(EXT$, 1) = "3" OR RIGHT$(EXT$, 1) = "4" OR RIGHT$(EXT$, 1) = "5" OR RIGHT$(EXT$, 1) = "6" OR RIGHT$(EXT$, 1) = "7" OR RIGHT$(EXT$, 1) = "8" OR  _
RIGHT$(EXT$, 1) = "9" THEN
                     FilesOutDDN = FilesOutDDN + 1
                     FilesOutOther = FilesOutOther - 1
                     LOCATE 16, 49
                     COLOR 2, 0
                     IF FilesOutDDN < 1000 THEN
                        PRINT USING "###"; FilesOutDDN
                     ELSE
                        PRINT USING "####"; FilesOutDDN
                     END IF
                     COLOR FieldsFore, FieldsBack
                  ELSE
                     PRINT #FDStatOut, SPACE$(21); "File:   "; Word$(3); " "; Word$(4); " "; LEFT$(Word$(5), LEN(Word$(5)) - 1)
                  END IF
               ELSE
                  IF EXT$ <> "PKT" AND EXT$ <> "TIC" AND EXT$ <> "REQ" THEN PRINT #FDStatOut, SPACE$(21); "File:   "; Word$(3); " "; Word$(4); " "; LEFT$(Word$(5), LEN(Word$(5)) - 1)
               END IF

               IF EXT$ = "PKT" THEN
                  FilesOutPKT = FilesOutPKT + 1
                  FilesOutOther = FilesOutOther - 1
                  LOCATE 16, 57
                  COLOR 2, 0
                 'PRINT USING "###"; FilesOutPKT
                  IF FilesOutPKT < 1000 THEN
                     PRINT USING "###"; FilesOutPKT
                  ELSE
                     PRINT USING "####"; FilesOutPKT
                  END IF
                  COLOR FieldsFore, FieldsBack
               END IF
           
               IF EXT$ = "TIC" THEN
                  FilesOutTIC = FilesOutTIC + 1
                  FilesOutOther = FilesOutOther - 1
                  LOCATE 16, 65
                  COLOR 2, 0
                  'PRINT USING "###"; FilesOutTIC
                  IF FilesOutTIC < 1000 THEN
                     PRINT USING "###"; FilesOutTIC
                  ELSE
                     PRINT USING "####"; FilesOutTIC
                  END IF
                  COLOR FieldsFore, FieldsBack
               END IF
          
               LOCATE 16, 75
               COLOR 2, 0
               IF FilesOutOther <> 0 THEN
                  IF FilesOutOther < 1000 THEN
                     PRINT USING "###"; FilesOutOther
                  ELSE
                     PRINT USING "####"; FilesOutOther
                  END IF
                  COLOR FieldsFore, FieldsBack
               END IF
            END IF
           
           ' '*** File Sending aborted by Remote Pollee ***
           '
           ' IF MID$(LineBuffer$, 13, 27) = "Receiver requested to skip " THEN
           '    FileOutError = FileOutError + 1
           '    PRINT #FDStatOut, "               Note: "; MID$(LineBuffer$, 13)
           ' END IF
           
            '*********** Poller Recieved files ******************************
           
            'Freq'ed files
            IF Word$(3) = "FREQ:" THEN PRINT #FDStatOut, "                     "; Word$(3); "   "; Word$(4)
           
            IF Word$(3) = "Rcvd" THEN
               
               ' Process Amount, Bytes & CPS Rate per Baud if Send completed

               IF Word$(6) <> "(incomplete)" THEN
                  
                  Bytes = VAL(Word$(5))
                  CPS = VAL(Word$(6))
                  IF CPS <> 0 THEN
                     Secs = Bytes / CPS
                  ELSE
                     Secs = 1
                  END IF
                  FilesInBytesTotal(ConnPoll) = FilesInBytesTotal(ConnPoll) + Bytes
                  FilesInSecs(ConnPoll) = FilesInSecs(ConnPoll) + Secs
                 
                  FilesInTotal = FilesInTotal + 1
                  FilesInBytesTotal = FilesInBytesTotal + Bytes
                  FilesInBytesSession = FilesInBytesSession + Bytes
                  FilesInSecsSession = FilesInSecsSession + Secs
                  IF FilesInSecsSession <> 0 THEN FilesInCPSSession = INT(FilesInBytesSession / FilesInSecsSession)
                 
                  IF FilesInSecs(ConnPoll) <> 0 THEN FilesInCPS(ConnPoll) = FilesInBytesTotal(ConnPoll) / FilesInSecs(ConnPoll)
                  FilesIn(ConnPoll) = FilesIn(ConnPoll) + 1
                  LOCATE FilesRow%(ConnPoll), FilesInKbCol%(ConnPoll)
                  'PRINT USING "####"; (FilesInBytesTotal(ConnPoll) / 1024)
                  KbIn = (FilesInBytesTotal(ConnPoll) / 1024)
                  IF KbIn < 9999 THEN PRINT USING "####"; KbIn
                  IF KbIn > 9999 AND KbIn < 99999 THEN PRINT USING "##.#"; KbIn / 1024; : COLOR 15, 0: PRINT "M"
                  IF KbIn > 99999 AND KbIn < 999999 THEN PRINT USING "###"; KbIn / 1024; : COLOR 15, 0: PRINT "M"
                  IF KbIn > 999999 AND KbIn < 9999999 THEN PRINT USING "####"; KbIn / 1024; : COLOR 15, 0: PRINT "M"
                  IF KbIn > 9999999 AND KbIn < 99999999 THEN PRINT USING "##.#"; (KbIn / 1024) / 1024; : COLOR 14, 0: PRINT "G"
                  IF KbIn > 99999999 AND KbIn < 999999999 THEN PRINT USING "###"; (KbIn / 1024) / 1024; : COLOR 14, 0: PRINT "G"
                  IF KbIn > 999999999 AND KbIn < 9999999999# THEN PRINT USING "####"; (KbIn / 1024) / 1024; : COLOR 14, 0: PRINT "G"
                  IF KbIn > 9999999999# THEN PRINT "*****"
                  COLOR FieldsFore, FieldsBack
                  LOCATE FilesRow%(ConnPoll), FilesInCPSCol%(ConnPoll)
                  IF FilesInCPS(ConnPoll) <> 0 THEN PRINT USING "####"; FilesInCPS(ConnPoll)
               END IF

               ' increment 'Other' files and then decrement if it is a TIC
               ' ??# (ie WE3) or PKT.

               FilesInOther = FilesInOther + 1
               EXT$ = RIGHT$(Word$(4), 4)
               EXT$ = LEFT$(EXT$, 3)
               IF LEFT$(EXT$, 2) = "SU" OR LEFT$(EXT$, 2) = "MO" OR LEFT$(EXT$, 2) = "TU" OR LEFT$(EXT$, 2) = "WE" OR LEFT$(EXT$, 2) = "TH" OR LEFT$(EXT$, 2) = "FR" OR LEFT$(EXT$, 2) = "SA" THEN
                  IF RIGHT$(EXT$, 1) = "0" OR RIGHT$(EXT$, 1) = "1" OR RIGHT$(EXT$, 1) = "2" OR RIGHT$(EXT$, 1) = "3" OR RIGHT$(EXT$, 1) = "4" OR RIGHT$(EXT$, 1) = "5" OR RIGHT$(EXT$, 1) = "6" OR RIGHT$(EXT$, 1) = "7" OR RIGHT$(EXT$, 1) = "8" OR  _
RIGHT$(EXT$, 1) = "9" THEN
                     FilesInDDN = FilesInDDN + 1
                     FilesInOther = FilesInOther - 1
                     LOCATE 17, 49
                     COLOR 2, 0
                     'PRINT USING "###"; FilesInDDN
                     IF FilesInDDN < 1000 THEN
                        PRINT USING "###"; FilesInDDN
                     ELSE
                        PRINT USING "####"; FilesInDDN
                     END IF
                     COLOR FieldsFore, FieldsBack
                  ELSE
                     PRINT #FDStatOut, SPACE$(21); "File:   "; Word$(3); " "; Word$(4); " "; LEFT$(Word$(5), LEN(Word$(5)) - 1)
                  END IF
               ELSE
                  IF EXT$ <> "PKT" AND EXT$ <> "TIC" AND EXT$ <> "REQ" THEN PRINT #FDStatOut, SPACE$(21); "File:   "; Word$(3); " "; Word$(4); " "; LEFT$(Word$(5), LEN(Word$(5)) - 1)
               END IF
          
               IF EXT$ = "PKT" THEN
                  FilesInPKT = FilesInPKT + 1
                  FilesInOther = FilesInOther - 1
                  LOCATE 17, 57
                  COLOR 2, 0
                  'PRINT USING "###"; FilesInPKT
                  IF FilesInPKT < 1000 THEN
                     PRINT USING "###"; FilesInPKT
                  ELSE
                     PRINT USING "####"; FilesInPKT
                  END IF
                  COLOR FieldsFore, FieldsBack
               END IF
          
               IF EXT$ = "TIC" THEN
                  FilesInTIC = FilesInTIC + 1
                  FilesInOther = FilesInOther - 1
                  LOCATE 17, 65
                  COLOR 2, 0
                  'PRINT USING "###"; FilesInTIC
                  IF FilesInTIC < 1000 THEN
                     PRINT USING "###"; FilesInTIC
                  ELSE
                     PRINT USING "####"; FilesInTIC
                  END IF
                  COLOR FieldsFore, FieldsBack
               END IF
       
               LOCATE 17, 75
               COLOR 2, 0
               IF FilesInOther <> 0 THEN
                  IF FilesInOther < 1000 THEN
                     PRINT USING "###"; FilesInOther
                  ELSE
                     PRINT USING "####"; FilesInOther
                  END IF
                  COLOR FieldsFore, FieldsBack
               END IF
           
            END IF
            
            GOSUB FDLine
       
         LOOP
        
         IF INSTR(Word$(5), ":") THEN
           
            IF FilesOutBytesSession < 10240 THEN
               Sent$ = RTRIM$(STR$(FilesOutBytesSession)) + "b"
            ELSE
               Sent$ = RTRIM$(STR$(INT(FilesOutBytesSession / 1024))) + "kb"
            END IF
          
            IF FilesInBytesSession < 10240 THEN
               Rcvd$ = RTRIM$(STR$(FilesInBytesSession)) + "b"
            ELSE
               Rcvd$ = RTRIM$(STR$(INT(FilesInBytesSession / 1024))) + "kb"
            END IF
            
            PRINT #FDStatOut, "                     Trans:  Sent"; Sent$; " at"; FilesOutCPSSession; "cps / Rcvd"; Rcvd$; " at"; FilesInCPSSession; "cps."
            PRINT #FDStatOut, "                     Online: "; Word$(5); " Cost: "; Word$(6)
            TotalCost = TotalCost + VAL(Word$(6))
            COLOR 2, 0
            LOCATE 18, 72
            IF TotalCost > 0 THEN
               IF TotalCost < 99999 THEN
                  PRINT USING "###.##"; (TotalCost / 100)
               ELSE
                  IF TotalCost < 99999900 THEN
                      PRINT USING "######"; (TotalCost / 100)
                  ELSE
                      PRINT "******"
                  END IF
               END IF
            END IF
         ELSE
            'PRINT #FDStatOut, "                     whilst connected to poller"; PollingBBS$
         END IF
         BBSNameFound = 0
         PrtConn = 0
         UnexPass = 0
         UnexPassTest = 0
         ERASE UnexPass
         ERASE AKAStr
         InString = 0
         PollingBBS$ = " <Unknown> "

         ' ****** End Poller Processing ********************
         
      END IF
   END IF
ELSE

   ' If RING and then "NO CARRIER" found in FD.LOG then assume Human Caller...
 
   IF Word$(3) = "NO" AND Word$(4) = "CARRIER" THEN
      CommentFail$ = " then NO CARRIER"
      'GOTO ConnInFail
   END IF
  
   'IF Word$(3) <> "CONNECT" AND (Word$(1) = "=" OR Word$(1) = "!" OR Word$(1) = "" OR Word$(1) = "-" OR Word$(3) = "Calling" OR (Word$(3) = "Preparing" AND Word$(4) = "outbound" AND Word$(5) = "mail")) THEN
   '   GOTO ConnInFail
   'END IF
  
   'IF Word$(1) = "=" OR Word$(1) = "" OR Word$(3) = "Calling" THEN RETURN
   'HumanInFailed = HumanInFailed + 1
   'LOCATE 21, 29
   'COLOR 12, 0
   'PRINT USING "####"; HumanInFailed
   'COLOR FieldsFore, FieldsBack

   GOTO ConnInFail

END IF
RETURN

'---------------------------------------------------------------------------
' Calls/Polls initiated by this FrontDoor Mailer to be processed.
'---------------------------------------------------------------------------
Calling:

   'Memorizing BBS Name we are Calling in case we fail to connect. So that
   'it can be reported in our FDStat Log (FDSTAT.LOG)

InsidePoll = -1
PollingBBS$ = ""
FOR n = 4 TO 30
    IF Word$(n) <> "" THEN
       PollingBBS$ = PollingBBS$ + " " + Word$(n)
    ELSE
       PollingBBS$ = LEFT$(PollingBBS$, LEN(PollingBBS$) - (LEN(Word$(n - 1)) + 2))
       EXIT FOR
    END IF
NEXT
PRINT #FDStatOut,
PRINT #FDStatOut, LEFT$(LineBuffer$, 10); "  Polling:"; PollingBBS$; ", ";

AKA = 1

GOSUB FDLine

'If modem produces RINGING then get next line and check for CONNECT

ringing:
IF Word$(3) = "RINGING" OR Word$(3) = "DFRS:" THEN
   GOSUB FDLine
   GOTO ringing
END IF

' Get CONNECT baud Rate

IF Word$(3) = "CONNECT" THEN
  IF VAL(LEFT$(Word$(4), 5)) >= 0 THEN ConnPoll = 1
  IF VAL(LEFT$(Word$(4), 5)) >= 4800 THEN ConnPoll = 2
  IF VAL(LEFT$(Word$(4), 5)) >= 7200 THEN ConnPoll = 3
  IF VAL(LEFT$(Word$(4), 5)) >= 9600 THEN ConnPoll = 4
  IF VAL(LEFT$(Word$(4), 6)) >= 12000 THEN ConnPoll = 5
  IF VAL(LEFT$(Word$(4), 6)) >= 14400 THEN ConnPoll = 6
  IF VAL(LEFT$(Word$(4), 6)) >= 16800 THEN ConnPoll = 7
  IF VAL(LEFT$(Word$(4), 6)) >= 19200 THEN ConnPoll = 8
  IF VAL(LEFT$(Word$(4), 6)) >= 21600 THEN ConnPoll = 9
  IF VAL(LEFT$(Word$(4), 6)) >= 24000 THEN ConnPoll = 10
  IF VAL(LEFT$(Word$(4), 6)) >= 26400 THEN ConnPoll = 11
  IF VAL(LEFT$(Word$(4), 6)) >= 28800 THEN ConnPoll = 12
  IF VAL(LEFT$(Word$(4), 6)) >= 31200 THEN ConnPoll = 13
  IF VAL(LEFT$(Word$(4), 6)) >= 33600 THEN ConnPoll = 14
  IF VAL(LEFT$(Word$(4), 4)) >= 300 THEN ConnHuman = 1
  IF VAL(LEFT$(Word$(4), 5)) >= 1200 THEN ConnHuman = 2
  IF VAL(LEFT$(Word$(4), 5)) >= 2400 THEN ConnHuman = 3
  IF VAL(LEFT$(Word$(4), 5)) >= 4800 THEN ConnHuman = 4
  IF VAL(LEFT$(Word$(4), 5)) >= 7200 THEN ConnHuman = 5
  IF VAL(LEFT$(Word$(4), 5)) >= 9600 THEN ConnHuman = 6
  IF VAL(LEFT$(Word$(4), 6)) >= 12000 THEN ConnHuman = 7
  IF VAL(LEFT$(Word$(4), 6)) >= 14400 THEN ConnHuman = 8
  IF VAL(LEFT$(Word$(4), 6)) >= 16800 THEN ConnHuman = 9
  IF VAL(LEFT$(Word$(4), 6)) >= 19200 THEN ConnHuman = 10
  IF VAL(LEFT$(Word$(4), 6)) >= 21600 THEN ConnHuman = 11
  IF VAL(LEFT$(Word$(4), 6)) >= 24000 THEN ConnHuman = 12
  IF VAL(LEFT$(Word$(4), 6)) >= 26400 THEN ConnHuman = 13
  IF VAL(LEFT$(Word$(4), 6)) >= 28800 THEN ConnHuman = 14
  IF VAL(LEFT$(Word$(4), 6)) >= 31200 THEN ConnHuman = 15
  IF VAL(LEFT$(Word$(4), 6)) >= 33600 THEN ConnHuman = 16
  
  'IF ConnHuman >= 9 THEN FieldsFore = 2 ELSE FieldsFore = 3

   ConnPoll$ = Word$(4) + " " + Word$(5) + " " + Word$(6) + " " + Word$(7)
   ConnBaud = 1
   GOSUB FDLine
          
   '******  Process Computer Connection (ConnPoll) *********************
        
   IF PrtConn = 0 THEN
      PRINT #FDStatOut, RTRIM$(ConnPoll$)
      PrtConn = 1
   END IF

   ConnOutComp(ConnPoll) = ConnOutComp(ConnPoll) + 1
   LOCATE ConnOutCompRow%(ConnPoll), ConnOutCompCol%(ConnPoll)
   PRINT USING "###"; ConnOutComp(ConnPoll)

   DO
      'Test if we lost connection!
      IF (Word$(3) = "Calling" AND INSTR(LineBuffer$, ",") > 1 AND INSTR(LineBuffer$, ":") > 1 AND INSTR(LineBuffer$, "/") > 1) OR (Word$(1) = "+" AND Word$(3) = "RING") OR (Word$(1) = "----------") OR (Word$(3) = "Event" AND MID$(Word$(4), 2, 1) =  _
"-") THEN
               NoLineGet = 1
               ConnOutFailed = ConnOutFailed + 1
               LOCATE 21, 50
               COLOR 12, 0
               PRINT USING "####"; ConnOutFailed
               COLOR FieldsFore, FILELDSBACK
               LOCATE 24, 1
               PRINT "                                                                                ";
               LOCATE 24, 1
               COLOR 12, 0
               PRINT DateCurrent$; SPACE$(11 - LEN(TimeCurrent$)); TimeCurrent$; "  > Poll ended abnormally! <";
               PRINT #FDStatOut, "              ERROR: > Poll ended abnormally! <"
               IF Beeps = 1 THEN BEEP
               IF Pause = 1 THEN
                  PressEnter Pause, Beeps
               END IF
         EXIT DO
      END IF

  
      'Constantly Process computer connection data until
      ' "From <Node>, <Time>, <Cost>" encountered indicating end of poll info.
   
            IF Word$(3) = "To" THEN
               COLOR 2, 0
               TimeOutPollersSecs = TimeOutPollersSecs + (VAL(RIGHT$(Word$(5), 3)) + 60 * VAL(Word$(5)))
               DO WHILE TimeOutPollersSecs > 59
                  TimeOutPollersMins = TimeOutPollersMins + 1
                  TimeOutPollersSecs = TimeOutPollersSecs - 60
               LOOP
               LOCATE 18, 64
               PRINT USING "###"; TimeOutPollersMins
               LOCATE 18, 67: PRINT ":";
               LOCATE 18, 68
               IF TimeOutPollersSecs > 9 THEN
                  PRINT USING "##"; TimeOutPollersSecs
               ELSE
                  PRINT "0"; LTRIM$(STR$(TimeOutPollersSecs))
               END IF
               EXIT DO       'Exit the Major Do for Polling/Poller processing.
            END IF
           
            DO WHILE Word$(3) = "Unexpected" AND Word$(4) = "password,"
               UnexPass = UnexPass + 1
               UnexPass(UnexPass) = Word$(7)
               GOSUB FDLine
            LOOP
           
            IF Word$(3) = "Password" AND Word$(4) = "error:" THEN
               ErrorPassword = ErrorPassword + 1
               ErrorOther = ErrorOther - 1
               LOCATE 20, 75
               COLOR 12, 0
               PRINT USING "###"; ErrorPassword
               COLOR FieldsFore, FieldsBack
            END IF
           
            IF Word$(3) = "Session" AND Word$(4) = "handshake" AND Word$(5) = "failure" THEN
               ConnOutFailed = ConnOutFailed + 1
               ErrorOther = ErrorOther - 1
               LOCATE 21, 50
               COLOR 12, 0
               PRINT USING "####"; ConnOutFailed
               COLOR FieldsFore, FieldsBack
            END IF
           
            IF Word$(1) = "?" OR (Word$(3) = "Terminating" AND Word$(4) = "call") THEN
               COLOR 12, 0
               ErrorOther = ErrorOther + 1
              
               ' Process Sent incomplete error
           
               IF Word$(6) = "(incomplete)" THEN
                  IF Word$(3) = "Send" THEN FileOutError = FileOutError + 1
                  IF Word$(3) = "Rcvd" THEN FileInError = FileInError + 1
                  ErrorOther = ErrorOther - 1
                  LOCATE 21, 64
                  IF FileOutError > 0 THEN PRINT USING "###"; FileOutError
                  LOCATE 20, 64
                  IF FileInError > 0 THEN PRINT USING "###"; FileInError
               END IF

               LOCATE 21, 75
               IF ErrorOther <> 0 THEN PRINT USING "###"; ErrorOther
              
               'Print error except for passwords in password error
               IF Word$(3) = "Password" AND Word$(4) = "error:" THEN
                  PRINT #FDStatOut, LEFT$(LineBuffer$, 12); "  ERROR: Password error from "; Word$(10)
               ELSE
                  PRINT #FDStatOut, LEFT$(LineBuffer$, 12); "  ERROR: "; MID$(LineBuffer$, 13, LEN(LineBuffer$) - 12)
               END IF
             
               LOCATE 24, 1
               PRINT "                                                                                ";
               LOCATE 24, 1
               COLOR 12, 0
               PRINT DateCurrent$; " "; LEFT$(LineBuffer$, 65);
               IF Beeps = 1 THEN BEEP
               IF Pause = 1 THEN
                  PressEnter Pause, Beeps
               END IF
              
               'Session handshake failure
               IF Word$(3) = "Session" AND Word$(4) = "handshake" AND Word$(5) = "failure" THEN
                  'PRINT #FDStatOut,
                  BBSNameFound = 0
                  PrtConn = 0
                  UnexPass = 0
                  UnexPassTest = 0
                  ERASE UnexPass
                  ERASE AKAStr
                  InString = 0
                  PollingBBS$ = " <Unknown> "
                  RETURN
                  'EXIT DO
               END IF
            END IF
            
            IF BBSNameFound = 0 AND Word$(1) = "+" THEN
           
               BBSNameFound = 1
           
               'Obtain Main Address from <The BBS Name>, <Main Address>
           
               DO WHILE AKAStr(0) = ""
                  InString = InString + 1
                  IF Word$(InString) = "" THEN EXIT DO
                  IF INSTR(Word$(InString), "/") > 0 AND INSTR(Word$(InString), ":") > 0 THEN
                     AKAStr(0) = Word$(InString)
                  END IF
               LOOP
            END IF
        
            'Get Other AKAs

            IF Word$(3) = "AKA:" THEN
               AKAStr(AKA) = Word$(4)
               AKAStr(AKA + 1) = Word$(5)
               AKAStr(AKA + 2) = Word$(6)
               AKA = AKA + 3
            END IF
        
            'Compare Unexpected AKAs with AKAs presented to obtain
            'addresses recognised at this site.

            IF Word$(3) = "SysOp:" THEN
               PRINT #FDStatOut, "                     SysOp:  "; MID$(LineBuffer$, 20, LEN(LineBuffer$))
              
               FOR MaxAKATest = 0 TO MaxAKA             '1.65c - Set MaxAKATest
                   IF AKAStr(MaxAKATest) = "" THEN        'to number of presented
                      MaxAKATest = MaxAKATest - 1       'AKAs for speedy testing
                      EXIT FOR                          'against Unexpected
                   END IF                               'passwords.   <--+
               NEXT                                     '                |
               FOR MaxUnexPassTest = 0 TO MaxUnexPass             '1.65c - Set MaxUnexPassTest
                   IF AKAStr(MaxUnexPassTest) = "" THEN             'to number of presented
                      MaxUnexPassTest = MaxUnexPassTest - 1       'Unexpected passwords for
                      EXIT FOR                                    'speedy testing against AKAs
                   END IF
               NEXT
              
               FOR AKATest = 0 TO MaxAKATest
                   FOR UnexPassTest = 0 TO MaxUnexPassTest
                       'AKA are shown as "AKA: <Node>, <Node>, <Node> therefore testing
                       'must account for comma as part of the word.
                       IF RIGHT$(AKAStr(AKATest), 1) = "," THEN AKAStr(AKATest) = LEFT$(AKAStr(AKATest), LEN(AKAStr(AKATest)) - 1)
                       IF AKAStr(AKATest) = UnexPass(UnexPassTest) THEN
                          AKAStr(AKATest) = ""
                       END IF
                   NEXT
               NEXT
               IF AKAStr(1) <> "" THEN
                  PRINT #FDStatOut, "                     AKAs:   ";
                  AKALine = 0
                  FOR AKATest = 1 TO MaxAKA
                      IF AKAStr(AKATest) <> "" THEN
                         IF AKALine MOD 4 = 0 AND AKALine <> 0 THEN
                            PRINT #FDStatOut,
                            PRINT #FDStatOut, "                             ";
                         END IF
                         PRINT #FDStatOut, AKAStr(AKATest); " ";
                         AKALine = AKALine + 1
                      END IF
                  NEXT
                  PRINT
                  PRINT #FDStatOut,
               END IF
            END IF

            '************ Calling/Polling Files sent ***********************

            IF Word$(3) = "Sent" THEN

               ' Process Sent incomplete error
            
               IF Word$(6) = "(incomplete)" THEN
                  FileOutError = FileOutError + 1
                  ErrorOther = ErrorOther - 1
                  LOCATE 21, 64
                  PRINT USING "###"; FileOutError
               END IF

               ' Process Amount, Bytes & CPS Rate per Baud if Send completed

               IF Word$(6) <> "(incomplete)" THEN
'                 Bytes = VAL(LEFT$(Word$(5), LEN(Word$(5)) - 1))
                  Bytes = VAL(Word$(5))
                  CPS = VAL(Word$(6))
                  IF CPS <> 0 THEN
                     Secs = Bytes / CPS
                  ELSE
                     Secs = 1
                  END IF
                  FilesOutBytesTotal(ConnPoll) = FilesOutBytesTotal(ConnPoll) + Bytes
                  FilesOutSecs(ConnPoll) = FilesOutSecs(ConnPoll) + Secs
                
                  FilesOutTotal = FilesOutTotal + 1
                  FilesOutBytesTotal = FilesOutBytesTotal + Bytes
                  FilesOutBytesSession = FilesOutBytesSession + Bytes
                  FilesOutSecsSession = FilesOutSecsSession + Secs
                  IF FilesOutSecsSession <> 0 THEN FilesOutCPSSession = INT(FilesOutBytesSession / FilesOutSecsSession)
               
                  IF FilesOutSecs(ConnPoll) <> 0 THEN FilesOutCPS(ConnPoll) = FilesOutBytesTotal(ConnPoll) / FilesOutSecs(ConnPoll)
                  FilesOut(ConnPoll) = FilesOut(ConnPoll) + 1
                  LOCATE FilesRow%(ConnPoll), FilesOutKbCol%(ConnPoll)
                  'PRINT USING "####"; (FilesOutBytesTotal(ConnPoll) / 1024)
                  KbOut = (FilesOutBytesTotal(ConnPoll) / 1024)
                  IF KbOut < 9999 THEN PRINT USING "####"; KbOut
                  IF KbOut > 9999 AND KbOut < 99999 THEN PRINT USING "##.#"; KbOut / 1024; : COLOR 15, 0: PRINT "M"
                  IF KbOut > 99999 AND KbOut < 999999 THEN PRINT USING "###"; KbOut / 1024; : COLOR 15, 0: PRINT "M"
                  IF KbOut > 999999 AND KbOut < 9999999 THEN PRINT USING "####"; KbOut / 1024; : COLOR 15, 0: PRINT "M"
                  IF KbOut > 9999999 AND KbOut < 99999999 THEN PRINT USING "##.#"; (KbOut / 1024) / 1024; : COLOR 14, 0: PRINT "G"
                  IF KbOut > 99999999 AND KbOut < 999999999 THEN PRINT USING "###"; (KbOut / 1024) / 1024; : COLOR 14, 0: PRINT "G"
                  IF KbOut > 999999999 AND KbOut < 9999999999# THEN PRINT USING "####"; (KbOut / 1024) / 1024; : COLOR 14, 0: PRINT "G"
                  IF KbOut > 9999999999# THEN PRINT "*****"
                  COLOR FieldsFore, FieldsBack
                  LOCATE FilesRow%(ConnPoll), FilesOutCPSCol%(ConnPoll)
                  IF FilesOutCPS(ConnPoll) <> 0 THEN PRINT USING "####"; FilesOutCPS(ConnPoll)
               END IF

               ' increment 'Other' files and then decrement if it is a TIC
               ' ??# (ie WE3) or PKT.
              
               FilesOutOther = FilesOutOther + 1
               EXT$ = RIGHT$(Word$(4), 4)
               EXT$ = LEFT$(EXT$, 3)
               IF LEFT$(EXT$, 2) = "SU" OR LEFT$(EXT$, 2) = "MO" OR LEFT$(EXT$, 2) = "TU" OR LEFT$(EXT$, 2) = "WE" OR LEFT$(EXT$, 2) = "TH" OR LEFT$(EXT$, 2) = "FR" OR LEFT$(EXT$, 2) = "SA" THEN
                  IF RIGHT$(EXT$, 1) = "0" OR RIGHT$(EXT$, 1) = "1" OR RIGHT$(EXT$, 1) = "2" OR RIGHT$(EXT$, 1) = "3" OR RIGHT$(EXT$, 1) = "4" OR RIGHT$(EXT$, 1) = "5" OR RIGHT$(EXT$, 1) = "6" OR RIGHT$(EXT$, 1) = "7" OR RIGHT$(EXT$, 1) = "8" OR  _
RIGHT$(EXT$, 1) = "9" THEN
                     FilesOutDDN = FilesOutDDN + 1
                     FilesOutOther = FilesOutOther - 1
                     LOCATE 16, 49
                     COLOR 2, 0
                     'PRINT USING "###"; FilesOutDDN
                     IF FilesOutDDN < 1000 THEN
                        PRINT USING "###"; FilesOutDDN
                     ELSE
                        PRINT USING "####"; FilesOutDDN
                     END IF
                     COLOR FieldsFore, FieldsBack
                  ELSE
                     PRINT #FDStatOut, SPACE$(21); "File:   "; Word$(3); " "; Word$(4); " "; LEFT$(Word$(5), LEN(Word$(5)) - 1)
                  END IF
               ELSE
                  IF EXT$ <> "PKT" AND EXT$ <> "TIC" AND EXT$ <> "REQ" THEN PRINT #FDStatOut, SPACE$(21); "File:   "; Word$(3); " "; Word$(4); " "; LEFT$(Word$(5), LEN(Word$(5)) - 1)
               END IF
              
               IF EXT$ = "PKT" THEN
                  FilesOutPKT = FilesOutPKT + 1
                  FilesOutOther = FilesOutOther - 1
                  LOCATE 16, 57
                  COLOR 2, 0
                  'PRINT USING "###"; FilesOutPKT
                  IF FilesOutPKT < 1000 THEN
                     PRINT USING "###"; FilesOutPKT
                  ELSE
                     PRINT USING "####"; FilesOutPKT
                  END IF
                  COLOR FieldsFore, FieldsBack
               END IF
          
               IF EXT$ = "TIC" THEN
                  FilesOutTIC = FilesOutTIC + 1
                  FilesOutOther = FilesOutOther - 1
                  LOCATE 16, 65
                  COLOR 2, 0
                 'PRINT USING "###"; FilesOutTIC
                  IF FilesOutTIC < 1000 THEN
                     PRINT USING "###"; FilesOutTIC
                  ELSE
                     PRINT USING "####"; FilesOutTIC
                  END IF
                  COLOR FieldsFore, FieldsBack
               END IF
             
               LOCATE 16, 75
               COLOR 2, 0
               IF FilesOutOther <> 0 THEN
                  IF FilesOutOther < 1000 THEN
                     PRINT USING "###"; FilesOutOther
                  ELSE
                     PRINT USING "####"; FilesOutOther
                  END IF
                  COLOR FieldsFore, FieldsBack
               END IF
          END IF            '2.11'
         
          '  '*** File Sending aborted by Poller ***
          '
          '  IF MID$(LineBuffer$, 13, 27) = "Receiver requested to skip " THEN
          '     FileOutError = FileOutError + 1
          '     PRINT #FDStatOut, "               Note: "; MID$(LineBuffer$, 13)
          '  END IF
           
           
            '*********** Calling/Polling Received (Rcvd) Files ************
          
            IF Word$(3) = "Rcvd" THEN

               ' Process Recieved error (Rcvd) incomplete error
           
               IF Word$(6) = "(incomplete)" THEN
                  FileOutError = FileOutError + 1
                  ErrorOther = ErrorOther - 1
                  LOCATE 20, 64
                  PRINT USING "###"; FileInError
               END IF

               ' Process Amount, Bytes & CPS Rate per Baud if Send completed

               IF Word$(6) <> "(incomplete)" THEN
                  
                  Bytes = VAL(Word$(5))
                  CPS = VAL(Word$(6))
                  IF CPS <> 0 THEN
                     Secs = Bytes / CPS
                  ELSE
                     Secs = 1
                  END IF
                  FilesInBytesTotal(ConnPoll) = FilesInBytesTotal(ConnPoll) + Bytes
                  FilesInSecs(ConnPoll) = FilesInSecs(ConnPoll) + Secs
                 
                  FilesInTotal = FilesInTotal + 1
                  FilesInBytesTotal = FilesInBytesTotal + Bytes
                  FilesInBytesSession = FilesInBytesSession + Bytes
                  FilesInSecsSession = FilesInSecsSession + Secs
                  IF FilesInSecsSession <> 0 THEN FilesInCPSSession = INT(FilesInBytesSession / FilesInSecsSession)

                  IF FilesInSecs(ConnPoll) <> 0 THEN FilesInCPS(ConnPoll) = FilesInBytesTotal(ConnPoll) / FilesInSecs(ConnPoll)
                  FilesIn(ConnPoll) = FilesIn(ConnPoll) + 1
                  ''LOCATE FilesRow%(ConnPoll), FilesInConnCol%(ConnPoll)
                  ''PRINT USING "###"; FilesIn(ConnPoll)
                  LOCATE FilesRow%(ConnPoll), FilesInKbCol%(ConnPoll)
                  'PRINT USING "####"; (FilesInBytesTotal(ConnPoll) / 1024)
                  KbIn = (FilesInBytesTotal(ConnPoll) / 1024)
                  IF KbIn < 9999 THEN PRINT USING "####"; KbIn
                  IF KbIn > 9999 AND KbIn < 99999 THEN PRINT USING "##.#"; KbIn / 1024; : COLOR 15, 0: PRINT "M"
                  IF KbIn > 99999 AND KbIn < 999999 THEN PRINT USING "###"; KbIn / 1024; : COLOR 15, 0: PRINT "M"
                  IF KbIn > 999999 AND KbIn < 9999999 THEN PRINT USING "####"; KbIn / 1024; : COLOR 15, 0: PRINT "M"
                  IF KbIn > 9999999 AND KbIn < 99999999 THEN PRINT USING "##.#"; (KbIn / 1024) / 1024; : COLOR 14, 0: PRINT "G"
                  IF KbIn > 99999999 AND KbIn < 999999999 THEN PRINT USING "###"; (KbIn / 1024) / 1024; : COLOR 14, 0: PRINT "G"
                  IF KbIn > 999999999 AND KbIn < 9999999999# THEN PRINT USING "####"; (KbIn / 1024) / 1024; : COLOR 14, 0: PRINT "G"
                  IF KbIn > 9999999999# THEN PRINT "*****"
                  COLOR FieldsFore, FieldsBack
                  LOCATE FilesRow%(ConnPoll), FilesInCPSCol%(ConnPoll)
                  IF FilesInCPS(ConnPoll) <> 0 THEN PRINT USING "####"; FilesInCPS(ConnPoll)
               END IF

               ' increment 'Other' files and then decrement if it is a TIC
               ' ??# (ie WE3) or PKT.

               FilesInOther = FilesInOther + 1
               EXT$ = RIGHT$(Word$(4), 4)
               EXT$ = LEFT$(EXT$, 3)
               IF LEFT$(EXT$, 2) = "SU" OR LEFT$(EXT$, 2) = "MO" OR LEFT$(EXT$, 2) = "TU" OR LEFT$(EXT$, 2) = "WE" OR LEFT$(EXT$, 2) = "TH" OR LEFT$(EXT$, 2) = "FR" OR LEFT$(EXT$, 2) = "SA" THEN
                  IF RIGHT$(EXT$, 1) = "0" OR RIGHT$(EXT$, 1) = "1" OR RIGHT$(EXT$, 1) = "2" OR RIGHT$(EXT$, 1) = "3" OR RIGHT$(EXT$, 1) = "4" OR RIGHT$(EXT$, 1) = "5" OR RIGHT$(EXT$, 1) = "6" OR RIGHT$(EXT$, 1) = "7" OR RIGHT$(EXT$, 1) = "8" OR  _
RIGHT$(EXT$, 1) = "9" THEN
                     FilesInDDN = FilesInDDN + 1
                     FilesInOther = FilesInOther - 1
                     LOCATE 17, 49
                     COLOR 2, 0
                     'PRINT USING "###"; FilesInDDN
                     IF FilesInDDN < 1000 THEN
                        PRINT USING "###"; FilesInDDN
                     ELSE
                        PRINT USING "####"; FilesInDDN
                     END IF
                     COLOR FieldsFore, FieldsBack
                  ELSE
                     PRINT #FDStatOut, SPACE$(21); "File:   "; Word$(3); " "; Word$(4); " "; LEFT$(Word$(5), LEN(Word$(5)) - 1)
                  END IF
               ELSE
                  IF EXT$ <> "PKT" AND EXT$ <> "TIC" AND EXT$ <> "REQ" THEN PRINT #FDStatOut, SPACE$(21); "File:   "; Word$(3); " "; Word$(4); " "; LEFT$(Word$(5), LEN(Word$(5)) - 1)
               END IF
         
               IF EXT$ = "PKT" THEN
                  FilesInPKT = FilesInPKT + 1
                  FilesInOther = FilesInOther - 1
                  LOCATE 17, 57
                  COLOR 2, 0
                  'RINT USING "###"; FilesInPKT
                  IF FilesInPKT < 1000 THEN
                     PRINT USING "###"; FilesInPKT
                  ELSE
                     PRINT USING "####"; FilesInPKT
                  END IF
                  COLOR FieldsFore, FieldsBack
               END IF
         
               IF EXT$ = "TIC" THEN
                  FilesInTIC = FilesInTIC + 1
                  FilesInOther = FilesInOther - 1
                  LOCATE 17, 65
                  COLOR 2, 0
                 'PRINT USING "###"; FilesInTIC
                  IF FilesInTIC < 1000 THEN
                     PRINT USING "###"; FilesInTIC
                  ELSE
                     PRINT USING "####"; FilesInTIC
                  END IF
                  COLOR FieldsFore, FieldsBack
               END IF
      
               LOCATE 17, 75
               COLOR 2, 0
               IF FilesInOther <> 0 THEN
                  IF FilesInOther < 1000 THEN
                     PRINT USING "###"; FilesInOther
                  ELSE
                     PRINT USING "####"; FilesInOther
                  END IF
                  COLOR FieldsFore, FieldsBack
               END IF
          
             END IF
             GOSUB FDLine
      
   LOOP

   'Check that a valid polling duration was recieved. If not assume error.

   IF INSTR(Word$(5), ":") THEN
           
      IF FilesOutBytesSession < 10240 THEN
         Sent$ = RTRIM$(STR$(FilesOutBytesSession)) + "b"
      ELSE
         Sent$ = RTRIM$(STR$(INT(FilesOutBytesSession / 1024))) + "kb"
      END IF
         
      IF FilesInBytesSession < 10240 THEN
         Rcvd$ = RTRIM$(STR$(FilesInBytesSession)) + "b"
      ELSE
         Rcvd$ = RTRIM$(STR$(INT(FilesInBytesSession / 1024))) + "kb"
      END IF
           
      PRINT #FDStatOut, "                     Trans:  Sent"; Sent$; " at"; FilesOutCPSSession; "cps / Rcvd"; Rcvd$; " at"; FilesInCPSSession; "cps."
      PRINT #FDStatOut, "                     Online: "; Word$(5); " Cost: "; Word$(6)
      TotalCost = TotalCost + VAL(Word$(6))
      COLOR 2, 0
      LOCATE 18, 72
      IF TotalCost > 0 THEN
         IF TotalCost < 99999 THEN
            PRINT USING "###.##"; (TotalCost / 100)
         ELSE
            IF TotalCost < 99999900 THEN
               PRINT USING "######"; (TotalCost / 100)
            ELSE
               PRINT "******"
            END IF
         END IF
      END IF
   ELSE
      'PRINT #FDStatOut, "                     whilst polling"; PollingBBS$
   END IF

   BBSNameFound = 0
   PrtConn = 0
   UnexPass = 0
   UnexPassTest = 0
   ERASE UnexPass
   ERASE AKAStr
   InString = 0
   PollingBBS$ = " <Unknown> "
  
   ' ****** End process computer connection 9600 ********************

ELSE   ' If a polling event does not produce "= hh:mm:ss CONNECT ..."

   IF Word$(1) = "=" THEN
      ConnOutFailed = ConnOutFailed + 1
      LOCATE 21, 50
      COLOR 12, 0
      PRINT USING "####"; ConnOutFailed
      PRINT #FDStatOut, MID$(LineBuffer$, 13)
      LOCATE 24, 1
      PRINT "                                                                                ";
      LOCATE 24, 1
      PRINT DateCurrent$; " "; LEFT$(LineBuffer$, 65);
      IF Beeps = 1 THEN BEEP
      IF Pause = 1 THEN
         PressEnter Pause, Beeps
      END IF
   ELSE
      PRINT #FDStatOut, "Aborted"  'CONNECT or Modem Message "=" not recieved 1.66
   END IF
END IF
NoLineGet = 1
RETURN


'--------------------------------------------------------------------------
' Obtain Words from each line of line of the FD.LOG for processing.
'--------------------------------------------------------------------------
FDLine:
ik$ = INKEY$
IF ik$ = CHR$(27) THEN
   CLOSE #FDLogFile, #FDStatOut
   LOCATE 24, 72
   COLOR 14, 0
   PRINT " ABORTED!";
   END
END IF

LogLine = LogLine + 1
LOCATE 23, 61
COLOR DATEFORE, DATEBACK
PRINT USING "#######"; LogLine

' Input line from file:
ERASE Word$
IF EOF(FDLogFile) THEN GOTO EndOfFile
LINE INPUT #FDLogFile, LineBuffer$
   
' Creat display of proceessing and processed lines.
COLOR FieldsFore, FieldsBack

LOCATE 3, 3
PRINT "                                                                            "
LOCATE 4, 3
PRINT "                                                                            "
LOCATE 5, 3
PRINT "                                                                            "
LOCATE 3, 4
IF LEFT$(LineBuffer2$, 1) = "?" OR LEFT$(LineBuffer2$, 1) = "!" THEN COLOR 12, 0
IF (LEFT$(LineBuffer2$, 1) = "%" AND MID$(LineBuffer2$, 13, 5) <> "FREQ:") OR (LEFT$(LineBuffer2$, 1) = "=" AND (MID$(LineBuffer2$, 13, 4) <> "RING" AND MID$(LineBuffer2$, 13, 8) <> "CONNECT " AND MID$(LineBuffer2$, 13, 5) <> "DFRS:")) THEN COLOR 14 _
, 0
PRINT LEFT$(LineBuffer2$, 74);
COLOR FieldsFore, FieldsBack
LOCATE 4, 4
IF LEFT$(LineBuffer1$, 1) = "?" OR LEFT$(LineBuffer1$, 1) = "!" THEN COLOR 12, 0
IF (LEFT$(LineBuffer1$, 1) = "%" AND MID$(LineBuffer1$, 13, 5) <> "FREQ:") OR (LEFT$(LineBuffer1$, 1) = "=" AND (MID$(LineBuffer1$, 13, 4) <> "RING" AND MID$(LineBuffer1$, 13, 8) <> "CONNECT " AND MID$(LineBuffer1$, 13, 5) <> "DFRS:")) THEN COLOR 14 _
, 0
PRINT LEFT$(LineBuffer1$, 74);
COLOR FieldsFore, FieldsBack
IF LEFT$(LineBuffer$, 1) = "?" OR LEFT$(LineBuffer$, 1) = "!" THEN COLOR 12, 0
IF (LEFT$(LineBuffer$, 1) = "%" AND MID$(LineBuffer$, 13, 5) <> "FREQ:") OR (LEFT$(LineBuffer$, 1) = "=" AND (MID$(LineBuffer$, 13, 4) <> "RING" AND MID$(LineBuffer$, 13, 8) <> "CONNECT " AND MID$(LineBuffer$, 13, 5) <> "DFRS:")) THEN COLOR 14, 0
LOCATE 5, 4
PRINT LEFT$(LineBuffer$, 74);
IF LEN(LineBuffer$) > 74 THEN LOCATE , 77: COLOR 14, 0: PRINT ">";
COLOR FieldsFore, FieldsBack
LineBuffer2$ = LineBuffer1$
LineBuffer1$ = LineBuffer$

'Convert words on each line to variables for processing
LineLength = LEN(LineBuffer$)
      
Word = 1
FOR Letter = 1 TO LineLength
           
    IF MID$(LineBuffer$, Letter, 1) = " " THEN
              
       'Don't increment to the Next Word variable if the previous
       'Word variable has not been used. This would happen in the
       'case of a double space being encountered.
       'NewWord is set to 1 when the present Word variable has been
       'used.
       IF NewWord = 0 THEN
          Word = Word + 1
          NewWord = 1
       END IF
    ELSE
       Word$(Word) = Word$(Word) + MID$(LineBuffer$, Letter, 1)
       NewWord = 0
    END IF
NEXT
COLOR FieldsFore, FieldsBack

'Check for FDTerminal info in Log not related to FD Mailer stats.

IF Word$(1) = "----------" AND Word$(6) = "FD" THEN NotFD = 0

IF (Word$(1) = "----------" AND Word$(6) <> "FD") OR NotFD = 1 THEN
      NotFD = 1
      GOTO FDLine
END IF

   IF NOT InsidePoll AND (Word$(1) = "!" OR Word$(1) = "?") THEN
      ErrorOther = ErrorOther + 1
      LOCATE 21, 75
      COLOR 12, 0
      PRINT USING "###"; ErrorOther
      PRINT #FDStatOut,
      PRINT #FDStatOut, LEFT$(LineBuffer$, 12); "  ERROR: "; MID$(LineBuffer$, 13)
      LOCATE 24, 1
      PRINT "                                                                                ";
      LOCATE 24, 1
      PRINT DateCurrent$; " "; LEFT$(LineBuffer$, 65);
      IF Beeps = 1 THEN BEEP
      IF Pause = 1 THEN
         PressEnter Pause, Beeps
      END IF
   END IF

   IF Word$(1) = "%" AND Word$(3) <> "FREQ:" THEN
      ErrorOther = ErrorOther + 1
      LOCATE 21, 75
      COLOR 12, 0
      PRINT USING "###"; ErrorOther
      IF InsidePoll THEN
         PRINT #FDStatOut, SPACE$(15); "Note: "; MID$(LineBuffer$, 13)
      ELSE
         PRINT #FDStatOut, LEFT$(LineBuffer$, 12); "   Note: "; MID$(LineBuffer$, 13)
      END IF
      LOCATE 24, 1
      PRINT "                                                                                ";
      LOCATE 24, 1
      PRINT DateCurrent$; " "; LEFT$(LineBuffer$, 65);
      IF Beeps = 1 THEN BEEP
      IF Pause = 1 THEN
         PressEnter Pause, Beeps
      END IF
   END IF

IF LEFT$(Word$(2), 1) = "0" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "1" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "2" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "3" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "4" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "5" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "6" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "7" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "8" THEN TimeCurrent$ = Word$(2)
IF LEFT$(Word$(2), 1) = "9" THEN TimeCurrent$ = Word$(2)

RETURN

' --------------------------------------------------------------------------
' Error Processing
' --------------------------------------------------------------------------

ErrorProc:
COLOR DosForeClr, DosBackClr
CLS

   SELECT CASE ERR

      CASE 64, 75                  ' Bad File Name
         PRINT "Oh No! An Invalid file name has been supplied!"
         PRINT
         PRINT "Please check command line switches and FD environment variable."
         PRINT
         PRINT "          Date: "; ADATE$; "  "; TIME$
         PRINT
         PRINT " Error Message: "; Env$
         PRINT
         PRINT "      Switches: "; COMMAND$
         PRINT "     Input Log: "; FDLog$
         PRINT "   Output File: "; FDStatFile$
         END
         RESUME

      CASE 71                   ' Disk not ready
         PRINT "Oh No! The Disk drive was not ready!"
         END
         RESUME

      CASE 53, 76              ' File or path not found
         PRINT "Oh No! The File or path was not found!"
         PRINT
         PRINT "Please check command line switches and FD environment variable."
         PRINT
         PRINT "          Date: "; ADATE$; "  "; TIME$
         PRINT "    FD Log Dir: "; Env$
         PRINT "      Switches: "; COMMAND$
         PRINT "     Input Log: "; FDLog$
         PRINT "   Output File: "; FDStatFile$
         END
         RESUME

      CASE ELSE:                ' Unforeseen error

         ' Disable error trapping and print standard
         ' system message:
         
         PRINT "Oh No! An Unexpected Error has occured!!"
         PRINT
         PRINT "Error Code:"; ERR; "occured on processing Log line"; LogLine; ":"
         PRINT LineBuffer$
         PRINT
         PRINT "          Date: "; ADATE$; "  "; TIME$
         PRINT "    FD Log Dir: "; Env$
         PRINT "      Switches: "; COMMAND$
         PRINT "     Input Log: "; FDLog$
         PRINT "   Output File: "; FDStatFile$
         PRINT
         PRINT " Free  String ="; FRE(2); "b  Free non-string array ="; FRE(-1); "b  Free stack ="; FRE(-2)
         PRINT
         PRINT "       Please Report this error to:  Scott Hall"
         PRINT "                                     FidoNet  3:712/393"
         PRINT "                                     Internet shall@world.net"
         PRINT
         PRINT "This information will be found in file '"; FDDir$; "FDSTAT.ERR'"
         PRINT "So that you can easily post it to me. "
         PRINT "If you can, can you please send the Log file you are processing too.      "
         PRINT ""
         PRINT " TA! :)"

         er = FREEFILE
         OPEN FDDir$ + "FDSTAT.ERR" FOR OUTPUT AS #er
         PRINT #er, "Oh No! An Unexpected Error has occured!!"
         PRINT #er,
         PRINT #er, "Error Code:"; ERR; "occured on processing Log line"; LogLine; ":"
         PRINT #er, LineBuffer$
         PRINT #er, ""
         PRINT #er, "          Date: "; ADATE$; "  "; TIME$
         PRINT #er, "    FD Log Dir: "; Env$
         PRINT #er, "      Switches: "; COMMAND$
         PRINT #er, "     Input Log: "; FDLog$
         PRINT #er, "   Output File: "; FDStatFile$
         PRINT #er,
         PRINT #er, " Free String ="; FRE(2); "b  Free non-string array ="; FRE(-1); "b  Free stack ="; FRE(-2)
         PRINT #er,
         PRINT #er, "       Please Report this error to:  Scott Hall "
         PRINT #er, "                                     FidoNet  3:712/393"
         PRINT #er, "                                     Internet shall@world.net"
         PRINT #er,
         PRINT #er, "* If you can please send the Log file you are processing."
         PRINT #er,
         CLOSE #er, #FDStatOut, FDLogFile
         END
         RESUME
  
   END SELECT

