#include <daydream.h>
#include <dirent.h>
#include <sys/param.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <sys/mman.h>
#include <signal.h>

#ifndef NO_VFS
#ifndef OS2
#include <sys/vfs.h>
#endif
#endif
#ifdef UNIX
#include <sys/mount.h>
#endif

struct bgcheckinfo {
	struct userbase bguser;
	int totbytes;
	int totfiles;
	int dupes;
	int okfiles;
	int okbytes;
};

extern int lmode;

void bghan(int sig);
int bgdone;
int checkbgdone(int);
int getdszuname(char *, char *);

void cleantemp(void);
char finname[255];
void deldir(char *);

struct DayDream_Archiver *arc;
int quickmode;

int handleupload(char *);

#ifdef _WINDOWS
#define S_ISDIR _S_ISDIR
#endif

int bgrun=0;

int wasbg;

static int ul_totulf;
static int ul_dupes;
static int ul_totulb;
static int ul_okf;
static int ul_okb;

static struct bgcheckinfo bi;

int isonline(int);

int addulbytes(int by)
{
	int dnod;
	struct dd_nodemessage ddn;

	if ( (dnod=isonline(user.user_account_id))) {
		dnod--;
		if (dnod < node) {
			ddn.dn_command=12;
			ddn.dn_data1=by;
			sendtosock(dnod,&ddn);
			ddn.dn_command=10;
			ddn.dn_data1=1;
			sendtosock(dnod,&ddn);
		}
	}
	user.user_ulbytes+=by;
	user.user_ulfiles++;
	return 1;
}

void recfiles(char *path, char *confp)
{
	char olddir[1024];
	char buf2[80];
	char udbuf[400];
	
	getcwd(olddir,80);
	chdir(path);

	sprintf(buf2,"%sdszlog.%d",DDTMP,node);
	unlink(buf2);
		
	if (lmode) { 
		HotKey(0);
	} else if (protocol->PROTOCOL_TYPE==1) {
		if (confp) {
			sprintf(udbuf,"%s/utils/ddrz -vv -b -r -f %sdata/paths.dat -F %stmplist%d -l %s -g %s -n %snodeinfo%d.data",origdir,conf->CONF_PATH,DDTMP,node,buf2,ttyname(serhandle),DDTMP,node);
		} else {
			sprintf(udbuf,"%s/utils/ddrz -vv -b -r -l %s -g %s -n %snodeinfo%d.data",origdir,buf2,ttyname(serhandle),DDTMP,node);
		}
		runstdio(udbuf,0,2);
	} else if (protocol->PROTOCOL_TYPE==2) {
		if (confp) {
			sprintf(udbuf,"%s/utils/hydracom dev %s ski %sdata/paths.dat rec %s res %s get",origdir,ttyname(serhandle),conf->CONF_PATH,path,buf2);
		} else {
			sprintf(udbuf,"%s/utils/hydracom dev %s rec %s res %s get",origdir,ttyname(serhandle),path,buf2);
		}
		runstdio(udbuf,0,4);
		killflood();
	} else if (protocol->PROTOCOL_TYPE==3) {
		if (confp) {
			sprintf(udbuf,"%s/utils/smodem -t -X -p %s -e 0 -d %s @%sdata/paths.dat @%stmplist%d -z %s",origdir,ttyname(serhandle),path,conf->CONF_PATH,DDTMP,node,buf2);
		} else {
			sprintf(udbuf,"%s/utils/smodem -t -X -p %s -x -e 0 -d %s -z %s",origdir,ttyname(serhandle),path,buf2);
		}
		runstdio(udbuf,0,4);
		killflood();
	} else if (protocol->PROTOCOL_TYPE==4) {
		checkforftp(2,path,buf2);
	}
	analyzedszlog(buf2,udbuf);
	chdir(olddir);
}

int upload(int mode)
{
	char udbuf[500];
	int autooff=0;
	int maxlen;
	struct dirent *dent;
	DIR *dh;
	int gotfiles=0;
	char olddir[80];
	int starttimeleft;
	time_t timenow;

	ul_totulf=ul_dupes=ul_totulb=ul_okf=ul_okb=0;

	setprotocol();
	
	changenodestatus("Uploading");
	
	if (user.user_toggles & (1L<<14)) quickmode=1; else quickmode=0;
		
	if (conf->CONF_FILEAREAS==0) {
		DDPut(sd[nofileareasstr]);
		return 0;
	}

	if (conf->CONF_UPLOADAREA==0) {
		DDPut(sd[nouploadsstr]);
		return 0;
	}

	if (mode==0 || mode ==1 || mode ==3) {
		bgrun=0;
		wasbg=0;
	
		cleantemp();
		if (mode != 3) TypeFile("upload",TYPE_MAKE|TYPE_CONF);
		if (!freespace()) return 0;
		if (conf->CONF_ATTRIBUTES & (1L<<3)) {
			maxlen=31;
		} else {
			maxlen=12;
		}
		
		if (mode!=3) {
			checkforpartialuploads(1);
			if (protocol->PROTOCOL_TYPE != 4) {
				char logn[512];

				sprintf(logn,"%sdszlog.%d",DDTMP,node);
				unlink(logn);
				
				if (checkforftp(1,currnode->MULTI_TEMPORARY,logn)) {
					analyzedszlog(logn,udbuf);
					goto ftpgo;
				}
			}
		
			sprintf(udbuf,sd[fnamelenstr],maxlen);
			DDPut(udbuf);
		
			while (1)
			{
				DDPut(sd[proceedtransferstr]);
				udbuf[0]=0;
				if (!(Prompt(udbuf,1,0))) return 0;
				if (!strcasecmp(udbuf,"a")) {
					return 0;
				} else if (!strcasecmp(udbuf,"d")) {
					autooff=1;
					break;
				} else if (!strcasecmp(udbuf,"p") || udbuf[0]==0) {
					break;
				}
			}
		}
	}

	if (mode==1) {
		sprintf(udbuf,sd[localulstr],currnode->MULTI_TEMPORARY);
		DDPut(udbuf);
		HotKey(0);
	} else if (mode == 0 || mode == 3) {
		starttimeleft=timeleft;	
		maketmplist();

		if ( (!(user.user_toggles & (1L<<15))) && (maincfg.CFG_FLAGS & (1L<<11)) && protocol->PROTOCOL_TYPE!=4) {
			initbgchecker();
		}
		recfiles(currnode->MULTI_TEMPORARY, conf->CONF_PATH);
		
		timenow=time(0);
		timeleft=starttimeleft;
		endtime=timenow+timeleft;
		

	}

	if (autooff) {
		if (autodisconnect()==1) quickmode=1;
		else autooff=0;
	}
	if (bgrun) {
		wasbg=1;
		
		DDPut(sd[w4bgcheckstr]);
		kill(bgrun,SIGUSR1);
		while(1) {
			if (checkbgdone(0)) break;
			sleep(1);
			if (!ispid(bgrun)) {
				checkbgdone(0); // Just to be sure 
				break;
			}
		}
		bgrun=0;
	}
	ftpgo:
	if (conf->CONF_ATTRIBUTES & (1L<<3)) {
		DDPut(sd[longfstr]);
	} else {	
		DDPut(sd[shortfstr]);
	}

	if ((dh=opendir(currnode->MULTI_TEMPORARY)))
	{
		
		getcwd(olddir,1024);
		chdir(currnode->MULTI_TEMPORARY);
		while((dent=readdir(dh)))
		{
          		if (dent->d_name[0] == '.' && (dent->d_name[1] == '\0' || (dent->d_name[1] == '.' && dent->d_name[2] == '\0'))) continue;   
			if (!strcmp(".packtmp",dent->d_name)) continue;
			gotfiles++;
			deldir(".packtmp");
			if (!handleupload(dent->d_name)) makelc(finname);
		}
		chdir(olddir);
		closedir(dh);
	}
	if (autooff) return 2;
/*
Upload statistics
=================
Type              Files         Bytes       Dupes      OK Files    OK Bytes
---------------------------------------------------------------------------
Normal              232       5443456           4           238   543452542
Background           10      54333345           2            22     3444432
---------------------------------------------------------------------------
TOTAL               242      59000000           6           245   567000000
*/
	if (gotfiles==0 && !ul_totulf && !bi.totfiles) {
		DDPut(sd[tempemptystr]);	
	} else {
		DDPut(sd[ulstathdrstr]);
		if (ul_totulf) {
			sprintf(udbuf,sd[ulstatlinestr],
				sd[ulstatnormstr],ul_totulf,ul_totulb,
				ul_dupes,ul_okf,ul_okb);
			DDPut(udbuf);
		}
		if (bi.totfiles && wasbg) {
			sprintf(udbuf,sd[ulstatlinestr],
				sd[ulstatbackstr],bi.totfiles,bi.totbytes,
				bi.dupes,bi.okfiles,bi.okbytes);
			DDPut(udbuf);
		}
		if (ul_totulf && bi.totfiles && wasbg) {
			sprintf(udbuf,sd[ulstattailstr],
				bi.totfiles+ul_totulf,bi.totbytes+ul_totulb,
				bi.dupes+ul_dupes,bi.okfiles+ul_okf,
				bi.okbytes+ul_okb);
			DDPut(udbuf);
		}
	}
	return 0;
}

int makelc(char *fn)
{
	char buf[1024];
	
	struct lcfile lc;
	int fd;
	
	memset(&lc,0,sizeof(struct lcfile));

	lc.lc_conf=conf->CONF_NUMBER;
	strcpy(lc.lc_name,fn);

	sprintf(buf,"%s/users/%d/lcfiles.dat",origdir,user.user_account_id);
	fd=open(buf,O_WRONLY|O_CREAT,0644);
	if (fd < 0) {
		unlink(fn);
		return 0;
	}
	lseek(fd,0,SEEK_END);
	write(fd,&lc,sizeof(struct lcfile));
	sprintf(buf,"%s/users/%d/lcfiles/%s",origdir,user.user_account_id,fn);
	close(fd);
	newrename(fn,buf);
	return 1;
}

int genstdiocmdline(char *dest, char *src, char *arc, char *no)
{
	char tbuffer[60];
	char *s;
	while(1)
	{
		if (*src=='%') {
			if (*(src+1)=='A' || *(src+1)=='a') {
				while (*arc) *dest++=*arc++;
				src+=2;
			} else if (*(src+1)=='N' || *(src+1)=='n') {
				s=tbuffer;
				if (!no) {
					sprintf(s,"%d",node);
				} else {
					strcpy(s,no);
				}
				while (*s) *dest++=*s++;
				src+=2;
			} else if (*(src+1)=='R' || *(src+1)=='r') {
				s=user.user_realname;
				while (*s) *dest++=*s++;
				src+=2;
			} else if (*(src+1)=='H' || *(src+1)=='h') {
				s=user.user_handle;
				while (*s) *dest++=*s++;
				src+=2;
			} else if (*(src+1)=='O' || *(src+1)=='o') {
				s=user.user_organization;
				while (*s) *dest++=*s++;
				src+=2;
			} else if (*(src+1)=='Z' || *(src+1)=='z') {
				s=user.user_zipcity;
				while (*s) *dest++=*s++;
				src+=2;
			} else if (*(src+1)=='S' || *(src+1)=='s') {
				s=tbuffer;;
				sprintf(s,"%d",user.user_securitylevel);
				while (*s) *dest++=*s++;
				src+=2;
			} else {
				*dest++=*src++;
			}
		} else {
			if (!*src) break;
				*dest++=*src++;
		}
	}
	*dest=0;
	return 0;
}

int handleupload(char *upname)
{
	char linebuf[20*45];
	char buf[200];	
	char daline[86];
	struct stat st;
	struct tm *muntm;
	time_t currtime;
	int linecnt=0;
	char *s;
	int sta=1;
	int i=0;
	char ulsize[10];
	char finalbuf[80*20];
	int descfd;
	int frees;
	FILE *founddiz=0;
	int lcn;
	struct stat fst;
						
	strcpy(finname,upname);
	
	stat(upname,&st);
	ul_totulb+=st.st_size;
	ul_totulf++;
	
	currtime=time(0);
	muntm=localtime(&currtime);
	
	while(checkfilename(finname)==0)
	{
		i=1;
		if (conf->CONF_ATTRIBUTES & (1L<<3)) {
			sprintf(buf,sd[linvalidstr],finname," ");
			DDPut(buf);
			buf[0]=0;
			if (!(Prompt(buf,34,PROMPT_NOCRLF|PROMPT_FILE))) return 0;
			strcpy(finname,buf);
		} else {	
			sprintf(buf,sd[sinvalidstr],finname);
			DDPut(buf);
			buf[0]=0;
			if (!(Prompt(buf,12,PROMPT_NOCRLF|PROMPT_FILE))) return 0;
			strcpy(finname,buf);
		}
	
	}
	if (i) rename(upname,finname);

	getarchiver(finname);
		
	DDPut("\r                                                                          \r");

	if (st.st_size > 10000000) {
		sprintf(ulsize,"%6dk",(int)st.st_size/1024);
	} else {
		sprintf(ulsize,"%7d",(int)st.st_size);
	}

	if (conf->CONF_ATTRIBUTES & (1L<<3)) {
		sprintf(daline,"%-34.34s ",finname);
	} else {
		sprintf(daline,"%-12.12s ",finname);
	}
	DDPut(daline);
	if ( (conf->CONF_ATTRIBUTES & (1L<<9)) && dupecheck(finname)) {
		ul_dupes++;
		return 1;
	}
	if (conf->CONF_ATTRIBUTES & (1L<<3)) {
		sprintf(&daline[35],"N--- %s %s",ulsize,ctime(&currtime));
		DDPut(&daline[35]);
		DDPut(sd[ullinestr]);
	} else {	
		sprintf(&daline[13],"N--- %s %2.2d.%2.2d.%2.2d ",ulsize,muntm->tm_mday,muntm->tm_mon+1,muntm->tm_year);
		DDPut(&daline[13]);
	}

	for (i=0;i < 45*15; i++) linebuf[i]=0;

	if (arc && arc->ARC_EXTRACTFILEID[0]) {
		struct dirent *dent;
		DIR *dh;
		
		char olddirri[1024];
		char extdiz[1024];
		DDPut(sd[checkdizstr]);
		
		mkdir(".packtmp",0700);
		deldir(".packtmp");

		getcwd(olddirri,80);
		chdir(".packtmp");

		sprintf(buf,"%s%s",currnode->MULTI_TEMPORARY,finname);
		genstdiocmdline(extdiz,arc->ARC_EXTRACTFILEID,buf,0);

		runstdio(extdiz,0,3); 

		chdir(olddirri);

		if ((dh=opendir(".packtmp")))
		{
			while((dent=readdir(dh)))
			{
				if (!strcasecmp("file_id.diz",dent->d_name)) {
					sprintf(buf,".packtmp/%s",dent->d_name);
					founddiz=fopen(buf,"r");
					stat(buf,&fst);
					break;
				}
			}
			closedir(dh);
		}
		DDPut("[27D                              [30D");

		if (founddiz) {
			char kelabuf[256];
			char dizbuf[45*20];
			int dizcnt=0;			

			DDPut(sd[gotdizstr]);

			s=dizbuf;
			while (dizcnt < 14 && fgetsnolf(kelabuf,250,founddiz))
			{
				if (!*kelabuf) continue;
				stripansi(kelabuf);
				sprintf(s,"%-44.44s",kelabuf);
				sprintf(buf,sd[dizlinestr],dizcnt+1,s);
				DDPut(buf);
				dizcnt++;
				s=&s[45];
			}
			*s=0;
			fclose(founddiz);
			if (checkcarrier() && !quickmode)
			{
				DDPut(sd[dizwaitstr]);
keke:
				delayt=3;
				if (!checkcarrier()) {
					quickmode=1;
				} else switch(HotKey(HOT_DELAY))

				{
				 case 'q':
				 case 'Q':
					quickmode=1;
				 case 0:
				 case 255:
				 case 's':
				 case 'S':
				 case 13:
				 case 10:
					sta=2;
					memcpy(linebuf,dizbuf,dizcnt*45);
					linecnt=dizcnt;
					break;
				 case 'H':
				 case 'h':
					sta=3;
					memcpy(linebuf,dizbuf,dizcnt*45);
					linecnt=dizcnt;
					break;
				 case 'e':
				 case 'E':
					memcpy(linebuf,dizbuf,dizcnt*45);
					linecnt=dizcnt;
				 case 'n':
				 case 'N':
					DDPut("\r                                                                      \r");					
					sprintf(buf,sd[lineistr],linecnt+1);
					DDPut(buf);
					break;
				 default:
					goto keke;
					break;
				}
				if (sta!=1) DDPut("\r                                                                      \r");
			} else {
				sta=2;
				memcpy(linebuf,dizbuf,dizcnt*45);
				linecnt=dizcnt;
			}
		}
	}

	while (sta==1)
	{
		s=linecnt*45+linebuf;
		if (!(Prompt(s,44,0))) return 0;
		if (s[0]==0 || linecnt == 14) {
			
			while (1)
			{
				DDPut(sd[entrymenustr]);
				buf[0]=0;
				if (!(Prompt(buf,2,0))) return 0;
				if (buf[0]==0 || (!strcasecmp(buf,"s"))) {
					sta=2;
					break;
				} else if (!strcasecmp(buf,"w")) {
					sta=4;
					break;
				} else if (!strcasecmp(buf,"r")) {
					sprintf(buf,"                          Line #%2.2d ",linecnt+1);
					DDPut(buf);
					break;
				} else if (!strcasecmp(buf,"e")) {
					int destlin;
					DDPut(sd[ullineedstr]);
					buf[0]=0;
					if (!(Prompt(buf,2,0))) return 0;
					destlin=atoi(buf);
					if (destlin > 0 && destlin < (linecnt + 1 )) {
						DDPut(sd[ullineeditingstr]);
						s=linebuf+(destlin-1)*45;
						if (!(Prompt(s,44,0))) return 0;											
					} else {
						DDPut(sd[unknownlinestr]);
					}
				} else if ((!strcasecmp(buf,"?")) || (!strcasecmp(buf,"c"))) {
					TypeFile("uploadcommands",TYPE_WARN|TYPE_MAKE);
				} else if (!strcasecmp(buf,"l")) {
					int j;
					DDPut(sd[descliststr]);
					if (linecnt==14) j=15; else j=linecnt;
					i=0;
					while (i!=linecnt)
					{
						s=linebuf+i*45;
						sprintf(buf,sd[dizlinestr],i+1,s);
						DDPut(buf);
						i++;
					}
				} else if (!strcasecmp(buf,"h")) {
					sta=3;
					break;
				} else if (!strcasecmp(buf,"d")) {
					unlink(finname);
					return 1;
					break;
				}
			}
		} else {
			linecnt++;
			sprintf(buf,sd[lineistr],linecnt+1);
			DDPut(buf);
		}	
	}

	s=linebuf;
	lcn=linecnt;
	
	finalbuf[0]=0;
	if (conf->CONF_ATTRIBUTES & (1L<<3)) {
		sprintf(finalbuf,"%s",daline);
	} else {
		sprintf(finalbuf,"%s%s\n",daline,s);
		s=&s[45];
	}	

	while (*s && linecnt)
	{
		strcat(finalbuf,"                                   ");
		strcat(finalbuf,s);
		strcat(finalbuf,"\n");
		s=&s[45];
		linecnt--;
	}

	if (arc && arc->ARC_FLAGS & (1L<<2) && founddiz) {
		struct tm *tm;
		char db[100];
		tm=localtime(&fst.st_mtime);
		sprintf(db,"                                   [ Date from file_id.diz: %2.2d.%2.2d.%2.2d  (%2.2d:%2.2d) ]\n",tm->tm_mday,tm->tm_mon+1,tm->tm_year,tm->tm_hour,tm->tm_min);
		strcat(finalbuf,db);		
	} 
	if ( (conf->CONF_ATTRIBUTES & (1L<<2)) && sta==2 ) {
		strcat(finalbuf,"                                   ");
		strcat(finalbuf,user.user_signature);
		strcat(finalbuf,"\n");
	
	}

	frees=isfreedl(finname);
	if (frees) {
		if (frees==1) {
			strcat(finalbuf,"                                   ");
			strcat(finalbuf,maincfg.CFG_FREEDLLINE);
			strcat(finalbuf,"\n");
		}
		if (conf->CONF_ATTRIBUTES & (1L<<3)) {
			finalbuf[36]='F';
		} else {
			finalbuf[14]='F';
		}
	}
	
/* daline -> filedesc, buf -> destination name */

	if (sta==3) {
		sprintf(daline,"%sDescriptions",maincfg.CFG_HOLDDIR);
		sprintf(buf,"%s%s",maincfg.CFG_HOLDDIR,finname);
	} else {
		if ( (conf->CONF_ATTRIBUTES & (1L<<8))==0 && arc && *arc->ARC_CMD_TEST) {
			char arcoutpname[80];
			char arccmd[200];
			char arcbuf[4000];
			FILE *checkd;
			
			sprintf(buf,"%s%s",currnode->MULTI_TEMPORARY,finname);
			genstdiocmdline(arccmd,arc->ARC_CMD_TEST,buf,0);
			sprintf(arcoutpname,"%sarcoutp%d",DDTMP,node);
			unlink(arcoutpname);
			
			DDPut(sd[testingarcstr]);
			if (arc->ARC_FLAGS & (1L<<4)) {
				DDPut(sd[testsepastr]);
				runstdio(arccmd,arcoutpname,0); 
				DDPut(sd[testsepastr]);
			} else {
				runstdio(arccmd,arcoutpname,3); 
			}
			if((checkd=fopen(arcoutpname,"r")))
			{
				int arcok=1;
				while(fgets(arcbuf,4000,checkd) && arcok)
				{
					if (*arc->ARC_CORRUPTED1 && strstr(arcbuf,arc->ARC_CORRUPTED1)) arcok=0;
					if (*arc->ARC_CORRUPTED2 && strstr(arcbuf,arc->ARC_CORRUPTED2)) arcok=0;
					if (*arc->ARC_CORRUPTED3 && strstr(arcbuf,arc->ARC_CORRUPTED3)) arcok=0;
				}
				fclose(checkd);				
				if (arcok) {
					if (conf->CONF_ATTRIBUTES & (1L<<3)) {
						finalbuf[35]='P';
					} else {
						finalbuf[13]='P';
					}
					DDPut(sd[arcokstr]);
				} else {
					if (arc->ARC_FLAGS & (1L<<3)) {
						DDPut(sd[arcbrokenstr]);
						unlink(finname);
						return 1;
					} else {
						DDPut(sd[arcbroken2str]);
						if (conf->CONF_ATTRIBUTES & (1L<<3)) {
							finalbuf[35]='F';
						} else {
							finalbuf[13]='F';
						}
					}
				}
			}
		}
		if (conf->CONF_ATTRIBUTES & (1L<<4)) {
			char db[80];
			char upath[1024];
			
			int ps;

askbag:			
			sprintf(upath,sd[uldeststr],conf->CONF_FILEAREAS);
			DDPut(upath);
			*db=0;
			ps=Prompt(db,3,0);
			if (!ps || toupper(*db)=='U' || !checkcarrier()) {
				sprintf(daline,"%sdata/directory.%3.3d",conf->CONF_PATH,conf->CONF_UPLOADAREA);
				if (conf->CONF_ULPATH[0]=='@') {
					getfreeulp(&conf->CONF_ULPATH[1],upath,0);
					sprintf(buf,"%s%s",upath,finname);
				} else {
					sprintf(buf,"%s%s",conf->CONF_ULPATH,finname);
				}
			} else if (toupper(*db)=='L') {
				TypeFile("filecatalogs",TYPE_MAKE|TYPE_WARN|TYPE_CONF);
				goto askbag;
			} else {
				ps=atoi(db);
				if (ps < 1 || ps > conf->CONF_FILEAREAS) goto askbag;
				sprintf(daline,"%sdata/directory.%3.3d",conf->CONF_PATH,ps);
				getpath(conf,upath,ps);
				sprintf(buf,"%s%s",upath,finname);
			}
		} else {
			char upath[1024];
			sprintf(daline,"%sdata/directory.%3.3d",conf->CONF_PATH,conf->CONF_UPLOADAREA);
			if (conf->CONF_ULPATH[0]=='@') {
				getfreeulp(&conf->CONF_ULPATH[1],upath,0);
				sprintf(buf,"%s%s",upath,finname);
			} else {
				sprintf(buf,"%s%s",conf->CONF_ULPATH,finname);
			}
		}
	}

	runexamine(finname);

	DDPut(sd[savingulstr]);

	if ( (sta==2 || sta==4) && !founddiz && arc && *arc->ARC_ADDFILEID) {
		FILE *fid;
		
		fid=fopen("file_id.diz","w");
		if (fid) {
			char adddiz[1024];
			char buu[1024];
			s=linebuf;
	
			while (*s && lcn)
			{
				fprintf(fid,"%-44.44s\n",s);
				s=&s[45];
				lcn--;
			}
			fclose(fid);
			sprintf(buu,"%s%s",currnode->MULTI_TEMPORARY,finname);
			genstdiocmdline(adddiz,arc->ARC_ADDFILEID,buu,0);
			runstdio(adddiz,0,3); 
			unlink("file_id.diz");
		}
	
	}
	
	descfd=open(daline,O_CREAT|O_WRONLY,0664);
	if (descfd==-1) {
		DDPut(sd[ulerrwritedescstr]);
		return 1;
	}
	lseek(descfd,0,SEEK_END);
	write(descfd,finalbuf,strlen(finalbuf));
	close(descfd);
	newrename(finname,buf);

	DDPut(sd[ulokstr]);	

	if ( (!(conf->CONF_ATTRIBUTES & (1L<<1))) && sta!=3 ) {
		addulbytes(st.st_size);
/*		user.user_ulfiles++;
		user.user_ulbytes+=st.st_size; */
	}
	ul_okf++;
	ul_okb+=st.st_size;
	
	{
		char lbuf[100];
		int logfd;
		struct DD_UploadLog ddl;
		sprintf(lbuf,"%s/logfiles/uploadlog.dat",origdir);
		logfd=open(lbuf,O_WRONLY|O_CREAT,0664);
		if (logfd!=-1) {
			memset((char *)&ddl,0,sizeof(struct DD_UploadLog));
			ddl.UL_SLOT=user.user_account_id;
			strcpy(ddl.UL_FILENAME,finname);
			ddl.UL_FILESIZE=st.st_size;
			ddl.UL_TIME=time(0);
			ddl.UL_BPSRATE=bpsrate;
			ddl.UL_NODE=node;
			ddl.UL_CONF=conf->CONF_NUMBER;
			lseek(logfd,0,SEEK_END);
			write(logfd,&ddl,sizeof(struct DD_UploadLog));
			close(logfd);
		}
	}
	return 1;
}

int getpath(struct DayDream_Conference *con, char *s, int b)
{
	char buf[1024];
	FILE *pf;
	int i;
	
	sprintf(buf,"%sdata/paths.dat",con->CONF_PATH);
	pf=fopen(buf,"r");
	if (!pf) {
		if (con->CONF_ULPATH[0]=='@') {
			getfreeulp(&con->CONF_ULPATH[1],s,0);
		} else {
			strcpy(s,con->CONF_ULPATH);
		}
		return 1;
	}
	i=1;
	while(fgetsnolf(buf,1024,pf)) {
		if (i==b) {
			strcpy(s,buf);
			fclose(pf);
			return 1;
		}
		i++;
	}
	fclose(pf);
	if (con->CONF_ULPATH[0]=='@') {
		getfreeulp(&con->CONF_ULPATH[1],s,0);
	} else {
		strcpy(s,con->CONF_ULPATH);
	}
	return 1;
}

int runexamine(char *filen)
{
	char exbuf[1024];

	sprintf(exbuf,"%sdata/examine.dat",conf->CONF_PATH);
	rundoorbatch(exbuf,filen);
	return 1;
}

int rundoorbatch(char *batch, char *fn)
{
	FILE *doorlist;
	char exbuf[1024];

	doorlist=fopen(batch,"r");
	if (doorlist) {
		while(fgetsnolf(exbuf,1024,doorlist))
		{
			if (!*exbuf) continue;
			rundoor(exbuf,fn);
		}
		fclose(doorlist);
	}
	return 1;
}

int newrename(char *old, char *new)
{
	if (!strcmp(old,new)) return 1;
	if (rename(old,new)==-1) {
		int oldfd;
		int newfd;
		char *rwbuf;
		
		oldfd=open(old,O_RDONLY);
		if (oldfd!=-1) {
			newfd=open(new,O_WRONLY|O_CREAT,0644);
			if (newfd!=-1) {
				int cnt;

				rwbuf=(char *)malloc(60000);
				
				while((cnt=read(oldfd,rwbuf,60000)))
				{
					write(newfd,rwbuf,cnt);
				}
				free(rwbuf);
			}
			close(newfd);
		}
		close(oldfd);
		unlink(old);
	}
	return 0;
}

int newcopy(char *old, char *new)
{
	int oldfd;
	int newfd;
	char *rwbuf;

	oldfd=open(old,O_RDONLY);
	if (oldfd!=-1) {
		newfd=open(new,O_WRONLY|O_CREAT,0644);
		if (newfd!=-1) {
			int cnt;
			
			rwbuf=(char *)malloc(60000);
			
			while((cnt=read(oldfd,rwbuf,60000)))
			{
				write(newfd,rwbuf,cnt);
			}
			free(rwbuf);
		}
		close(newfd);
	}
	close(oldfd);
	return 1;
}

int checkfilename(char *name)
{
	int len=0;
	int hips=0;
	while(*name)
	{
		len++;
		if (*name==39) {
			hips++;
		}
		name++;
	}

	if (hips > 1) return 0;
	
	if (conf->CONF_ATTRIBUTES & (1L<<3)) {
		if (len > 34) return 0;
	} else {	
		if (len > 12) return 0;
	}

	if (len < 3) return 0;
	
	return 1;

}

int getarchiver(char *file)
{
	arc=arcs;
	
	while(arc->ARC_FLAGS!=255)
	{
		if (wildcmp(file,arc->ARC_PATTERN)) {
			return 1;
		}
		arc++;
	}
	arc=0;
	return 0;
}

void cleantemp(void)
{
	DIR *dirfd;
	struct dirent *ent;
	char tempbuf[80];
	
	if ((dirfd=opendir(currnode->MULTI_TEMPORARY)))
	{
		while((ent=readdir(dirfd)))
		{
			sprintf(tempbuf,"%s%s",currnode->MULTI_TEMPORARY,ent->d_name);
			unlink(tempbuf);
		}
		closedir(dirfd);
	} else {
		DDPut(sd[tempcleanerrstr]);
	}
}

void deldir(char *dir)
{
	DIR *dirfd;
	struct dirent *ent;
	char tempbuf[1024];
	
	if ((dirfd=opendir(dir)))
	{
		while((ent=readdir(dirfd)))
		{
			struct stat st;

			if ( (ent->d_name[0]=='.' && ent->d_name[1]==0) || (ent->d_name[0]=='.' && ent->d_name[1]=='.' && ent->d_name[2]==0)) continue;
			sprintf(tempbuf,"%s/%s",dir,ent->d_name);
			stat(tempbuf,&st);

			if (S_ISDIR(st.st_mode)) {
				deldir(tempbuf);
				rmdir(tempbuf);
			} else {
				unlink(tempbuf);
			}
		}
		closedir(dirfd);
	} 
}

int freespace(void)
{
	unsigned long long freesp, freesp2;
	char voukubuf[1024];
	
	if (conf->CONF_ULPATH[0]=='@') {
		freesp=getfreeulp(&conf->CONF_ULPATH[1],voukubuf,1);
	} else {
		freesp=getfreesp(conf->CONF_ULPATH);
	}
	freesp2=getfreesp(currnode->MULTI_TEMPORARY);
	if (freesp < maincfg.CFG_FREEHDDSPACE || freesp2 < maincfg.CFG_FREEHDDSPACE) {
		DDPut(sd[notfreespacestr]);
		return 0;	
	} else {
		sprintf(voukubuf,sd[freespacestr],freesp,freesp2);
		DDPut(voukubuf);
		return 1;	
	}
}

unsigned long long getfreesp(char *path)
{
#ifdef UNIX
	struct statfs freest;
	
	if (!statfs(path,&freest)) {
		return ((unsigned long long)freest.f_bsize*(unsigned long long)freest.f_bavail);
	}
	return 0;
#elif defined(_WINDOWS)
	
#endif
}

int localupload(void)
{
	return upload(1);
}

int dupecheck(char *fname)
{
	struct DayDream_Conference *tconf;
	struct DayDream_MsgBase *tbase;

	DDPut(sd[dckstr]);

	if (maincfg.CFG_FLAGS & (1L<<10)) {
		struct DD_UploadLog *ddl, *lo;
		
		char lbuf[1024];
		int logfd;
		struct stat st;
		int df=0;
		int i;

		sprintf(lbuf,"%s/logfiles/uploadlog.dat",origdir);
		logfd=open(lbuf,O_RDONLY);
		if (logfd!=-1) {
			fstat(logfd,&st);
			(void *)ddl=mmap(0,st.st_size,PROT_READ,MAP_SHARED,logfd,0);
			if ((char *)ddl==(char *)-1) {
				multibackspace(strlena(sd[dckstr]));
				close(logfd);
				return 0;
			}
			i=st.st_size/sizeof(struct DD_UploadLog);
			for(lo=ddl;i;lo++,i--) {
				if (!strcasecmp(lo->UL_FILENAME,fname)) {
					df=1;
					break;
				}
			}
			munmap((void *)ddl,st.st_size);
			close(logfd);
			if (df) {
				multibackspace(strlena(sd[dckstr]));
				DDPut(sd[dckfailedstr]);
				unlink(fname);
				return 1;
			}
		}
                multibackspace(strlena(sd[dckstr]));
		return 0;
	} else {
		tconf=confs;
	
		while(tconf->CONF_NUMBER!=255 && tconf->CONF_NUMBER) {
			int bcnt;
			if (!(tconf->CONF_ATTRIBUTES & (1L<<7))) {
				char de[1024];
				if (findfile(fname,de,tconf)) {
					multibackspace(strlena(sd[dckstr]));
					DDPut(sd[dckfailedstr]);
					unlink(fname);
				return 1;
				}
			}
			(struct DayDream_Conference *)tbase=tconf+1;
			bcnt=tconf->CONF_MSGBASES;
			while(bcnt) {
				tbase++;
				bcnt--;
			}
			tconf=(struct DayDream_Conference *)tbase;
		}
		multibackspace(strlena(sd[dckstr]));
		return 0;
	}
}
int maketmplist()
{
	char buf[1024];
	FILE *fi;
	struct DayDream_Multinode *cn;
	
	sprintf(buf,"%stmplist%d",DDTMP,node);
	fi=fopen(buf,"w");
	if (fi)
	{
		for(cn=nodes;cn->MULTI_NODE;cn++)
		{
			if (cn->MULTI_NODE == 253) {
				int j;
				int i=maincfg.CFG_TELNET1ST;
				j=maincfg.CFG_TELNETMAX;
				
				while(j) {
					j--;
					if (i != node) {
						fprintf(fi,cn->MULTI_TEMPORARY,i);
						fputc('\n',fi);
					}
					i++;
				}
			} else if (cn->MULTI_NODE == 254) {
				int j;
				int i=maincfg.CFG_LOCAL1ST;
				j=maincfg.CFG_LOCALMAX;
					
				while(j) {
					j--;
					if (i != node) {
						fprintf(fi,cn->MULTI_TEMPORARY,i);
						fputc('\n',fi);
					}
					i++;
				}
			} else if (cn->MULTI_NODE != 252) {
				if (cn->MULTI_NODE != node) {
					fprintf(fi,cn->MULTI_TEMPORARY,cn->MULTI_NODE);
					fputc('\n',fi);
				}
			}
		}
		fclose(fi);
	}
	return 1;
}

int checkbgdone(int mode)
{
	char buf[1024];
	int efdii;
	int rere;

	while ((waitpid(-1, NULL, WNOHANG)) > 0);
	
	sprintf(buf,"/tmp/dd/bgdone.%d",node);
	if (mode==1) {
		unlink(buf);
	} else if (mode==0) {
		int tries=0;
		doom:
		efdii=open(buf,O_RDONLY);
		if (efdii==-1) return 0;
		rere=read(efdii,&bi,sizeof(struct bgcheckinfo)); 
		close(efdii);
		tries++;
		if (rere!=sizeof(struct bgcheckinfo) && (tries < 50 )) goto doom;
		unlink(buf);
		user=bi.bguser;
		return 1;
	} else {
		bi.bguser=user;
		bi.totbytes=ul_totulb;
		bi.dupes=ul_dupes;
		bi.totfiles=ul_totulf;
		bi.okfiles=ul_okf;
		bi.okbytes=ul_okb;

		efdii=open(buf,O_WRONLY|O_CREAT,0755);  /* If this fails -> trouble */
		if (efdii < 0) {
			return 0;
		}
		write(efdii,&bi,sizeof(struct bgcheckinfo));
		close(efdii);
	}
	return 1;
}

void bghan(int sig)
{
	bgdone=1;
}
int initbgchecker(void)
{

	int lastf;
	char buf[1024];
	FILE *log;
	int cnt;
	char fname[256];
	lastf=0;

	ul_totulf=ul_dupes=ul_totulb=ul_okf=ul_okb=0;

	signal(SIGUSR1,bghan);
	
	bgrun=fork();
	if (bgrun<0) {
		bgrun=0;
		return 0;
	}
	if (bgrun>0) return 0;
	
	bgmode=1;
	bgdone=0;
	carrier=0;
	
	while(!bgdone) {
		sprintf(buf,"%sdszlog.%d",DDTMP,node);
		log=fopen(buf,"r");
		if (log) {
			for(cnt=0;cnt<lastf;cnt++) {
				fgetsnolf(buf,1024,log);
			}
			if (fgetsnolf(buf,1024,log)) {
				if (getdszuname(buf,fname)) {
					char oldwd[1024];

					getcwd(oldwd,1024);
					chdir(currnode->MULTI_TEMPORARY);
					handleupload(filepart(fname));
					chdir(oldwd);
				}
				lastf++;
			}
			fclose(log);
		}
		sleep(1);
	}
	checkbgdone(2);
	/* Commit suicide with style */
	kill(getpid(),SIGKILL);
	return 0;
}

int getdszuname(char *loge, char *name)
{
	char *s, *t;
	s=loge;
	t=name;
	if (*s=='S' || *s=='R') {
		s=&s[2];
		while(*s==' ') if (!*s) return 0; else s++;
		while(*s!=' ') if (!*s) return 0; else s++;
		
		while(*s==' ') if (!*s) return 0; else s++;
		while(*s!=' ') if (!*s) return 0; else s++;
		
		while(*s==' ') if (!*s) return 0; else s++;
		while(*s!=' ') if (!*s) return 0; else s++;
		
		while(*s==' ') if (!*s) return 0; else s++;
		while(*s!=' ') if (!*s) return 0; else s++;

		if (strlen(s)<4) return 0;
		s=&s[4];
		
		while(*s==' ') if (!*s) return 0; else s++;
		while(*s!=' ') if (!*s) return 0; else s++;

		if (strlen(s)<7) return 0;
		s=&s[7];
		while(*s==' ') if (!*s) return 0; else s++;
		while(*s!=' ') if (!*s) return 0; else s++;

		while(*s==' ') if (!*s) return 0; else s++;
		while(*s!=' ') if (!*s) return 0; else s++;

		while(*s==' ') if (!*s) return 0; else s++;
		while(*s!=' ') if (!*s) return 0; else *t++=*s++;
		*t=0;
		
		return 1;
	}
	return 0;
}

int getfreeulp(char *fi, char *gna, int mode)
{
	FILE *fo;
	unsigned long long tot=0;
	fo=fopen(fi,"r");
	if (!fo) return 0;
	
	while(fgetsnolf(gna,1024,fo)) {
		if (mode) {
			tot+=getfreesp(gna);
		} else {
			if (getfreesp(gna) > maincfg.CFG_FREEHDDSPACE) {
				fclose(fo);
				return 1;
			}
		}
	}
	fclose(fo);
	if (mode) return tot;
	return 0;
}


