@ECHO OFF
REM ----------------------------------------------
REM  *** DUPE CHECKER HANDLER - DO NOT DELETE ***
REM ----------------------------------------------
REM %1=Checker %2=Filename %3=Node %4=Dupe Checker Path

IF "%1"=="" GOTO ENDE
IF "%2"=="" GOTO ENDE
IF EXIST crcfail.%3 DEL crcfail.%3 >NUL
IF "%1" == "ULP" GOTO ULP
IF "%1" == "ZDCS" GOTO ZDCS
IF "%1" == "TBWEEDER" GOTO TBWEEDER
GOTO ENDE

REM *** ULP **********************************************************
REM Create a ULP config file named BOOMULP.CFG in ULP's directory
:ULP
%4ULPTEST -C%4boomulp.cfg -F%2 -L
IF ERRORLEVEL == 200 GOTO PROG_ERROR
IF ERRORLEVEL == 111 GOTO LOG_ERROR
IF ERRORLEVEL == 110 GOTO NO_MEMORY
IF ERRORLEVEL == 102 GOTO CFG_ERROR
IF ERRORLEVEL == 101 GOTO CMD_ERROR
IF ERRORLEVEL == 12 GOTO DISK_FULL
IF ERRORLEVEL == 7 GOTO OTHER_ERROR
IF ERRORLEVEL == 6 GOTO ARC_ERROR
IF ERRORLEVEL == 5 GOTO DUPE_FULL
IF ERRORLEVEL == 4 GOTO OTHER_ERROR
IF ERRORLEVEL == 3 GOTO ARC_ERROR
IF ERRORLEVEL == 1 GOTO ARC_ERROR
GOTO NO_DUPES

REM *** ZDCS *********************************************************
:ZDCS
%4ZDCSFC %2 UPLOAD
IF ERRORLEVEL 5 GOTO PROG_ERROR
IF ERRORLEVEL 4 GOTO NO_DUPES
IF ERRORLEVEL 3 GOTO DUPE_FULL
IF ERRORLEVEL 2 GOTO DUPE_PCT
IF ERRORLEVEL 1 GOTO SOME_DUPES
GOTO NO_DUPES

REM *** TBWEEDER *****************************************************
:TBWEEDER
%4TBWEEDER /add /del %2
IF NOT EXIST %2 GOTO DUPE_FULL
GOTO NO_DUPES

REM *** DUPE CHECKER RESULTS *****************************************

:NO_DUPES
ECHO PASSED >CRCFAIL.%3
ECHO -1 >>CRCFAIL.%3
GOTO ENDE

:SOME_DUPES
ECHO SOME DUPES FOUND >CRCFAIL.%3
ECHO 0 >>CRCFAIL.%3
GOTO ENDE

:DUPE_PCT
ECHO TOO MANY DUPLICATES FOUND! >CRCFAIL.%3
ECHO 1 >>CRCFAIL.%3
GOTO ENDE

:DUPE_FULL
ECHO DUPLICATES PREVIOUS UPLOAD! >CRCFAIL.%3
ECHO 1 >>CRCFAIL.%3
GOTO ENDE

REM **** PROGRAM WARNINGS ********************************************

:CMD_ERROR
ECHO %1 COMMAND LINE ERROR! >CRCFAIL.%3
ECHO 0 >>CRCFAIL.%3
GOTO ENDE

:PROG_ERROR
ECHO %1 PROGRAM ERROR! >CRCFAIL.%3
ECHO 0 >>CRCFAIL.%3
GOTO ENDE

:CFG_ERROR
ECHO %1 CONFIG ERROR! >CRCFAIL.%3
ECHO 0 >>CRCFAIL.%3
GOTO ENDE

:ARC_ERROR
ECHO %1 - ARCHIVER ERROR! >CRCFAIL.%3
ECHO 0 >>CRCFAIL.%3
GOTO ENDE

:OTHER_ERROR
ECHO FAILED OTHER %1 TESTS! >CRCFAIL.%3
ECHO 0 >>CRCFAIL.%3
GOTO ENDE

:LOG_ERROR
ECHO UNABLE TO OPEN %1 LOG! >CRCFAIL.%3
ECHO 0 >>CRCFAIL.%3
GOTO ENDE

:NO_MEMORY
ECHO %1 - INSUFFICIENT MEMORY! >CRCFAIL.%3
ECHO 0 >>CRCFAIL.%3
GOTO ENDE

:DISK_FULL
ECHO %1 - DISK FULL!!! >CRCFAIL.%3
ECHO 0 >>CRCFAIL.%3
GOTO ENDE

:ENDE
IF EXIST pcbpass.txt DEL pcbpass.txt >NUL
IF EXIST pcbfail.txt DEL pcbfail.txt >NUL
