#         _____
#       __)  _|_  03/14/2004
#   ____\_  / _/___        _
#   \_     / / ___( myst/x )
#  __| ;  \_/   |
# <<__ ;   | ;  _> animated, randomized
#    | ;   | ;  |  pause prompts with
#    L_    | ;  |  failsafe, no cfg!
#      \_  |  __;_ _
#      hx//__//__///// /  /
#
# +----- ---- --- -- -  -
# | by:     haliphax
# | for:    mystic 1.0.7.3+
# | source: yes
# +----- --- -- -  -
#
uses cfg        # for cfgtextpath and cfgmpepath constants

#
# variable declarations
#
var prompt string array(1..100),        # holds the pause prompt
    prompts integer,                    # total number of pause prompts
    plines integer,                     # lines in particular prompt
    plen integer,                       # maximum string width of prompt
    i1 integer,                         # multi-purpose integer
    curx integer,                       # gets wherex
    cury integer,                       # gets wherey
    ch char                             # user input keypress

#
# main program
#
begin
  getcfg
  
  # check for existence of "original" prompt
  
  if not fexist(cfgtextpath + 'anipause.0') then
    writeln('[generic pause]')
    halt
  endif
  prompts := 1
  
  # cycle through file list to determine number of prompts
  
  for i1 := 1 to 999
    if fexist(cfgtextpath + 'anipause.' + int2str(i1)) then
      prompts := prompts + 1
    else
      i1 := 999
    endif
  fend
  
  # read prompt file, updating plen as necessary
  
  i1 := random(prompts)
  fopen(1, text, reset, cfgtextpath + 'anipause.' + int2str(i1))
  i1 := 0
  while not eof(1)
    i1 := i1 + 1
    freadln(1, prompt(i1))
    if length(stripmci(prompt(i1))) > plen then plen := length(stripmci(prompt(i1))) endif
  wend
  fclose(1)

  # bounds checking for number of lines

  if i1 > 100 then i1 := 100 endif
  plines := i1
  ch := chr(0)

  # if only one line, do not animate -- if blank file, use generic

  gotoxy(wherex, wherey)
  if plines = 1 then
    write(prompt(1))
    repeat until keypressed
    ch := readkey
  else if plines = 0 then
    write('[generic pause]')
    plen := length('[generic pause]')
    repeat until keypressed
    ch := readkey
    endif
  endif

  # only animate if more than one line

  if ch = chr(0)
    curx := wherex
    cury := wherey
    repeat
      for i1 := 1 to plines
        gotoxy(curx,cury)
        write(prompt(i1))
        delay(100)
        if keypressed then
          ch := readkey
          i1 := plines
        endif
      fend
    until ch <> chr(0)
  endif

  # clear prompt and relocate cursor to original position

  gotoxy(curx,cury)
  write(strrep(' ', plen))
  gotoxy(curx, cury)
  stuffkey(ch)
end

# +----- ---- --- -- -  -
# | shameless plug
# +----- --- -- -  -
#
#   constipation of the mind is myst/x modding headquarters. we have a crapton
#   of doors, emulator ROMs, art packs, and the like. all ami/x menusets,
#   running mystic 1.0.7.3 (win32) ... 573 revival!
#
#   constipation of the mind - cotm.dyndns.org (+o haliphax)
#
# +----- ---- --- -- -  -
# | eof('hx-anipz.mps')
# +----- --- -- -  -

