/*
 * MuggiChat v1 main source file.
 *
 * Feel free to make modifications, and email me about problems in 
 * the source. 			-flower/projectdeedee.
 */

#include <dd.h>
#include <ddlib.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include "shmem.h"
#include "config.h"
#include "newstrop.h"
#include "motherl.h"
#include "newmacro.h"

char *fgetsnolfs(char *buf, int n, FILE *fh);
int lscpy(char *s,char *t);

class doorconfig {
	motherlist cfg;
	motherlist color;
public:
	doorconfig(char *fn);
	char *getconfig(int value) {
		return cfg.get(value);
	}
	char *getcolor(int value) {
		return color.get(value%color.count());
	}
};

doorconfig::doorconfig(char *fn) {
	char buf[1000],buf2[1000];
	FILE *f;
	int i;

	if ((f=fopen(fn,"r"))) {
		for (i=0;i<CFGLINES;i++) {
			fgetsnolfs((char*)&buf,1024,f);
			lscpy((char*)&buf,(char*)&buf2);
			cfg.add(buf2,i);
		}
		if (feof(f)) {
			cout << "error in configfile: " << fn << "\n";
			exit(10);
		}
		i=0;
		while ((fgetsnolfs((char*)&buf,1024,f)))
			color.add(buf,i++);
		fclose(f);
	} else {
		cout << "cant find " << fn << " you nuttah\n";
		exit(10);
	}
}

class outctl {
	int lastfrom;
	doorconfig *cfg;
	int needenter;
public:
	outctl(doorconfig *c) { 
		needenter=0;
		lastfrom=-1; 
		cfg=c;
	}
	char *pstr(char *instr,userinfo *u,int n);
	char *parsepack(int node,int c,userinfo *nodeuser);
	setlastfrom(int l) { lastfrom=l; }
};

char *outctl::pstr(char *instr,userinfo *u,int n) {
	char *ret,pbuf[1000],pbuf2[1000];

	strcopy(pbuf,instr);
	parse((char*)&pbuf,"@NU",u->u_handle);
	sprintf(pbuf2,"%d",n);
	parse((char*)&pbuf,"@NN",pbuf2);
	parse((char*)&pbuf,"@NL",u->u_group);
	parse((char*)&pbuf,"@NC",cfg->getcolor(n));

	ret=(char*)malloc(strlng(pbuf)+1);
	strcopy(ret,pbuf);
	return ret;
}

char *outctl::parsepack(int node,int c,userinfo *nodeuser) {
	char *r=(char*)malloc(1000);
	char buf[1000];
	int handleenter=1;

	switch (c) {
		case CHAT_SIGNON: sprintf(r,pstr(cfg->getconfig(CFG_SIGNON),nodeuser,node));
				  lastfrom=-1;
				  needenter=0;
				  break;
		case CHAT_SIGNOFF:sprintf(r,pstr(cfg->getconfig(CFG_SIGNOFF),nodeuser,node));
				  lastfrom=-1;
				  needenter=0;
				  break;
		case 13		: sprintf(r,pstr(cfg->getconfig(CFG_AFTERNL),nodeuser,node));
				  needenter=0;
				  break;
		case 127	:
		case 8		: sprintf(r,"\b \b");
				  handleenter=0;
				  break;
		case 250	: /* no cursor keys thanks :p */
		case 251	:
		case 252	:
		case 253	: handleenter=0;
				  break;

		case CHAT_WHO	: 
				  sprintf(r,pstr(cfg->getconfig(CFG_WHOLINE),nodeuser,node));
				  needenter=0;
				  break;
		case CHAT_PAGEMESSAGE : sprintf(r,pstr(cfg->getconfig(CFG_PAGEMESSAGE),nodeuser,node));
					needenter=0;
				  	break;
		case CHAT_PAGEOK : sprintf(r,pstr(cfg->getconfig(CFG_PAGEOK),nodeuser,node));
					needenter=0;
				   break;
		case CHAT_PAGENOTOK : sprintf(r,pstr(cfg->getconfig(CFG_PAGENOTOK),nodeuser,node));
					needenter=0;
				      break;
		case CHAT_ENTERPAGENODE : sprintf(r,pstr(cfg->getconfig(CFG_ENTERPAGENODE),nodeuser,node));
					needenter=0;
				      break;
		default: if (!(node==lastfrom)) {
				sprintf(r,pstr(cfg->getconfig(CFG_NEWDUDE),nodeuser,node));
				sprintf(buf,"%c",c);
				strkat(r,buf);
				lastfrom=node;
				needenter=1;
			} else {
				sprintf(r,"%c",c);
				handleenter=0;
				needenter=1;

			}
	}
	if ((!handleenter)&&(!needenter)) {
		strcopy(buf,r);
		sprintf(r,"\n%s",buf);
	}
	return r;
}

class ddif {
	dif *d;
	int isnode(int n,DayDream_NodeInfo *n);
	olm(int n,char *str);
	DayDream_MainConfig c;
public:
	ddif(char *n);
	~ddif() {dd_close(d);};
	int tget(int usec);
	put(char *str) {dd_sendstring(d,str);};
	showf(char *fn) {dd_typefile(d,fn,TYPE_MAKE|TYPE_SEC);};
	char *user();
	char *group();
	who();
	page(outctl *outp,userinfo *u,int n,shmem *m);
	status(char *s) { dd_changestatus(d,s); }
};

ddif::page(outctl *outp,userinfo *u,int n,shmem *m) {
	char buf[1000],buf2[1000];
	int i;

	put(outp->parsepack(n,CHAT_ENTERPAGENODE,u));
	buf[0]='\0';
	dd_prompt(d,(char*)&buf,3,0);
	i=atoi((char*)&buf);
	if (olm(i,outp->parsepack(n,CHAT_PAGEMESSAGE,u)))
		put(outp->parsepack(i,CHAT_PAGEOK,m->u_get(i)));
	else
		put(outp->parsepack(i,CHAT_PAGENOTOK,m->u_get(i)));

}

int ddif::isnode(int n,DayDream_NodeInfo *ninf) {
	FILE *nf;
	char buf[1000];

	bzero(ninf,sizeof(struct DayDream_NodeInfo));
	sprintf(buf,"%s/nodeinfo%d.data",DDTEMP,n);
	if ((nf=fopen(buf,"r"))) {
		fread(ninf,sizeof(struct DayDream_NodeInfo),1,nf);
		fclose(nf);
		return 1;
	} else
		return 0;
}


int ddif::olm(int n,char *str) {
	dd_nodemessage ddn;
	timeval tv;
	char buf[1000];
	int fd,sock;
        struct sockaddr_un name;
	DayDream_NodeInfo ninfo;

	if (isnode(n,&ninfo)&&(!((ninfo.ddn_flags&(1L<<0))==0))) {
		bzero(&ddn,sizeof(struct dd_nodemessage));
		ddn.dn_command=2;
		dd_getstrval(d,(char*)&buf,USER_HANDLE);
		strncopy(ddn.dn_string,str,299); /* shits, this be the bug :( */
		sprintf(name.sun_path,"%sdd_sock%d",DDTEMP,n);
		sock=socket(AF_UNIX,SOCK_DGRAM,0);
		if (sock<0)
			name.sun_family = AF_UNIX;

		sendto(sock,&ddn, sizeof(struct dd_nodemessage), 0,(struct sockaddr *)&name, sizeof(struct sockaddr_un));
		close(sock);

		return 1;
	} else
		return 0;
}

ddif::who() {
	dd_docmd(d,"who");
}

char *ddif::user() {
	char *r=(char *)malloc(30);
	
	dd_getstrval(d,r,USER_HANDLE);
	return r;
}

char *ddif::group() {
	char *r=(char *)malloc(30);
	
	dd_getstrval(d,r,USER_ORGANIZATION);
	return r;
}

ddif::ddif(char *n) {
	FILE *cfg;
	char buf[1000];

	d=dd_initdoor(n);
	sprintf(buf,"%s/data/daydream.dat",getenv("DAYDREAM"));
	if ((cfg=fopen(buf,"r"))) {
		fread(&c,sizeof(struct DayDream_MainConfig),1,cfg);
		fclose(cfg);
	} else {
		cout << "cant find daydream.dat\n";
		exit(401);
	}
}

int ddif::tget(int usec) {
        fd_set rfds;
        struct timeval tv;
        int retval,i=-1;

        FD_ZERO(&rfds);
        FD_SET(0, &rfds);
        tv.tv_sec = 0;
        tv.tv_usec = usec;

        retval = select(1, &rfds, NULL, NULL, &tv);

        if (retval)
                return dd_hotkey(d,HOT_QUICK|HOT_CURSOR);
	else
		return -2;
}

char *fgetsnolfs(char *buf, int n, FILE *fh) {
        char *in;
        char *tmp;

        in=fgets(buf,n,fh);
        if (!in) return 0;
        tmp=buf;
        while (*tmp) {
                if ((*tmp==10)||(*tmp==13)) {
                        *tmp=0;
                        break;
                }
                tmp++;
        }
        return in;
}

int lscpy(char *s, char *t) {
        char *u=t;
        while(*s) {
                if (*s=='\\') {
                        s++;
                        if (*s=='\\')
                                *t++='\\';
                        else if (*s=='n')
                                *t++=10;
                        else if (*s=='r')
                                *t++='\r';
                        else if (*s=='e')
                                *t++=27;
                        else if (*s=='a')
                                *t++=1;
                        s++;
                } else {
                        *t++=*s++;
                }
        }
        *t=0;
        return strlng(u)+1;
}


void main(int argc,char *argv[]) {
	shmem	mem;
	ddif	*daydream;
	doorconfig *dcfg;
	outctl	*oc;
	userinfo nu,*tmpuser;
	char	buf[1000],*un;
	int	node,from,donechatting=0;
	int	c,i;

	if (argc!=3) {
		cout << "you da man!!\n";
		exit(1);
	}

	node=atoi(argv[1]);
	daydream=new ddif(argv[1]);
	dcfg=new doorconfig(argv[2]);
	oc=new outctl(dcfg);
	strcopy(nu.u_handle,daydream->user());
	strcopy(nu.u_group,daydream->group());
	nu.u_actuallyhere=1;
	nu.u_signon=time(0);
	mem.u_set(node,&nu);
	mem.add(node,CHAT_SIGNON);
	
	daydream->showf("muggichat_enter");
	daydream->status(MUGGICHAT_STATUS);

	while (!donechatting) {
		if (!((c=daydream->tget(CPUHOGVALUE))<=0)) {
			switch(c) {
				case '' : mem.add(node,CHAT_SIGNOFF);
					    donechatting=1;
					    break;
				case '' : daydream->who();
					    oc->setlastfrom(-1);
					    daydream->status(MUGGICHAT_STATUS);
					    break;
				case '' : daydream->showf("muggichat_whohead");
					    for (i=0;i<=MAXUSERS;i++) {
						tmpuser=mem.u_get(i);
						if ((tmpuser->u_actuallyhere))
							daydream->put(oc->parsepack(i,CHAT_WHO,tmpuser));
					    }
					    oc->setlastfrom(-1);
					    daydream->showf("muggichat_whobutt");
					    break;
				case '' : daydream->who();
					    daydream->page(oc,&nu,node,&mem);
					    oc->setlastfrom(-1);
					    break;
				case '' : daydream->showf("muggichat_help");
					    oc->setlastfrom(-1);
					    break;
				default: mem.add(node,c);
			}
		} else
			if (c==-1)
				donechatting=1;
		while (!(mem.isupdated())) {
			mem.get(&from,&c);
			daydream->put(oc->parsepack(from,c,mem.u_get(from)));
		}
	}

	daydream->showf("muggichat_exit");
	nu.u_actuallyhere=0;
	mem.u_set(node,&nu);

	free(oc);
	free(daydream);
	exit(0);
}
