{-----------------------------------------------------------------------------}
{                                                                             }
{  FossilInterface Unit by cyberkid/food '96.                                 }
{                                                                             }
{-----------------------------------------------------------------------------}


unit fossil;
{$S-,V-,R-}

interface
uses dos;

type
  ASCIZ_id = array[1..128] of char;
  ascizptr  = ^asciz_id;

  fossildatatype = record
                    strsize: word;
                    majver: byte;
                    minver: byte;
                    ident: ascizPtr;
                    ibufr: word;
                    ifree: word;
                    obufr: word;
                    ofree: word;
                    swidth: byte;
                    sheight: byte;
                    baud: byte;
                   end;

procedure async_send(c: char;portnum:byte);
procedure async_send_string(s: string;portnum:byte);
function async_read_buffer(portnum:byte):char;
function async_receive(var ch: char;portnum:byte): boolean;
function async_carrier_drop(portnum:byte): boolean;
function async_carrier_present(portnum:byte): boolean;
function async_buffer_check(portnum:byte) : boolean;
function async_init_fossil(portnum:byte): boolean;
procedure async_deinit_fossil(portnum:byte);
procedure async_set_dtr(state: boolean;portnum:byte);
procedure async_flush_output(portnum:byte);
procedure async_purge_output(portnum:byte);
procedure async_purge_input(portnum:byte);
procedure async_watchdog_on(portnum:byte);
procedure async_watchdog_off(portnum:byte);
procedure async_set_baud(n: longint;portnum:byte);
procedure async_set_baudBnu(n: longint;portnum:byte);
procedure async_set_flow(SoftTran,Hard,SoftRecv: boolean);
procedure async_get_fossil_data(var fossildata:fossildatatype;portnum:byte);
procedure Async_Buffer_Status(var Insize,Infree,OutSize,Outfree: word;
                              var fossilname:string;portnum:byte);
procedure AsyncSelectPort(pn: byte;var portnum:byte;var initok:boolean);
function AsyncCharPresent(portnum:byte): boolean;
procedure AsyncReceiveChar(var ch: char;portnum:byte);
procedure AsyncSelectFossil(var fossilname:string;var fosbnu:boolean;portnum:byte);
procedure AsyncSetBaud(n: longint;fosbnu:boolean;portnum:byte);


implementation

procedure async_send(c: char;portnum:byte);assembler;
asm
  mov ah,01h
  mov al,c
  xor dh,dh
  mov dl,portnum
  int 14h
end;

procedure async_send_string(s: string;portnum:byte);
var a: integer;
begin
  for a:=1 to length(s) do async_send(s[a],portnum);
end;

function async_read_buffer(portnum:byte):char;
var regs:registers;
begin
  regs.ah := $02;
  regs.dx := portnum;
  intr($14,regs);
  async_read_buffer := chr(regs.al);
end;

function async_receive(var ch: char;portnum:byte):boolean;
var regs: registers;
begin
  ch:=#255;
  regs.ah:=$03;
  regs.dx:=portnum;
  intr($14,regs);
  if (regs.ah and 1)=1 then begin
    regs.ah:=$02;
    regs.dx:=portnum;
    intr($14,regs);
    ch:=chr(regs.al);
    async_receive:=true;
  end else
    async_receive:=false;
end;

function async_carrier_drop(portnum:byte): boolean;
var regs: registers;
begin
  regs.ah:=$03;
  regs.dx:=portnum;
  intr($14,regs);
  if (regs.al and $80)<>0 then
    async_carrier_drop:=false
  else
    async_carrier_drop:=true;
end;

function async_carrier_present(portnum:byte): boolean;
var regs: registers;
begin
  regs.ah:=$03;
  regs.dx:=portnum;
  intr($14,regs);
  if (regs.al and $80)<>0 then
    async_carrier_present:=true
  else
    async_carrier_present:=false;
end;

function async_buffer_check(portnum:byte) : boolean;
var regs: registers;
begin
  regs.ah:=$03;
  regs.dx:=portnum;
  intr($14,regs);
  if (regs.ah and 1)=1 then
    async_buffer_check:=true
  else
    async_buffer_check:=false;
end;

function async_init_fossil(portnum:byte): boolean;
var regs: registers;
begin
  regs.ah:=$04;
  regs.bx:=$00;
  regs.dx:=portnum;
  intr($14,regs);
  if regs.ax=$1954 then
    async_init_fossil:=true
  else
    async_init_fossil:=false;
end;

procedure async_deinit_fossil(portnum:byte);assembler;
asm
  mov ah,05h
  xor dh,dh
  mov dl,portnum
  int 14h
end;

procedure async_set_dtr(state: boolean;portnum:byte);
var regs: registers;
begin
  regs.ah:=$06;
  if state then
    regs.al:=1
  else
    regs.al:=0;
  regs.dx:=portnum;
  intr($14,regs);
end;

procedure async_flush_output(portnum:byte);assembler;
asm
  mov ah,08h
  xor dh,dh
  mov dl,portnum
  int 14h
end;

procedure async_purge_output(portnum:byte);assembler;
asm
  mov ah,09h
  xor dh,dh
  mov dl,portnum
  int 14h
end;

procedure async_purge_input(portnum:byte);assembler;
asm
  mov ah,0Ah
  xor dh,dh
  mov dl,portnum
  int 14h
end;

procedure async_watchdog_on(portnum:byte);assembler;
asm
  mov ax,1410h
  xor dh,dh
  mov dl,portnum
  int 14h
end;

procedure async_watchdog_off(portnum:byte);assembler;
asm
  mov ax,1400h
  xor dh,dh
  mov dl,portnum
  int 14h
end;

procedure async_set_baud(n: longint;portnum:byte);
var w : word;
    regs: registers;
begin
  regs.ah:=$00;
  regs.al:=$03;
  regs.dx:=portnum;
  w := n;
  If n > 76800 then         {115200 }
    regs.al:=regs.al or $80
  else
  If n > 57600 then         { 76800 }
    regs.al:=regs.al or $60
  else
    case w of
      300  : regs.al:=regs.al or $40;
      600  : regs.al:=regs.al or $60;
      1200 : regs.al:=regs.al or $80;
      2400 : regs.al:=regs.al or $A0;
      4800 : regs.al:=regs.al or $C0;
      9600 : regs.al:=regs.al or $E0;
      9601..19200:  regs.al:=regs.al or $00;
      19201..38400: regs.al:=regs.al or $20;
      38401..57600: regs.al:=regs.al or $40;
    end;
  intr($14,regs);
end;

procedure async_set_baudBnu(n: longint;portnum:byte);
var w : word;
    regs: registers;
begin
  regs.ah:=$00;
  regs.al:=$03;
  regs.dx:=portnum;
  w := n;
  If n>38400 then
   begin
     If n > 57600 then               {115200}
       regs.al:=regs.al or $80
     else
       regs.al:=regs.al or $60;       { 57600 }
     regs.bx:=$69DC;
     regs.cx:=$69DC;
   end
  else
    case w of
      300  : regs.al:=regs.al or $40;
      600  : regs.al:=regs.al or $60;
      1200 : regs.al:=regs.al or $80;
      2400 : regs.al:=regs.al or $A0;
      4800 : regs.al:=regs.al or $C0;
      9600 : regs.al:=regs.al or $E0;
      9601..19200:  regs.al:=regs.al or $00;
      19201..38400: regs.al:=regs.al or $20;
    end;
  intr($14,regs);
end;

procedure async_set_flow(SoftTran,Hard,SoftRecv: boolean);
var regs: registers;
begin
  regs.ah:=$0F;
  regs.al:=$00;
  if softtran then
    regs.al:=regs.al or $01;
  if Hard then
    regs.al:=regs.al or $02;
  if SoftRecv
    then regs.al:=regs.al or $08;
  regs.al:=regs.al or $F0;
  Intr($14,regs);
end;

procedure async_get_fossil_data(var fossildata:fossildatatype;portnum:byte);
var regs: registers;
begin
  regs.ah:=$1B;
  regs.cx:=sizeof(fossildata);
  regs.dx:=portnum;
  regs.es:=seg(fossildata);
  regs.di:=ofs(fossildata);
  intr($14,regs);
end;

procedure Async_Buffer_Status(var Insize,Infree,OutSize,Outfree: word;
                              var fossilname:string;portnum:byte);
var i:byte;
    fossildata:fossildatatype;
begin
  async_get_fossil_data(fossildata,portnum);
  insize:=fossildata.ibufr;
  infree:=fossildata.ifree;
  outsize:=fossildata.obufr;
  outfree:=fossildata.ofree;
  i := 1;
  while (i<62) and (fossildata.ident^[i] <> #0)  do
    inc(i);
  move(fossildata.ident^, fossilname[1], i);
  fossilname[0] := char(i);
end;

procedure AsyncSelectPort(pn: byte;var portnum:byte;var initok:boolean);
begin
  portnum:=pn-1;
  async_deinit_fossil(portnum);
  initok:=async_init_fossil(portnum);
end;

procedure AsyncReceiveChar(var ch: char;portnum:byte);
var b: boolean;
begin
  b:=async_receive(ch,portnum);
end;

function AsyncCharPresent(portnum:byte): boolean;
begin;
  asyncCharPresent:=Async_buffer_check(portnum);
end;

procedure AsyncSelectFossil(var fossilname:string;var fosbnu:boolean;portnum:byte);
var Insize,infree,outsize,outfree: word;
    s:string;
    p:byte;
begin;
  Async_Buffer_Status(Insize,infree,outsize,outfree,fossilname,portnum);
  s:='';
  for p:=1 to length(fossilname) do
    s:=s+Upcase(fossilname[p]);
  if Pos('BNU',s) <> 0 then
    fosbnu:=true
  else
    fosbnu := false;
end;

procedure AsyncSetBaud(n: longint;fosbnu:boolean;portnum:byte);
begin;
  If fosbnu then
    async_set_baudbnu(n,portnum)
  else
    async_set_baud(n,portnum);
end;

begin
end.
