/**************************************************************************

                         ------ dRUNKEN2K ------

                   MailingList 1.2 for Daydream/UN*X
                             Code by Rezine
                      **  Fixed by esc/demonic **
                    (C) Y2K All wrongs conserved =)
 
            Lough 'bout it, learn from it. Its your decision
      HEY, i told ya: don't rip my credz off or i rip your ballz!!
      
         Coded & Tested on a DayDream 2.14.9 / Ubuntu 10.04 system.

**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <mydd.h>
#include <fcntl.h>
#include <ctype.h>
#include "mlist.h"

void MainMenu(void);
int CreateList(void);
void ListLists(void);
void EditList(int list);
int DecideWhich(int min, int max, int which);
int checkinput(char *check);
void ListMenu(int);
int GetUsers(int list);
void LoadList(void);
void SaveList(void);
void ListUsers(int list);
void WriteMail(int list);
void DeleteList(int list);

struct dif *d;


struct DayDream_MainConfig ddmain;


struct ml_Mailinglist
{
    int users;
    char name[42];
    char user[MAXUSERS][41];
}ml[MAXLISTS];


int curlists=0;
int curusers=0;
int curlistusers=0;

int node;

char FSEDCommand[160];

void die(void)
{
    _center(d,"\e[37m-\e[35m[\e[36mdAYDREAM mAILINGLIST 1.0 bY rEZINE\e[35m^\e[36mdRUNKEN\e[35m]\e[0m-");
    dd_close(d);
}

void ReadDDConfig()
{
    strcpy(FSEDCommand,FSEDCMD);
}

int main(int argc, char *argv[])
{
	if (argc==1) {
		printf("Too much beer? RTFM! =)\n");
		exit(1);
	}
	d=dd_initdoor(argv[1]);
	if (d==0) {
		printf("Couldn't find socket!\n");
		exit(1);
	}
	//Oh yeah, COMMENTS ==)
	node = atoi(argv[1]); //on which node are we running?
	atexit(die); //what to do at an exit
	ReadDDConfig(); //Read config for FSED Command
	LoadList(); //Load currently defined lists
	MainMenu(); //Show up main menu
	exit(0); //uhhmm =)
}

void ShowMainPrompt(void)
{
char buf[160];
    dd_clrscr(d);
    dd_ansipos(d,1,1);
    dd_typefile(d,"mlist",TYPE_MAKE|TYPE_WARN);
    dd_sendstring(d,"\n\e[35m[ \e[36mdRUNKEN mAILINGLIST 1.0 fOR dAYDREAM/uNIX \e[35m]\n");
    dd_sendstring(d,                "---------------------------------------------\n");
    sprintf(buf,"\e[0mYou have currently defined \e[36m%i\e[0m users in \e[36m%i\e[0m lists.\n\n",curusers,curlists);
    dd_sendstring(d,buf);        
    sprintf(buf,"   \e[35m[\e[36mC\e[35m]\e[0mreate a new mailinglist\n");
    dd_sendstring(d,buf);
    if (curlists > 0)
    {
	sprintf(buf,"   \e[35m[\e[36mL\e[35m]\e[0mist all existing mailinglist\n");
	dd_sendstring(d,buf);
	sprintf(buf,"   \e[35m[\e[36mD\e[35m]\e[0melete an existing mailinglist\n");
	dd_sendstring(d,buf);
	sprintf(buf,"   \e[35m[\e[36mW\e[35m]\e[0mrite a mail to a mailinglist\n");
	dd_sendstring(d,buf);

    }
    sprintf(buf,"   \e[35m[\e[36mQ\e[35m]\e[0muit this door.\n\n");
    dd_sendstring(d,buf);
    dd_sendstring(d,"Where do you want to go today? ");
}

void MainMenu(void)
{
int key=0,i;
char buf[160];

    ShowMainPrompt();
    strcpy(buf,"");
    while(key==0)
    {
	key = dd_hotkey(d,HOT_QUICK);
	switch(key)
	{
	    case 'q':
	    case 'Q':
		dd_sendstring(d,"Quit!\n\n");
		SaveList();
		return;
		
	    case 'l':
	    case 'L':
		if (curlists > 0)
		{
		    dd_sendstring(d,"List...\n\n");
		    ListLists();
		    i=0;
		    while(i==0)
		    {
			i=DecideWhich(1,curlists,2);
			ListUsers(i);
		    }
		}
		key=0;
		ShowMainPrompt();
		break;
		
	    case 'd':
	    case 'D':
	    	if (curlists > 0)
		{
		    dd_sendstring(d,"Delete...\n\n");
		    ListLists();
		    i=0;
		    while(i==0)
		    {
			i=DecideWhich(1,curlists,3);
			DeleteList(i);
		    }
		}
		key=0;
		ShowMainPrompt();
		break;
	    
	    case 'w':
	    case 'W':
		key=0;
		if (curlists > 0)
		{
		    dd_sendstring(d,"Write message...\n\n");
		    i=0;
		    while(i==0)
		    {
			i = DecideWhich(1,curlists,1);
		    }
		    WriteMail(i);
		}
		key=0;
		ShowMainPrompt();
		break; 

	    case '?':
	    case 'h':
	    case 'H':
		dd_sendstring(d,"?\n\n");
		dd_typefile(d,"mlisthelp",TYPE_MAKE|TYPE_WARN);
		dd_pause(d);
		key=0;
		ShowMainPrompt();
		break;
		
	    case 'c':
	    case 'C':
		key=0;
		dd_sendstring(d,"Create new list...\n\n");
		CreateList();	
		ShowMainPrompt();
		key=0;
		break;
		
	    default:
		key=0;
	}
    }
}
    
// *******************************************************************
// Returns -1 if error occured, 0 if aborted, 1 if succesfully created
// *******************************************************************/
int CreateList(void)
{
char buf[160];
int i;
    if (curlists == MAXLISTS)
    {
	dd_sendstring(d,"\e[31mCannot add list, limit reached!\e[0m\n");
	dd_pause(d);
	return(0);
    }
    dd_sendstring(d,"Please enter the name for the new list. Leave blank to abort\n");
    dd_sendstring(d,"Name of new list : ");
    strcpy(buf,"");
    dd_prompt(d,buf,40,0);
    if (strcmp(buf,"")==0)
    {
	dd_sendstring(d,"\e[31mAborted...\e[0m\n");
	dd_pause(d);
	return(0);
    } 
    for (i=1;i<=curlists;i++)
    {
	if (strcmp(buf,ml[i].name)==0)
	{
	    dd_sendstring(d,"\e[31mThere already exists a list with this name! Aborting...\e[0m\n");
	    dd_pause(d);
	    return(0);
	}
    }
    curlists++;    
    strcpy(ml[curlists].name,buf);
    sprintf(buf,"\n\nTo create the list now, we'll fire up the Fullscreen Editor\n");
    dd_sendstring(d,buf);
    sprintf(buf,"Put every user you want to be in the list on a single line and\n");
    dd_sendstring(d,buf);
    sprintf(buf,"press CTRL-Z if you are finished or CTRL-A to abort at any time\n");
    dd_sendstring(d,buf);
    sprintf(buf,"Now press any key to continue!\n");
    dd_sendstring(d,buf);
    dd_pause(d);
//    dd_docmd(d,"/home/bbs/doors/dded %N");
    dd_docmd(d,"edtest");
    i = GetUsers(curlists);
    if (i == -1)
    {
	sprintf(buf,"\e[31mAborted!...\e[0m");
	dd_sendstring(d,buf);
	dd_pause(d);
	curlists--;
	return(0);
    }
    sprintf(buf,"\e[35mFound \e[36m%i \e[35musers in the list!\e[0m",i);
    dd_sendstring(d,buf);
    dd_pause(d);
    return(1);
}

//List all currently defined lists, with option to show users of any list
void ListLists(void)
{
int i;
char buf[160];
    dd_sendstring(d,"\nYou have the following lists defined at the moment :\n\n");
    for(i=1;i<=curlists;i++)
    {
	sprintf(buf,"%.02i : \e[36m%-40s \e[0m- \e[35m%i\e[0m users\n",i,ml[i].name,ml[i].users);
	dd_sendstring(d,buf);
    }
    dd_sendstring(d,"\n");
}

void EditList(int list)
{
char buf[160];
    dd_sendstring(d,"\e[0m");
    dd_ansipos(d,1,1);
    dd_clrscr(d);
    dd_ansipos(d,1,1);
    dd_sendstring(d,"\n\e[35m[ \e[36mdRUNKEN mAILINGLIST 1.0 fOR dAYDREAM/uNIX \e[35m]\n");
    dd_sendstring(d,                "---------------------------------------------\n");
    sprintf(buf,"\e[0mYou are just editing list nr. \e[36m%i\e[0m : \e[35%s\e[0m.\n",list,ml[list].name);
    dd_sendstring(d,buf);        
    sprintf(buf,"You have the following options : \n\n");
    dd_sendstring(d,buf);
    sprintf(buf,"   \e[35m[\e[36mA\e[35m]\e[0mdd a new user to the list\n");
    dd_sendstring(d,buf);
    if (ml[list].users > 0)
    {
	sprintf(buf,"   \e[35m[\e[36mL\e[35m]\e[0mist all existing users in this list\n");
	dd_sendstring(d,buf);
	sprintf(buf,"   \e[35m[\e[36mD\e[35m]\e[0melete an existing user from list\n");
	dd_sendstring(d,buf);
    }
    sprintf(buf,"   E\e[35m[\e[36mX\e[35m]\e[0mit to main menu.\n\n");
    dd_sendstring(d,buf);
    dd_sendstring(d,"Where do you want to go today? ");
}

//Some prompt displaying and input parsing...
int DecideWhich(int min, int max, int which)		
{
char buf[160],buff[100];
    while(1)
    {
	if (which==1)
	{
	    sprintf(buf,"Select list to write to \e[35m(\e[36m %i \e[37m- \e[36m%i\e[35m ) (\e[36mL\e[37m to list, \e[36mENTER \e[36mquits\e[35m)\e[0m ? ",min,max);
	}    
	if (which==2)
	{
	    sprintf(buf,"List users of list \e[35m(\e[36m %i \e[37m- \e[36m%i\e[35m ) (\e[36mL\e[37m to list, \e[36mENTER \e[36mquits\e[35m)\e[0m ? ",min,max);
	}
	if (which==3)
	{
	    sprintf(buf,"Select list to delete \e[35m(\e[36m %i \e[37m- \e[36m%i\e[35m ) (\e[36mL\e[37m to list, \e[36mENTER \e[36mquits\e[35m)\e[0m ? ",min,max);
	}
	dd_sendstring(d,buf);
	*buf = '\0';  //	strcpy(buf,"");
	sprintf(buff,"%i",max);
	dd_prompt(d,buf,strlen(buff)+1,0); //dd_prompt(d,buf,strlen(buff),0);

	if ((strcmp(buf,"L")==0)||strcmp(buf,"l")==0)
	{
	    ListLists();
	    return(0);
	}
	else if (checkinput(buf))
	{
	    if((atoi(buf) >= min) && (atoi(buf) <= max))
	    {
		return(atoi(buf));
	    }
	    else return(0);
	}
	else return(-1);
    }
}

// Was input a numeric-only string?
int checkinput(char *check) 
{
int i;
    for(i=0;i<=strlen(check)-1;i++)
    {
	if (!isdigit(check[i])) return(0);
    }
    return(1);
}


int GetUsers(int list) //Checks just created list, removes dupes, etc...
{
char buf[160];
FILE *f;
int i,found;
    ml[list].users = 0; //Init...
    sprintf(buf,"Please wait, checking users... ");
    dd_sendstring(d,buf);
    sprintf(buf,"%s/fsed%d.txt",DDTMP,node); //Get the file where all the added users are into
    f = fopen(buf,"r"); //Open the file...
    if (!f) return(-1);
    while(!feof(f))
    {
	fgets(buf,41,f);
	found=0;
	strcpy(buf,stripcrlf(buf));
	for (i=1;i<=ml[list].users;i++) // Check for dupes...
	{
	    if (strcmp(buf,ml[list].user[i])==0)
	    {
		found=1; // Oh, pretty dumb... do not enter two the same =) 
		break;
	    }
	}
	/*********************************************************************
	   Looks up if the user really exist on the system, and if the current
	   entry is not a dupe and the MAXUSERS limit has not been reached :
	   Add the user to list, yeah! =)
	**********************************************************************/
	if (dd_findusername(d,buf) != -1 && found == 0 && curusers <= MAXUSERS)
	{
	    ml[list].users++;
	    curusers++;
	    strcpy(ml[list].user[ml[list].users],buf);
	}
    }
    sprintf(buf,"%s/fsed%d.txt",DDTMP,node); //Get name for temporary DDED file
    unlink(buf); //Delete temporary file
    return(ml[list].users); //Return nr. of users collected
}

void SaveList(void) // Save user's lists
{
int i,f;
char buf[160];
    sprintf(buf,"%s/users/%i/mlist.dat",getenv("DAYDREAM"),dd_getintval(d,USER_ACCOUNT_ID));
    f = open(buf,O_WRONLY | O_TRUNC | O_CREAT,0644);
    if (!f) // Humm, cannot create file, error & exit
    {
	dd_sendstring(d,"\e[31mERROR! Couldn't save your lists!\e[0m\n");
	exit(-1);
    }
    for (i=1;i<=curlists;i++)
    {
	write(f,&ml[i],sizeof(ml[i]));
    }
    close(f);
}

/********************************
* Load user's lists
********************************/
void LoadList(void)
{
int f;
char buf[200];
    sprintf(buf,"%s/users/%i/mlist.dat",getenv("DAYDREAM"),dd_getintval(d,USER_ACCOUNT_ID));
    f = open(buf,O_RDONLY);
    if (f==-1) return; // Does the user have at least one list defined? 
    while(read(f,&ml[curlists+1],sizeof(ml[curlists+1])))
    {
	curlists++;
	curusers = curusers + ml[curlists].users;
    }
    close(f);
}

// Show users of a specified list
void ListUsers(int list)
{
char buf[160];
int i;
    if (list<1) return;
    sprintf(buf,"\nListing users for list \e[36m%s\e[0m\n\n",ml[list].name);
    dd_sendstring(d,buf);

    for (i=1;i<=ml[list].users;i++)
    {
	sprintf(buf,"  \e[35m%02i\e[36m.\e[0m %s\n",i,ml[list].user[i]);
	dd_sendstring(d,buf);
    }
    dd_sendstring(d,"\n");
    dd_pause(d);
}

// Writes the mail to all users of a list
void WriteMail(int list) 
{
char rwexec[160],buf[160],subject[80]="";
int i;
FILE *f;
    if (list < 1) return; // wus a valid list?? no, return 
    dd_sendstring(d,"\e[36mSubject of msg, BLANK to abort : \e[0m");
    dd_prompt(d,subject,40,0); // get subject of msg 
    if (strcmp(subject,"")==0) return; // no subject == return
    dd_docmd(d,FSEDCommand); // fire up dd fsed
    sprintf(buf,"%s/fsed%d.txt",DDTMP,node); //this will be the file containing the msgbody
    f = fopen(buf,"r"); //does it exist?
    if (!f) //no, exit
    {
	dd_sendstring(d,"\e[35mMessage entry aborted");dd_pause(d);
	return;
    }
    fclose(f);
    f = fopen(buf,"a");
    
    // CREDITS!! NO RIPPING MAN!!! I TOLD YA!
    
    fprintf(f,"\n--[\e[36mThis mail was sent through \e[35mDrunken MailingList\e[36m v1.0\e[0m]------------------------\n");
    fclose(f);
    dd_sendstring(d,"\e[36mPlease wait, writing mails... "); //yes, write mails to users
    for (i=1;i<=ml[list].users;i++)
    {
	dd_getstrval(d,buf,USER_HANDLE);
	// We call robowriter to write the messages...
	sprintf(rwexec,"%s/utils/robowriter -f %s -r %s -s %s -c %i -b %i -p %s/fsed%d.txt",getenv("DAYDREAM"),buf,ml[list].user[i],subject,dd_getintval(d,SYS_CONF),dd_getintval(d,SYS_MSGBASE),DDTMP,node); 
	dd_system(d,rwexec,0);
    }  
    sprintf(buf,"%s/fsed%d.txt",DDTMP,node);
    unlink(buf); //delete the file with the msgbody
    dd_sendstring(d,"\e[35mDONE!\e[0m\n");dd_pause(d);
}


void DeleteList(int list)  //Deletes a list
{
int i;
    // THIS IS THE FIX. SMALL BUT DOES IT ALL, BEFORE IT WAS
    // if (list==0) return;
    // Hah, damn slampy and untested code ;)
    if (list==-1) return;
    
    for (i=1;i<=ml[list].users;i++)
    {
	strcpy(ml[list].user[i],"");
    }
    strcpy(ml[list].name,"");
    curusers = curusers - ml[list].users;

    for (i=list;i<=curlists-1;i++)
    {
	ml[i]=ml[i+1];
    }
    curlists--;	
}

/****************************************************************************
                      YES, THIS IS THE END, MY FRIEND
*****************************************************************************/
