/*************************************************************************
* dRUNkENjOiN v.1.1 for DayDream/UN*X
*
* Developing environment : FreeBSD 4.1, DayDream 2.11
* Not guaranteed to work for you, though it works for me.
* 
* Code by Rezine
* Fixed code by esc
* Artwork\\Design by Threaz
*
* Greetings to all those ppl of the DayDream development staff. You did 
* and do great things, men. 
*
* DayDream ownz.
*
* This source code is released under the DPL, the Drunken Public License.
*
* You know the deal : Learn from my code, laugh 'bout my code but
*                     NEVER EVER EVER rip my credz off my code!
*
* Btw, this time i tried to comment this thing somehow......
**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include "mydd.h" // Some own routines for ddlib
#include "parseme.h" // This is my very own parsing routine =)

// Some function prototypes

int get_confs(void);
char *get_conf_alias(int conference);
int checkinput(char *check);
void display_Conferences(void);
void lightBar(char *str, int num);
int join_Conference(int conference);
void ReadConfig(void);
int KeyMode(int key);
void StatusBar(char *str,int,int);

struct dif *d;

struct conferences // This is a struct taking all the needed stuff for confs.
{
    int num;
    char name[40];
    char alias[1024];
    char password[40];
}conf[64]; // Place for 64 confs.. should last, atm

int confs=0;
int creds=1;
int keymode=0;

// Some configuration variables follow.

int cfg_ShowNoAxx=1; //Show confs which user has no axx to also?
int cfg_ShowAlias=1; //Show confs aliases?
int cfg_StartLine=10; //How many lines has your header + 1 ? :)
int cfg_ShowRealID=1; //Show "real" or "faked" conference id number 
int cfg_ConfsPage=10; // Maximum number of confs on one page

int cfg_StatX=1;
int cfg_StatY=2;
int cfg_StatLen=10;

int cfg_LightBarX=1;
int cfg_LightBarY=11;
int cfg_LightBarLen=80;

char cfg_StatNormal[1024];
char cfg_StatKeymode[1024];
char cfg_StatEmpty[1024];

char bar_hl[1024];
char bar_nl[1024];

char get_pw[1024];
char pw_wrong[1024];
char no_axxess[1024];

/**************************************************************************
* End of configuration variables ;).
**************************************************************************/


void die(void) // What to do before door drops back to DD?
{
    if(creds) // Display creds? DON'T RIP man!!
    {
        dd_sendstring(d,"\e[35m[\e[44m \e[36mdRUNkENjOiN 1.1 -BETA- \e[0m\e[35m]\e[32m Type \e[35mj ?\e[32m to get help on all features!\e[0m\n\n");
    }
    dd_close(d); // Close the door handler
}


int main(int argc, char *argv[]) // Main routine of the door
{
char buf[1024];

    if (argc==1) // Check if there's a cmdline arg
    {
	printf("Uhmm this won't do mate! =[\n");
	exit(-1);
    }
    
    if(!(d = dd_initdoor(argv[1]))) // Check if the cmdline arg is valid node
    {
	printf("Couldn't find socket, bye\n");
	exit(-1);
    }
    
    atexit(die); // Register the handler for program exitus

    ReadConfig(); // Suck in programm configuration
    
    if(!get_confs()) // Read in DD conference data.
    {
        dd_sendstring(d,"Couldn't read out conference data... strange =\\\n"); // Oi, didn't happen to work...
        exit(0);
    }
    
    dd_getstrval(d,buf,DOOR_PARAMS); // Getting a cmdline param that might be there
        
    if(!strcasecmp(buf,"h") || !strcasecmp(buf,"?")) // Look if user wants help...
    {
        dd_typefile(d,"djoinhelp",TYPE_MAKE|TYPE_WARN);
        creds=0;
        exit(0);
    }
    
    if(strcmp(buf,"")) // If there is, we consider it being a conference number ;)
    {
        if(checkinput(buf)) 
        {
            if(atoi(buf) < confs && atoi(buf) > 0)
            {
                cfg_StatX=0; // Put the door in "linemode" :)
                cfg_StatY=0;
                if(join_Conference(atoi(buf)))
                {
                    exit(0);
                }
                else
                {
                    //dd_sendstring(d,"Couldn't join that conference!\n");
                    exit(0);
                }
            }
        }
    }
    
    display_Conferences(); // Let this function do the rest ;)

    exit(0); // ... and finally theres the end.
}

/************************************************************************
* Yes, this code is 99% taken from libdd.doc =) 
* Damn, consider me lame or lazy... :)
************************************************************************/
int get_confs(void)
{
    struct DayDream_Conference *cd;
    struct DayDream_Conference *dconfs;
    struct DayDream_MsgBase *bd;
    
    dconfs=(struct DayDream_Conference *)dd_getconfdata();
    
    if(!dconfs) return(0);
    cd=dconfs;
    
    while(1)
    {
        int bcnt;
        if (cd->CONF_NUMBER==255 || !cd->CONF_NUMBER) break;
        
        /********************************************************
        * Now filling our "own" array of conference data
        ********************************************************/
        if(cfg_ShowNoAxx) // Show all confs? ...
        {
            confs++;
            conf[confs].num=cd->CONF_NUMBER;
            strcpy(conf[confs].name,cd->CONF_NAME);
            strcpy(conf[confs].alias,get_conf_alias(cd->CONF_NUMBER)); // Get an alias for this conf, if there is one
            if(cd->CONF_PASSWD)
            {
                strcpy(conf[confs].password,cd->CONF_PASSWD);
            }
        }
        else // ... if not,  we must decide which confs to get in
        {
            if(dd_isconfaccess(d,cd->CONF_NUMBER))
            {
                confs++;
                conf[confs].num=cd->CONF_NUMBER;
                strcpy(conf[confs].name,cd->CONF_NAME);
                strcpy(conf[confs].alias,get_conf_alias(cd->CONF_NUMBER));
                if(cd->CONF_PASSWD)
                {
                    strcpy(conf[confs].password,cd->CONF_PASSWD);
                }
            }
        }
        bcnt=cd->CONF_MSGBASES;
	bd = (struct DayDream_Conference *) (1 + cd);
//        (struct DayDream_Conference *)bd=cd+1;
        for(bcnt=cd->CONF_MSGBASES;bcnt;bcnt--,bd++);
//        (struct DayDream_MsgBase *)cd=bd; 
	cd = (struct DayDream_MsgBase *) (bd);
    }
    return(1);
}


/**************************************************************************
* Here we read out the Aliases for each conference
* If none is found, an empty string will be returned ("")
***************************************************************************/
char *get_conf_alias(int conference)
{
FILE *f;
int i=0;
char buf[1024];

    sprintf(buf,"%s/configs/djoin.aliases",getenv("DAYDREAM"));
    f=fopen(buf,"r");

    if(!f)
    {
        return("");
    }

    while(!feof(f))
    {
        fgets(buf,70,f);
        if(feof(f)) break;
        if(strlen(buf)<1) break;
        i++;
        if(i==conference)
        {
            if(!strcmp(buf,"-\n"))
            {
                return("");
            }
            return(stripcrlf(buf));
        }
    }
    
    fclose(f);
    return("");
}
    
int checkinput(char *check) // Check if the string only contains "numeric" characters (0-9)
{
int i;
    for(i=0;i<=strlen(check)-1;i++)
    {
        if (!isdigit(check[i])) return(0); // If we found just ONE single non-numeric, report failure
    }
    return(1); // Else report success
}
                        

void display_Conferences(void) // This is the "main" display function
{
int act;
int page=0;
int pages;
int i;
int key;
int quit=0;
int lpage=255;
int ftrdisp=0;
int changed=1;
int stat_changed=1;
int last_hl=-1;
int km;
char buf[1024];
char buff[10];


    pages=(confs/cfg_ConfsPage); // How many pages a 10 confs do we have?
    if(cfg_ShowNoAxx) // We no determine, where we have to set the lightbar on first
    {
        act=dd_getintval(d,SYS_CONF); // In which conference are we atm?
    }
    else
    {
        for(i=1;i<=confs;i++)
        {
            if(conf[i].num==dd_getintval(d,SYS_CONF))
            {
                act=i;
                break;
            }
        }
    }

    dd_ansipos(d,1,1); // Home cursor
    dd_typefile(d,"djoinhdr",TYPE_MAKE); // Display the header
    
    while(!quit) // Our main loop
    {
        page=((act-1)/cfg_ConfsPage); // Which page is the current page?    
        
        if(lpage!=page) // Did the page change lately?
        {
            // If yes, do some cleanup stuff.
            last_hl=-1; // No last highlighted bar...
            for(i=1;i<=cfg_ConfsPage;i++) // Clean up the page
            {
                dd_ansipos(d,cfg_LightBarX,i+cfg_LightBarY);
                lightBar("",0);
            }
            lpage=page; // And we just changed the page...
            stat_changed=1;
        }
        
        if(changed) // Has there been an event that needs screenrefreshing?
        {
            for(i=1;i<=cfg_ConfsPage;i++) // Display the conferences now
            {
                if(i+(page*cfg_ConfsPage) > confs) break; // If we reached the max. conference, break out of for()

                if(act==i+(page*cfg_ConfsPage)) //To highlight or not to highlight, that is here the question =)
                {
                    dd_ansipos(d,cfg_LightBarX,i+cfg_LightBarY);
                    lightBar(bar_hl,i+(page*cfg_ConfsPage));
                }
                else 
                {
                    if(last_hl==i+(page*cfg_ConfsPage) || last_hl==-1)
                    {
                        dd_ansipos(d,cfg_LightBarX,i+cfg_LightBarY);
                        lightBar(bar_nl,i+(page*cfg_ConfsPage));
                    }
                }
            }
            changed=0; //Lets say nothing has changed now ;)
        }
        
        if(!ftrdisp) // Did we display the footer yet...?
        {
            dd_ansipos(d,1,20);
            dd_typefile(d,"djoinftr",TYPE_MAKE); // We don't "warn" about footer not there, because we can have "fullscreen" mode as well :)
            ftrdisp=1; // ... yes we did! =)
        }

        if (stat_changed && cfg_StatX && cfg_StatY)
        {
            if(stat_changed==1)
            {
                StatusBar(cfg_StatNormal,page+1,pages+1);
            }
            stat_changed=0;
        }

        
        key=0; // Init the variable that stores our keypresses.

        while(!key) // Until a key was pressed ......
        {
            key=dd_hotkey(d,HOT_CURSOR);
        }

        switch(key)
        {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
            case 8:
                // This might have be done better, but well :
                // it works =P
                km=KeyMode(key);
                if(!km)
                {
                    stat_changed=1;
                }
                else
                {
                    if(!keymode)
                    {
                        
                        last_hl=act;
                        act=km;
                        stat_changed=1;
                        changed=1;
                        break;
                    }
                    else
                    {
                        stat_changed=0;
                    }
                }
                break;
                
            case 250:        // Key up
                if (act-1 >= 1)
                {
                    last_hl=act;
                    changed=1;
                    act--;
                }
                if(keymode)
                {
                    keymode=0;
                    stat_changed=1;
                }
                break;
                
            case 251:        // Key down
                if (act+1 <= confs)
                {
                    last_hl=act;
                    changed=1;
                    act++;
                }
                if(keymode)
                {
                    keymode=0;
                    stat_changed=1;
                }
                break;
                
            case 'q':
            case 'Q':
                dd_ansipos(d,1,dd_getintval(d,USER_SCREENLENGTH));
                quit=1;
                break;    

            case 'j':
            case 'J':
            case 13:
                if(join_Conference(act))
                {
                    exit(0);
                }
                stat_changed=1;
                break;
            
            // Don't ask me, its different PGUP's and PGDN's ;)
            // (local and remote, i tested, maybe there are more different keycodes for that?)
            case 86:
            case 73:
                if (act - cfg_ConfsPage >= 1)
                {
                    last_hl=act;
                    act=act-cfg_ConfsPage;
                    changed=1;
                }
                else
                {
                    last_hl=act;
                    act=1;
                    changed=1;
                }
                if(keymode)
                {
                    keymode=0;
                    stat_changed=1;
                }
                break;
                
            case 85:
            case 71:
                if (act + cfg_ConfsPage <= confs)
                {
                    last_hl=act;
                    act = act + cfg_ConfsPage;
                    changed=1;
                }
                else
                {
                    last_hl=act;
                    act = confs;
                    changed=1;
                }
                if(keymode)
                {
                    keymode=0;
                    stat_changed=1;
                }
                break;
                
            default:
                break;
        }
    }
    // We should now be at an end =)
}

// This is my lousy function for number key lightbar positioning
// Hmm could need some optimization... :)
int KeyMode(int key)
{
static char buf[10];

    if(key==8 && keymode==1)
    {
        keymode=0;
        return(0);
    }
    
    if(!keymode && key!=8)
    {
        keymode=1;
        dd_ansipos(d,cfg_StatX,cfg_StatY);
        dd_sendstring(d,cfg_StatEmpty);
        dd_ansipos(d,cfg_StatX,cfg_StatY);
        dd_sendstring(d,cfg_StatKeymode);
        sprintf(buf,"%c",key);
        dd_sendstring(d,buf);
        return(1);
    }
    else if(keymode==1 && key!=8)
    {
        keymode=2;
        dd_ansipos(d,cfg_StatX,cfg_StatY);
        dd_sendstring(d,cfg_StatEmpty);
        dd_ansipos(d,cfg_StatX,cfg_StatY);
        dd_sendstring(d,cfg_StatKeymode);
        sprintf(buf,"%s%c",buf,key);
        dd_sendstring(d,buf);
        keymode=0;
        if(atoi(buf) > 0 && atoi(buf) <= confs)
            return(atoi(buf));
        else
            keymode=0;
        
            return(0);
    }
    return(0);
}


void lightBar(char *str, int num) // Construct the conference string and display it
{
char buf[1024];
char buff[10];
int i;

    if(num==0)
    {
        strcpy(buf,"");
        for(i=1;i<=cfg_LightBarLen;i++)
        {
            strcat(buf," ");
        }
        dd_sendstring(d,buf);
        return;
    }

    sprintf(buff,"%i",num); // Integer-To-Ascii ;)

    // Yeah, here comes my "real" feature =]. We parse the lightbar strings
    // for "tags" and replace them dynamically... for more information see
    // parseme.c included with this release or check README.parser...

    if(cfg_ShowRealID)
    {
        strcpy(buf,parse_string(str,"CONFNR",buff,"0"));
    }
    else
    {
        strcpy(buf,parse_string(str,"CONFNR",buff,"0"));
    }

    strcpy(buf,parse_string(buf,"CONFNAME",conf[num].name," "));

    if(cfg_ShowAlias)
    {
        strcpy(buf,parse_string(buf,"CONFALIAS",conf[num].alias," "));
    }
    else
    {
        strcpy(buf,parse_string(buf,"CONFALIAS",""," "));
    }
    dd_sendstring(d,buf);
}

void StatusBar(char *str,int page, int pages) // Statusbar parsing.. don't ask why i put that in an own function :)
{
char buf[1024];
char buff[10];

    dd_ansipos(d,cfg_StatX,cfg_StatY);
    sprintf(buff,"%i",page);
    strcpy(buf,parse_string(str,"PAGEOF",buff,"0"));
    sprintf(buff,"%i",pages);
    strcpy(buf,parse_string(buf,"PAGES",buff,"0"));
    dd_sendstring(d,buf);
            
}


int join_Conference(int conference) // Returns 1 on success, 0 on failure
{
char buf[1024];
int pwcount=3;

    if(conf[conference].num == dd_getintval(d,SYS_CONF)) // If users "joins" the conference he is just in, we return success just to not confuse the calling routine ;)
    {
        if(cfg_StatX && cfg_StatY)
        {
            dd_ansipos(d,1,dd_getintval(d,USER_SCREENLENGTH));
        }
        else
        {
            dd_sendstring(d,"\n");
        }
        creds=0; // We don't want to display any credits if users joins his actual conf, don't ask why ;)
        return(1);
    }

    // Check if a password is set on the conference, and ofcourse if the user has axx to it
    if(strcmp(conf[conference].password,"") && dd_isconfaccess(d,conf[conference].num))
    {
        while(1)
        {
            if (cfg_StatX && cfg_StatY) // Have a look if we are joining from "GUI" or cmdline
            {
                dd_ansipos(d,cfg_StatX,cfg_StatY); // If from GUI, make some screen positioning
                dd_sendstring(d,cfg_StatEmpty);
                dd_ansipos(d,cfg_StatX,cfg_StatY);
            }

            dd_sendstring(d,get_pw); // This Ask-For-Password we'll send in either case ... ;)

            strcpy(buf,""); // Initialize the buffer that we get the pw in
    
            dd_prompt(d,buf,12,PROMPT_SECRET); // Get the password
            
            if(!strcmp(buf,"")) // Just pressed enter?
            {
                if(!cfg_StatY && !cfg_StatY)
                {
                    creds=0; // Ohjo, in linemode no credz, too ;)
                }
                return(0);
            }
            
            if(!strcmp(buf,conf[conference].password))
            {
                break;
            }
            
            pwcount--;
            
            if (cfg_StatX && cfg_StatY)
            {
                dd_ansipos(d,cfg_StatX,cfg_StatY);
                dd_sendstring(d,cfg_StatEmpty);
                dd_ansipos(d,cfg_StatX,cfg_StatY);
                dd_sendstring(d,pw_wrong);
                sleep(2);
            }
            else
            {
                dd_sendstring(d,pw_wrong);
                dd_sendstring(d,"\n");
            }
            
            if(pwcount==0)
            {
                return(0);
            }
        }
    }
    
    if (dd_isconfaccess(d,conf[conference].num))
    {
        dd_ansipos(d,1,dd_getintval(d,USER_SCREENLENGTH));
        dd_sendstring(d,"\n");
        return(dd_joinconf(d,conf[conference].num,JC_SHUTUP));
    }
    else
    {
        if (cfg_StatX && cfg_StatY) // In "GUI" mode?
        {
            dd_ansipos(d,cfg_StatX,cfg_StatY); 
            dd_sendstring(d,cfg_StatEmpty); // Clear statusline
            dd_ansipos(d,cfg_StatX,cfg_StatY);
            dd_sendstring(d,no_axxess); // Print out "noaxx" string.
            sleep(2);
        }
        else
        {
            creds=0;
            dd_sendstring(d,no_axxess);
            dd_sendstring(d,"\n");
        }
        return(0);
    }
    return(0);    
}


void ReadConfig(void) // Suck in configuration file and set variables
{
/*
This still might be some unoptimized shit for reading out # commented
config files hehe ;)
*/
FILE *f;
char buf[1024];
int i;

    sprintf(buf,"%s/configs/djoin.cfg",getenv("DAYDREAM"));
    f=fopen(buf,"r");
    
    if(!f)
    {
        dd_sendstring(d,"FAILURE!\n");
        dd_pause(d);    
    }

    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            strcpy(bar_nl,stripcrlf(buf));
            break;
        }
    }    
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            strcpy(bar_hl,stripcrlf(buf));
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            strcpy(cfg_StatNormal,stripcrlf(buf));
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            strcpy(cfg_StatKeymode,stripcrlf(buf));
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            strcpy(get_pw,stripcrlf(buf));
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            strcpy(pw_wrong,stripcrlf(buf));
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            strcpy(no_axxess,stripcrlf(buf));
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_StatX=atoi(buf);
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_StatY=atoi(buf);
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_StatLen=atoi(buf);
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_LightBarX=atoi(buf);
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_LightBarY=atoi(buf);
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_LightBarLen=atoi(buf);
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_ShowAlias=atoi(buf);
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_ShowNoAxx=atoi(buf);
            break;
        }
    }

    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_ShowRealID=atoi(buf);
            break;
        }
    }

    strcpy(cfg_StatEmpty,"");

    for(i=1;i<=cfg_StatLen;i++)
    {
        strcat(cfg_StatEmpty," ");
    }

    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_ConfsPage=atoi(buf);
            break;
        }
    }

    fclose(f);
}


/* <EOC> <EOF> */
