/*
[ dRUNkEN ] id3todiz v1.0
(C)tHrEAz / Drunken & Damones & Twisted 2001
<threaz@damones.net>
*/

#include <stdio.h>
#include <fcntl.h>

/*
DEFINE THE PATH OF TEMPORARY FILE_ID.DIZ
*/
#define DIZPATH    "file_id.diz"

#define DESIGNLINE "-------------------------------------------\n"

#define NOTITLE    1
#define NOARTIST   2
#define NOALBUM    4
#define NOYEAR     8
#define NOCOMMENT 16
#define DESIGN    32

struct id3struct {
  char tag[3];
  char title[30];
  char artist[30];
  char album[30];
  char year[4];
  char comment[30];
  /* unused but included */
  unsigned char genre;
} id3;

void PrintUsage(char *argv[])
{
  fprintf(stderr, "id3todiz 1.0 (c)tHrEAz/dRUNKEN\n");
  fprintf(stderr, "Usage: %s [-t] [-a] [-n] [-y] [-c] [-f] [-d] <mp3file>\n\n", argv[0]);
  fprintf(stderr, "    -t  no title to output\n");
  fprintf(stderr, "    -a  no artist to output\n");
  fprintf(stderr, "    -n  no album to output\n");
  fprintf(stderr, "    -y  no year to output\n");
  fprintf(stderr, "    -c  no comment to output\n\n");
  fprintf(stderr, "    -f  don't generate file_id.diz, just display info\n");
  fprintf(stderr, "    -d  include \"design\" lines\n");
}

int AnyContent(char string[30])
{
  unsigned int i;

  for (i=0; i < strlen(string); i++) {
    if (string[i] != ' ' && string[i] != '\0')
      return 1;
  return 0;
  }
  return -1;
}

int main(int argc, char *argv[])
{
  int handle=0;
  FILE *output=0;

  char dofile=1;
  char novalue=0;
  int filename=0;
  char isok=1;
  int i;

  char spaces[4] = "\0";

  if (argc < 2) {
    PrintUsage(argv);
    isok=0;
  } else {
    for (i=1; i < argc; i++) {
      if (!isok) {
        PrintUsage(argv);
        break;
      }
      if (!strncmp(argv[i], "-", 1)) {
	switch (argv[i][1]) {
          case 't':
            if (argv[i][2] != '\0')
              isok=0;
	    novalue ^= NOTITLE;
	    break;
          case 'a':
            if (argv[i][2] != '\0')
              isok=0;
            novalue ^= NOARTIST;
	    break;
          case 'n':
            if (argv[i][2] != '\0')
              isok=0;
	    novalue ^= NOALBUM;
	    break;
          case 'y':
            if (argv[i][2] != '\0')
              isok=0;
	    novalue ^= NOYEAR;
	    break;
          case 'c':
            if (argv[i][2] != '\0')
              isok=0;
	    novalue ^= NOCOMMENT;
	    break;
          case 'f':
            if (argv[i][2] != '\0')
              isok=0;
            dofile = 0;
            break;
          case 'd':
            if (argv[i][2] != '\0')
              isok=0;
            novalue ^= DESIGN;
            sprintf(spaces, "   ");
            break;
          default:
	    isok=0;
	    PrintUsage(argv);
	    break;
	}
      } else {
	if (filename) {
	  PrintUsage(argv);
	  isok=0;
	} else {
            filename = i;
	}
      }
    }
  }

  if (!filename)
    isok=0;

  if (isok)
    if ((handle = open(argv[filename], O_RDONLY, 0)) == -1) {
      fprintf(stderr, "Error opening %s\n", argv[filename]);
      isok=0;
    }

  if (isok)
    if (lseek(handle, -128, SEEK_END) < 0) {
      perror("Can't seek!");
      isok=0;
    }

  if (isok)
    if ((i = read(handle, &id3, 128)) != 128) {
      fprintf(stderr, "Error reading %s (%i/128)\n", argv[filename], i);
      isok=0;
    }

  if (handle)
    close(handle);

  if (isok && dofile)
    if (!(output = fopen(DIZPATH, "w"))) {
      fprintf(stderr, "Error opening %s\n", DIZPATH);
      isok=0;
    }

  if (isok && !dofile)
    output = stdout;

  if (isok) {
    if (!strncmp(id3.tag, "TAG", 3)) {
      if (novalue & DESIGN)
        fprintf(output, DESIGNLINE);
      if (AnyContent(id3.title) && !(novalue & NOTITLE))
	fprintf(output, "%stITLE..: %1.30s\n", spaces, id3.title);
      if (AnyContent(id3.artist) && !(novalue & NOARTIST))
	fprintf(output, "%saRTIST.: %1.30s\n", spaces, id3.artist);
      if (AnyContent(id3.album) && !(novalue & NOALBUM))
	fprintf(output, "%saLBUM..: %1.30s\n", spaces, id3.album);
      if (AnyContent(id3.year) && !(novalue & NOYEAR))
	fprintf(output, "%syEAR...: %1.4s\n", spaces, id3.year);
      if (AnyContent(id3.comment) && !(novalue & NOCOMMENT))
	fprintf(output, "%scOMMENT: %1.30s\n", spaces, id3.comment);
      if (novalue & DESIGN)
        fprintf(output, DESIGNLINE);
    } else {
      fprintf(output, ">(: nO iD3 tAG iN fiLE :)<\n");
    }
  }

  if (output)
    fclose(output);

  if (isok)
    return 0;
  else
    return -1;
}
