#include <stdio.h>
#include <dd.h>
#include <ddlib.h>

void die(void);
int strlenansi(char *string);

//struct dif *d;


/***************************************************************************
 FUNCTION :	dd_anispos(struct dif *d, int x, inty)
 DOES     :	Positions the cursor to x and y pos on the screen
 RETURNS  :	Nothing
 EXAMPLE  :	dd_ansipos(d,1,1) // positions the cursor upper left corner
 ISSUES   :     If you want to have the cursor positioned direct AFTER
                a dd_clrscr you must call dd_clrscr AFTER dd_ansipos e.a.
		   dd_ansipos(d,10,10);
		   dd_clrscr(d);
****************************************************************************/
void dd_ansipos(struct dif *d,int x, int y)
{
char tmpstring[10];
    //dd_sendstring(d,"\n");	
    sprintf(tmpstring,"\e[%i;%iH",y,x);
    dd_sendstring(d,tmpstring);
}

void dd_clrscr(struct dif *d)
{
    dd_sendstring(d,"\e[2J");
}

void _center(struct dif *d, char *string)
{
int i;
int len;
    len = strlenansi(string);
    for(i=1;i<=40-len/2;i++)
    {
	dd_sendstring(d," ");
    }
    dd_sendstring(d,string);
    dd_sendstring(d,"\n");
}    

void center(struct dif *d, char *string,int x)
{
    dd_ansipos(d,x,40 - strlen(string) / 2);
    dd_sendstring(d,string);
}

int strlenansi(char *string)
{
int i,len,striplen=0;
len=strlen(string);
    for(i=0;i<=len;i++)
    {
	if (string[i]==27)
	{
	    striplen++;
	    while (string[i]!='m')
	    {
		striplen++;
		i++;
	    }
	}
    }
    return(len-striplen);
}

char *stripcrlf(char *string)
{
int i;
int len;
    len=strlen(string);
    for(i=len-3;i<=len;i++)
    {
        if(string[i]==10)
        {
            string[i]=0;
            break;
        }
    }
    return(string);
}
								    