Unit Modem;
{$I DIRECT.INC}
Interface


Var SendChar    : Procedure (K:Char);
    SendModemStr: Procedure (Str:String; Display:Boolean);
    SendString  : Procedure (Str:String);
    GetChar     : Function : Char;
    Carrier     : Function : Boolean;
    NumChars    : Function : Boolean;
    ClosePort   : Procedure;
    HangUp      : Procedure;
    DoAnswer    : Procedure;
    DontAnswer  : Procedure;
    NukeInput   : Procedure;
    NukeOutput  : Procedure;
    SetParam    : Procedure;
    Comport     : Word;
         Vah    : Byte;
         Vax    : Integer;
         C      : Char;
         W      : Word;

Function InstallFossil : Boolean;
Procedure Null_Modem;

Implementation

Uses Crt,ConfigRt,Subs1, SubsOvr;
const
   Null   = #0;


Procedure ComSendString (S : String);
var x : byte;
begin
for x := 1 to length(s) do
    sendChar(s[x]);
end;


Function  carrierDetected: Boolean; assembler;
 Asm
  mov ah, $03
  mov dx, comport
  int 14h
  mov bl, al
  xor al, al
  and bl, $80
  cmp bl, $80
  jne @@exitcarr
  inc al
  @@exitcarr:
 End;



Function  charWaiting: Boolean;
 Begin
  Asm
   mov ah, $03
   mov dx, comport
   int 14h
   mov vah, ah
  End;
  if (vah and 1) = 1 then charWaiting := true else charWaiting := false;
 End;


Procedure comSetParam;
 Var
  C: Byte;
 Begin
  If cfg.defBaudRate = 0 Then Exit;
  C := 0;
  C := 8 - 5;
  c := c or ((1 - 1)shl 2);
  case upcase('N') of
   'O': c := c or $08; { odd }
   'N': c := c or $00; { n }
   'E': c := c or $18; { even }
   end;
  case cfg.defBaudRate of
   12  : c := c or $80;
   24  : c := c or $A0;
   48  : c := c or $C0;
   96  : c := c or $E0;
   192 : c := c or $00;
   384 : c := c or $20;
   576 : c := c or $40;
  1152 : c := c or $40;
  end;
  asm
   xor ah, ah
   mov al, c
   mov dx, comport
   xor dh, dh
   int 14h
  end;
end;

Function installFossil : Boolean;
 Begin
   installFossil := False;
   asm
    mov ah, $04
    mov dx, comport
    int 14h
    mov vax, ax;
   end;
  if vax = $1954 then installFossil := True;
 End;


Procedure comWriteChar(c: Char); assembler;
 Asm
  mov ah, 0Bh
  mov al, c
  mov dx, comport
  int 14h
 End;


Function comReadChar: Char;
 Begin
   Asm
    mov c, null
    mov ah, $02
    mov dx, comport
    int 14h
    mov c, al
   End;
  comReadChar := c;
 End;


Procedure deActivatePort; assembler;
 Asm
  mov ah, $05
  mov dx, comport
  int 14h
 End;

Procedure FDontAnswer; Assembler;
Asm
  mov ax,$0600
  mov dx,comport
  int $14
End;

Procedure FDoAnswer; Assembler;
Asm
  mov ax,$0601
  mov dx,comport
  int $14
End;

Procedure DoHangup;
Begin
  DontAnswer;
  Delay (500);
  If Carrier Then
  Begin
    DoAnswer;
    Delay(100);
    SendModemStr(Cfg.ModemHangUpStr, False);
    DontAnswer;
    Delay(100);
  End;
  UpdateNode('0','');
End;

Procedure ClearOutBuffer; Assembler;
Asm
  mov ah,$09
  mov dx,comport
  int $14
End;

Procedure ClearInBuffer; Assembler;
Asm
  mov ah,$0a
  mov dx,comport
  int $14
End;


Procedure ComSendModemStr (Str:String; Display:Boolean);
Var X : Byte;
Begin
  While Display AND CharWaiting Do Write(ComReadChar);
  Delay(50);
  For X := 1 to Length(Str) Do
  Begin
    Case Str[X] of
      '|' : ComWriteChar(#13);
      '~' : Delay (300);
      Else  ComWriteChar(Str[X])
    End;
    Delay(50);
    If Display Then If CharWaiting Then Write(ComReadChar);
  End;
  For X := 1 To 255 Do If Display and CharWaiting Then Write(ComReadChar);
  Delay(50);
End;

Procedure Null_Proc;
Begin
End;

Procedure Null_Hang;
Begin
  UpdateNode('0','');
End;


Function Null_NumChars : Word;
Begin
  Null_NumChars := 0;
End;

Function Null_Boolean_Func : Boolean;
Begin
  Null_Boolean_Func := False;
End;

Function Null_Char_Func : Char;
Begin
End;

Procedure Null_SendChar (K : Char);
Begin
End;

Procedure Null_SendString (Str : String);
Begin
End;

Procedure Null_SendModemStr (Str:String; Display:Boolean);
Begin
End;



Procedure Null_Modem;
Begin
  ClosePort;
  GetChar    := Null_Char_Func;
  SendChar   := Null_SendChar;
  SendString := Null_SendString;
  Carrier    := Null_Boolean_Func;
  NumChars   := Null_Boolean_Func;
  ClosePort  := Null_Proc;
  HangUp     := Null_Hang;
  DoAnswer   := Null_Proc;
  DontAnswer := Null_Proc;
  NukeInput  := Null_Proc;
  NukeOutput := Null_Proc;
  SetParam   := Null_Proc;
SendModemStr := Null_SendModemStr;
End;

Begin
    Comport    := Cfg.Usecom - 1;
    GetChar    := ComReadChar;
    SendChar   := ComWriteChar;
    Carrier    := CarrierDetected;
    NumChars   := CharWaiting;
    ClosePort  := DeActivatePort;
    HangUp     := DoHangup;
    DoAnswer   := FDoAnswer;
    DontAnswer := FDontAnswer;
    NukeInput  := ClearInBuffer;
    NukeOutput := ClearOutBuffer;
    SetParam   := ComSetParam;
    SendString := ComSendString;
    SendModemStr := ComSendModemStr;
{   end else
{    begin
     ComPort   := Cfg.useCom -1;
     getChar   := async.getChar;
     sendChar  := async.sendByte;
     carrier   := async.carrier;
     closePort := async.modemDeInit;
     hangUp    := async.hangUp;
     nukeInput := async.asyncPurgeInput;
     nukeOutput:= async.asyncPurgeOutput;
     sendString:= async.aWrite;
     sendModemStr := async.aModemWrite;
    end;}
End.
