{darkness v1.00 beta 3 file structure records}
{jay phillips --- damned software, 2001}

{------------------------------ --- -- -}
type
{------------------------------ --- -- -}

      playerrecord = record
        pnum        : integer;    {player number, used for index/reference}
        preal       : string[30]; {real name, used for loading player info}
        pname       : string[20]; {players name in game}
        pclass      : shortint;   {1, assassin, 2 tech, 3 streetscum}
        pexp        : longint;    {total experience}
        plevel      : shortint;   {users level, 1-10}
        php         : integer;    {hit points}
        php_left    : integer;    {hit points left}
        pgang       : shortint;   {number of gang he's in}
        psf         : integer;    {street fights, usually 15}
        psf_left    : integer;    {street fights left}
        ppf         : integer;    {player fights, usually 3}
        ppf_left    : integer;    {player fights left}
        pcredits    : longint;    {credits on hand}
        pcreditsbank: longint;    {credits in bank}
        pweapon     : string[20]; {weapon name}
        pattack     : integer;    {weapon // other accumlated strength}
        parmor      : string[20]; {armour name}
        pdefense    : integer;    {armour // other accumlated defense}
        pbionics    : string[20]; {bionics name}
        pcharm      : integer;    {charm}
        plays       : integer;    {lays}
        pdead       : shortint;   {is he dead? 0 or no, 5 for yes}
        pontoday    : shortint;   {has he been on today? 0 or no, 5 for yes}
        pigmnow     : shortint;   {currenty in an igm? 0 for no, 5 for yes}
        pinigm      : shortint;   {sleeping in an igm? 0 or no, 5 for yes}
        pwhichigm   : string[50];  {which igm is user in?}
        pininn      : shortint;   {is he in the inn? 0 or no, 5 for yes}
        pgleader    : shortint;   {is he a gang leader? 0 or no, 5 for yes}
        pisingang   : shortint;   {is he in a gang? 0 or no, 5 for yes}
        pjail       : shortint;   {is he in jail? 0 for no, 5 for yes}
        parrests    : shortint;   {number of times arrested}
        psex        : string[6];  {players sex, genrally male or female}
        pskill1     : shortint;   {number of skill 1 uses per day}
        pskill1_left: shortint;   {number of skill 1 uses left today}
        pskill2     : shortint;   {number of skill 2 uses per day}
        pskill2_left: shortint;   {number of skill 2 uses left today}
        pskill3     : shortint;   {number of skill 3 uses per day}
        pskill3_left: shortint;   {number of skill 3 uses left today}
        pseengirl   : shortint;   {seen whore? 0 for no, 5 for yes}
        pseen2300   : shortint;   {seen orasmatron? 0 for no, 5 for yes}
        podcount    : shortint;   {overdose count, => 20 = bad}
        pattrib1    : shortint;   {has it? 0 for no, 5 for yes}{body comp}
        pattrib2    : shortint;   {has it? 0 for no, 5 for yes}{spring comp}
        pattrib3    : shortint;   {has it? 0 for no, 5 for yes}{digital mem}
        pcrate      : shortint;   {cyber rating... => 10 = bad}
        firsttime   : shortint;   {has it? 0 for no, 5 for yes}
        lasttime    : shortint;   {last time user was online}
        ponnode     : shortint;   {which node is user on?}
        ponnow      : shortint;   {user on now? 0 for no, 5 for yes}
        pkilledm    : shortint;   {times user has killed masters}
        pkilledby   : string[20]; {last killed by}
        pkills      : integer;    {times player has killed a player}
        pdeaths     : integer;    {times player has been killed by a player}
        ponfight    : shortint;   {in online fight? 0 for no, 5 for yes}
        reserved    : Array[1..374] of Byte; {reserved space}
      end;

{------------------------------ --- -- -}

      gangrecord = record
        gnum        : integer;    {gang number, not really used}
        gname       : string[20]; {gang name}
        ghit        : shortint;   {have they hit? 0 or no, 5 for yes}
        gkilled     : shortint;   {have they assassinated?? 0 or no, 5 for yes}
        gnarced     : shortint;   {have they narced? 0 or no, 5 for yes}
        gmoney      : longint;    {money in gangs bank}
        gstrength   : integer;    {gangs strength}
        gmembers    : shortint;   {number of members in gang}
        gmem1       : string[30]; {players name}
        gmem2       : string[30]; {players name}
        gmem3       : string[30]; {players name}
        gmem4       : string[30]; {players name}
        gmem5       : string[30]; {players name}
        gmem6       : string[30]; {players name}
        gmem7       : string[30]; {players name}
        gmem8       : string[30]; {players name}
        gmem9       : string[30]; {players name}
        gmem10      : string[30]; {players name}
        gleader     : string[30]; {leaders name}
        gpass       : string[10]; {password}
        reserved    : Array[1..400] of Byte; {reserved space}
      end;

{------------------------------ --- -- -}

      configfile = record
        sysopname   : string[30]; {sysop name}
        bbsname     : string[30]; {bbs name}
        regnum      : longint;    {not used yet}
        darkdir     : string[60]; {just path, not file}
        numpf       : shortint;   {number of pfs xx}
        numsf       : shortint;   {number of sfs xx}
        numgangs    : shortint;   {doesn't matter how many, xx}
        maxingang   : shortint;   {1-10}
        del1ex      : shortint;   {0 for no, 5 for yes}
        delperiod   : shortint;   {players deleted after how long?}
        defsl       : byte;       {default sl}
        sligms      : byte;       {sl for igm access}
        sllockmsg   : string[60]; {lockout msg}
        firsttime   : shortint;   {has door run today?, 0 for no, 5 for yes}
        lasttime    : shortint;   {last time door was ran (day)}
        gameover    : shortint;   {game over? 0 for no, 5 for yes}
        overby      : string;     {who beat the game?}
        maketopb    : shortint;   {make rank bulletin? 0 for no, 5 for yes}
        topbfilen   : string[60]; {path and file nme}
{added as of beta 2}
        autoreset   : shortint;   {auto reset game}
        resetperiod : byte;       {days to reset after}

        reserved    : Array[1..398] of Byte; {reserved space}
      end;

{------------------------------ --- -- -}

{------------------------------ --- -- -}

      nodesfile = record
        nodenum     : byte;       {1-255}
        droptype    : byte;       {1-3 according to xdoor}
        dropdir     : string[60]; {just path, not file}
      end;

{------------------------------ --- -- -}


      enemyrecord = record
        enum        : integer;    {number of enemy}
        ename       : string[30]; {name of enemy}
        ecredits    : longint;    {credits won from enemy}
        eweapon     : string[30]; {weapon name}
        eattack     : integer;    {attack}
        eexp        : integer;    {experience won}
        ehp         : integer;    {hp of enemy}
        edeath      : string;     {death phrase/description}
        eintro      : string;     {intro phrase/description}
        esex        : string;     {geneder of enemy... it/she/he}
        reserved    : Array[1..400] of Byte; {reserved space}
      end;

{------------------------------ --- -- -}

      mailfile = record
        mto         : string[30]; {who message is to}
        mfrom       : string[30]; {who message is from}
        msub        : string[79]; {subject}
        mline1      : string[79]; {line #1 of msg}
        mline2      : string[79]; {line #2 of msg}
        mline3      : string[79]; {line #3 of msg}
        mline4      : string[79]; {line #4 of msg}
        mline5      : string[79]; {line #5 of msg}
        mline6      : string[79]; {line #6 of msg}
        mspecial    : char;       {special type of email? A-K/L-V}
        reserved    : Array[1..400] of Byte; {reserved space}
      end;

{------------------------------ --- -- -}

const
     vershort      = '1.00b3';               {version of release}
     verlong       = '1.00 beta 3'; {long version}
     compdate      = '6/15/01';            {compile date of version/build}
     lline1        = '|08-------------------------------------------------------------------------------';
     lline2        = '[1;30m-------------------------------------------------------------------------------';
     maxplayers    = 150;                      {max players allowed}
     maxgangs      = 100;                        {max gangs allowed}

{------------------------------ --- -- -}
{eof}
