/*
 * Decompiled with CFR 0.152.
 */
package org.kd.fakedemo;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import java.util.Arrays;
import org.kd.common.Scene;
import org.kd.common.SceneManager;
import org.kd.fakedemo.Scene1C64;
import org.kd.fakedemo.Scene2;

public class AnimationManager
extends ApplicationAdapter {
    SpriteBatch batch;
    SceneManager sceneManager;

    @Override
    public void create() {
        this.batch = new SpriteBatch();
        this.sceneManager = new SceneManager();
        Scene1C64 scene1Tiles = new Scene1C64("scene1");
        Scene2 scene2 = new Scene2("scene2");
        Arrays.asList(scene1Tiles, scene2).forEach(s -> {
            s.create();
            this.sceneManager.addScene(s.id, (Scene)s);
        });
        this.sceneManager.switchScene("scene1");
    }

    @Override
    public void render() {
        float delta = Gdx.graphics.getDeltaTime();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.sceneManager.update(delta);
        this.batch.begin();
        this.sceneManager.render();
        this.batch.end();
        long frame = Gdx.graphics.getFrameId();
        if (frame == 283L) {
            this.sceneManager.switchScene("scene2");
        }
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        this.sceneManager.disposeScenes();
    }
}

