#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct VoxelizationDispatchParams
{
    int lights_num;
    uint component_tags;
    float env_map_intensity;
};

layout(set = 1, binding = 1, std430) buffer VoxelLightBuffer
{
    uint in_voxel_light_data[];
} _115;

layout(set = 1, binding = 2, std430) buffer VoxelOcclusionBuffer
{
    uint in_voxel_occlusion_data[];
} _133;

layout(set = 1, binding = 3, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(location = 1) in vec3 vGridCoords;
layout(location = 5) in vec3 vPointCoords;
bool twoSided;
bool clipless;

uint rt_calculate_grid_cell_idx(uint cx, uint cy, uint cz)
{
    return (cx + (cy * 256u)) + ((cz * 256u) * 256u);
}

void rt_store_voxel_occlusion(uint cx, uint cy, uint cz, float v)
{
    uint param = cx;
    uint param_1 = cy;
    uint param_2 = cz;
    uint idx = rt_calculate_grid_cell_idx(param, param_1, param_2);
    uint _140 = atomicMax(_133.in_voxel_occlusion_data[idx], uint(v * 1024.0));
}

void rt_store_voxel_color_emissive(uint cx, uint cy, uint cz, inout vec4 v)
{
    uint param = cx;
    uint param_1 = cy;
    uint param_2 = cz;
    uint idx = rt_calculate_grid_cell_idx(param, param_1, param_2);
    float v_mag = ceil(length(v.xyz));
    vec4 _65 = v;
    vec3 _69 = _65.xyz / vec3(v_mag);
    v.x = _69.x;
    v.y = _69.y;
    v.z = _69.z;
    v_mag = min(127.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    vi |= 2147483648u;
    uint _121 = atomicMax(_115.in_voxel_light_data[idx], vi);
}

void main()
{
    twoSided = false;
    clipless = false;
    vec3 bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 bbox_grid_size = in_bbox_data.grid_size_voxelize.xyz;
    vec3 pos = vGridCoords;
    vec3 gc = (gl_FragCoord.xyz / vec3(1.0, 1.0, 0.00390625)) + vec3(0.0);
    gc.y = 255.5 - gc.y;
    ivec3 mi = ivec3(vPointCoords);
    ivec3 ma = mi;
    mi = clamp(mi, ivec3(0), ivec3(255));
    ma = clamp(ma, ivec3(0), ivec3(255));
    uint cx = uint(gc.x);
    uint cy = uint(gc.y);
    uint cz = uint(gc.z);
    vec3 voxel_color = vec3(1.0);
    int sampling_r = 2;
    int _210 = -sampling_r;
    for (int sz = _210; sz <= sampling_r; sz++)
    {
        int _221 = -sampling_r;
        for (int sy = _221; sy <= sampling_r; sy++)
        {
            int _232 = -sampling_r;
            for (int sx = _232; sx <= sampling_r; sx++)
            {
                uvec3 cc = uvec3(ivec3(int(cx), int(cy), int(cz)) + ivec3(sx, sy, sz));
                vec3 cellPos = vec3(cc);
                vec3 cellSize = vec3(1.0);
                vec3 sampling_pos = cellPos + (cellSize * 0.5);
                float point_d = length(vPointCoords - sampling_pos);
                float max_d = cellSize.x * float(sampling_r);
                if (point_d < max_d)
                {
                    float occ = 1.0 - (point_d / max_d);
                    uint param = cc.x;
                    uint param_1 = cc.y;
                    uint param_2 = cc.z;
                    float param_3 = occ;
                    rt_store_voxel_occlusion(param, param_1, param_2, param_3);
                    uint param_4 = cc.x;
                    uint param_5 = cc.y;
                    uint param_6 = cc.z;
                    vec4 param_7 = vec4(voxel_color, 1.0) * occ;
                    rt_store_voxel_color_emissive(param_4, param_5, param_6, param_7);
                }
            }
        }
    }
}

 