#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
#extension GL_EXT_buffer_reference2 : require
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct AllocateMemoryForCellsParams
{
    uint64_t buff_grid_markers_ptr;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(buffer_reference) buffer RT_BuffPointerToU32;
layout(buffer_reference, buffer_reference_align = 4, std430) buffer RT_BuffPointerToU32
{
    uint v;
};

layout(set = 0, binding = 1, std430) buffer FacesLinkedListTailsBuffer
{
    uint in_faces_list_tails_data[];
} _47;

layout(set = 0, binding = 3, std140) uniform AllocateMemoryForCellsParamsBuffer
{
    AllocateMemoryForCellsParams allocate_memory_for_cells_params;
} _249;

layout(set = 0, binding = 2, std430) buffer FacesLinkedListBuffer
{
    uint buffer_counter;
    uint occupied_cell_counter;
    uint _pad0;
    uint _pad1;
    uint _pad2;
    uint _pad3;
    uint _pad4;
    uint _pad5;
    uint node_buffer[];
} in_faces_list_data;

layout(set = 0, binding = 4, r32ui) uniform uimage3D imGridMarkers0;
layout(set = 0, binding = 5, r32ui) uniform uimage3D imGridMarkers2;

bool _rt_grid_marker_validate(uint64_t markers_ptr)
{
    return true;
}

void rt_pack_grid_marker_to_uint_buff(uvec3 p, uint grid_res, out uint p_packed, out uint bit)
{
    uvec3 p_low_bits = p & uvec3(3u, 3u, 1u);
    uvec3 p_high_bits = uvec3(p.x >> uint(2), p.y >> uint(2), p.z >> uint(1));
    uint high_linearized = (p_high_bits.x + (p_high_bits.y * (grid_res / 4u))) + ((p_high_bits.z * (grid_res / 4u)) * (grid_res / 4u));
    p_packed = high_linearized;
    bit = (p_low_bits.x + (p_low_bits.y * 4u)) + ((p_low_bits.z * 4u) * 4u);
}

bool _rt_read_grid_marker_high_res(uint64_t markers_ptr, ivec3 pos)
{
    uint64_t param = markers_ptr;
    if (_rt_grid_marker_validate(param) == false)
    {
        return false;
    }
    uvec3 upos = uvec3(pos);
    if (max(upos.x, max(upos.y, upos.z)) >= 256u)
    {
        return false;
    }
    uvec3 param_1 = upos;
    uint param_2 = 256u;
    uint param_3;
    uint param_4;
    rt_pack_grid_marker_to_uint_buff(param_1, param_2, param_3, param_4);
    uint pos_packed = param_3;
    uint bit = param_4;
    RT_BuffPointerToU32 markers = RT_BuffPointerToU32(markers_ptr + uint64_t(pos_packed * 4u));
    return ((markers.v & (1u << bit)) != 0u) ? true : false;
}

void rt_pack_grid_marker_to_uint_img(ivec3 p, out ivec3 p_packed, out uint bit)
{
    ivec3 p_low_bits = p & ivec3(3, 3, 1);
    p_packed = ivec3(p.x >> 2, p.y >> 2, p.z >> 1);
    bit = uint((p_low_bits.x + (p_low_bits.y * 4)) + ((p_low_bits.z * 4) * 4));
}

uint rt_link_list_get_count(uint list_index)
{
    return _47.in_faces_list_tails_data[list_index];
}

void main()
{
    uint total = 0u;
    uint utilized = 0u;
    uvec3 p = gl_GlobalInvocationID * uvec3(2u);
    ivec3 param_3;
    uint param_4;
    for (int iz = 0; iz < 2; iz++)
    {
        for (int iy = 0; iy < 2; iy++)
        {
            for (int ix = 0; ix < 2; ix++)
            {
                uint ccx = p.x + uint(ix);
                uint ccy = p.y + uint(iy);
                uint ccz = p.z + uint(iz);
                uint64_t param = _249.allocate_memory_for_cells_params.buff_grid_markers_ptr;
                ivec3 param_1 = ivec3(int(ccx), int(ccy), int(ccz));
                bool cell_used = _rt_read_grid_marker_high_res(param, param_1);
                if (cell_used)
                {
                    do
                    {
                        ivec3 param_2 = ivec3(int(ccx), int(ccy), int(ccz));
                        rt_pack_grid_marker_to_uint_img(param_2, param_3, param_4);
                        ivec3 pos_packed = param_3;
                        uint bit = param_4;
                        uint _293 = imageAtomicOr(imGridMarkers0, pos_packed, 1u << bit);
                    } while (false);
                    utilized++;
                }
            }
        }
    }
    if (utilized == 0u)
    {
        return;
    }
    for (int iz_1 = 0; iz_1 < 2; iz_1++)
    {
        for (int iy_1 = 0; iy_1 < 2; iy_1++)
        {
            for (int ix_1 = 0; ix_1 < 2; ix_1++)
            {
                uint ccx_1 = p.x + uint(ix_1);
                uint ccy_1 = p.y + uint(iy_1);
                uint ccz_1 = p.z + uint(iz_1);
                uint list_index = (ccx_1 + (ccy_1 * 256u)) + ((ccz_1 * 256u) * 256u);
                uint param_5 = list_index;
                uint count = rt_link_list_get_count(param_5);
                total += count;
            }
        }
    }
    uint _380 = atomicAdd(in_faces_list_data.buffer_counter, total + utilized);
    uint allocation = _380;
    uint occupied_cells = 0u;
    for (int iz_2 = 0; iz_2 < 2; iz_2++)
    {
        for (int iy_2 = 0; iy_2 < 2; iy_2++)
        {
            for (int ix_2 = 0; ix_2 < 2; ix_2++)
            {
                uint ccx_2 = p.x + uint(ix_2);
                uint ccy_2 = p.y + uint(iy_2);
                uint ccz_2 = p.z + uint(iz_2);
                uint list_index_1 = (ccx_2 + (ccy_2 * 256u)) + ((ccz_2 * 256u) * 256u);
                uint param_6 = list_index_1;
                uint count_1 = rt_link_list_get_count(param_6);
                if (count_1 > 0u)
                {
                    _47.in_faces_list_tails_data[list_index_1] = allocation;
                    in_faces_list_data.node_buffer[allocation] = 0u;
                    allocation += (count_1 + 1u);
                    occupied_cells++;
                }
            }
        }
    }
    if (true)
    {
        uint _463 = atomicAdd(in_faces_list_data.occupied_cell_counter, occupied_cells);
    }
    if (occupied_cells > 0u)
    {
        ivec3 param_8;
        uint param_9;
        do
        {
            ivec3 param_7 = ivec3(int(p.x), int(p.y), int(p.z)) >> ivec3(2);
            rt_pack_grid_marker_to_uint_img(param_7, param_8, param_9);
            ivec3 pos_packed_1 = param_8;
            uint bit_1 = param_9;
            uint _497 = imageAtomicOr(imGridMarkers2, pos_packed_1, 1u << bit_1);
        } while (false);
    }
}

 