#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleEmitterPrimitive_Params
{
    mat4 transform;
    vec4 particle_color;
    vec3 primitive_size;
    int perimeter_only;
    int primitive_type;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    int pending;
};

struct ParticleLifecycleParams
{
    float time_step;
    float life_time_step;
    float max_lifetime;
    uint reset;
    uint capacity;
    uint has_previous;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ModifierFactorFromParticleProperty_Params
{
    uint property;
    uint modifier_function;
    float property_scale;
    int _pad2;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct ParticleModifierAttractor_Params
{
    vec3 position;
    float radius;
    float velocity;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct ModifierFactorCurveTransfer_Params
{
    int curve_idx;
    float input_range_min;
    float input_range_max;
    float amplitude;
    float base;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct VM10Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 velocity;
    float time_step;
};

struct VM15Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 velocity;
    float time_step;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _444;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _475;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _498;

layout(set = 0, binding = 7, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1255;

layout(set = 0, binding = 8, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _2137;

layout(set = 0, binding = 4, std430) buffer VM0
{
    layout(row_major) ParticleEmitterPrimitive_Params VM0_params;
} _2209;

layout(set = 0, binding = 9, std140) uniform VM1
{
    ModifierFactorFromParticleProperty_Params VM1_params;
} _2246;

layout(set = 0, binding = 10, std140) uniform VM2
{
    ModifierFactorMulAdd_Params VM2_params;
} _2261;

layout(set = 0, binding = 11, std140) uniform VM3
{
    ModifierFactorClamp_Params VM3_params;
} _2274;

layout(set = 0, binding = 12, std140) uniform VM4
{
    ParticleModifierCurl_Params VM4_params;
} _2293;

layout(set = 0, binding = 13, std140) uniform VM5
{
    layout(row_major) ModifierFactorNoise_Params VM5_params;
} _2323;

layout(set = 0, binding = 14, std140) uniform VM6
{
    ParticleModifierCurl_Params VM6_params;
} _2343;

layout(set = 0, binding = 5, std430) buffer VM7
{
    ParticleModifierAttractor_Params VM7_params;
} _2369;

layout(set = 0, binding = 15, std140) uniform VM8
{
    ModifierFactorClamp_Params VM8_params;
} _2398;

layout(set = 0, binding = 16, std140) uniform VM9
{
    layout(row_major) ModifierFactorNoise_Params VM9_params;
} _2409;

layout(set = 0, binding = 17, std140) uniform VM10
{
    VM10Params VM10_params;
} _2424;

layout(set = 0, binding = 18, std140) uniform VM11
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM11_params;
} _2452;

layout(set = 0, binding = 6, std430) buffer VM12
{
    ParticleModifierAttractor_Params VM12_params;
} _2472;

layout(set = 0, binding = 19, std140) uniform VM13
{
    ModifierFactorFromParticleProperty_Params VM13_params;
} _2500;

layout(set = 0, binding = 20, std140) uniform VM14
{
    ModifierFactorCurveTransfer_Params VM14_params;
} _2514;

layout(set = 0, binding = 21, std140) uniform VM15
{
    VM15Params VM15_params;
} _2528;

layout(set = 0, binding = 22) uniform sampler2D s_Curves;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_498.prt_prev_positions[(id * 3u) + 0u], _498.prt_prev_positions[(id * 3u) + 1u], _498.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _450;
    _450.life_time = _444.prt_states[id].life_time;
    _450.life_span = _444.prt_states[id].life_span;
    _450.generation_id = _444.prt_states[id].generation_id;
    _450.color = _444.prt_states[id].color;
    ParticleState _449 = _450;
    return _449;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _457;
    _457.life_time = state.life_time;
    _457.life_span = state.life_span;
    _457.generation_id = state.generation_id;
    _457.color = state.color;
    _444.prt_states[id] = _457;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

float particle_emitter_primitive_rand(float n)
{
    return fract(sin(n) * 43758.546875);
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    float generation_id = state.generation_id + 1.0;
    if (generation_id > 65536.0)
    {
        generation_id = 0.0;
    }
    state.generation_id = generation_id;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _538 = color_convert_rgb_float3_uint(param);
    uint v = _538;
    state.color = v;
}

void particle_emitter_primitive_emit(ParticleEmitterPrimitive_Params emitter_params, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    float fid = float(id);
    float param = fid * 5.131999969482421875;
    float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * particle_emitter_primitive_rand(param)));
    ParticleState param_1 = p.state;
    float param_2 = lifetime;
    prt_spawn(param_1, param_2);
    p.state = param_1;
    float param_3 = fid * 0.0130000002682209014892578125;
    float param_4 = (fid * 0.112999998033046722412109375) + 132.1410064697265625;
    float param_5 = (fid * 0.3129999935626983642578125) - 43.120998382568359375;
    vec3 pos = (vec3(particle_emitter_primitive_rand(param_3), particle_emitter_primitive_rand(param_4), particle_emitter_primitive_rand(param_5)) * 2.0) - vec3(1.0);
    if (emitter_params.primitive_type == 0)
    {
        float l = length(pos);
        if (l > 1.0)
        {
            pos /= vec3(l);
        }
        pos *= emitter_params.primitive_size;
    }
    else
    {
        if (emitter_params.primitive_type == 1)
        {
            pos *= emitter_params.primitive_size;
        }
    }
    vec3 param_6 = pos;
    mat4 param_7 = emitter_params.transform;
    vec3 _992 = vector_transform_by_mat43(param_6, param_7);
    pos = _992;
    p.pos = pos;
    ParticleState param_8 = p.state;
    vec3 param_9 = emitter_params.particle_color.xyz;
    prt_set_color(param_8, param_9);
    p.state = param_8;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_from_particle_property(ModifierFactorFromParticleProperty_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    uint id = modifier_factor.id;
    uint param = id;
    ParticleState state = prt_get_state(param);
    ParticleState param_1 = state;
    if (prt_is_alive(param_1) == false)
    {
        return;
    }
    float v = 0.0;
    if (modifier_params.property == 0u)
    {
        v = state.life_time;
    }
    else
    {
        if (modifier_params.property == 1u)
        {
            v = max(0.0, state.life_span - state.life_time);
        }
        else
        {
            if (modifier_params.property == 2u)
            {
                v = state.generation_id;
            }
        }
    }
    v *= modifier_params.property_scale;
    ModifierFactor param_2 = modifier_factor;
    uint param_3 = modifier_params.modifier_function;
    float param_4 = v;
    modifier_process_modifier_factor(param_2, param_3, param_4);
    modifier_factor = param_2;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

vec3 pm_curl_snoiseVec3(vec3 x)
{
    vec3 param = vec3(x);
    float s = snoise(param);
    vec3 param_1 = vec3(x.y - 19.1000003814697265625, x.z + 33.40000152587890625, x.x + 47.200000762939453125);
    float s1 = snoise(param_1);
    vec3 param_2 = vec3(x.z + 74.1999969482421875, x.x - 124.5, x.y + 99.40000152587890625);
    float s2 = snoise(param_2);
    vec3 c = vec3(s, s1, s2);
    return c;
}

vec3 pm_curl_curlNoise(vec3 p, out vec3 gradient, out float out_scale)
{
    vec3 dx = vec3(0.100000001490116119384765625, 0.0, 0.0);
    vec3 dy = vec3(0.0, 0.100000001490116119384765625, 0.0);
    vec3 dz = vec3(0.0, 0.0, 0.100000001490116119384765625);
    vec3 param = p - dx;
    vec3 p_x0 = pm_curl_snoiseVec3(param);
    vec3 param_1 = p + dx;
    vec3 p_x1 = pm_curl_snoiseVec3(param_1);
    vec3 param_2 = p - dy;
    vec3 p_y0 = pm_curl_snoiseVec3(param_2);
    vec3 param_3 = p + dy;
    vec3 p_y1 = pm_curl_snoiseVec3(param_3);
    vec3 param_4 = p - dz;
    vec3 p_z0 = pm_curl_snoiseVec3(param_4);
    vec3 param_5 = p + dz;
    vec3 p_z1 = pm_curl_snoiseVec3(param_5);
    float x = ((p_y1.z - p_y0.z) - p_z1.y) + p_z0.y;
    float y = ((p_z1.x - p_z0.x) - p_x1.z) + p_x0.z;
    float z = ((p_x1.y - p_x0.y) - p_y1.x) + p_y0.x;
    gradient = vec3(p_x0.x, p_y0.y, p_z0.z) * 3.1400001049041748046875;
    out_scale = p_x0.x;
    return normalize(vec3(x, y, z));
}

void particle_modifier_curl(ParticleModifierCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 param = (p.pos * modifier_params.noise_scale) + (vec3(_1255.globals.time, _1255.globals.time * 0.3014999926090240478515625, (-_1255.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_1;
    float param_2;
    vec3 _1277 = pm_curl_curlNoise(param, param_1, param_2);
    vec3 gradient = param_1;
    float out_scale = param_2;
    p.pos += (((_1277 * modifier_params.noise_strength) * modifier_factor.factor) * lifecycle_params.time_step);
}

vec4 _permute(vec4 x)
{
    vec4 xm = mod(x, vec4(289.0));
    return mod(((xm * 34.0) + vec4(10.0)) * xm, vec4(289.0));
}

float psrdnoise(vec3 x, vec3 period, float alpha, out vec3 gradient)
{
    vec3 uvw = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * x;
    vec3 i0 = floor(uvw);
    vec3 f0 = fract(uvw);
    vec3 g_ = step(f0.xyx, f0.yzz);
    vec3 l_ = vec3(1.0) - g_;
    vec3 g = vec3(l_.z, g_.xy);
    vec3 l = vec3(l_.xy, g_.z);
    vec3 o1 = min(g, l);
    vec3 o2 = max(g, l);
    vec3 i1 = i0 + o1;
    vec3 i2 = i0 + o2;
    vec3 i3 = i0 + vec3(1.0);
    vec3 v0 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i0;
    vec3 v1 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i1;
    vec3 v2 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i2;
    vec3 v3 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i3;
    vec3 x0 = x - v0;
    vec3 x1 = x - v1;
    vec3 x2 = x - v2;
    vec3 x3 = x - v3;
    if (any(greaterThan(period, vec3(0.0))))
    {
        vec4 vx = vec4(v0.x, v1.x, v2.x, v3.x);
        vec4 vy = vec4(v0.y, v1.y, v2.y, v3.y);
        vec4 vz = vec4(v0.z, v1.z, v2.z, v3.z);
        if (period.x > 0.0)
        {
            vx = mod(vx, vec4(period.x));
        }
        if (period.y > 0.0)
        {
            vy = mod(vy, vec4(period.y));
        }
        if (period.z > 0.0)
        {
            vz = mod(vz, vec4(period.z));
        }
        i0 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.x, vy.x, vz.x);
        i1 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.y, vy.y, vz.y);
        i2 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.z, vy.z, vz.z);
        i3 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.w, vy.w, vz.w);
        i0 = floor(i0 + vec3(0.5));
        i1 = floor(i1 + vec3(0.5));
        i2 = floor(i2 + vec3(0.5));
        i3 = floor(i3 + vec3(0.5));
    }
    vec4 param = vec4(i0.z, i1.z, i2.z, i3.z);
    vec4 param_1 = _permute(param) + vec4(i0.y, i1.y, i2.y, i3.y);
    vec4 param_2 = _permute(param_1) + vec4(i0.x, i1.x, i2.x, i3.x);
    vec4 hash = _permute(param_2);
    vec4 theta = hash * 3.883222103118896484375;
    vec4 sz = (hash * (-0.006920414976775646209716796875)) + vec4(0.996539771556854248046875);
    vec4 psi = hash * 0.10870562493801116943359375;
    vec4 Ct = cos(theta);
    vec4 St = sin(theta);
    vec4 sz_prime = sqrt(vec4(1.0) - (sz * sz));
    vec4 gx;
    vec4 gy;
    vec4 gz;
    if (alpha != 0.0)
    {
        vec4 Sp = sin(psi);
        vec4 Cp = cos(psi);
        vec4 px = Ct * sz_prime;
        vec4 py = St * sz_prime;
        vec4 pz = sz;
        vec4 Ctp = (St * Sp) - (Ct * Cp);
        vec4 qx = mix(Ctp * St, Sp, sz);
        vec4 qy = mix((-Ctp) * Ct, Cp, sz);
        vec4 qz = -((py * Cp) + (px * Sp));
        vec4 Sa = vec4(sin(alpha));
        vec4 Ca = vec4(cos(alpha));
        gx = (Ca * px) + (Sa * qx);
        gy = (Ca * py) + (Sa * qy);
        gz = (Ca * pz) + (Sa * qz);
    }
    else
    {
        gx = Ct * sz_prime;
        gy = St * sz_prime;
        gz = sz;
    }
    vec3 g0 = vec3(gx.x, gy.x, gz.x);
    vec3 g1 = vec3(gx.y, gy.y, gz.y);
    vec3 g2 = vec3(gx.z, gy.z, gz.z);
    vec3 g3 = vec3(gx.w, gy.w, gz.w);
    vec4 w = vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3));
    w = max(w, vec4(0.0));
    vec4 w2 = w * w;
    vec4 w3 = w2 * w;
    vec4 gdotx = vec4(dot(g0, x0), dot(g1, x1), dot(g2, x2), dot(g3, x3));
    float n = dot(w3, gdotx);
    vec4 dw = (w2 * (-6.0)) * gdotx;
    vec3 dn0 = (g0 * w3.x) + (x0 * dw.x);
    vec3 dn1 = (g1 * w3.y) + (x1 * dw.y);
    vec3 dn2 = (g2 * w3.z) + (x2 * dw.z);
    vec3 dn3 = (g3 * w3.w) + (x3 * dw.w);
    gradient = (((dn0 + dn1) + dn2) + dn3) * 39.5;
    return 39.5 * n;
}

float modifier_factor_noise_snoise_simplex2(vec3 v)
{
    vec3 param = v;
    vec3 param_1 = vec3(0.0);
    float param_2 = 0.0;
    vec3 param_3;
    float _1815 = psrdnoise(param, param_1, param_2, param_3);
    vec3 gradient = param_3;
    float n = _1815;
    return n;
}

void modifier_factor_noise_simplex2(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1882 = vector_transform_by_mat43(param, param_1);
        coords = _1882;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1889 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1889;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = modifier_factor_noise_snoise_simplex2(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _424 = hash(param);
    uint param_1 = _424;
    float _426 = floatConstruct(param_1);
    return _426;
}

void particle_modifier_attractor(ParticleModifierAttractor_Params modifier_params, ModifierFactor modifier_factor, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    vec3 pos = p.pos;
    vec3 dir = normalize(modifier_params.position - pos);
    vec3 up = vec3(0.0, 1.0, 0.0);
    float param = float(id) * 0.3172299861907958984375;
    vec3 right = (cross(dir, up) * modifier_params.radius) * (random(param) - 0.5);
    dir = normalize((modifier_params.position + right) - pos);
    pos += (((dir * lifecycle_params.time_step) * modifier_params.velocity) * modifier_factor.factor);
    p.pos = pos;
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1833 = vector_transform_by_mat43(param, param_1);
        coords = _1833;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1840 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1840;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        vec3 _1996 = vector_transform_by_mat43(param, param_1);
        coords = _1996;
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            vec3 _2007 = vector_transform_by_mat43(param_2, param_3);
            coords = _2007;
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _2017 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _2017;
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

void modifier_factor_curve_transfer(ModifierFactorCurveTransfer_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v - modifier_params.input_range_min) / (modifier_params.input_range_max - modifier_params.input_range_min);
    v = clamp(v, 0.0, 1.0);
    int param = modifier_params.curve_idx;
    float param_1 = v;
    v = curve_sample(param, param_1);
    v = (v * modifier_params.amplitude) + modifier_params.base;
    modifier_factor.factor = v;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_position(uint id, vec3 p)
{
    _475.prt_positions[(id * 3u) + 0u] = p.x;
    _475.prt_positions[(id * 3u) + 1u] = p.y;
    _475.prt_positions[(id * 3u) + 2u] = p.z;
}

void prt_set_prev_position(uint id, vec3 p)
{
    _498.prt_prev_positions[(id * 3u) + 0u] = p.x;
    _498.prt_prev_positions[(id * 3u) + 1u] = p.y;
    _498.prt_prev_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    float prev_generation_id = p.state.generation_id;
    if (_2137.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    if (id >= _2137.lifecycle_params.capacity)
    {
        ParticleState param_3 = p.state;
        prt_kill(param_3);
        p.state = param_3;
        uint param_4 = id;
        ParticleState param_5 = p.state;
        prt_set_state(param_4, param_5);
        return;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    ParticleState param_6 = p.state;
    vec3 _2182;
    if (prt_is_alive(param_6))
    {
        _2182 = p.pos;
    }
    else
    {
        _2182 = vec3(0.0);
    }
    modifier_factor.position = _2182;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_7 = p.state;
    if (!prt_is_alive(param_7))
    {
        int _2213 = atomicAdd(_2209.VM0_params.pending, -1);
        int pending = _2213;
        if (pending > 0)
        {
            ParticleEmitterPrimitive_Params _2222;
            _2222.transform = _2209.VM0_params.transform;
            _2222.particle_color = _2209.VM0_params.particle_color;
            _2222.primitive_size = _2209.VM0_params.primitive_size;
            _2222.perimeter_only = _2209.VM0_params.perimeter_only;
            _2222.primitive_type = _2209.VM0_params.primitive_type;
            _2222.particle_lifetime = _2209.VM0_params.particle_lifetime;
            _2222.particle_lifetime_randomness = _2209.VM0_params.particle_lifetime_randomness;
            _2222.rate = _2209.VM0_params.rate;
            _2222.seed = _2209.VM0_params.seed;
            _2222.pending = _2209.VM0_params.pending;
            ParticleEmitterPrimitive_Params param_8 = _2222;
            ParticleLifecycleParams _2227;
            _2227.time_step = _2137.lifecycle_params.time_step;
            _2227.life_time_step = _2137.lifecycle_params.life_time_step;
            _2227.max_lifetime = _2137.lifecycle_params.max_lifetime;
            _2227.reset = _2137.lifecycle_params.reset;
            _2227.capacity = _2137.lifecycle_params.capacity;
            _2227.has_previous = _2137.lifecycle_params.has_previous;
            ParticleLifecycleParams param_9 = _2227;
            Particle param_10 = p;
            uint param_11 = id;
            particle_emitter_primitive_emit(param_8, param_9, param_10, param_11);
            p = param_10;
        }
    }
    ParticleState param_12 = p.state;
    if (prt_is_alive(param_12))
    {
        modifier_factor.position = p.pos;
    }
    ModifierFactorFromParticleProperty_Params _2251;
    _2251.property = _2246.VM1_params.property;
    _2251.modifier_function = _2246.VM1_params.modifier_function;
    _2251.property_scale = _2246.VM1_params.property_scale;
    _2251._pad2 = _2246.VM1_params._pad2;
    ModifierFactorFromParticleProperty_Params param_13 = _2251;
    ModifierFactor param_14 = modifier_factor;
    CoordinateSystemTrasforms param_15 = cs_transforms;
    modifier_factor_from_particle_property(param_13, param_14, param_15);
    modifier_factor = param_14;
    ModifierFactorMulAdd_Params _2266;
    _2266.multiply_value = _2261.VM2_params.multiply_value;
    _2266.add_value = _2261.VM2_params.add_value;
    ModifierFactorMulAdd_Params param_16 = _2266;
    ModifierFactor param_17 = modifier_factor;
    modifier_factor_mul_add(param_16, param_17);
    modifier_factor = param_17;
    ModifierFactorClamp_Params _2279;
    _2279.clamp_min = _2274.VM3_params.clamp_min;
    _2279.clamp_max = _2274.VM3_params.clamp_max;
    _2279.clamp_min_enable = _2274.VM3_params.clamp_min_enable;
    _2279.clamp_max_enable = _2274.VM3_params.clamp_max_enable;
    ModifierFactorClamp_Params param_18 = _2279;
    ModifierFactor param_19 = modifier_factor;
    modifier_factor_clamp(param_18, param_19);
    modifier_factor = param_19;
    ParticleState param_20 = p.state;
    if (prt_is_alive(param_20))
    {
        ParticleModifierCurl_Params _2298;
        _2298.position = _2293.VM4_params.position;
        _2298.falloff_mode = _2293.VM4_params.falloff_mode;
        _2298.radius = _2293.VM4_params.radius;
        _2298.falloff_inverse = _2293.VM4_params.falloff_inverse;
        _2298.noise_strength = _2293.VM4_params.noise_strength;
        _2298.noise_speed = _2293.VM4_params.noise_speed;
        _2298.noise_scale = _2293.VM4_params.noise_scale;
        ParticleModifierCurl_Params param_21 = _2298;
        ParticleLifecycleParams _2302;
        _2302.time_step = _2137.lifecycle_params.time_step;
        _2302.life_time_step = _2137.lifecycle_params.life_time_step;
        _2302.max_lifetime = _2137.lifecycle_params.max_lifetime;
        _2302.reset = _2137.lifecycle_params.reset;
        _2302.capacity = _2137.lifecycle_params.capacity;
        _2302.has_previous = _2137.lifecycle_params.has_previous;
        ParticleLifecycleParams param_22 = _2302;
        ModifierFactor param_23 = modifier_factor;
        Particle param_24 = p;
        uint param_25 = id;
        particle_modifier_curl(param_21, param_22, param_23, param_24, param_25);
        p = param_24;
    }
    ParticleState param_26 = p.state;
    if (prt_is_alive(param_26))
    {
        modifier_factor.position = p.pos;
    }
    ModifierFactorNoise_Params _2328;
    _2328.transform_local_to_gizmo = _2323.VM5_params.transform_local_to_gizmo;
    _2328.noise_domain_scale = _2323.VM5_params.noise_domain_scale;
    _2328.modifier_function = _2323.VM5_params.modifier_function;
    _2328.noise_domain_offset = _2323.VM5_params.noise_domain_offset;
    _2328.noise_value_scale = _2323.VM5_params.noise_value_scale;
    _2328.noise_value_offset = _2323.VM5_params.noise_value_offset;
    _2328.influence_scope = _2323.VM5_params.influence_scope;
    _2328._pad0 = _2323.VM5_params._pad0;
    _2328._pad1 = _2323.VM5_params._pad1;
    ModifierFactorNoise_Params param_27 = _2328;
    ModifierFactor param_28 = modifier_factor;
    CoordinateSystemTrasforms param_29 = cs_transforms;
    modifier_factor_noise_simplex2(param_27, param_28, param_29);
    modifier_factor = param_28;
    ParticleState param_30 = p.state;
    if (prt_is_alive(param_30))
    {
        ParticleModifierCurl_Params _2347;
        _2347.position = _2343.VM6_params.position;
        _2347.falloff_mode = _2343.VM6_params.falloff_mode;
        _2347.radius = _2343.VM6_params.radius;
        _2347.falloff_inverse = _2343.VM6_params.falloff_inverse;
        _2347.noise_strength = _2343.VM6_params.noise_strength;
        _2347.noise_speed = _2343.VM6_params.noise_speed;
        _2347.noise_scale = _2343.VM6_params.noise_scale;
        ParticleModifierCurl_Params param_31 = _2347;
        ParticleLifecycleParams _2351;
        _2351.time_step = _2137.lifecycle_params.time_step;
        _2351.life_time_step = _2137.lifecycle_params.life_time_step;
        _2351.max_lifetime = _2137.lifecycle_params.max_lifetime;
        _2351.reset = _2137.lifecycle_params.reset;
        _2351.capacity = _2137.lifecycle_params.capacity;
        _2351.has_previous = _2137.lifecycle_params.has_previous;
        ParticleLifecycleParams param_32 = _2351;
        ModifierFactor param_33 = modifier_factor;
        Particle param_34 = p;
        uint param_35 = id;
        particle_modifier_curl(param_31, param_32, param_33, param_34, param_35);
        p = param_34;
    }
    ParticleState param_36 = p.state;
    if (prt_is_alive(param_36))
    {
        ParticleModifierAttractor_Params _2374;
        _2374.position = _2369.VM7_params.position;
        _2374.radius = _2369.VM7_params.radius;
        _2374.velocity = _2369.VM7_params.velocity;
        ParticleModifierAttractor_Params param_37 = _2374;
        ModifierFactor param_38 = modifier_factor;
        ParticleLifecycleParams _2380;
        _2380.time_step = _2137.lifecycle_params.time_step;
        _2380.life_time_step = _2137.lifecycle_params.life_time_step;
        _2380.max_lifetime = _2137.lifecycle_params.max_lifetime;
        _2380.reset = _2137.lifecycle_params.reset;
        _2380.capacity = _2137.lifecycle_params.capacity;
        _2380.has_previous = _2137.lifecycle_params.has_previous;
        ParticleLifecycleParams param_39 = _2380;
        Particle param_40 = p;
        uint param_41 = id;
        particle_modifier_attractor(param_37, param_38, param_39, param_40, param_41);
        p = param_40;
    }
    ParticleState param_42 = p.state;
    if (prt_is_alive(param_42))
    {
        modifier_factor.position = p.pos;
    }
    ModifierFactorClamp_Params _2402;
    _2402.clamp_min = _2398.VM8_params.clamp_min;
    _2402.clamp_max = _2398.VM8_params.clamp_max;
    _2402.clamp_min_enable = _2398.VM8_params.clamp_min_enable;
    _2402.clamp_max_enable = _2398.VM8_params.clamp_max_enable;
    ModifierFactorClamp_Params param_43 = _2402;
    ModifierFactor param_44 = modifier_factor;
    modifier_factor_clamp(param_43, param_44);
    modifier_factor = param_44;
    ModifierFactorNoise_Params _2413;
    _2413.transform_local_to_gizmo = _2409.VM9_params.transform_local_to_gizmo;
    _2413.noise_domain_scale = _2409.VM9_params.noise_domain_scale;
    _2413.modifier_function = _2409.VM9_params.modifier_function;
    _2413.noise_domain_offset = _2409.VM9_params.noise_domain_offset;
    _2413.noise_value_scale = _2409.VM9_params.noise_value_scale;
    _2413.noise_value_offset = _2409.VM9_params.noise_value_offset;
    _2413.influence_scope = _2409.VM9_params.influence_scope;
    _2413._pad0 = _2409.VM9_params._pad0;
    _2413._pad1 = _2409.VM9_params._pad1;
    ModifierFactorNoise_Params param_45 = _2413;
    ModifierFactor param_46 = modifier_factor;
    CoordinateSystemTrasforms param_47 = cs_transforms;
    modifier_factor_noise_default(param_45, param_46, param_47);
    modifier_factor = param_46;
    vec3 modifier_position = _2424.VM10_params.position;
    p.pos += ((_2424.VM10_params.velocity * _2137.lifecycle_params.time_step) * modifier_factor.factor);
    ParticleState param_48 = p.state;
    if (prt_is_alive(param_48))
    {
        modifier_factor.position = p.pos;
    }
    ModifierFactorDistanceRadial_Params _2457;
    _2457.transform_local_to_gizmo = _2452.VM11_params.transform_local_to_gizmo;
    _2457.falloff_curve_idx = _2452.VM11_params.falloff_curve_idx;
    _2457.falloff_inverse = _2452.VM11_params.falloff_inverse;
    _2457.domain_repeat_x = _2452.VM11_params.domain_repeat_x;
    _2457.domain_repeat_y = _2452.VM11_params.domain_repeat_y;
    _2457.domain_repeat_z = _2452.VM11_params.domain_repeat_z;
    _2457.influence_scope = _2452.VM11_params.influence_scope;
    _2457.modifier_function = _2452.VM11_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_49 = _2457;
    ModifierFactor param_50 = modifier_factor;
    CoordinateSystemTrasforms param_51 = cs_transforms;
    modifier_factor_distance_radial(param_49, param_50, param_51);
    modifier_factor = param_50;
    ParticleState param_52 = p.state;
    if (prt_is_alive(param_52))
    {
        ParticleModifierAttractor_Params _2476;
        _2476.position = _2472.VM12_params.position;
        _2476.radius = _2472.VM12_params.radius;
        _2476.velocity = _2472.VM12_params.velocity;
        ParticleModifierAttractor_Params param_53 = _2476;
        ModifierFactor param_54 = modifier_factor;
        ParticleLifecycleParams _2482;
        _2482.time_step = _2137.lifecycle_params.time_step;
        _2482.life_time_step = _2137.lifecycle_params.life_time_step;
        _2482.max_lifetime = _2137.lifecycle_params.max_lifetime;
        _2482.reset = _2137.lifecycle_params.reset;
        _2482.capacity = _2137.lifecycle_params.capacity;
        _2482.has_previous = _2137.lifecycle_params.has_previous;
        ParticleLifecycleParams param_55 = _2482;
        Particle param_56 = p;
        uint param_57 = id;
        particle_modifier_attractor(param_53, param_54, param_55, param_56, param_57);
        p = param_56;
    }
    ParticleState param_58 = p.state;
    if (prt_is_alive(param_58))
    {
        modifier_factor.position = p.pos;
    }
    ModifierFactorFromParticleProperty_Params _2504;
    _2504.property = _2500.VM13_params.property;
    _2504.modifier_function = _2500.VM13_params.modifier_function;
    _2504.property_scale = _2500.VM13_params.property_scale;
    _2504._pad2 = _2500.VM13_params._pad2;
    ModifierFactorFromParticleProperty_Params param_59 = _2504;
    ModifierFactor param_60 = modifier_factor;
    CoordinateSystemTrasforms param_61 = cs_transforms;
    modifier_factor_from_particle_property(param_59, param_60, param_61);
    modifier_factor = param_60;
    ModifierFactorCurveTransfer_Params _2519;
    _2519.curve_idx = _2514.VM14_params.curve_idx;
    _2519.input_range_min = _2514.VM14_params.input_range_min;
    _2519.input_range_max = _2514.VM14_params.input_range_max;
    _2519.amplitude = _2514.VM14_params.amplitude;
    _2519.base = _2514.VM14_params.base;
    ModifierFactorCurveTransfer_Params param_62 = _2519;
    ModifierFactor param_63 = modifier_factor;
    modifier_factor_curve_transfer(param_62, param_63);
    modifier_factor = param_63;
    vec3 modifier_position_1 = _2528.VM15_params.position;
    p.pos += ((_2528.VM15_params.velocity * _2137.lifecycle_params.time_step) * modifier_factor.factor);
    ParticleState param_64 = p.state;
    float param_65 = _2137.lifecycle_params.life_time_step;
    float param_66 = _2137.lifecycle_params.max_lifetime;
    prt_advance_life(param_64, param_65, param_66);
    p.state = param_64;
    uint param_67 = id;
    ParticleState param_68 = p.state;
    prt_set_state(param_67, param_68);
    uint param_69 = id;
    vec3 param_70 = p.pos;
    prt_set_position(param_69, param_70);
    bool _2569 = _2137.lifecycle_params.has_previous != 0u;
    bool _2576;
    if (_2569)
    {
        _2576 = p.state.generation_id != prev_generation_id;
    }
    else
    {
        _2576 = _2569;
    }
    if (_2576)
    {
        uint param_71 = id;
        vec3 param_72 = p.pos;
        prt_set_prev_position(param_71, param_72);
    }
}

 