#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryInstantiateParams
{
    int surfaces_num;
    int surface_idx;
    int _pad0;
    int _pad1;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

layout(set = 0, binding = 1, std430) buffer GPUOnlyMemoryAllocatorInfoBuffer
{
    uint offset;
    uint num_allocations;
    uint _pad0;
    uint _pad1;
} gpu_allocator_data;

layout(set = 0, binding = 2, std430) buffer OutGeometryInformationBuffer
{
    GeometryInformation output_geometry_information;
} _161;

layout(set = 0, binding = 3, scalar) uniform InGeometryInformationBuffer
{
    GeometryInformation input_geometry_information;
} _164;

layout(set = 0, binding = 4, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _210;

GeometryInformation GPUMemoryAllocateForGeometry(inout GeometryInformation geometry_information)
{
    uint id = gl_GlobalInvocationID.x;
    uint allocation_size = 0u;
    uint faces_num = 0u;
    for (int i = 0; uint(i) < geometry_information.surfaces_num; i++)
    {
        faces_num += geometry_information.faces_num_per_surface[i];
    }
    uint _67 = atomicAdd(gpu_allocator_data.offset, (faces_num * 3u) * 4u);
    uint idx_buffer_offset = _67;
    geometry_information.idx_buffer_offset = idx_buffer_offset / 4u;
    allocation_size += ((faces_num * 3u) * 4u);
    for (int i_1 = 0; uint(i_1) < 8u; i_1++)
    {
        if (geometry_information.attributes[i_1].stride > 0u)
        {
            uint _102 = atomicAdd(gpu_allocator_data.offset, (geometry_information.vtx_num * geometry_information.attributes[i_1].stride) * 4u);
            uint attribute_buffer_offset = _102;
            geometry_information.attributes[i_1].offset = attribute_buffer_offset / 4u;
            allocation_size += ((geometry_information.vtx_num * geometry_information.attributes[i_1].stride) * 4u);
        }
    }
    geometry_information.vtx_num = 0u;
    for (int i_2 = 0; uint(i_2) < geometry_information.surfaces_num; i_2++)
    {
        geometry_information.faces_num_per_surface[i_2] = 0u;
    }
    geometry_information.gpu_memory_allocation_size = allocation_size;
    geometry_information.gpu_memory_allocation_size_total = gpu_allocator_data.offset;
    geometry_information.is_gpu_allocated = 1u;
    uint _144 = atomicAdd(gpu_allocator_data.num_allocations, 1u);
    return geometry_information;
}

void main()
{
    uint thread_idx = gl_GlobalInvocationID.x;
    if (thread_idx == 0u)
    {
        _161.output_geometry_information.surfaces_num = _164.input_geometry_information.surfaces_num;
        _161.output_geometry_information.builtin_attribute_mask = _164.input_geometry_information.builtin_attribute_mask;
        for (int i = 0; uint(i) < 8u; i++)
        {
            _161.output_geometry_information.attributes[i].stride = _164.input_geometry_information.attributes[i].stride;
            _161.output_geometry_information.attributes[i].offset = 4294967295u;
        }
        for (int i_1 = 0; uint(i_1) < _164.input_geometry_information.surfaces_num; i_1++)
        {
            _161.output_geometry_information.faces_num_per_surface[i_1] = _164.input_geometry_information.faces_num_per_surface[i_1] * uint(_210.instance_params.instance_count);
        }
        uint vtx_num = _164.input_geometry_information.vtx_num * uint(_210.instance_params.instance_count);
        _161.output_geometry_information.vtx_num = vtx_num;
        GeometryInformation _233;
        _233.vtx_num = _161.output_geometry_information.vtx_num;
        _233.surfaces_num = _161.output_geometry_information.surfaces_num;
        _233.builtin_attribute_mask = _161.output_geometry_information.builtin_attribute_mask;
        _233.flipbook_cards_num = _161.output_geometry_information.flipbook_cards_num;
        _233.idx_buffer_offset = _161.output_geometry_information.idx_buffer_offset;
        _233.is_gpu_allocated = _161.output_geometry_information.is_gpu_allocated;
        _233.gpu_memory_allocation_size = _161.output_geometry_information.gpu_memory_allocation_size;
        _233.gpu_memory_allocation_size_total = _161.output_geometry_information.gpu_memory_allocation_size_total;
        _233.aux_tracking_0 = _161.output_geometry_information.aux_tracking_0;
        _233.aux_tracking_1 = _161.output_geometry_information.aux_tracking_1;
        _233.aux_tracking_2 = _161.output_geometry_information.aux_tracking_2;
        _233.aux_tracking_3 = _161.output_geometry_information.aux_tracking_3;
        _233.attributes[0].offset = _161.output_geometry_information.attributes[0].offset;
        _233.attributes[0].stride = _161.output_geometry_information.attributes[0].stride;
        _233.attributes[0]._pad0 = _161.output_geometry_information.attributes[0]._pad0;
        _233.attributes[0]._pad1 = _161.output_geometry_information.attributes[0]._pad1;
        _233.attributes[1].offset = _161.output_geometry_information.attributes[1].offset;
        _233.attributes[1].stride = _161.output_geometry_information.attributes[1].stride;
        _233.attributes[1]._pad0 = _161.output_geometry_information.attributes[1]._pad0;
        _233.attributes[1]._pad1 = _161.output_geometry_information.attributes[1]._pad1;
        _233.attributes[2].offset = _161.output_geometry_information.attributes[2].offset;
        _233.attributes[2].stride = _161.output_geometry_information.attributes[2].stride;
        _233.attributes[2]._pad0 = _161.output_geometry_information.attributes[2]._pad0;
        _233.attributes[2]._pad1 = _161.output_geometry_information.attributes[2]._pad1;
        _233.attributes[3].offset = _161.output_geometry_information.attributes[3].offset;
        _233.attributes[3].stride = _161.output_geometry_information.attributes[3].stride;
        _233.attributes[3]._pad0 = _161.output_geometry_information.attributes[3]._pad0;
        _233.attributes[3]._pad1 = _161.output_geometry_information.attributes[3]._pad1;
        _233.attributes[4].offset = _161.output_geometry_information.attributes[4].offset;
        _233.attributes[4].stride = _161.output_geometry_information.attributes[4].stride;
        _233.attributes[4]._pad0 = _161.output_geometry_information.attributes[4]._pad0;
        _233.attributes[4]._pad1 = _161.output_geometry_information.attributes[4]._pad1;
        _233.attributes[5].offset = _161.output_geometry_information.attributes[5].offset;
        _233.attributes[5].stride = _161.output_geometry_information.attributes[5].stride;
        _233.attributes[5]._pad0 = _161.output_geometry_information.attributes[5]._pad0;
        _233.attributes[5]._pad1 = _161.output_geometry_information.attributes[5]._pad1;
        _233.attributes[6].offset = _161.output_geometry_information.attributes[6].offset;
        _233.attributes[6].stride = _161.output_geometry_information.attributes[6].stride;
        _233.attributes[6]._pad0 = _161.output_geometry_information.attributes[6]._pad0;
        _233.attributes[6]._pad1 = _161.output_geometry_information.attributes[6]._pad1;
        _233.attributes[7].offset = _161.output_geometry_information.attributes[7].offset;
        _233.attributes[7].stride = _161.output_geometry_information.attributes[7].stride;
        _233.attributes[7]._pad0 = _161.output_geometry_information.attributes[7]._pad0;
        _233.attributes[7]._pad1 = _161.output_geometry_information.attributes[7]._pad1;
        _233.faces_num_per_surface[0] = _161.output_geometry_information.faces_num_per_surface[0];
        _233.faces_num_per_surface[1] = _161.output_geometry_information.faces_num_per_surface[1];
        _233.faces_num_per_surface[2] = _161.output_geometry_information.faces_num_per_surface[2];
        _233.faces_num_per_surface[3] = _161.output_geometry_information.faces_num_per_surface[3];
        _233.faces_num_per_surface[4] = _161.output_geometry_information.faces_num_per_surface[4];
        _233.faces_num_per_surface[5] = _161.output_geometry_information.faces_num_per_surface[5];
        _233.faces_num_per_surface[6] = _161.output_geometry_information.faces_num_per_surface[6];
        _233.faces_num_per_surface[7] = _161.output_geometry_information.faces_num_per_surface[7];
        _233.faces_num_per_surface[8] = _161.output_geometry_information.faces_num_per_surface[8];
        _233.faces_num_per_surface[9] = _161.output_geometry_information.faces_num_per_surface[9];
        _233.faces_num_per_surface[10] = _161.output_geometry_information.faces_num_per_surface[10];
        _233.faces_num_per_surface[11] = _161.output_geometry_information.faces_num_per_surface[11];
        _233.faces_num_per_surface[12] = _161.output_geometry_information.faces_num_per_surface[12];
        _233.faces_num_per_surface[13] = _161.output_geometry_information.faces_num_per_surface[13];
        _233.faces_num_per_surface[14] = _161.output_geometry_information.faces_num_per_surface[14];
        _233.faces_num_per_surface[15] = _161.output_geometry_information.faces_num_per_surface[15];
        _233.faces_num_per_surface[16] = _161.output_geometry_information.faces_num_per_surface[16];
        _233.faces_num_per_surface[17] = _161.output_geometry_information.faces_num_per_surface[17];
        _233.faces_num_per_surface[18] = _161.output_geometry_information.faces_num_per_surface[18];
        _233.faces_num_per_surface[19] = _161.output_geometry_information.faces_num_per_surface[19];
        _233.faces_num_per_surface[20] = _161.output_geometry_information.faces_num_per_surface[20];
        _233.faces_num_per_surface[21] = _161.output_geometry_information.faces_num_per_surface[21];
        _233.faces_num_per_surface[22] = _161.output_geometry_information.faces_num_per_surface[22];
        _233.faces_num_per_surface[23] = _161.output_geometry_information.faces_num_per_surface[23];
        _233.faces_num_per_surface[24] = _161.output_geometry_information.faces_num_per_surface[24];
        _233.faces_num_per_surface[25] = _161.output_geometry_information.faces_num_per_surface[25];
        _233.faces_num_per_surface[26] = _161.output_geometry_information.faces_num_per_surface[26];
        _233.faces_num_per_surface[27] = _161.output_geometry_information.faces_num_per_surface[27];
        _233.faces_num_per_surface[28] = _161.output_geometry_information.faces_num_per_surface[28];
        _233.faces_num_per_surface[29] = _161.output_geometry_information.faces_num_per_surface[29];
        _233.faces_num_per_surface[30] = _161.output_geometry_information.faces_num_per_surface[30];
        _233.faces_num_per_surface[31] = _161.output_geometry_information.faces_num_per_surface[31];
        _233.faces_num_per_surface[32] = _161.output_geometry_information.faces_num_per_surface[32];
        _233.faces_num_per_surface[33] = _161.output_geometry_information.faces_num_per_surface[33];
        _233.faces_num_per_surface[34] = _161.output_geometry_information.faces_num_per_surface[34];
        _233.faces_num_per_surface[35] = _161.output_geometry_information.faces_num_per_surface[35];
        _233.faces_num_per_surface[36] = _161.output_geometry_information.faces_num_per_surface[36];
        _233.faces_num_per_surface[37] = _161.output_geometry_information.faces_num_per_surface[37];
        _233.faces_num_per_surface[38] = _161.output_geometry_information.faces_num_per_surface[38];
        _233.faces_num_per_surface[39] = _161.output_geometry_information.faces_num_per_surface[39];
        _233.faces_num_per_surface[40] = _161.output_geometry_information.faces_num_per_surface[40];
        _233.faces_num_per_surface[41] = _161.output_geometry_information.faces_num_per_surface[41];
        _233.faces_num_per_surface[42] = _161.output_geometry_information.faces_num_per_surface[42];
        _233.faces_num_per_surface[43] = _161.output_geometry_information.faces_num_per_surface[43];
        _233.faces_num_per_surface[44] = _161.output_geometry_information.faces_num_per_surface[44];
        _233.faces_num_per_surface[45] = _161.output_geometry_information.faces_num_per_surface[45];
        _233.faces_num_per_surface[46] = _161.output_geometry_information.faces_num_per_surface[46];
        _233.faces_num_per_surface[47] = _161.output_geometry_information.faces_num_per_surface[47];
        _233.faces_num_per_surface[48] = _161.output_geometry_information.faces_num_per_surface[48];
        _233.faces_num_per_surface[49] = _161.output_geometry_information.faces_num_per_surface[49];
        _233.faces_num_per_surface[50] = _161.output_geometry_information.faces_num_per_surface[50];
        _233.faces_num_per_surface[51] = _161.output_geometry_information.faces_num_per_surface[51];
        _233.faces_num_per_surface[52] = _161.output_geometry_information.faces_num_per_surface[52];
        _233.faces_num_per_surface[53] = _161.output_geometry_information.faces_num_per_surface[53];
        _233.faces_num_per_surface[54] = _161.output_geometry_information.faces_num_per_surface[54];
        _233.faces_num_per_surface[55] = _161.output_geometry_information.faces_num_per_surface[55];
        _233.faces_num_per_surface[56] = _161.output_geometry_information.faces_num_per_surface[56];
        _233.faces_num_per_surface[57] = _161.output_geometry_information.faces_num_per_surface[57];
        _233.faces_num_per_surface[58] = _161.output_geometry_information.faces_num_per_surface[58];
        _233.faces_num_per_surface[59] = _161.output_geometry_information.faces_num_per_surface[59];
        _233.faces_num_per_surface[60] = _161.output_geometry_information.faces_num_per_surface[60];
        _233.faces_num_per_surface[61] = _161.output_geometry_information.faces_num_per_surface[61];
        _233.faces_num_per_surface[62] = _161.output_geometry_information.faces_num_per_surface[62];
        _233.faces_num_per_surface[63] = _161.output_geometry_information.faces_num_per_surface[63];
        GeometryInformation param = _233;
        GeometryInformation _234 = GPUMemoryAllocateForGeometry(param);
        GeometryInformation _236;
        _236.vtx_num = _234.vtx_num;
        _236.surfaces_num = _234.surfaces_num;
        _236.builtin_attribute_mask = _234.builtin_attribute_mask;
        _236.flipbook_cards_num = _234.flipbook_cards_num;
        _236.idx_buffer_offset = _234.idx_buffer_offset;
        _236.is_gpu_allocated = _234.is_gpu_allocated;
        _236.gpu_memory_allocation_size = _234.gpu_memory_allocation_size;
        _236.gpu_memory_allocation_size_total = _234.gpu_memory_allocation_size_total;
        _236.aux_tracking_0 = _234.aux_tracking_0;
        _236.aux_tracking_1 = _234.aux_tracking_1;
        _236.aux_tracking_2 = _234.aux_tracking_2;
        _236.aux_tracking_3 = _234.aux_tracking_3;
        _236.attributes[0].offset = _234.attributes[0].offset;
        _236.attributes[0].stride = _234.attributes[0].stride;
        _236.attributes[0]._pad0 = _234.attributes[0]._pad0;
        _236.attributes[0]._pad1 = _234.attributes[0]._pad1;
        _236.attributes[1].offset = _234.attributes[1].offset;
        _236.attributes[1].stride = _234.attributes[1].stride;
        _236.attributes[1]._pad0 = _234.attributes[1]._pad0;
        _236.attributes[1]._pad1 = _234.attributes[1]._pad1;
        _236.attributes[2].offset = _234.attributes[2].offset;
        _236.attributes[2].stride = _234.attributes[2].stride;
        _236.attributes[2]._pad0 = _234.attributes[2]._pad0;
        _236.attributes[2]._pad1 = _234.attributes[2]._pad1;
        _236.attributes[3].offset = _234.attributes[3].offset;
        _236.attributes[3].stride = _234.attributes[3].stride;
        _236.attributes[3]._pad0 = _234.attributes[3]._pad0;
        _236.attributes[3]._pad1 = _234.attributes[3]._pad1;
        _236.attributes[4].offset = _234.attributes[4].offset;
        _236.attributes[4].stride = _234.attributes[4].stride;
        _236.attributes[4]._pad0 = _234.attributes[4]._pad0;
        _236.attributes[4]._pad1 = _234.attributes[4]._pad1;
        _236.attributes[5].offset = _234.attributes[5].offset;
        _236.attributes[5].stride = _234.attributes[5].stride;
        _236.attributes[5]._pad0 = _234.attributes[5]._pad0;
        _236.attributes[5]._pad1 = _234.attributes[5]._pad1;
        _236.attributes[6].offset = _234.attributes[6].offset;
        _236.attributes[6].stride = _234.attributes[6].stride;
        _236.attributes[6]._pad0 = _234.attributes[6]._pad0;
        _236.attributes[6]._pad1 = _234.attributes[6]._pad1;
        _236.attributes[7].offset = _234.attributes[7].offset;
        _236.attributes[7].stride = _234.attributes[7].stride;
        _236.attributes[7]._pad0 = _234.attributes[7]._pad0;
        _236.attributes[7]._pad1 = _234.attributes[7]._pad1;
        _236.faces_num_per_surface[0] = _234.faces_num_per_surface[0];
        _236.faces_num_per_surface[1] = _234.faces_num_per_surface[1];
        _236.faces_num_per_surface[2] = _234.faces_num_per_surface[2];
        _236.faces_num_per_surface[3] = _234.faces_num_per_surface[3];
        _236.faces_num_per_surface[4] = _234.faces_num_per_surface[4];
        _236.faces_num_per_surface[5] = _234.faces_num_per_surface[5];
        _236.faces_num_per_surface[6] = _234.faces_num_per_surface[6];
        _236.faces_num_per_surface[7] = _234.faces_num_per_surface[7];
        _236.faces_num_per_surface[8] = _234.faces_num_per_surface[8];
        _236.faces_num_per_surface[9] = _234.faces_num_per_surface[9];
        _236.faces_num_per_surface[10] = _234.faces_num_per_surface[10];
        _236.faces_num_per_surface[11] = _234.faces_num_per_surface[11];
        _236.faces_num_per_surface[12] = _234.faces_num_per_surface[12];
        _236.faces_num_per_surface[13] = _234.faces_num_per_surface[13];
        _236.faces_num_per_surface[14] = _234.faces_num_per_surface[14];
        _236.faces_num_per_surface[15] = _234.faces_num_per_surface[15];
        _236.faces_num_per_surface[16] = _234.faces_num_per_surface[16];
        _236.faces_num_per_surface[17] = _234.faces_num_per_surface[17];
        _236.faces_num_per_surface[18] = _234.faces_num_per_surface[18];
        _236.faces_num_per_surface[19] = _234.faces_num_per_surface[19];
        _236.faces_num_per_surface[20] = _234.faces_num_per_surface[20];
        _236.faces_num_per_surface[21] = _234.faces_num_per_surface[21];
        _236.faces_num_per_surface[22] = _234.faces_num_per_surface[22];
        _236.faces_num_per_surface[23] = _234.faces_num_per_surface[23];
        _236.faces_num_per_surface[24] = _234.faces_num_per_surface[24];
        _236.faces_num_per_surface[25] = _234.faces_num_per_surface[25];
        _236.faces_num_per_surface[26] = _234.faces_num_per_surface[26];
        _236.faces_num_per_surface[27] = _234.faces_num_per_surface[27];
        _236.faces_num_per_surface[28] = _234.faces_num_per_surface[28];
        _236.faces_num_per_surface[29] = _234.faces_num_per_surface[29];
        _236.faces_num_per_surface[30] = _234.faces_num_per_surface[30];
        _236.faces_num_per_surface[31] = _234.faces_num_per_surface[31];
        _236.faces_num_per_surface[32] = _234.faces_num_per_surface[32];
        _236.faces_num_per_surface[33] = _234.faces_num_per_surface[33];
        _236.faces_num_per_surface[34] = _234.faces_num_per_surface[34];
        _236.faces_num_per_surface[35] = _234.faces_num_per_surface[35];
        _236.faces_num_per_surface[36] = _234.faces_num_per_surface[36];
        _236.faces_num_per_surface[37] = _234.faces_num_per_surface[37];
        _236.faces_num_per_surface[38] = _234.faces_num_per_surface[38];
        _236.faces_num_per_surface[39] = _234.faces_num_per_surface[39];
        _236.faces_num_per_surface[40] = _234.faces_num_per_surface[40];
        _236.faces_num_per_surface[41] = _234.faces_num_per_surface[41];
        _236.faces_num_per_surface[42] = _234.faces_num_per_surface[42];
        _236.faces_num_per_surface[43] = _234.faces_num_per_surface[43];
        _236.faces_num_per_surface[44] = _234.faces_num_per_surface[44];
        _236.faces_num_per_surface[45] = _234.faces_num_per_surface[45];
        _236.faces_num_per_surface[46] = _234.faces_num_per_surface[46];
        _236.faces_num_per_surface[47] = _234.faces_num_per_surface[47];
        _236.faces_num_per_surface[48] = _234.faces_num_per_surface[48];
        _236.faces_num_per_surface[49] = _234.faces_num_per_surface[49];
        _236.faces_num_per_surface[50] = _234.faces_num_per_surface[50];
        _236.faces_num_per_surface[51] = _234.faces_num_per_surface[51];
        _236.faces_num_per_surface[52] = _234.faces_num_per_surface[52];
        _236.faces_num_per_surface[53] = _234.faces_num_per_surface[53];
        _236.faces_num_per_surface[54] = _234.faces_num_per_surface[54];
        _236.faces_num_per_surface[55] = _234.faces_num_per_surface[55];
        _236.faces_num_per_surface[56] = _234.faces_num_per_surface[56];
        _236.faces_num_per_surface[57] = _234.faces_num_per_surface[57];
        _236.faces_num_per_surface[58] = _234.faces_num_per_surface[58];
        _236.faces_num_per_surface[59] = _234.faces_num_per_surface[59];
        _236.faces_num_per_surface[60] = _234.faces_num_per_surface[60];
        _236.faces_num_per_surface[61] = _234.faces_num_per_surface[61];
        _236.faces_num_per_surface[62] = _234.faces_num_per_surface[62];
        _236.faces_num_per_surface[63] = _234.faces_num_per_surface[63];
        _161.output_geometry_information = _236;
        _161.output_geometry_information.vtx_num = vtx_num;
        for (int i_2 = 0; uint(i_2) < _164.input_geometry_information.surfaces_num; i_2++)
        {
            _161.output_geometry_information.faces_num_per_surface[i_2] = _164.input_geometry_information.faces_num_per_surface[i_2] * uint(_210.instance_params.instance_count);
        }
    }
}

 