#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleRibbonSegmentInfo
{
    uint segments;
    uint first;
    uint previous;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct VertexModifierColorizeParams
{
    vec3 color;
    float alpha;
    int use_gradient;
    float color_blend;
    float alpha_blend;
    int color_gradient_idx;
    int mixing_mode;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct ModifierFactorFromParticleProperty_Params
{
    uint property;
    uint modifier_function;
    float property_scale;
    int _pad2;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct VertexModifierDisplaceParams
{
    vec3 displace_normal;
    float displace_normal_modifier_factor;
    vec3 displace_base;
    float displace_base_modifier_factor;
    int influence_scope;
};

struct RibbonRenderParams
{
    int max_segments;
    int base_idx_;
    int base_segment_;
    int particles_per_segment;
    float thickness;
    int lights_num;
    int material_index;
    float first_segment_time_factor;
    int render_as_strips;
    int segment_subdivisions;
    int export_ribbon_t_as_modifier_factor;
    int export_segment_t_as_modifier_factor;
};

struct ParticleRibbonState
{
    float generation_id;
    uint segment_info;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct _2325
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _748;

layout(set = 0, binding = 5, std140) uniform RibbonRenderParamsBuffer
{
    RibbonRenderParams ribbon_render_params;
} _828;

layout(set = 0, binding = 2, std430) restrict readonly buffer RibbonStatesData
{
    ParticleRibbonState states[];
} prt_states_snapshots;

layout(set = 0, binding = 3, std430) restrict readonly buffer RibbonPositionsData
{
    float position[];
} prt_position_snapshots;

layout(set = 0, binding = 6, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1469;

layout(set = 0, binding = 7, std140) uniform VM0
{
    ModifierFactorMulAdd_Params VM0_params;
} _1482;

layout(set = 0, binding = 8, std140) uniform VM1
{
    ModifierFactorClamp_Params VM1_params;
} _1495;

layout(set = 0, binding = 9, std140) uniform VM2
{
    VertexModifierColorizeParams VM2_params;
} _1508;

layout(set = 0, binding = 10, std140) uniform VM3
{
    ModifierFactorFromParticleProperty_Params VM3_params;
} _1527;

layout(set = 0, binding = 11, std140) uniform VM4
{
    ModifierFactorMulAdd_Params VM4_params;
} _1541;

layout(set = 0, binding = 12, std140) uniform VM5
{
    ModifierFactorClamp_Params VM5_params;
} _1552;

layout(set = 0, binding = 13, std140) uniform VM6
{
    layout(row_major) ModifierFactorNoise_Params VM6_params;
} _1564;

layout(set = 0, binding = 14, std140) uniform VM7
{
    VertexModifierDisplaceParams VM7_params;
} _1579;

layout(set = 0, binding = 15, std140) uniform VM8
{
    layout(row_major) ModifierFactorNoise_Params VM8_params;
} _1599;

layout(set = 0, binding = 16, std140) uniform VM9
{
    VertexModifierDisplaceParams VM9_params;
} _1612;

layout(set = 0, binding = 4, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 0, binding = 17) uniform sampler2D s_Gradients;

layout(location = 0) out uint instanceID;
layout(location = 1) out _2325 vtx_output;

ParticleRibbonSegmentInfo ribbon_decode_segment_info(uint segment_info)
{
    ParticleRibbonSegmentInfo si;
    si.segments = segment_info & 65535u;
    si.first = segment_info >> uint(16);
    si.previous = si.first - 1u;
    if (si.first == 0u)
    {
        si.previous = uint(_828.ribbon_render_params.max_segments - 1);
    }
    return si;
}

uint get_ribbon_segments(uint ribbon_id)
{
    uint param = prt_states_snapshots.states[ribbon_id].segment_info;
    ParticleRibbonSegmentInfo ribbon_si = ribbon_decode_segment_info(param);
    int s = max(0, (min(_828.ribbon_render_params.max_segments, int(ribbon_si.segments)) - 1));
    return uint(max(1, s));
}

bool prt_is_alive(uint id)
{
    return _748.prt_states[id].life_time < _748.prt_states[id].life_span;
}

float compute_t_from_subsegment(int sub_segment_idx)
{
    return float(sub_segment_idx) / float(_828.ribbon_render_params.segment_subdivisions);
}

int calculate_vidx_for_ribbon_segment(uint ribbon_id, inout int ribbon_segment)
{
    uint param = prt_states_snapshots.states[ribbon_id].segment_info;
    ParticleRibbonSegmentInfo ribbon_si = ribbon_decode_segment_info(param);
    ribbon_segment = int(ribbon_si.first) - ribbon_segment;
    if (ribbon_segment < 0)
    {
        ribbon_segment += _828.ribbon_render_params.max_segments;
    }
    int vidx = (ribbon_segment * _828.ribbon_render_params.particles_per_segment) + int(ribbon_id);
    return vidx;
}

vec3 ribbon_get_coords_for_vidx(int vidx)
{
    return vec3(prt_position_snapshots.position[(vidx * 3) + 0], prt_position_snapshots.position[(vidx * 3) + 1], prt_position_snapshots.position[(vidx * 3) + 2]);
}

vec3 catmull_rom(vec3 p0, vec3 p1, vec3 p2, vec3 p3, float t)
{
    float t2 = t * t;
    float t3 = t2 * t;
    return ((((p1 * 2.0) + (((-p0) + p2) * t)) + (((((p0 * 2.0) - (p1 * 5.0)) + (p2 * 4.0)) - p3) * t2)) + (((((-p0) + (p1 * 3.0)) - (p2 * 3.0)) + p3) * t3)) * 0.5;
}

vec3 ribbon_get_coords_for_t_spline(uint ribbon_idx, uint segment_idx, float t)
{
    uint param = ribbon_idx;
    int control_points_num = int(get_ribbon_segments(param)) + 1;
    int s1 = int(segment_idx);
    int s2 = min((s1 + 1), (control_points_num - 1));
    int s0 = max((s1 - 1), 0);
    int s3 = min((s2 + 1), (control_points_num - 1));
    uint param_1 = ribbon_idx;
    int param_2 = s0;
    int _994 = calculate_vidx_for_ribbon_segment(param_1, param_2);
    int vidx0 = _994;
    uint param_3 = ribbon_idx;
    int param_4 = s1;
    int _1000 = calculate_vidx_for_ribbon_segment(param_3, param_4);
    int vidx1 = _1000;
    uint param_5 = ribbon_idx;
    int param_6 = s2;
    int _1006 = calculate_vidx_for_ribbon_segment(param_5, param_6);
    int vidx2 = _1006;
    uint param_7 = ribbon_idx;
    int param_8 = s3;
    int _1012 = calculate_vidx_for_ribbon_segment(param_7, param_8);
    int vidx3 = _1012;
    int param_9 = vidx0;
    vec3 p0 = ribbon_get_coords_for_vidx(param_9);
    int param_10 = vidx1;
    vec3 p1 = ribbon_get_coords_for_vidx(param_10);
    int param_11 = vidx2;
    vec3 p2 = ribbon_get_coords_for_vidx(param_11);
    int param_12 = vidx3;
    vec3 p3 = ribbon_get_coords_for_vidx(param_12);
    if (s0 == s1)
    {
        p0 = p1 - (p2 - p1);
    }
    if (s3 == s2)
    {
        p3 = p2 + (p2 - p1);
    }
    if (false)
    {
        float d = length(p1 - p0);
        p0 = p1 - (normalize(p1 - p0) * d);
        p3 = p2 + (normalize(p3 - p2) * d);
    }
    vec3 param_13 = p0;
    vec3 param_14 = p1;
    vec3 param_15 = p2;
    vec3 param_16 = p3;
    float param_17 = t;
    return catmull_rom(param_13, param_14, param_15, param_16, param_17);
}

vec3 ribbon_get_coords_for_segment_t(uint ribbon_id, int segment_idx, float t)
{
    uint param = ribbon_id;
    uint param_1 = uint(segment_idx);
    float param_2 = t;
    return ribbon_get_coords_for_t_spline(param, param_1, param_2);
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _748.prt_states[id].color;
    vec3 _781 = color_convert_uint_to_float3(param);
    c.x = _781.x;
    c.y = _781.y;
    c.z = _781.z;
    return c;
}

float get_initial_modifier_factor(int ribbon_id, int segment_idx, int sub_segment_idx)
{
    float t = float(segment_idx) + (float(sub_segment_idx) / float(_828.ribbon_render_params.segment_subdivisions));
    if (segment_idx > 0)
    {
        t += (_828.ribbon_render_params.first_segment_time_factor - 1.0);
    }
    if (_828.ribbon_render_params.export_segment_t_as_modifier_factor != 0)
    {
        return t;
    }
    if (_828.ribbon_render_params.export_ribbon_t_as_modifier_factor != 0)
    {
        uint param = uint(ribbon_id);
        return t / float(get_ribbon_segments(param) * uint(_828.ribbon_render_params.segment_subdivisions));
    }
    return 1.0;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

void vertex_modifier_colorize_apply(VertexModifierColorizeParams modifier_params, ModifierFactor modifier_factor, inout VertexInput vtx)
{
    vec3 c = vec3(1.0);
    float a = modifier_params.alpha;
    if (modifier_params.use_gradient != 0)
    {
        int param = modifier_params.color_gradient_idx;
        float param_1 = modifier_factor.factor;
        c = gradient_sample(param, param_1).xyz;
        c *= modifier_params.color;
    }
    else
    {
        c = modifier_params.color;
    }
    if (modifier_params.mixing_mode == 0)
    {
        if (modifier_params.use_gradient == 0)
        {
            c *= modifier_factor.factor;
        }
        a *= modifier_factor.factor;
    }
    if (modifier_params.mixing_mode == 1)
    {
        c = mix(vtx.color.xyz, c, vec3(modifier_factor.factor));
        a = mix(vtx.color.w, a, modifier_factor.factor);
    }
    if (modifier_params.mixing_mode == 2)
    {
        c = vtx.color.xyz + (c * modifier_factor.factor);
        a = vtx.color.w + (a * modifier_factor.factor);
    }
    vec4 _1264 = vtx.color;
    vec3 _1270 = mix(_1264.xyz, c, vec3(modifier_params.color_blend));
    vtx.color.x = _1270.x;
    vtx.color.y = _1270.y;
    vtx.color.z = _1270.z;
    vtx.color.w = mix(vtx.color.w, a, modifier_params.alpha_blend);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _771;
    _771.life_time = _748.prt_states[id].life_time;
    _771.life_span = _748.prt_states[id].life_span;
    _771.generation_id = _748.prt_states[id].generation_id;
    _771.color = _748.prt_states[id].color;
    ParticleState _770 = _771;
    return _770;
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_from_particle_property(ModifierFactorFromParticleProperty_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    uint id = modifier_factor.id;
    uint param = id;
    ParticleState state = prt_get_state(param);
    ParticleState param_1 = state;
    if (prt_is_alive(param_1) == false)
    {
        return;
    }
    float v = 0.0;
    if (modifier_params.property == 0u)
    {
        v = state.life_time;
    }
    else
    {
        if (modifier_params.property == 1u)
        {
            v = max(0.0, state.life_span - state.life_time);
        }
        else
        {
            if (modifier_params.property == 2u)
            {
                v = state.generation_id;
            }
        }
    }
    v *= modifier_params.property_scale;
    ModifierFactor param_2 = modifier_factor;
    uint param_3 = modifier_params.modifier_function;
    float param_4 = v;
    modifier_process_modifier_factor(param_2, param_3, param_4);
    modifier_factor = param_2;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1354 = vector_transform_by_mat43(param, param_1);
        coords = _1354;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1361 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1361;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void _vertex_modifier_displace_apply(VertexModifierDisplaceParams params, ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    vec3 modifier_position = vec3(0.0);
    float influence = modifier_factor.factor;
    if (influence != 0.0)
    {
        vec3 n = vtx.norm;
        vec3 p = vtx.pos;
        p += ((params.displace_base * params.displace_base_modifier_factor) * influence);
        p += (((n * params.displace_normal) * params.displace_normal_modifier_factor) * influence);
        vtx.pos = p;
    }
}

void vertex_modifier_displace_apply(VertexModifierDisplaceParams params, inout ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    VertexModifierDisplaceParams param = params;
    ModifierFactor param_1 = modifier_factor;
    VertexInput param_2 = vtx;
    CoordinateSystemTrasforms param_3 = cs_transforms;
    _vertex_modifier_displace_apply(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    vtx = param_2;
}

vec3 apply_vtx_modifier(inout vec3 pos, vec3 norm, inout vec3 color, uint ribbon_id, float t)
{
    VertexInput vtx_input;
    vtx_input.id = ribbon_id;
    vtx_input.pos = pos;
    vtx_input.norm = norm;
    vtx_input.color = vec4(color, 1.0);
    vtx_input.uv0 = vec2(0.0);
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = t;
    modifier_factor.hash = ribbon_id;
    modifier_factor.id = ribbon_id;
    modifier_factor.instance_id = ribbon_id;
    modifier_factor.position = pos;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _1469.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = _1469.transform_params.mModelInv;
    ModifierFactorMulAdd_Params _1487;
    _1487.multiply_value = _1482.VM0_params.multiply_value;
    _1487.add_value = _1482.VM0_params.add_value;
    ModifierFactorMulAdd_Params param = _1487;
    ModifierFactor param_1 = modifier_factor;
    modifier_factor_mul_add(param, param_1);
    modifier_factor = param_1;
    ModifierFactorClamp_Params _1500;
    _1500.clamp_min = _1495.VM1_params.clamp_min;
    _1500.clamp_max = _1495.VM1_params.clamp_max;
    _1500.clamp_min_enable = _1495.VM1_params.clamp_min_enable;
    _1500.clamp_max_enable = _1495.VM1_params.clamp_max_enable;
    ModifierFactorClamp_Params param_2 = _1500;
    ModifierFactor param_3 = modifier_factor;
    modifier_factor_clamp(param_2, param_3);
    modifier_factor = param_3;
    VertexModifierColorizeParams _1513;
    _1513.color = _1508.VM2_params.color;
    _1513.alpha = _1508.VM2_params.alpha;
    _1513.use_gradient = _1508.VM2_params.use_gradient;
    _1513.color_blend = _1508.VM2_params.color_blend;
    _1513.alpha_blend = _1508.VM2_params.alpha_blend;
    _1513.color_gradient_idx = _1508.VM2_params.color_gradient_idx;
    _1513.mixing_mode = _1508.VM2_params.mixing_mode;
    VertexModifierColorizeParams param_4 = _1513;
    ModifierFactor param_5 = modifier_factor;
    VertexInput param_6 = vtx_input;
    vertex_modifier_colorize_apply(param_4, param_5, param_6);
    modifier_factor = param_5;
    vtx_input = param_6;
    modifier_factor.position = vtx_input.pos;
    ModifierFactorFromParticleProperty_Params _1532;
    _1532.property = _1527.VM3_params.property;
    _1532.modifier_function = _1527.VM3_params.modifier_function;
    _1532.property_scale = _1527.VM3_params.property_scale;
    _1532._pad2 = _1527.VM3_params._pad2;
    ModifierFactorFromParticleProperty_Params param_7 = _1532;
    ModifierFactor param_8 = modifier_factor;
    CoordinateSystemTrasforms param_9 = cs_transforms;
    modifier_factor_from_particle_property(param_7, param_8, param_9);
    modifier_factor = param_8;
    ModifierFactorMulAdd_Params _1545;
    _1545.multiply_value = _1541.VM4_params.multiply_value;
    _1545.add_value = _1541.VM4_params.add_value;
    ModifierFactorMulAdd_Params param_10 = _1545;
    ModifierFactor param_11 = modifier_factor;
    modifier_factor_mul_add(param_10, param_11);
    modifier_factor = param_11;
    ModifierFactorClamp_Params _1556;
    _1556.clamp_min = _1552.VM5_params.clamp_min;
    _1556.clamp_max = _1552.VM5_params.clamp_max;
    _1556.clamp_min_enable = _1552.VM5_params.clamp_min_enable;
    _1556.clamp_max_enable = _1552.VM5_params.clamp_max_enable;
    ModifierFactorClamp_Params param_12 = _1556;
    ModifierFactor param_13 = modifier_factor;
    modifier_factor_clamp(param_12, param_13);
    modifier_factor = param_13;
    ModifierFactorNoise_Params _1569;
    _1569.transform_local_to_gizmo = _1564.VM6_params.transform_local_to_gizmo;
    _1569.noise_domain_scale = _1564.VM6_params.noise_domain_scale;
    _1569.modifier_function = _1564.VM6_params.modifier_function;
    _1569.noise_domain_offset = _1564.VM6_params.noise_domain_offset;
    _1569.noise_value_scale = _1564.VM6_params.noise_value_scale;
    _1569.noise_value_offset = _1564.VM6_params.noise_value_offset;
    _1569.influence_scope = _1564.VM6_params.influence_scope;
    _1569._pad0 = _1564.VM6_params._pad0;
    _1569._pad1 = _1564.VM6_params._pad1;
    ModifierFactorNoise_Params param_14 = _1569;
    ModifierFactor param_15 = modifier_factor;
    CoordinateSystemTrasforms param_16 = cs_transforms;
    modifier_factor_noise_default(param_14, param_15, param_16);
    modifier_factor = param_15;
    VertexModifierDisplaceParams _1584;
    _1584.displace_normal = _1579.VM7_params.displace_normal;
    _1584.displace_normal_modifier_factor = _1579.VM7_params.displace_normal_modifier_factor;
    _1584.displace_base = _1579.VM7_params.displace_base;
    _1584.displace_base_modifier_factor = _1579.VM7_params.displace_base_modifier_factor;
    _1584.influence_scope = _1579.VM7_params.influence_scope;
    VertexModifierDisplaceParams param_17 = _1584;
    ModifierFactor param_18 = modifier_factor;
    VertexInput param_19 = vtx_input;
    CoordinateSystemTrasforms param_20 = cs_transforms;
    vertex_modifier_displace_apply(param_17, param_18, param_19, param_20);
    modifier_factor = param_18;
    vtx_input = param_19;
    modifier_factor.position = vtx_input.pos;
    ModifierFactorNoise_Params _1603;
    _1603.transform_local_to_gizmo = _1599.VM8_params.transform_local_to_gizmo;
    _1603.noise_domain_scale = _1599.VM8_params.noise_domain_scale;
    _1603.modifier_function = _1599.VM8_params.modifier_function;
    _1603.noise_domain_offset = _1599.VM8_params.noise_domain_offset;
    _1603.noise_value_scale = _1599.VM8_params.noise_value_scale;
    _1603.noise_value_offset = _1599.VM8_params.noise_value_offset;
    _1603.influence_scope = _1599.VM8_params.influence_scope;
    _1603._pad0 = _1599.VM8_params._pad0;
    _1603._pad1 = _1599.VM8_params._pad1;
    ModifierFactorNoise_Params param_21 = _1603;
    ModifierFactor param_22 = modifier_factor;
    CoordinateSystemTrasforms param_23 = cs_transforms;
    modifier_factor_noise_default(param_21, param_22, param_23);
    modifier_factor = param_22;
    VertexModifierDisplaceParams _1616;
    _1616.displace_normal = _1612.VM9_params.displace_normal;
    _1616.displace_normal_modifier_factor = _1612.VM9_params.displace_normal_modifier_factor;
    _1616.displace_base = _1612.VM9_params.displace_base;
    _1616.displace_base_modifier_factor = _1612.VM9_params.displace_base_modifier_factor;
    _1616.influence_scope = _1612.VM9_params.influence_scope;
    VertexModifierDisplaceParams param_24 = _1616;
    ModifierFactor param_25 = modifier_factor;
    VertexInput param_26 = vtx_input;
    CoordinateSystemTrasforms param_27 = cs_transforms;
    vertex_modifier_displace_apply(param_24, param_25, param_26, param_27);
    modifier_factor = param_25;
    vtx_input = param_26;
    pos = vtx_input.pos;
    color = vtx_input.color.xyz;
    return pos;
}

float get_initial_modifier_factor_t(int ribbon_id, int segment_idx, inout float t)
{
    t = float(segment_idx) + t;
    if (_828.ribbon_render_params.export_segment_t_as_modifier_factor != 0)
    {
        return t;
    }
    if (_828.ribbon_render_params.export_ribbon_t_as_modifier_factor != 0)
    {
        uint param = uint(ribbon_id);
        return t / float(get_ribbon_segments(param) * uint(_828.ribbon_render_params.segment_subdivisions));
    }
    return 1.0;
}

vec3 get_ribbon_transformed_segment_position_t(int ribbon_id, int segment_idx, float sub_segment_t)
{
    uint param = uint(ribbon_id);
    int param_1 = segment_idx;
    float param_2 = sub_segment_t;
    vec3 p = ribbon_get_coords_for_segment_t(param, param_1, param_2);
    vec3 dummy_normal = vec3(0.0);
    vec3 dummy_color = vec3(0.0);
    int param_3 = ribbon_id;
    int param_4 = segment_idx;
    float param_5 = sub_segment_t;
    float _1730 = get_initial_modifier_factor_t(param_3, param_4, param_5);
    vec3 param_6 = p;
    vec3 param_7 = dummy_normal;
    vec3 param_8 = dummy_color;
    uint param_9 = uint(ribbon_id);
    float param_10 = _1730;
    vec3 _1739 = apply_vtx_modifier(param_6, param_7, param_8, param_9, param_10);
    dummy_color = param_8;
    vec3 modified_p = _1739;
    vec3 param_11 = modified_p;
    mat4 param_12 = _1469.transform_params.mModelView;
    vec3 _1746 = vector_transform_by_mat43(param_11, param_12);
    return _1746;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec4 ray_cyl_intersect(vec3 ro, vec3 rd, vec3 cb, vec3 ca, float cr)
{
    vec3 oc = ro - cb;
    float caca = dot(ca, ca);
    float card = dot(ca, rd);
    float caoc = dot(ca, oc);
    float a = 1.0 - (card * card);
    float b = dot(oc, rd) - (caoc * card);
    float c = (dot(oc, oc) - (caoc * caoc)) - (cr * cr);
    float h = (b * b) - (a * c);
    if (h < 0.0)
    {
        return vec4(-1.0);
    }
    h = sqrt(h);
    float t = ((-b) - h) / a;
    float y = caoc + (t * card);
    vec3 n = ((oc + (rd * t)) - ((ca * y) / vec3(caca))) / vec3(cr);
    return vec4(t, n.x, n.y, n.z);
}

void main()
{
    instanceID = uint(gl_InstanceIndex);
    int odd_even = ((gl_VertexIndex & 1) == 0) ? 1 : (-1);
    int ribbon_id;
    int ribbon_segment;
    int ribbon_sub_segment;
    if (_828.ribbon_render_params.render_as_strips != 0)
    {
        ribbon_id = gl_InstanceIndex;
        int n = gl_VertexIndex / 2;
        ribbon_segment = n / _828.ribbon_render_params.segment_subdivisions;
        ribbon_sub_segment = n - (ribbon_segment * _828.ribbon_render_params.segment_subdivisions);
    }
    else
    {
        uint max_segments_uint = uint(((_828.ribbon_render_params.max_segments - 1) * _828.ribbon_render_params.segment_subdivisions) + 1);
        uint n_1 = uint(gl_VertexIndex) / 2u;
        ribbon_id = (gl_InstanceIndex * 64) + int(n_1 / max_segments_uint);
        n_1 %= max_segments_uint;
        ribbon_segment = int(n_1 / uint(_828.ribbon_render_params.segment_subdivisions));
        ribbon_sub_segment = int(n_1 - uint(ribbon_segment * _828.ribbon_render_params.segment_subdivisions));
    }
    uint param = uint(ribbon_id);
    uint ribbon_segments = get_ribbon_segments(param);
    uint param_1 = uint(ribbon_id);
    bool _1929 = !prt_is_alive(param_1);
    bool _1937;
    if (!_1929)
    {
        _1937 = uint(ribbon_segment) > ribbon_segments;
    }
    else
    {
        _1937 = _1929;
    }
    bool _1948;
    if (!_1937)
    {
        _1948 = (uint(ribbon_segment) == ribbon_segments) && (ribbon_sub_segment > 0);
    }
    else
    {
        _1948 = _1937;
    }
    if (_1948 || (ribbon_segments <= 1u))
    {
        gl_Position = vec4(uintBitsToFloat(0x7fc00000u /* nan */));
        return;
    }
    if (ribbon_id == 24019)
    {
    }
    int param_2 = ribbon_sub_segment;
    uint param_3 = uint(ribbon_id);
    int param_4 = ribbon_segment;
    float param_5 = compute_t_from_subsegment(param_2);
    vec3 vInstPosition = ribbon_get_coords_for_segment_t(param_3, param_4, param_5);
    vec3 vInstNormal = vec3(1.0, 0.0, 0.0);
    uint param_6 = uint(ribbon_id);
    vec4 vInstColor = prt_get_color(param_6);
    int param_7 = ribbon_id;
    int param_8 = ribbon_segment;
    int param_9 = ribbon_sub_segment;
    vec3 param_10 = vInstPosition;
    vec3 param_11 = vInstNormal;
    vec3 param_12 = vInstColor.xyz;
    uint param_13 = uint(ribbon_id);
    float param_14 = get_initial_modifier_factor(param_7, param_8, param_9);
    vec3 _2004 = apply_vtx_modifier(param_10, param_11, param_12, param_13, param_14);
    vInstColor.x = param_12.x;
    vInstColor.y = param_12.y;
    vInstColor.z = param_12.z;
    vInstPosition = _2004;
    uint param_15 = uint(ribbon_id);
    ParticleState vState = prt_get_state(param_15);
    bool is_last = (uint(ribbon_segment) == ribbon_segments) && (ribbon_sub_segment == 0);
    bool is_last_section = uint(ribbon_segment) >= (ribbon_segments - 1u);
    bool is_first_section = ribbon_segment == 0;
    bool _2039 = uint(ribbon_segment) == (ribbon_segments - 1u);
    bool _2047;
    if (_2039)
    {
        _2047 = ribbon_sub_segment == (_828.ribbon_render_params.segment_subdivisions - 1);
    }
    else
    {
        _2047 = _2039;
    }
    bool is_one_before_last = _2047;
    bool is_first = (ribbon_segment == 0) && (ribbon_sub_segment == 0);
    bool is_full = ribbon_segments == uint(_828.ribbon_render_params.max_segments - 1);
    vec3 extrusion = vec3(0.0);
    vec3 modelview_cylinder_axis = vec3(0.0, 0.0, 1.0);
    int second_segment_offset = 0;
    int second_subsegment_offset = -1;
    bool swap_second_segment_direction = false;
    if ((ribbon_sub_segment == 0) && (second_subsegment_offset < 0))
    {
        second_segment_offset = -1;
        second_subsegment_offset = 0;
    }
    if ((ribbon_segment == 0) && (second_segment_offset < 0))
    {
        swap_second_segment_direction = true;
        second_subsegment_offset = 1;
        if (second_subsegment_offset >= _828.ribbon_render_params.segment_subdivisions)
        {
            second_subsegment_offset = 0;
            second_segment_offset = 1;
        }
    }
    if (true)
    {
        float ribbon_t;
        if (is_first_section)
        {
            ribbon_t = (float(ribbon_sub_segment) * _828.ribbon_render_params.first_segment_time_factor) / float(_828.ribbon_render_params.segment_subdivisions);
        }
        else
        {
            ribbon_t = float(ribbon_segment) + (float(ribbon_sub_segment) / float(_828.ribbon_render_params.segment_subdivisions));
            ribbon_t -= (1.0 - _828.ribbon_render_params.first_segment_time_factor);
        }
        float curve_mirror_point = ((float(ribbon_segments) - 0.5) + _828.ribbon_render_params.first_segment_time_factor) * 0.449999988079071044921875;
        if ((ribbon_segments > 3u) && (ribbon_t > curve_mirror_point))
        {
            ribbon_t = curve_mirror_point - ((ribbon_t - curve_mirror_point) * 0.75);
        }
        float shrink_factor = 1.0 - exp((-ribbon_t) * 2.0);
        float min_shrink_modifier = 0.0500000007450580596923828125;
        float t_shift = (1.0 / float(_828.ribbon_render_params.segment_subdivisions)) * 0.0500000007450580596923828125;
        int param_16 = ribbon_sub_segment;
        int param_17 = ribbon_id;
        int param_18 = ribbon_segment;
        float param_19 = compute_t_from_subsegment(param_16) - t_shift;
        vec3 currPosition = get_ribbon_transformed_segment_position_t(param_17, param_18, param_19);
        int param_20 = ribbon_sub_segment + second_subsegment_offset;
        int param_21 = ribbon_id;
        int param_22 = ribbon_segment + second_segment_offset;
        float param_23 = compute_t_from_subsegment(param_20) + t_shift;
        vec3 nextPosition = get_ribbon_transformed_segment_position_t(param_21, param_22, param_23);
        modelview_cylinder_axis = currPosition - nextPosition;
        SPIRV_CROSS_BRANCH
        if (length(modelview_cylinder_axis) <= 9.9999997473787516355514526367188e-05)
        {
            if (ribbon_segment > 1)
            {
                int param_24 = ribbon_id;
                int param_25 = ribbon_segment + second_segment_offset;
                float param_26 = float(ribbon_sub_segment + (second_subsegment_offset * 2));
                nextPosition = get_ribbon_transformed_segment_position_t(param_24, param_25, param_26);
                modelview_cylinder_axis = currPosition - nextPosition;
            }
        }
        modelview_cylinder_axis = normalize(modelview_cylinder_axis);
        vec2 dir2d = normalize(currPosition.xy - nextPosition.xy);
        if (swap_second_segment_direction)
        {
            modelview_cylinder_axis *= (-1.0);
            dir2d *= (-1.0);
        }
        dir2d = vec2(-dir2d.y, dir2d.x);
        vec3 dir = vec3(dir2d, 0.0);
        if ((uint(ribbon_segment) == ribbon_segments) && (ribbon_segments > 1u))
        {
        }
        SPIRV_CROSS_BRANCH
        if (is_full && is_last_section)
        {
            float t = _828.ribbon_render_params.first_segment_time_factor;
            uint param_27 = uint(ribbon_id);
            int param_28 = int(ribbon_segments - 1u);
            float param_29 = 0.0;
            vec3 prevInstPosition = ribbon_get_coords_for_segment_t(param_27, param_28, param_29);
            int param_30 = ribbon_id;
            int param_31 = ribbon_segment;
            int param_32 = ribbon_sub_segment;
            vec3 param_33 = prevInstPosition;
            vec3 param_34 = vInstNormal;
            vec3 param_35 = vInstColor.xyz;
            uint param_36 = uint(ribbon_id);
            float param_37 = get_initial_modifier_factor(param_30, param_31, param_32);
            vec3 _2285 = apply_vtx_modifier(param_33, param_34, param_35, param_36, param_37);
            vInstColor.x = param_35.x;
            vInstColor.y = param_35.y;
            vInstColor.z = param_35.z;
            prevInstPosition = _2285;
            vInstPosition = mix(vInstPosition, prevInstPosition, vec3(t));
        }
        dir *= max(min_shrink_modifier, shrink_factor);
        extrusion = dir * _828.ribbon_render_params.thickness;
    }
    if (ribbon_segment == 0)
    {
        modelview_cylinder_axis *= (-1.0);
    }
    uint param_38 = uint(ribbon_id);
    if (!prt_is_alive(param_38))
    {
        gl_Position = vec4(uintBitsToFloat(0x7fc00000u /* nan */), uintBitsToFloat(0x7fc00000u /* nan */), uintBitsToFloat(0x7fc00000u /* nan */), -1.0);
        return;
    }
    vec3 pos = vInstPosition;
    vtx_output.vLocalPos = pos;
    vec3 vPos1 = pos;
    vec3 param_39 = vPos1;
    mat4 param_40 = _1469.transform_params.mModelView;
    vec3 _2339 = vector_transform_by_mat43(param_39, param_40);
    vec3 vPos = _2339;
    if (vPos.z > 1.0)
    {
        mat4 projection_no_jitter = _1469.transform_params.mProjection;
        projection_no_jitter[2].x = 0.0;
        projection_no_jitter[2].y = 0.0;
        vec3 param_41 = vec3(extrusion.xy, vPos.z);
        mat4 param_42 = projection_no_jitter;
        vec4 _2361 = vector_transform_by_mat_projection(param_41, param_42);
        vec4 projected_extrusion = _2361;
        vec4 _2362 = projected_extrusion;
        float _2365 = projected_extrusion.w;
        vec3 _2367 = _2362.xyz / vec3(_2365);
        projected_extrusion.x = _2367.x;
        projected_extrusion.y = _2367.y;
        projected_extrusion.z = _2367.z;
        float min_extrusion_size = 0.0006500000017695128917694091796875;
        float projected_extrusion_size = length(projected_extrusion.xy);
        if (projected_extrusion_size > 0.0)
        {
            if (projected_extrusion_size < min_extrusion_size)
            {
                float scale = min_extrusion_size / projected_extrusion_size;
                extrusion *= scale;
            }
        }
    }
    float remaining_lifetime_based_extrusion_modifier = 1.0;
    float remaining_lifetime_margin = 0.20000000298023223876953125;
    if (vState.life_time > (vState.life_span - remaining_lifetime_margin))
    {
        remaining_lifetime_based_extrusion_modifier = vState.life_time - (vState.life_span - remaining_lifetime_margin);
        remaining_lifetime_based_extrusion_modifier /= (vState.life_span - remaining_lifetime_margin);
        remaining_lifetime_based_extrusion_modifier = 1.0 - remaining_lifetime_based_extrusion_modifier;
    }
    else
    {
        if (vState.life_time < remaining_lifetime_margin)
        {
            remaining_lifetime_based_extrusion_modifier = vState.life_time;
            remaining_lifetime_based_extrusion_modifier /= remaining_lifetime_margin;
            remaining_lifetime_based_extrusion_modifier = 1.0 - remaining_lifetime_based_extrusion_modifier;
        }
    }
    remaining_lifetime_based_extrusion_modifier = clamp(remaining_lifetime_based_extrusion_modifier, 0.0, 1.0);
    vPos += ((extrusion * remaining_lifetime_based_extrusion_modifier) * float(odd_even));
    MaterialPropertiesGPU _2461;
    _2461.diffuse = materials.material_properties[_828.ribbon_render_params.material_index].diffuse;
    _2461.transparency = materials.material_properties[_828.ribbon_render_params.material_index].transparency;
    _2461.emissive = materials.material_properties[_828.ribbon_render_params.material_index].emissive;
    _2461.roughness = materials.material_properties[_828.ribbon_render_params.material_index].roughness;
    _2461.triplanar_factor = materials.material_properties[_828.ribbon_render_params.material_index].triplanar_factor;
    _2461.refraction = materials.material_properties[_828.ribbon_render_params.material_index].refraction;
    _2461.normal_factor = materials.material_properties[_828.ribbon_render_params.material_index].normal_factor;
    _2461.emissive_factor = materials.material_properties[_828.ribbon_render_params.material_index].emissive_factor;
    _2461.temporal_accumulation_factor = materials.material_properties[_828.ribbon_render_params.material_index].temporal_accumulation_factor;
    _2461.shadowmap_bias = materials.material_properties[_828.ribbon_render_params.material_index].shadowmap_bias;
    _2461.metalness = materials.material_properties[_828.ribbon_render_params.material_index].metalness;
    _2461.albedo_sampler = materials.material_properties[_828.ribbon_render_params.material_index].albedo_sampler;
    _2461.emissive_sampler = materials.material_properties[_828.ribbon_render_params.material_index].emissive_sampler;
    _2461.normal_sampler = materials.material_properties[_828.ribbon_render_params.material_index].normal_sampler;
    _2461.metalic_roughness_sampler = materials.material_properties[_828.ribbon_render_params.material_index].metalic_roughness_sampler;
    _2461.flags = materials.material_properties[_828.ribbon_render_params.material_index].flags;
    _2461._pad0 = materials.material_properties[_828.ribbon_render_params.material_index]._pad0;
    _2461._pad1 = materials.material_properties[_828.ribbon_render_params.material_index]._pad1;
    MaterialPropertiesGPU material = _2461;
    vec3 param_43 = vPos1 + (extrusion * float(odd_even));
    mat4 param_44 = _1469.transform_params.mModel;
    vec3 _2472 = vector_transform_by_mat43(param_43, param_44);
    vtx_output.vWorldPos = _2472;
    vtx_output.vWorldPos -= _1469.transform_params.vCameraPosition;
    vtx_output.vWorldNorm = vec3(vInstPosition);
    vtx_output.vNorm = vInstNormal;
    vtx_output.vCoords = vPos;
    vtx_output.vNorm = vec3(float(odd_even), 0.0, -0.5);
    vec3 param_45 = modelview_cylinder_axis;
    mat4 param_46 = _1469.transform_params.mViewInv;
    vec3 model_cylinder_axis = vector_transform_by_mat33(param_45, param_46);
    vec3 param_47 = vPos;
    mat4 param_48 = _1469.transform_params.mViewInv;
    vec3 _2509 = vector_transform_by_mat43(param_47, param_48);
    vec3 model_on_cylinder_pos = _2509;
    vec3 param_49 = vInstPosition;
    mat4 param_50 = _1469.transform_params.mModel;
    vec3 _2516 = vector_transform_by_mat43(param_49, param_50);
    vec3 model_cylinder_pos = _2516;
    vec3 param_51 = _1469.transform_params.vCameraPosition;
    vec3 param_52 = normalize(model_on_cylinder_pos - _1469.transform_params.vCameraPosition);
    vec3 param_53 = model_cylinder_pos;
    vec3 param_54 = model_cylinder_axis;
    float param_55 = length(extrusion) * 2.0;
    vec4 cylinder_intersect = ray_cyl_intersect(param_51, param_52, param_53, param_54, param_55);
    vtx_output.vWorldNorm = -vec3(cylinder_intersect.yzw);
    if (cylinder_intersect.x == (-1.0))
    {
    }
    float life_time_factor = min(1.0, vState.life_time / vState.life_span);
    life_time_factor = 1.0 - sin((life_time_factor * 3.1415927410125732421875) * 0.5);
    vec4 _2565 = vInstColor;
    vec3 _2567 = _2565.xyz * (1.0 - pow(life_time_factor, 4.0));
    vInstColor.x = _2567.x;
    vInstColor.y = _2567.y;
    vInstColor.z = _2567.z;
    vtx_output.vColor = vec4(vInstColor);
    vec3 param_56 = vPos;
    mat4 param_57 = _1469.transform_params.mProjection;
    vec4 _2586 = vector_transform_by_mat_projection(param_56, param_57);
    gl_Position = _2586;
}

 