#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 10) uniform sampler3D sSourceColor;
layout(set = 0, binding = 1, r8) uniform readonly image3D imSourceOccupancy;
layout(set = 0, binding = 2, r32ui) uniform writeonly uimage3D imTarget0Color;
layout(set = 0, binding = 3, r8) uniform writeonly image3D imTarget0Occupancy;
layout(set = 0, binding = 4, r32ui) uniform writeonly uimage3D imTarget1Color;
layout(set = 0, binding = 5, r8) uniform writeonly image3D imTarget1Occupancy;
layout(set = 0, binding = 6, r32ui) uniform writeonly uimage3D imTarget2Color;
layout(set = 0, binding = 7, r8) uniform writeonly image3D imTarget2Occupancy;
layout(set = 0, binding = 8, r32ui) uniform writeonly uimage3D imTarget3Color;
layout(set = 0, binding = 9, r8) uniform writeonly image3D imTarget3Occupancy;

shared vec4 cube_samples_mip1[8][8][8];

vec4 vx_correct_after_downsampling(inout vec4 v)
{
    v *= 2.0;
    v.w = min(1.0, v.w);
    return v;
}

uint color_convert_rgb_rgb9e5(inout vec3 rgb)
{
    float kMaxVal = uintBitsToFloat(1199538176u);
    float kMinVal = uintBitsToFloat(931135488u);
    rgb = clamp(rgb, vec3(0.0), vec3(kMaxVal));
    float MaxChannel = max(max(kMinVal, rgb.x), max(rgb.y, rgb.z));
    float Bias = uintBitsToFloat((floatBitsToUint(MaxChannel) + 125845504u) & 2139095040u);
    uvec3 RGB = floatBitsToUint(rgb + vec3(Bias));
    uint E = (floatBitsToUint(Bias) << uint(4)) + 268435456u;
    return ((E | (RGB.z << uint(18))) | (RGB.y << uint(9))) | (RGB.x & 511u);
}

void main()
{
    vec4 v;
    for (int tiz = 0; tiz < 8; tiz++)
    {
        vec4 v_sum = vec4(0.0);
        for (int _iz = 0; _iz < 2; _iz++)
        {
            for (int _iy = 0; _iy < 2; _iy++)
            {
                for (int _ix = 0; _ix < 2; _ix++)
                {
                    int ix = (int(gl_LocalInvocationID.x) * 2) + _ix;
                    int iy = (int(gl_LocalInvocationID.y) * 2) + _iy;
                    int iz = (tiz * 2) + _iz;
                    ivec3 store_pos = ivec3(ix, iy, iz);
                    vec3 _182 = texelFetch(sSourceColor, store_pos, 4).xyz;
                    v.x = _182.x;
                    v.y = _182.y;
                    v.z = _182.z;
                    v.w = imageLoad(imSourceOccupancy, store_pos).x;
                    v_sum += v;
                }
            }
        }
        int ix_1 = int(gl_LocalInvocationID.x);
        int iy_1 = int(gl_LocalInvocationID.y);
        int iz_1 = tiz;
        v_sum.w *= 0.125;
        vec4 _222 = v_sum;
        vec3 _224 = _222.xyz * 0.125;
        v_sum.x = _224.x;
        v_sum.y = _224.y;
        v_sum.z = _224.z;
        vec4 param = v_sum;
        vec4 _233 = vx_correct_after_downsampling(param);
        v_sum = _233;
        cube_samples_mip1[iz_1][iy_1][ix_1] = v_sum;
        ivec3 store_pos_1 = ivec3(ix_1, iy_1, iz_1);
        vec3 param_1 = v_sum.xyz;
        uint _259 = color_convert_rgb_rgb9e5(param_1);
        imageStore(imTarget0Color, store_pos_1, uvec4(_259));
        imageStore(imTarget0Occupancy, store_pos_1, v_sum.wwww);
    }
    barrier();
    memoryBarrierShared();
    bool _272 = gl_LocalInvocationID.x > 0u;
    bool _279;
    if (!_272)
    {
        _279 = gl_LocalInvocationID.y > 0u;
    }
    else
    {
        _279 = _272;
    }
    if (_279)
    {
        return;
    }
    vec4 samples_color;
    vec4 cube_samples_mip2[4][4][4];
    for (int iz_2 = 0; iz_2 < 8; iz_2++)
    {
        for (int iy_2 = 0; iy_2 < 8; iy_2++)
        {
            for (int ix_2 = 0; ix_2 < 8; ix_2++)
            {
                samples_color.w = cube_samples_mip1[iz_2][iy_2][ix_2].w;
                samples_color.x = cube_samples_mip1[iz_2][iy_2][ix_2].xyz.x;
                samples_color.y = cube_samples_mip1[iz_2][iy_2][ix_2].xyz.y;
                samples_color.z = cube_samples_mip1[iz_2][iy_2][ix_2].xyz.z;
                bool _329 = (ix_2 & 1) == 0;
                bool _335;
                if (_329)
                {
                    _335 = (iy_2 & 1) == 0;
                }
                else
                {
                    _335 = _329;
                }
                bool _341;
                if (_335)
                {
                    _341 = (iz_2 & 1) == 0;
                }
                else
                {
                    _341 = _335;
                }
                if (_341)
                {
                    cube_samples_mip2[iz_2 / 2][iy_2 / 2][ix_2 / 2] = vec4(0.0);
                }
                int _358 = iz_2 / 2;
                int _360 = iy_2 / 2;
                int _362 = ix_2 / 2;
                cube_samples_mip2[_358][_360][_362] += samples_color;
            }
        }
    }
    vec4 cube_samples_mip3[2][2][2];
    for (int iz_3 = 0; iz_3 < 4; iz_3++)
    {
        for (int iy_3 = 0; iy_3 < 4; iy_3++)
        {
            for (int ix_3 = 0; ix_3 < 4; ix_3++)
            {
                ivec3 store_pos_2 = ivec3(ix_3, iy_3, iz_3);
                vec4 samples_color_1 = vec4(0.0);
                samples_color_1.w = cube_samples_mip2[iz_3][iy_3][ix_3].w;
                samples_color_1.x = cube_samples_mip2[iz_3][iy_3][ix_3].xyz.x;
                samples_color_1.y = cube_samples_mip2[iz_3][iy_3][ix_3].xyz.y;
                samples_color_1.z = cube_samples_mip2[iz_3][iy_3][ix_3].xyz.z;
                samples_color_1.w *= 0.125;
                vec4 _426 = samples_color_1;
                vec3 _428 = _426.xyz * 0.125;
                samples_color_1.x = _428.x;
                samples_color_1.y = _428.y;
                samples_color_1.z = _428.z;
                vec4 param_2 = samples_color_1;
                vec4 _437 = vx_correct_after_downsampling(param_2);
                samples_color_1 = _437;
                vec3 param_3 = samples_color_1.xyz;
                uint _444 = color_convert_rgb_rgb9e5(param_3);
                imageStore(imTarget1Color, store_pos_2, uvec4(_444));
                imageStore(imTarget1Occupancy, store_pos_2, samples_color_1.wwww);
                bool _453 = (ix_3 & 1) == 0;
                bool _459;
                if (_453)
                {
                    _459 = (iy_3 & 1) == 0;
                }
                else
                {
                    _459 = _453;
                }
                bool _465;
                if (_459)
                {
                    _465 = (iz_3 & 1) == 0;
                }
                else
                {
                    _465 = _459;
                }
                if (_465)
                {
                    cube_samples_mip3[iz_3 / 2][iy_3 / 2][ix_3 / 2] = vec4(0.0);
                }
                int _481 = iz_3 / 2;
                int _483 = iy_3 / 2;
                int _485 = ix_3 / 2;
                cube_samples_mip3[_481][_483][_485] += samples_color_1;
            }
        }
    }
    vec4 cube_samples_mip4 = vec4(0.0);
    for (int iz_4 = 0; iz_4 < 2; iz_4++)
    {
        for (int iy_4 = 0; iy_4 < 2; iy_4++)
        {
            for (int ix_4 = 0; ix_4 < 2; ix_4++)
            {
                ivec3 store_pos_3 = ivec3(ix_4, iy_4, iz_4);
                vec4 samples_color_2 = vec4(0.0);
                samples_color_2.w = cube_samples_mip3[iz_4][iy_4][ix_4].w;
                samples_color_2.x = cube_samples_mip3[iz_4][iy_4][ix_4].xyz.x;
                samples_color_2.y = cube_samples_mip3[iz_4][iy_4][ix_4].xyz.y;
                samples_color_2.z = cube_samples_mip3[iz_4][iy_4][ix_4].xyz.z;
                samples_color_2.w *= 0.125;
                vec4 _550 = samples_color_2;
                vec3 _552 = _550.xyz * 0.125;
                samples_color_2.x = _552.x;
                samples_color_2.y = _552.y;
                samples_color_2.z = _552.z;
                vec4 param_4 = samples_color_2;
                vec4 _561 = vx_correct_after_downsampling(param_4);
                samples_color_2 = _561;
                vec3 param_5 = samples_color_2.xyz;
                uint _568 = color_convert_rgb_rgb9e5(param_5);
                imageStore(imTarget2Color, store_pos_3, uvec4(_568));
                imageStore(imTarget2Occupancy, store_pos_3, samples_color_2.wwww);
                cube_samples_mip4 += samples_color_2;
            }
        }
    }
    vec4 samples_color_3 = vec4(0.0);
    samples_color_3.w = cube_samples_mip4.w;
    samples_color_3.x = cube_samples_mip4.xyz.x;
    samples_color_3.y = cube_samples_mip4.xyz.y;
    samples_color_3.z = cube_samples_mip4.xyz.z;
    samples_color_3.w *= 0.125;
    vec4 _600 = samples_color_3;
    vec3 _602 = _600.xyz * 0.125;
    samples_color_3.x = _602.x;
    samples_color_3.y = _602.y;
    samples_color_3.z = _602.z;
    vec4 param_6 = samples_color_3;
    vec4 _611 = vx_correct_after_downsampling(param_6);
    samples_color_3 = _611;
    vec3 param_7 = samples_color_3.xyz;
    uint _618 = color_convert_rgb_rgb9e5(param_7);
    imageStore(imTarget3Color, ivec3(0), uvec4(_618));
    imageStore(imTarget3Occupancy, ivec3(0), samples_color_3.wwww);
}

 