#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
#extension GL_EXT_buffer_reference2 : require
#extension GL_EXT_shader_realtime_clock : require
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchDeferredParams
{
    mat4 mat_projection;
    mat4 mat_projection_previous;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 camera_projection_params_previous;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
    vec2 frustum_shift;
};

struct VXBRDFOutput
{
    vec3 color_weighted;
    vec3 color_raw;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct VXLightingParams
{
    float average_position_factor;
    float average_normals_factor;
    float average_colors_factor;
    float light_falloff_factor;
    float occlusion_falloff_factor;
    float light_trace_distance_scale;
    float trace_range;
    float reprojection_tolerance;
    int filter_step;
    int compute_diffuse;
    int compute_specular;
    int max_samples_diffuse;
    int max_samples_specular;
    int debug_clock;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 3, std140) uniform DeferredParams
{
    layout(row_major) DispatchDeferredParams dispatch_setup;
} _298;

layout(set = 0, binding = 4, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _518;

layout(set = 0, binding = 1, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 5, std140) uniform VoxelLightingParams
{
    VXLightingParams voxel_lighting_setup;
} _1293;

layout(set = 0, binding = 2, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 0, binding = 11) uniform sampler2DArray s_BlueNoise;
layout(set = 0, binding = 12) uniform sampler2D s_BRDF;
layout(set = 0, binding = 6, rg16f) uniform readonly image2D imGuiding;
layout(set = 0, binding = 7, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 0, binding = 8, rgba16f) uniform writeonly image2D imTargetLighting;
layout(set = 0, binding = 9, rgba16f) uniform writeonly image2D imTargetOcclusion;
layout(set = 0, binding = 10, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 13) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 14) uniform sampler3D s_voxel_colors_filtered;
layout(set = 0, binding = 15) uniform sampler3D s_voxel_occupancy_filtered;
layout(set = 0, binding = 16) uniform sampler2D imAlbedo;

int decode_material(uint data)
{
    return int(data >> 31u);
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

vec3 deferred_get_view_direction_from_screen_pos(DispatchDeferredParams ddp, vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((ddp.frustum_shift * ddp.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-ddp.camera_projection_params.z) + ((ddp.camera_projection_params.x * vd_pos.x) * ddp.inv_resolution.x);
    view_direction.y = (-ddp.camera_projection_params.w) + ((ddp.camera_projection_params.y * vd_pos.y) * ddp.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _229;
    if (nor.x > 0.0)
    {
        _229 = -t;
    }
    else
    {
        _229 = t;
    }
    nor.x += _229;
    float _244;
    if (nor.y > 0.0)
    {
        _244 = -t;
    }
    else
    {
        _244 = t;
    }
    nor.y += _244;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

float linearizeDepth(float d)
{
    return _298.dispatch_setup.near_far_plane.z / ((_298.dispatch_setup.near_far_plane.y + _298.dispatch_setup.near_far_plane.x) - (d * _298.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return (_298.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

void get_weight_for_sample(inout ivec2 p, vec3 n, inout float w_diffuse, inout float w_specular)
{
    w_diffuse = 1.0;
    w_specular = 1.0;
    p.x &= (-4);
    p.y &= (-4);
    w_diffuse = 0.0;
    w_specular = 0.0;
    float c_diffuse = 1.0;
    float c_specular = 1.0;
    int r = 2;
    int _1048 = -r;
    for (int iy = _1048; iy <= r; iy++)
    {
        int _1059 = -r;
        for (int ix = _1059; ix <= r; ix++)
        {
            ivec2 candidate_p = ivec2(p.x + (ix * 4), p.y + (iy * 4));
            vec4 v = imageLoad(imGuiding, candidate_p / ivec2(4));
            uint encoded_normal_material = imageLoad(imNormalMaterial, candidate_p).x;
            uint param = encoded_normal_material;
            vec3 _1102 = decode_normal(param);
            vec3 nn = _1102;
            float w = max(0.0, dot(n, nn));
            if (v.x >= 0.0)
            {
                w_diffuse += (v.x * w);
                c_diffuse += w;
            }
            if (v.y >= 0.0)
            {
                w_specular += (v.y * w);
                c_specular += w;
            }
        }
    }
    w_diffuse /= c_diffuse;
    w_specular /= c_specular;
    w_diffuse = sqrt(w_diffuse);
    w_specular = sqrt(w_specular);
}

mat3 matrixFromVector(inout vec3 n)
{
    if (n.z == (-1.0))
    {
        n.z = -0.99500000476837158203125;
    }
    float a = 1.0 / (1.0 + n.z);
    float b = ((-n.x) * n.y) * a;
    vec3 b1 = vec3(1.0 - ((n.x * n.x) * a), b, -n.x);
    vec3 b2 = vec3(b, 1.0 - ((n.y * n.y) * a), -n.y);
    return mat3(vec3(b1), vec3(b2), vec3(n));
}

vec3 CosineSampleHemisphere(float u1, float u2)
{
    float r = sqrt(u1);
    float theta = 6.283185482025146484375 * u2;
    float x = r * cos(theta);
    float y = r * sin(theta);
    return vec3(x, y, sqrt(max(0.0, 1.0 - u1)));
}

vec4 rt_cone_trace_sample_cubemap(sampler3D smp, int texture_size, vec3 p, float mip)
{
    return textureLod(smp, p, mip);
}

vec4 rt_cone_trace_occlusion(ivec2 screen_pos, sampler3D voxel_color_texture, sampler3D voxel_occupancy_texture, vec3 grid_size, int grid_res, vec3 grid_origin, vec3 origin, vec3 surface_normal, vec3 dir, float range, float lightTraceDistanceScale, float roughness, int rays, float color_falloff, float occlusion_falloff, float trace_range)
{
    if (range <= 0.0)
    {
        return vec4(0.0);
    }
    float occ = 0.0;
    vec3 occ_color = vec3(0.0);
    for (int si = 0; si < rays; si++)
    {
        vec3 c_color = vec3(0.0);
        float c_occlusion = 0.0;
        int frame = _518.globals.monotonic & 1023;
        vec2 _noise = texelFetch(s_BlueNoise, ivec3(screen_pos, frame & 15), 0).xy;
        _noise = fract(_noise + vec2(float(si) * 1.61803400516510009765625));
        vec2 hash = _noise;
        vec3 param = dir;
        mat3 _556 = matrixFromVector(param);
        mat3 vecSpace = _556;
        float param_1 = hash.x * roughness;
        float param_2 = hash.y;
        vec3 V = CosineSampleHemisphere(param_1, param_2);
        V = vecSpace * V;
        float VdotN = dot(V, surface_normal);
        if ((VdotN < 0.0) && true)
        {
            hash = fract(_noise + vec2(float(frame + 10) * 1.61803400516510009765625));
            float param_3 = hash.x * roughness;
            float param_4 = hash.y;
            V = CosineSampleHemisphere(param_3, param_4);
            V = vecSpace * V;
            VdotN = dot(V, surface_normal);
            if (VdotN < 0.0)
            {
                return vec4(0.0);
            }
        }
        vec3 p = origin;
        float prestep_distance = 3.0;
        p += ((surface_normal * range) * prestep_distance);
        float base_V = hash.x;
        float l = base_V * range;
        float max_l = 0.0;
        float coneAperture = tan(((roughness * 3.1415927410125732421875) * 0.5) * 0.100000001490116119384765625);
        float range_rcp = 1.0 / range;
        int steps = 0;
        bool is_inside = false;
        int iter = 0;
        bool loop = true;
        while (loop)
        {
            float diameter = max(range, (2.0 * coneAperture) * l);
            float mip = min(8.0, log2(diameter * range_rcp));
            vec3 grid_p = ((p + (V * l)) - grid_origin) / grid_size;
            vec3 sample_p = (grid_p + vec3(0.5)) / vec3(float(grid_res));
            if (is_inside == false)
            {
                bool _689 = all(greaterThanEqual(sample_p, vec3(0.0)));
                bool _696;
                if (_689)
                {
                    _696 = all(lessThan(sample_p, vec3(1.0)));
                }
                else
                {
                    _696 = _689;
                }
                if (_696)
                {
                    is_inside = true;
                }
            }
            else
            {
                bool _702 = any(lessThan(sample_p, vec3(0.0)));
                bool _709;
                if (!_702)
                {
                    _709 = any(greaterThanEqual(sample_p, vec3(1.0)));
                }
                else
                {
                    _709 = _702;
                }
                if (_709)
                {
                    is_inside = false;
                    loop = false;
                    iter++;
                }
            }
            float mip_coarse = min(8.0, mip + 1.0);
            int param_5 = 256;
            vec3 param_6 = sample_p;
            float param_7 = mip_coarse;
            vec4 gc = vec4(rt_cone_trace_sample_cubemap(voxel_occupancy_texture, param_5, param_6, param_7).xxxx);
            if (gc.w > 0.0040000001899898052215576171875)
            {
                int param_8 = 256;
                vec3 param_9 = sample_p;
                float param_10 = mip;
                gc.w = rt_cone_trace_sample_cubemap(voxel_occupancy_texture, param_8, param_9, param_10).x;
                int param_11 = 256;
                vec3 param_12 = sample_p;
                float param_13 = mip;
                vec3 _757 = vec3(rt_cone_trace_sample_cubemap(voxel_color_texture, param_11, param_12, param_13).xyz);
                gc.x = _757.x;
                gc.y = _757.y;
                gc.z = _757.z;
            }
            if (gc.w > 0.75)
            {
                gc.w = 1.0;
            }
            float blend = 1.0 - c_occlusion;
            c_occlusion = min(1.0, c_occlusion + gc.w);
            c_color += (gc.xyz * blend);
            l += (diameter * lightTraceDistanceScale);
            if (l >= trace_range)
            {
                loop = false;
            }
            if (c_occlusion >= 0.99500000476837158203125)
            {
                loop = false;
            }
            if (mip >= 1.5)
            {
                break;
            }
        }
        while (loop)
        {
            float diameter_1 = max(range, (2.0 * coneAperture) * l);
            float mip_1 = min(8.0, log2(diameter_1 * range_rcp));
            vec3 grid_p_1 = ((p + (V * l)) - grid_origin) / grid_size;
            vec3 sample_p_1 = (grid_p_1 + vec3(0.5)) / vec3(float(grid_res));
            if (is_inside == false)
            {
                bool _849 = all(greaterThanEqual(sample_p_1, vec3(0.0)));
                bool _855;
                if (_849)
                {
                    _855 = all(lessThan(sample_p_1, vec3(1.0)));
                }
                else
                {
                    _855 = _849;
                }
                if (_855)
                {
                    is_inside = true;
                }
            }
            else
            {
                bool _861 = any(lessThan(sample_p_1, vec3(0.0)));
                bool _868;
                if (!_861)
                {
                    _868 = any(greaterThanEqual(sample_p_1, vec3(1.0)));
                }
                else
                {
                    _868 = _861;
                }
                if (_868)
                {
                    is_inside = false;
                    loop = false;
                    iter++;
                }
            }
            if (is_inside)
            {
                vec4 gc_1 = vec4(0.0);
                int param_14 = 256;
                vec3 param_15 = sample_p_1;
                float param_16 = mip_1;
                gc_1.w = rt_cone_trace_sample_cubemap(voxel_occupancy_texture, param_14, param_15, param_16).x;
                if (gc_1.w > 0.0040000001899898052215576171875)
                {
                    int param_17 = 256;
                    vec3 param_18 = sample_p_1;
                    float param_19 = mip_1;
                    vec3 _900 = vec3(rt_cone_trace_sample_cubemap(voxel_color_texture, param_17, param_18, param_19).xyz);
                    gc_1.x = _900.x;
                    gc_1.y = _900.y;
                    gc_1.z = _900.z;
                }
                if (gc_1.w > 0.75)
                {
                    gc_1.w = 1.0;
                }
                float blend_1 = 1.0 - c_occlusion;
                c_occlusion = min(1.0, c_occlusion + gc_1.w);
                c_color += (gc_1.xyz * blend_1);
            }
            l += (diameter_1 * lightTraceDistanceScale);
            if (l >= trace_range)
            {
                loop = false;
            }
            if (c_occlusion >= 0.99500000476837158203125)
            {
                loop = false;
            }
        }
        c_occlusion = min(1.0, c_occlusion);
        float power = 0.75;
        occ += (c_occlusion / pow(l * occlusion_falloff, power));
        occ_color += (c_color * dot(V, dir));
    }
    occ /= float(rays);
    occ_color /= vec3(float(rays));
    if (occ > 1.0)
    {
        occ = 1.0;
    }
    return vec4(occ_color, occ);
}

VXBRDFOutput vx_brdf(vec3 n, vec3 v, vec3 diffuseColor, vec3 specularColor, vec3 diffuseLight, inout vec3 specularLight, vec3 f0, vec3 f90, float perceptual_roughness)
{
    float NdotV = clamp(dot(n, v), 0.0, 1.0);
    vec3 r = reflect(-v, n);
    vec2 brdf_sample_point = clamp(vec2(NdotV, 1.0 - perceptual_roughness), vec2(0.0), vec2(1.0));
    vec2 brdf = textureLod(s_BRDF, brdf_sample_point, 0.0).xy;
    specularLight *= (brdf.x + brdf.y);
    VXBRDFOutput vx;
    vx.color_weighted = (diffuseColor * diffuseLight) + (specularColor * specularLight);
    vx.color_raw = diffuseLight + specularLight;
    return vx;
}

vec3 TurboColormap(inout float x)
{
    x = clamp(x, 0.0, 1.0);
    vec4 v4 = vec4(1.0, x, x * x, (x * x) * x);
    vec2 v2 = v4.zw * v4.z;
    return vec3(dot(v4, vec4(0.135721385478973388671875, 4.6153926849365234375, -42.6603240966796875, 132.1310882568359375)) + dot(v2, vec2(-152.9423980712890625, 59.286380767822265625)), dot(v4, vec4(0.091402612626552581787109375, 2.1941883563995361328125, 4.842966556549072265625, -14.1850337982177734375)) + dot(v2, vec2(4.277298450469970703125, 2.82956600189208984375)), dot(v4, vec4(0.106673300266265869140625, 12.64194583892822265625, -60.5820465087890625, 110.36277008056640625)) + dot(v2, vec2(-89.903106689453125, 27.3482494354248046875)));
}

void main()
{
    float range = min(in_bbox_data.grid_size_voxelize.x, min(in_bbox_data.grid_size_voxelize.y, in_bbox_data.grid_size_voxelize.z));
    uvec2 tile_pos = gl_WorkGroupID.xy;
    ivec2 pixel_pos = ivec2((tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy);
    uint64_t _1182 = clockRealtimeEXT();
    uint64_t clock_start = _1182;
    ivec2 noise_pos = pixel_pos;
    uint encoded_normal_material = imageLoad(imNormalMaterial, pixel_pos).x;
    uint param = encoded_normal_material;
    int materialId = decode_material(param);
    if ((materialId & 1) == 1)
    {
        imageStore(imTargetLighting, pixel_pos, vec4(0.0));
        imageStore(imTargetOcclusion, pixel_pos, vec4(0.0));
    }
    else
    {
        uvec2 param_1 = imageLoad(imMetalnessRoughnessMaterialTags, pixel_pos).xy;
        float param_2;
        float param_3;
        uint param_4;
        decode_metalness_roughness_material(param_1, param_2, param_3, param_4);
        float metalness = param_2;
        float roughness = param_3;
        uint material = param_4;
        DispatchDeferredParams _1233;
        _1233.mat_projection = _298.dispatch_setup.mat_projection;
        _1233.mat_projection_previous = _298.dispatch_setup.mat_projection_previous;
        _1233.mat_model = _298.dispatch_setup.mat_model;
        _1233.mat_model_previous = _298.dispatch_setup.mat_model_previous;
        _1233.mat_view_inverse = _298.dispatch_setup.mat_view_inverse;
        _1233.mat_view_previous = _298.dispatch_setup.mat_view_previous;
        _1233.camera_position = _298.dispatch_setup.camera_position;
        _1233.camera_projection_params = _298.dispatch_setup.camera_projection_params;
        _1233.camera_projection_params_previous = _298.dispatch_setup.camera_projection_params_previous;
        _1233.near_far_plane = _298.dispatch_setup.near_far_plane;
        _1233.resolution = _298.dispatch_setup.resolution;
        _1233.inv_resolution = _298.dispatch_setup.inv_resolution;
        _1233.frustum_shift = _298.dispatch_setup.frustum_shift;
        DispatchDeferredParams param_5 = _1233;
        vec2 param_6 = vec2(pixel_pos);
        vec3 view_direction = deferred_get_view_direction_from_screen_pos(param_5, param_6);
        uint encoded_normal_material_1 = imageLoad(imNormalMaterial, pixel_pos).x;
        uint param_7 = encoded_normal_material_1;
        vec3 _1244 = decode_normal(param_7);
        vec3 vNorm = _1244;
        uint param_8 = encoded_normal_material_1;
        int materialId_1 = decode_material(param_8);
        float param_9 = texelFetch(sTextureDepth, pixel_pos, 0).x;
        float depth = linearizeDepth(param_9);
        vec3 param_10 = view_direction;
        float param_11 = depth;
        vec3 world = positionFromDepth(param_10, param_11);
        vec3 dir = normalize(world - _298.dispatch_setup.camera_position);
        ivec2 noise_pos_diffuse = noise_pos;
        ivec2 noise_pos_specular = noise_pos;
        vec4 diffuse = vec4(0.0);
        vec4 specular = vec4(0.0);
        float w_diffuse = 1.0;
        float w_specular = 1.0;
        ivec2 param_12 = noise_pos;
        vec3 param_13 = vNorm;
        float param_14;
        float param_15;
        get_weight_for_sample(param_12, param_13, param_14, param_15);
        w_diffuse = param_14;
        w_specular = param_15;
        int samples_diffuse = _1293.voxel_lighting_setup.max_samples_diffuse;
        int samples_specular = _1293.voxel_lighting_setup.max_samples_specular;
        bool _1300 = w_specular > 0.0;
        bool _1316;
        if (_1300)
        {
            _1316 = (materials.material_properties[material].flags & 16384u) != 0u;
        }
        else
        {
            _1316 = _1300;
        }
        SPIRV_CROSS_BRANCH
        if (_1316)
        {
            vec3 dir_1 = normalize(reflect(world - _298.dispatch_setup.camera_position, vNorm));
            float specular_roughness = dot(dir_1, vNorm) * roughness;
            specular_roughness *= specular_roughness;
            ivec2 param_16 = noise_pos_specular & ivec2(127);
            vec3 param_17 = in_bbox_data.grid_size_voxelize.xyz;
            int param_18 = 256;
            vec3 param_19 = in_bbox_data.bbox_voxelize_min.xyz;
            vec3 param_20 = world;
            vec3 param_21 = vNorm;
            vec3 param_22 = dir_1;
            float param_23 = range;
            float param_24 = _1293.voxel_lighting_setup.light_trace_distance_scale;
            float param_25 = specular_roughness;
            int param_26 = samples_specular;
            float param_27 = _1293.voxel_lighting_setup.light_falloff_factor;
            float param_28 = _1293.voxel_lighting_setup.occlusion_falloff_factor;
            float param_29 = _1293.voxel_lighting_setup.trace_range;
            specular = rt_cone_trace_occlusion(param_16, s_voxel_colors_filtered, s_voxel_occupancy_filtered, param_17, param_18, param_19, param_20, param_21, param_22, param_23, param_24, param_25, param_26, param_27, param_28, param_29);
            specular *= (1.0 - ((roughness * roughness) * 0.85000002384185791015625));
        }
        diffuse *= w_diffuse;
        specular *= w_specular;
        vec4 combined_lighting_occlusion = diffuse;
        vec4 _1397 = combined_lighting_occlusion;
        vec3 _1399 = _1397.xyz + specular.xyz;
        combined_lighting_occlusion.x = _1399.x;
        combined_lighting_occlusion.y = _1399.y;
        combined_lighting_occlusion.z = _1399.z;
        if (true)
        {
            vec3 V = normalize(_298.dispatch_setup.camera_position - world);
            vec3 N = vNorm;
            vec4 base_color = texelFetch(imAlbedo, ivec2(pixel_pos), 0);
            vec3 f0 = vec3(0.039999999105930328369140625);
            vec3 diffuseColor = (base_color.xyz * (vec3(1.0) - f0)) * (1.0 - metalness);
            vec3 specularColor = mix(f0, base_color.xyz, vec3(metalness));
            float alphaRoughness = roughness * roughness;
            vec3 specularEnvironmentR0 = specularColor;
            float reflectance = max(max(specularColor.x, specularColor.y), specularColor.z);
            vec3 specularEnvironmentR90 = vec3(1.0) * clamp(reflectance * 25.0, 0.0, 1.0);
            vec3 param_30 = N;
            vec3 param_31 = V;
            vec3 param_32 = diffuseColor;
            vec3 param_33 = specularColor;
            vec3 param_34 = diffuse.xyz;
            vec3 param_35 = specular.xyz;
            vec3 param_36 = specularEnvironmentR0;
            vec3 param_37 = specularEnvironmentR90;
            float param_38 = roughness;
            VXBRDFOutput _1486 = vx_brdf(param_30, param_31, param_32, param_33, param_34, param_35, param_36, param_37, param_38);
            VXBRDFOutput vx_brdf_1 = _1486;
            vec3 _1490 = vx_brdf_1.color_weighted * 20.0;
            combined_lighting_occlusion.x = _1490.x;
            combined_lighting_occlusion.y = _1490.y;
            combined_lighting_occlusion.z = _1490.z;
        }
        float diffuse_occlusion = diffuse.w;
        float specular_occlusion = specular.w;
        vec2 combined_occlusion = vec2(diffuse_occlusion, specular_occlusion);
        float specular_occlusion_contribution = clamp(0.5 - roughness, 0.0, 1.0);
        combined_lighting_occlusion.w = (combined_lighting_occlusion.w * (1.0 - (specular_occlusion_contribution * 0.5))) + (specular.w * specular_occlusion_contribution);
        imageStore(imTargetLighting, ivec2(pixel_pos), combined_lighting_occlusion);
        imageStore(imTargetOcclusion, ivec2(pixel_pos), vec4(combined_occlusion, 0.0, 0.0));
    }
    if ((_1293.voxel_lighting_setup.debug_clock != 0) && false)
    {
        uint64_t _1546 = clockRealtimeEXT();
        uint64_t clock_end = _1546;
        uint64_t clock_diff = clock_end - clock_start;
        float c = float(clock_diff / 1000ul);
        float param_39 = c / 512.0;
        vec3 _1561 = TurboColormap(param_39);
        vec3 clock_color = _1561;
        imageStore(imTargetLighting, ivec2(pixel_pos), vec4(clock_color, 1.0));
    }
}

 