#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct RibbonRenderParams
{
    int max_segments;
    float voxelize_thickness;
    int base_segment;
    int particles_per_segment;
    float thickness;
    int lights_num;
    int material_index;
    float first_segment_time_factor;
    int render_as_strips;
    int segment_subdivisions;
    int _pad1;
    int _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct VoxelizationDispatchParams
{
    int lights_num;
    uint component_tags;
    float env_map_intensity;
};

layout(set = 1, binding = 1, std430) buffer VoxelLightBuffer
{
    uint in_voxel_light_data[];
} _141;

layout(set = 1, binding = 2, std430) buffer VoxelOcclusionBuffer
{
    uint in_voxel_occlusion_data[];
} _159;

layout(set = 1, binding = 3, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 1, binding = 5, std140) uniform RibbonRenderParamsBuffer
{
    RibbonRenderParams ribbon_render_params;
} _433;

layout(set = 1, binding = 4, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 1, binding = 6, scalar) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 1, binding = 7) uniform sampler2D material_textures[128];

layout(location = 0) flat in int vOrientationIndex;
layout(location = 1) in vec3 vGridCoords;
layout(location = 5) in vec3 vLineCoords[2];
layout(location = 8) in vec4 vColor;
layout(location = 2) in vec2 vUV0;
bool twoSided;
bool clipless;

uint build_step_dir()
{
    if (vOrientationIndex == 0)
    {
        return 1u;
    }
    else
    {
        if (vOrientationIndex == 1)
        {
            return 2u;
        }
        else
        {
            return 4u;
        }
    }
}

float light_calculate_spot_attenuation(LightProperties light, vec3 pos)
{
    float cutoff = light.cutoff;
    float light_distance = length(light.position - pos);
    float angle_falloff = dot(light.direction, (pos - light.position) / vec3(light_distance));
    float attenuation = 0.0;
    bool _195 = angle_falloff > cutoff;
    bool _202;
    if (_195)
    {
        _202 = light_distance < light.range;
    }
    else
    {
        _202 = _195;
    }
    if (_202)
    {
        attenuation = 1.0 - ((1.0 - angle_falloff) / (1.0 - cutoff));
        attenuation = pow(attenuation, light.angular_falloff_power);
        float distance_attenuation = 1.0 - (light_distance / light.range);
        attenuation *= (distance_attenuation * distance_attenuation);
    }
    return attenuation;
}

float point_to_segment_distance(vec3 A, vec3 B, vec3 P)
{
    vec3 AB = B - A;
    vec3 AP = P - A;
    float t = dot(AP, AB) / dot(AB, AB);
    t = clamp(t, 0.0, 1.0);
    vec3 Q = A + (AB * t);
    return length(P - Q);
}

uint rt_calculate_grid_cell_idx(uint cx, uint cy, uint cz)
{
    return (cx + (cy * 256u)) + ((cz * 256u) * 256u);
}

void rt_store_voxel_occlusion(uint cx, uint cy, uint cz, float v)
{
    uint param = cx;
    uint param_1 = cy;
    uint param_2 = cz;
    uint idx = rt_calculate_grid_cell_idx(param, param_1, param_2);
    uint _166 = atomicMax(_159.in_voxel_occlusion_data[idx], uint(v * 1024.0));
}

void rt_store_voxel_color_emissive(uint cx, uint cy, uint cz, inout vec4 v)
{
    uint param = cx;
    uint param_1 = cy;
    uint param_2 = cz;
    uint idx = rt_calculate_grid_cell_idx(param, param_1, param_2);
    float v_mag = ceil(length(v.xyz));
    vec4 _92 = v;
    vec3 _96 = _92.xyz / vec3(v_mag);
    v.x = _96.x;
    v.y = _96.y;
    v.z = _96.z;
    v_mag = min(127.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    vi |= 2147483648u;
    uint _147 = atomicMax(_141.in_voxel_light_data[idx], vi);
}

void main()
{
    twoSided = false;
    clipless = false;
    vec3 bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 bbox_grid_size = in_bbox_data.grid_size_voxelize.xyz;
    vec3 pos = vGridCoords;
    vec3 gc = (gl_FragCoord.xyz / vec3(1.0, 1.0, 0.00390625)) + vec3(0.0);
    gc.y = 255.5 - gc.y;
    ivec3 mi = ivec3(floor(min(vLineCoords[0], vLineCoords[1])));
    ivec3 ma = ivec3(ceil(max(vLineCoords[0], vLineCoords[1])));
    mi = clamp(mi, ivec3(0), ivec3(255));
    ma = clamp(ma, ivec3(0), ivec3(255));
    uint stepDir = 0u;
    uvec3 stepStart = uvec3(0u);
    uint cy;
    uint cz;
    uint cx;
    int steps;
    if (vOrientationIndex == 0)
    {
        cy = uint(gc.x);
        cz = uint(gc.y);
        cx = uint(gc.z);
        stepStart = uvec3(cx, cy, cz);
        steps = ma.x - mi.x;
    }
    else
    {
        if (vOrientationIndex == 1)
        {
            cz = uint(gc.x);
            cx = uint(gc.y);
            cy = uint(gc.z);
            stepStart = uvec3(cx, cy, cz);
            steps = ma.y - mi.y;
        }
        else
        {
            cx = uint(gc.x);
            cy = uint(gc.y);
            cz = uint(gc.z);
            stepStart = uvec3(cx, cy, cz);
            steps = ma.z - mi.z;
        }
    }
    stepDir = build_step_dir();
    int stepMin = 0;
    int stepCount = 0;
    vec3 voxel_color = vec3(0.0);
    int sampling_r = int(ceil(_433.ribbon_render_params.voxelize_thickness * vColor.w));
    MaterialPropertiesGPU _461;
    _461.diffuse = materials.material_properties[_433.ribbon_render_params.material_index].diffuse;
    _461.transparency = materials.material_properties[_433.ribbon_render_params.material_index].transparency;
    _461.emissive = materials.material_properties[_433.ribbon_render_params.material_index].emissive;
    _461.roughness = materials.material_properties[_433.ribbon_render_params.material_index].roughness;
    _461.triplanar_factor = materials.material_properties[_433.ribbon_render_params.material_index].triplanar_factor;
    _461.refraction = materials.material_properties[_433.ribbon_render_params.material_index].refraction;
    _461.normal_factor = materials.material_properties[_433.ribbon_render_params.material_index].normal_factor;
    _461.emissive_factor = materials.material_properties[_433.ribbon_render_params.material_index].emissive_factor;
    _461.temporal_accumulation_factor = materials.material_properties[_433.ribbon_render_params.material_index].temporal_accumulation_factor;
    _461.shadowmap_bias = materials.material_properties[_433.ribbon_render_params.material_index].shadowmap_bias;
    _461.metalness = materials.material_properties[_433.ribbon_render_params.material_index].metalness;
    _461.albedo_sampler = materials.material_properties[_433.ribbon_render_params.material_index].albedo_sampler;
    _461.emissive_sampler = materials.material_properties[_433.ribbon_render_params.material_index].emissive_sampler;
    _461.normal_sampler = materials.material_properties[_433.ribbon_render_params.material_index].normal_sampler;
    _461.metalic_roughness_sampler = materials.material_properties[_433.ribbon_render_params.material_index].metalic_roughness_sampler;
    _461.flags = materials.material_properties[_433.ribbon_render_params.material_index].flags;
    _461._pad0 = materials.material_properties[_433.ribbon_render_params.material_index]._pad0;
    _461._pad1 = materials.material_properties[_433.ribbon_render_params.material_index]._pad1;
    MaterialPropertiesGPU material = _461;
    float roughness = material.roughness;
    vec3 world = (vec3(stepStart) * in_bbox_data.grid_size_voxelize.xyz) + in_bbox_data.bbox_voxelize_min.xyz;
    vec3 base_albedo = vColor.xyz;
    vec3 base_emissive = vec3(1.0);
    bool _485 = material.albedo_sampler >= 0;
    bool _491;
    if (_485)
    {
        _491 = material.albedo_sampler < 16;
    }
    else
    {
        _491 = _485;
    }
    if (_491)
    {
        base_albedo *= textureLod(material_textures[material.albedo_sampler], vUV0, 2.0).xyz;
    }
    bool _516 = material.emissive_sampler >= 0;
    bool _522;
    if (_516)
    {
        _522 = material.emissive_sampler < 16;
    }
    else
    {
        _522 = _516;
    }
    if (_522)
    {
        base_emissive = textureLod(material_textures[material.emissive_sampler], vUV0, 2.0).xyz;
    }
    for (int light_idx = 0; light_idx < _433.ribbon_render_params.lights_num; light_idx++)
    {
        LightProperties _556;
        _556.diffuse = lights.light_properties[light_idx].diffuse;
        _556.direction = lights.light_properties[light_idx].direction;
        _556.position = lights.light_properties[light_idx].position;
        _556.up = lights.light_properties[light_idx].up;
        _556.right = lights.light_properties[light_idx].right;
        _556.dimensions = lights.light_properties[light_idx].dimensions;
        _556.lighting_exclusion_tags = lights.light_properties[light_idx].lighting_exclusion_tags;
        _556.intensity = lights.light_properties[light_idx].intensity;
        _556.range = lights.light_properties[light_idx].range;
        _556.cutoff = lights.light_properties[light_idx].cutoff;
        _556.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
        _556.is_area = lights.light_properties[light_idx].is_area;
        _556.type = lights.light_properties[light_idx].type;
        _556.projector_sampler = lights.light_properties[light_idx].projector_sampler;
        _556.projector_intensity = lights.light_properties[light_idx].projector_intensity;
        _556.downsampled_shadowmap_sampler = lights.light_properties[light_idx].downsampled_shadowmap_sampler;
        _556.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
        _556.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
        _556.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
        _556.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
        _556.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
        _556.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
        _556.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
        _556.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
        _556.angular_falloff_power = lights.light_properties[light_idx].angular_falloff_power;
        _556.angular_falloff_color_gradient_idx = lights.light_properties[light_idx].angular_falloff_color_gradient_idx;
        _556.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
        _556.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
        _556.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
        _556.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
        _556.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
        _556.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
        _556.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
        _556.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
        _556.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
        LightProperties light = _556;
        if ((light.type & 256) != 0)
        {
            continue;
        }
        vec4 projector_color = vec4(0.0);
        vec3 pointToLight = light.position - world;
        if ((light.type & 1) != 0)
        {
            pointToLight = -light.direction;
        }
        vec3 lighting = material.diffuse;
        float shadow = 0.0;
        lighting = (lighting * light.diffuse.xyz) * light.intensity;
        lighting *= (1.0 - shadow);
        if ((light.type & 130) == 130)
        {
            LightProperties param = light;
            vec3 param_1 = world;
            float attenuation = light_calculate_spot_attenuation(param, param_1);
            lighting *= attenuation;
        }
        voxel_color += vec3(lighting);
    }
    voxel_color *= base_albedo;
    voxel_color += ((material.emissive * base_emissive) * material.emissive_factor);
    int _637 = -sampling_r;
    for (int sz = _637; sz <= sampling_r; sz++)
    {
        int _648 = -sampling_r;
        for (int sy = _648; sy <= sampling_r; sy++)
        {
            int _659 = -sampling_r;
            for (int sx = _659; sx <= sampling_r; sx++)
            {
                uvec3 cc = stepStart + uvec3(ivec3(sx, sy, sz));
                vec3 cellPos = vec3(cc);
                vec3 cellSize = vec3(1.0);
                vec3 sampling_pos = cellPos + (cellSize * 0.5);
                vec3 param_2 = vLineCoords[0];
                vec3 param_3 = vLineCoords[1];
                vec3 param_4 = sampling_pos;
                float line_segment_d = point_to_segment_distance(param_2, param_3, param_4);
                float max_d = (cellSize.x * _433.ribbon_render_params.voxelize_thickness) * vColor.w;
                if (line_segment_d < max_d)
                {
                    float occ = 1.0 - (line_segment_d / max_d);
                    uint param_5 = cc.x;
                    uint param_6 = cc.y;
                    uint param_7 = cc.z;
                    float param_8 = occ;
                    rt_store_voxel_occlusion(param_5, param_6, param_7, param_8);
                    uint param_9 = cc.x;
                    uint param_10 = cc.y;
                    uint param_11 = cc.z;
                    vec4 param_12 = vec4(voxel_color, 1.0) * occ;
                    rt_store_voxel_color_emissive(param_9, param_10, param_11, param_12);
                }
                if (false)
                {
                    if (true)
                    {
                        uint param_13 = cc.x;
                        uint param_14 = cc.y;
                        uint param_15 = cc.z;
                        float param_16 = 1.0;
                        rt_store_voxel_occlusion(param_13, param_14, param_15, param_16);
                        uint param_17 = cc.x;
                        uint param_18 = cc.y;
                        uint param_19 = cc.z;
                        vec4 param_20 = vec4(voxel_color, 1.0);
                        rt_store_voxel_color_emissive(param_17, param_18, param_19, param_20);
                    }
                    stepCount++;
                }
            }
        }
    }
}

 