#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct TextureResourceParams
{
    int flip_y;
    int clamp_range_01;
    float remap_range_start;
    float remap_range_end;
};

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct VertexModifierTextureDisplaceParams
{
    mat4 transform_world_to_local;
    mat4 transform_local_to_world;
    mat4 transform_local;
    mat4 transform_local_inv;
    mat4 transform_parent;
    mat4 transform_parent_inv;
    vec3 value_scale;
    float value_base;
    vec3 scale;
    int falloff_inverse;
    vec3 position;
    int displacement_mode;
    vec3 radius;
    int value_absolute;
    int falloff_curve_idx;
    int material_id;
    int radial;
    int smooth_displacement;
    int mapping_plane;
    int _pad0;
    int _pad1;
    int _pad2;
    TextureResourceParams source_txt_params;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct VertexModifierUVParams
{
    mat4 transform;
    bool override;
    int override_mode;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

const int _603[5] = int[](-2, -1, 0, 1, 2);
const float _625[5] = float[](0.0625, 0.25, 0.375, 0.25, 0.0625);

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct VertexModifierUVParams_1
{
    mat4 transform;
    uint override;
    int override_mode;
};

struct _2153
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 11, scalar) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _323;

layout(set = 0, binding = 1, std430) readonly buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) readonly buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) readonly buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) readonly buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 5, std430) readonly buffer VTXCustom0
{
    uint custom0[];
} vtx_custom0;

layout(set = 0, binding = 12, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _706;

layout(set = 0, binding = 6, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 0, binding = 13, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1748;

layout(set = 0, binding = 7, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1759;

layout(set = 0, binding = 8, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1847;

layout(set = 0, binding = 9, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _2039;

layout(set = 0, binding = 14, std140) uniform VM0
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM0_params;
} _2088;

layout(set = 0, binding = 15, std140) uniform VM1
{
    layout(row_major) VertexModifierTextureDisplaceParams VM1_params;
} _2104;

layout(set = 0, binding = 16, std140) uniform VM2
{
    layout(row_major) ModifierFactorNoise_Params VM2_params;
} _2122;

layout(set = 0, binding = 17, std140) uniform VM3
{
    layout(row_major) VertexModifierUVParams_1 VM3_params;
} _2137;

layout(set = 0, binding = 10, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _2248;

layout(set = 0, binding = 18) uniform sampler2D s_Curves;
layout(set = 0, binding = 19) uniform sampler2D material_textures[128];
layout(set = 0, binding = 147) uniform sampler2D s_NoiseRGBA;

layout(location = 1) out _2153 vtx_output;
layout(location = 0) out uint instanceID;

vec3 vtx_coords_load(inout uint idx)
{
    idx *= _323.geometry_information.attributes[0].stride;
    idx += _323.geometry_information.attributes[0].offset;
    return vec3(vtx_coords.coords[idx + 0u], vtx_coords.coords[idx + 1u], vtx_coords.coords[idx + 2u]);
}

vec3 vtx_albedo_load(inout uint idx)
{
    idx *= _323.geometry_information.attributes[2].stride;
    idx += _323.geometry_information.attributes[2].offset;
    return vec3(vtx_albedo.albedo[idx + 0u], vtx_albedo.albedo[idx + 1u], vtx_albedo.albedo[idx + 2u]);
}

vec3 vtx_normals_load(inout uint idx)
{
    idx *= _323.geometry_information.attributes[1].stride;
    idx += _323.geometry_information.attributes[1].offset;
    return vec3(vtx_normals.normals[idx + 0u], vtx_normals.normals[idx + 1u], vtx_normals.normals[idx + 2u]);
}

vec2 vtx_uv0_load(inout uint idx)
{
    idx *= _323.geometry_information.attributes[3].stride;
    idx += _323.geometry_information.attributes[3].offset;
    return vec2(vtx_uv0.uv0[idx + 0u], vtx_uv0.uv0[idx + 1u]);
}

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

uint vtx_custom0_load(inout uint idx)
{
    idx *= _323.geometry_information.attributes[6].stride;
    idx += _323.geometry_information.attributes[6].offset;
    return vtx_custom0.custom0[idx + 0u];
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        vec3 _478 = vector_transform_by_mat43(param, param_1);
        coords = _478;
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            vec3 _489 = vector_transform_by_mat43(param_2, param_3);
            coords = _489;
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _499 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _499;
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

vec4 texture_sample_lod_with_params(sampler2D smp, inout vec2 uv, float lod, TextureResourceParams params)
{
    if (params.flip_y != 0)
    {
        uv.y = 1.0 - uv.y;
    }
    vec4 v = textureLod(smp, uv, lod);
    v = (v - vec4(params.remap_range_start)) / vec4(params.remap_range_end - params.remap_range_start);
    if (params.clamp_range_01 != 0)
    {
        v = clamp(v, vec4(0.0), vec4(1.0));
    }
    return v;
}

float vertex_modifier_texture_displace_sample_texture_avg(sampler2D t, vec2 p, float lod, inout float d, TextureResourceParams t_params)
{
    float t_w = 0.0;
    float v = 0.0;
    ivec2 t_size = textureSize(t, int(lod));
    d = 1.0 / float(t_size.x);
    for (int y = 0; y < 5; y++)
    {
        for (int x = 0; x < 5; x++)
        {
            vec2 dp = (vec2(float(_603[x]), float(_603[y])) * d) * 1.5;
            float w = _625[x] * _625[y];
            vec2 param = p + dp;
            float param_1 = lod;
            TextureResourceParams param_2 = t_params;
            vec4 _644 = texture_sample_lod_with_params(t, param, param_1, param_2);
            v += (_644.x * w);
            t_w += w;
        }
    }
    return v / t_w;
}

float vertex_modifier_texture_displace_sample_texture(sampler2D t, vec2 p, float lod, float d, bool smooth_displacement, TextureResourceParams t_params)
{
    if (smooth_displacement)
    {
        vec2 param = p;
        float param_1 = lod;
        float param_2 = d;
        TextureResourceParams param_3 = t_params;
        float _673 = vertex_modifier_texture_displace_sample_texture_avg(t, param, param_1, param_2, param_3);
        return _673;
    }
    else
    {
        vec2 param_4 = p;
        float param_5 = lod;
        TextureResourceParams param_6 = t_params;
        vec4 _682 = texture_sample_lod_with_params(t, param_4, param_5, param_6);
        return _682.x;
    }
}

void vertex_modifier_texture_displace_apply(VertexModifierTextureDisplaceParams params, ModifierFactor modifier_factor, inout VertexInput vtx_input)
{
    if (params.material_id == 0)
    {
        return;
    }
    vec3 modifier_position = vec3(0.0);
    vec3 base_pos = vtx_input.pos;
    vec3 param = vtx_input.pos;
    mat4 param_1 = (params.transform_parent_inv * params.transform_local_inv) * _706.transform_params.mModel;
    vec3 _715 = vector_transform_by_mat43(param, param_1);
    vec3 influence_pos = _715;
    vec3 texture_sample_pos = influence_pos;
    vec3 rel_coords = base_pos;
    vec3 influence_rel_coords = influence_pos;
    float influence = length((influence_rel_coords - modifier_position) / params.radius);
    if (influence <= 1.0)
    {
        MaterialPropertiesGPU _748;
        _748.diffuse = materials.material_properties[params.material_id].diffuse;
        _748.transparency = materials.material_properties[params.material_id].transparency;
        _748.emissive = materials.material_properties[params.material_id].emissive;
        _748.roughness = materials.material_properties[params.material_id].roughness;
        _748.triplanar_factor = materials.material_properties[params.material_id].triplanar_factor;
        _748.refraction = materials.material_properties[params.material_id].refraction;
        _748.normal_factor = materials.material_properties[params.material_id].normal_factor;
        _748.emissive_factor = materials.material_properties[params.material_id].emissive_factor;
        _748.temporal_accumulation_factor = materials.material_properties[params.material_id].temporal_accumulation_factor;
        _748.shadowmap_bias = materials.material_properties[params.material_id].shadowmap_bias;
        _748.metalness = materials.material_properties[params.material_id].metalness;
        _748.albedo_sampler = materials.material_properties[params.material_id].albedo_sampler;
        _748.emissive_sampler = materials.material_properties[params.material_id].emissive_sampler;
        _748.normal_sampler = materials.material_properties[params.material_id].normal_sampler;
        _748.metalic_roughness_sampler = materials.material_properties[params.material_id].metalic_roughness_sampler;
        _748.flags = materials.material_properties[params.material_id].flags;
        _748._pad0 = materials.material_properties[params.material_id]._pad0;
        _748._pad1 = materials.material_properties[params.material_id]._pad1;
        MaterialPropertiesGPU material = _748;
        if (material.albedo_sampler == (-1))
        {
            return;
        }
        if (params.falloff_inverse == 0)
        {
            influence = 1.0 - influence;
        }
        int param_2 = params.falloff_curve_idx;
        float param_3 = 1.0 - influence;
        influence = curve_sample(param_2, param_3);
        influence *= modifier_factor.factor;
        float lod = 0.0;
        float d_texel = 1.0 / float(textureSize(material_textures[material.albedo_sampler], int(lod)).x);
        vec2 d_gradient = vec2(0.02500000037252902984619140625);
        vec2 tpos = vec2(0.0);
        vec3 tpos_offset_x = vec3(0.0);
        vec3 tpos_offset_y = vec3(0.0);
        if (params.mapping_plane == 0)
        {
            d_gradient = (params.radius.yz * d_texel) / (params.scale.xy / vec2(2.0));
            tpos = texture_sample_pos.yz / (params.radius.yz * 2.0);
            tpos_offset_x = vec3(0.0, d_gradient.x, 0.0);
            tpos_offset_y = vec3(0.0, 0.0, d_gradient.y);
        }
        else
        {
            if (params.mapping_plane == 1)
            {
                d_gradient = (params.radius.xz * d_texel) / (params.scale.xy / vec2(2.0));
                tpos = texture_sample_pos.xz / (params.radius.xz * 2.0);
                tpos_offset_x = vec3(d_gradient.x, 0.0, 0.0);
                tpos_offset_y = vec3(0.0, 0.0, d_gradient.y);
            }
            else
            {
                d_gradient = (params.radius.xy * d_texel) / (params.scale.xy / vec2(2.0));
                tpos = texture_sample_pos.xy / (params.radius.xy * 2.0);
                tpos_offset_x = vec3(d_gradient.x, 0.0, 0.0);
                tpos_offset_y = vec3(0.0, d_gradient.y, 0.0);
            }
        }
        if (params.radial != 0)
        {
            float r = length(fract(abs(tpos)) - vec2(0.5));
            vec2 t = fract(tpos) - vec2(0.5);
            if (abs(t.y) < 9.9999997473787516355514526367188e-06)
            {
                t.y = 9.9999997473787516355514526367188e-06;
            }
            tpos.x = 1.0 - (abs((atan(t.y, t.x) / 3.1415927410125732421875) + 1.0) * 0.5);
            tpos.y = r * 2.0;
            tpos *= params.scale.xy;
        }
        else
        {
            tpos *= params.scale.xy;
            tpos -= vec2(0.5);
            tpos.y = 1.0 - tpos.y;
        }
        tpos.y = 1.0 - tpos.y;
        vec2 param_4 = tpos + vec2(-d_texel, 0.0);
        float param_5 = lod;
        float param_6 = d_texel;
        bool param_7 = params.smooth_displacement != 0;
        TextureResourceParams param_8 = params.source_txt_params;
        float b_x = vertex_modifier_texture_displace_sample_texture(material_textures[material.albedo_sampler], param_4, param_5, param_6, param_7, param_8);
        vec2 param_9 = tpos + vec2(0.0, d_texel);
        float param_10 = lod;
        float param_11 = d_texel;
        bool param_12 = params.smooth_displacement != 0;
        TextureResourceParams param_13 = params.source_txt_params;
        float b_y = vertex_modifier_texture_displace_sample_texture(material_textures[material.albedo_sampler], param_9, param_10, param_11, param_12, param_13);
        vec2 param_14 = tpos;
        float param_15 = lod;
        float param_16 = d_texel;
        bool param_17 = params.smooth_displacement != 0;
        TextureResourceParams param_18 = params.source_txt_params;
        float b = vertex_modifier_texture_displace_sample_texture(material_textures[material.albedo_sampler], param_14, param_15, param_16, param_17, param_18);
        float n = params.value_base + b;
        float n_dx = params.value_base + b_x;
        float n_dy = params.value_base + b_y;
        if (params.value_absolute != 0)
        {
            n = abs(n);
            n_dx = abs(n_dx);
            n_dy = abs(n_dy);
        }
        float scale = params.value_scale.z;
        vec3 local_norm = vtx_input.norm;
        if (params.displacement_mode == 1)
        {
            vec3 param_19 = modifier_position;
            mat4 param_20 = params.transform_local;
            vec3 _1051 = vector_transform_by_mat43(param_19, param_20);
            local_norm = normalize(base_pos - _1051);
        }
        vec3 new_pos = base_pos + ((local_norm * n) * scale);
        vec3 new_pos_dx = (base_pos + tpos_offset_x) + ((local_norm * n_dx) * scale);
        vec3 new_pos_dy = (base_pos + tpos_offset_y) + ((local_norm * n_dy) * scale);
        new_pos = mix(base_pos, new_pos, vec3(influence));
        new_pos_dx = mix(base_pos + tpos_offset_x, new_pos_dx, vec3(influence));
        new_pos_dy = mix(base_pos + tpos_offset_y, new_pos_dy, vec3(influence));
        vec3 dx;
        vec3 dy;
        if (params.mapping_plane == 0)
        {
            dx = vec3(((n_dx - n) * influence) * scale, d_gradient.x, 0.0);
            dy = vec3(((n_dy - n) * influence) * scale, 0.0, d_gradient.y);
        }
        else
        {
            if (params.mapping_plane == 1)
            {
                dx = vec3(d_gradient.x, ((-(n_dx - n)) * influence) * scale, 0.0);
                dy = vec3(0.0, ((-(n_dy - n)) * influence) * scale, d_gradient.y);
            }
            else
            {
                dx = vec3(d_gradient.x, 0.0, ((n_dx - n) * influence) * scale);
                dy = vec3(0.0, d_gradient.y, ((n_dy - n) * influence) * scale);
            }
        }
        vec3 new_norm = vec3(1.0);
        dx = normalize(dx);
        dy = normalize(dy);
        vec3 dz = cross(dx, dy);
        dx = cross(dz, dy);
        mat3 m;
        m[0] = vec3(dx.x, dy.x, dz.x);
        m[1] = vec3(dx.y, dy.y, dz.y);
        m[2] = vec3(dx.z, dy.z, dz.z);
        if (params.mapping_plane == 0)
        {
            new_norm = mat3(vec3(dx), vec3(dy), vec3(dz)) * vtx_input.norm;
        }
        else
        {
            if (params.mapping_plane == 1)
            {
                mat3 _1260 = mat3(vec3(dx), vec3(dz), vec3(dy));
                new_norm = mat3(-_1260[0], -_1260[1], -_1260[2]) * vtx_input.norm;
            }
            else
            {
                new_norm = mat3(vec3(dx), vec3(dy), vec3(dz)) * vtx_input.norm;
            }
        }
        vtx_input.pos = new_pos;
        vtx_input.norm = normalize(new_norm);
    }
}

vec3 voronoise_random3f(vec3 p)
{
    return textureLod(s_NoiseRGBA, ((p.xy + (vec2(3.0, 1.0) * p.z)) + vec2(0.5)) / vec2(256.0), 0.0).xyz;
}

vec3 voronoise(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    float id = 0.0;
    vec2 res = vec2(100.0);
    for (int k = -1; k <= 1; k++)
    {
        for (int j = -1; j <= 1; j++)
        {
            for (int i = -1; i <= 1; i++)
            {
                vec3 b = vec3(float(i), float(j), float(k));
                vec3 param = p + b;
                vec3 r = (vec3(b) - f) + voronoise_random3f(param);
                float d = dot(r, r);
                if (d < res.x)
                {
                    id = dot(p + b, vec3(1.0, 57.0, 113.0));
                    res = vec2(d, res.x);
                }
                else
                {
                    if (d < res.y)
                    {
                        res.y = d;
                    }
                }
            }
        }
    }
    return vec3((sqrt(res) * 2.0) - vec2(1.0), abs(id));
}

void modifier_factor_noise_voronoi(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1432 = vector_transform_by_mat43(param, param_1);
        coords = _1432;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1439 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1439;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = voronoise(param_4).y;
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void vertex_modifier_uv_apply(VertexModifierUVParams params, inout VertexInput vtx_input)
{
    vec2 uv = vtx_input.uv0;
    if (params.override)
    {
        if (params.override_mode == 0)
        {
            uv = vtx_input.pos.xy;
        }
        if (params.override_mode == 1)
        {
            uv = vtx_input.pos.yz;
        }
        if (params.override_mode == 2)
        {
            uv = vtx_input.pos.xz;
        }
        if (params.override_mode == 3)
        {
            uv.x = length(vtx_input.pos);
            uv.y = 0.0;
        }
    }
    uv = (params.transform * vec4(uv, 0.0, 1.0)).xy;
    vtx_input.uv0 = uv;
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    uint load_vertex_idx = uint(gl_VertexIndex);
    if (_1748.instance_params.stride > 0)
    {
        uint flipbook_card = _1759.instance_flipbook_card[gl_InstanceIndex];
        flipbook_card = min(flipbook_card, (_323.geometry_information.flipbook_cards_num - 1u));
        load_vertex_idx += (_323.geometry_information.vtx_num * flipbook_card);
    }
    VertexInput vtx_input;
    vtx_input.id = uint(gl_VertexIndex);
    uint param = load_vertex_idx;
    vec3 _1781 = vtx_coords_load(param);
    vtx_input.pos = _1781;
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_323.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vec3 _1799 = vtx_albedo_load(param_1);
        vtx_input.color.x = _1799.x;
        vtx_input.color.y = _1799.y;
        vtx_input.color.z = _1799.z;
    }
    if ((_323.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = load_vertex_idx;
        vec3 _1814 = vtx_normals_load(param_2);
        vtx_input.norm = _1814;
    }
    if ((_323.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vec2 _1825 = vtx_uv0_load(param_3);
        vtx_input.uv0 = _1825;
    }
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 mat_instance_model_inv = mat_instance_model;
    if (_1748.instance_params.stride > 0)
    {
        vec4 inst_m0 = _1847.instance_transform[(gl_InstanceIndex * _1748.instance_params.stride) + 0];
        vec4 inst_m1 = _1847.instance_transform[(gl_InstanceIndex * _1748.instance_params.stride) + 1];
        vec4 inst_m2 = _1847.instance_transform[(gl_InstanceIndex * _1748.instance_params.stride) + 2];
        vec3 _1878 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _1878.x;
        mat_instance_model[0].y = _1878.y;
        mat_instance_model[0].z = _1878.z;
        vec3 _1891 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _1891.x;
        mat_instance_model[1].y = _1891.y;
        mat_instance_model[1].z = _1891.z;
        vec3 _1904 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _1904.x;
        mat_instance_model[2].y = _1904.y;
        mat_instance_model[2].z = _1904.z;
        vec3 _1917 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _1917.x;
        mat_instance_model[3].y = _1917.y;
        mat_instance_model[3].z = _1917.z;
        mat_instance_model_inv = mat_instance_model;
        mat3 param_4 = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
        mat3 inv = inverse_mat3(param_4);
        mat_instance_model_inv[0].x = inv[0].x;
        mat_instance_model_inv[0].y = inv[0].y;
        mat_instance_model_inv[0].z = inv[0].z;
        mat_instance_model_inv[1].x = inv[1].x;
        mat_instance_model_inv[1].y = inv[1].y;
        mat_instance_model_inv[1].z = inv[1].z;
        mat_instance_model_inv[2].x = inv[2].x;
        mat_instance_model_inv[2].y = inv[2].y;
        mat_instance_model_inv[2].z = inv[2].z;
        mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
        mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
        mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = uint(gl_VertexIndex);
    modifier_factor.id = uint(gl_VertexIndex);
    modifier_factor.instance_id = uint(gl_InstanceIndex);
    if (_1748.instance_params.stride > 0)
    {
        modifier_factor.instance_id = _2039.instance_hash[gl_InstanceIndex];
    }
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    modifier_factor.color = vtx_input.color;
    if ((_323.geometry_information.builtin_attribute_mask & 64u) != 0u)
    {
        uint param_5 = uint(gl_VertexIndex);
        uint _2062 = vtx_custom0_load(param_5);
        modifier_factor.custom0 = _2062;
    }
    if ((_323.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_6 = uint(gl_VertexIndex);
        vec2 _2073 = vtx_uv0_load(param_6);
        modifier_factor.uv0 = _2073;
    }
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _706.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_instance_model;
    cs_transforms.mat_local_to_model_inv = _706.transform_params.mModelInv;
    ModifierFactorDistanceRadial_Params _2093;
    _2093.transform_local_to_gizmo = _2088.VM0_params.transform_local_to_gizmo;
    _2093.falloff_curve_idx = _2088.VM0_params.falloff_curve_idx;
    _2093.falloff_inverse = _2088.VM0_params.falloff_inverse;
    _2093.domain_repeat_x = _2088.VM0_params.domain_repeat_x;
    _2093.domain_repeat_y = _2088.VM0_params.domain_repeat_y;
    _2093.domain_repeat_z = _2088.VM0_params.domain_repeat_z;
    _2093.influence_scope = _2088.VM0_params.influence_scope;
    _2093.modifier_function = _2088.VM0_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_7 = _2093;
    ModifierFactor param_8 = modifier_factor;
    CoordinateSystemTrasforms param_9 = cs_transforms;
    modifier_factor_distance_radial(param_7, param_8, param_9);
    modifier_factor = param_8;
    VertexModifierTextureDisplaceParams _2109;
    _2109.transform_world_to_local = _2104.VM1_params.transform_world_to_local;
    _2109.transform_local_to_world = _2104.VM1_params.transform_local_to_world;
    _2109.transform_local = _2104.VM1_params.transform_local;
    _2109.transform_local_inv = _2104.VM1_params.transform_local_inv;
    _2109.transform_parent = _2104.VM1_params.transform_parent;
    _2109.transform_parent_inv = _2104.VM1_params.transform_parent_inv;
    _2109.value_scale = _2104.VM1_params.value_scale;
    _2109.value_base = _2104.VM1_params.value_base;
    _2109.scale = _2104.VM1_params.scale;
    _2109.falloff_inverse = _2104.VM1_params.falloff_inverse;
    _2109.position = _2104.VM1_params.position;
    _2109.displacement_mode = _2104.VM1_params.displacement_mode;
    _2109.radius = _2104.VM1_params.radius;
    _2109.value_absolute = _2104.VM1_params.value_absolute;
    _2109.falloff_curve_idx = _2104.VM1_params.falloff_curve_idx;
    _2109.material_id = _2104.VM1_params.material_id;
    _2109.radial = _2104.VM1_params.radial;
    _2109.smooth_displacement = _2104.VM1_params.smooth_displacement;
    _2109.mapping_plane = _2104.VM1_params.mapping_plane;
    _2109._pad0 = _2104.VM1_params._pad0;
    _2109._pad1 = _2104.VM1_params._pad1;
    _2109._pad2 = _2104.VM1_params._pad2;
    _2109.source_txt_params.flip_y = _2104.VM1_params.source_txt_params.flip_y;
    _2109.source_txt_params.clamp_range_01 = _2104.VM1_params.source_txt_params.clamp_range_01;
    _2109.source_txt_params.remap_range_start = _2104.VM1_params.source_txt_params.remap_range_start;
    _2109.source_txt_params.remap_range_end = _2104.VM1_params.source_txt_params.remap_range_end;
    VertexModifierTextureDisplaceParams param_10 = _2109;
    ModifierFactor param_11 = modifier_factor;
    VertexInput param_12 = vtx_input;
    vertex_modifier_texture_displace_apply(param_10, param_11, param_12);
    vtx_input = param_12;
    modifier_factor.position = vtx_input.pos;
    ModifierFactorNoise_Params _2127;
    _2127.transform_local_to_gizmo = _2122.VM2_params.transform_local_to_gizmo;
    _2127.noise_domain_scale = _2122.VM2_params.noise_domain_scale;
    _2127.modifier_function = _2122.VM2_params.modifier_function;
    _2127.noise_domain_offset = _2122.VM2_params.noise_domain_offset;
    _2127.noise_value_scale = _2122.VM2_params.noise_value_scale;
    _2127.noise_value_offset = _2122.VM2_params.noise_value_offset;
    _2127.influence_scope = _2122.VM2_params.influence_scope;
    _2127._pad0 = _2122.VM2_params._pad0;
    _2127._pad1 = _2122.VM2_params._pad1;
    ModifierFactorNoise_Params param_13 = _2127;
    ModifierFactor param_14 = modifier_factor;
    CoordinateSystemTrasforms param_15 = cs_transforms;
    modifier_factor_noise_voronoi(param_13, param_14, param_15);
    modifier_factor = param_14;
    VertexModifierUVParams param_16;
    param_16.transform = _2137.VM3_params.transform;
    param_16.override = _2137.VM3_params.override != 0u;
    param_16.override_mode = _2137.VM3_params.override_mode;
    VertexInput param_17 = vtx_input;
    vertex_modifier_uv_apply(param_16, param_17);
    vtx_input = param_17;
    vtx_output.vLocalPos = vtx_input.pos;
    instanceID = uint(gl_InstanceIndex);
    if (_1748.instance_params.stride > 0)
    {
        vec4 inst_m0_1 = _1847.instance_transform[(gl_InstanceIndex * _1748.instance_params.stride) + 0];
        vec4 inst_m1_1 = _1847.instance_transform[(gl_InstanceIndex * _1748.instance_params.stride) + 1];
        vec4 inst_m2_1 = _1847.instance_transform[(gl_InstanceIndex * _1748.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0_1, v);
        vtx_input.pos.y = dot(inst_m1_1, v);
        vtx_input.pos.z = dot(inst_m2_1, v);
        vec3 param_18 = vtx_input.norm;
        mat4 param_19 = transpose(mat4(vec4(inst_m0_1), vec4(inst_m1_1), vec4(inst_m2_1), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_18, param_19));
        vec2 _2254 = unpackHalf2x16(_2248.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _2254.x;
        inst_c.y = _2254.y;
        vec2 _2264 = unpackHalf2x16(_2248.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _2264.x;
        inst_c.w = _2264.y;
        vec4 _2270 = vtx_input.color;
        vec3 _2274 = _2270.xyz * inst_c.xyz;
        vtx_input.color.x = _2274.x;
        vtx_input.color.y = _2274.y;
        vtx_input.color.z = _2274.z;
        vtx_input.color.w *= inst_c.w;
    }
    vec3 param_20 = vtx_input.pos;
    mat4 param_21 = _706.transform_params.mModel;
    vec3 _2294 = vector_transform_by_mat43(param_20, param_21);
    vec3 vPosModel = _2294;
    vec3 param_22 = vtx_input.norm;
    mat4 param_23 = _706.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vector_transform_by_mat33(param_22, param_23);
    vec3 param_24 = vPosModel;
    mat4 param_25 = _706.transform_params.mView;
    vec3 _2309 = vector_transform_by_mat43(param_24, param_25);
    vec3 vPosModelView = _2309;
    vtx_output.vCoords = vPosModelView;
    vtx_output.vCameraRelativeWorldPos = vPosModel - _706.transform_params.vCameraPosition;
    vtx_output.vNorm.x = dot(_706.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_706.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_706.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = vtx_input.norm;
    vtx_output.vColor = vtx_input.color;
    vtx_output.vUV0 = vtx_input.uv0;
    vec3 param_26 = vtx_output.vCoords;
    mat4 param_27 = _706.transform_params.mProjection;
    vec4 _2362 = vector_transform_by_mat_projection(param_26, param_27);
    gl_Position = _2362;
}

 