#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

const float _38[7] = float[](0.08348800241947174072265625, 0.082687996327877044677734375, 0.079319000244140625, 0.07350300252437591552734375, 0.0656580030918121337890625, 0.0564710013568401336669921875, 0.0467769987881183624267578125);

struct TextureResourceParams
{
    int flip_y;
    int clamp_range_01;
    float remap_range_start;
    float remap_range_end;
};

struct TextureProcessParams
{
    int width;
    int height;
    float width_inv;
    float height_inv;
    float param1;
    float param2;
    float param3;
    float param4;
    vec4 param_color;
    TextureResourceParams txt_params;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std140) uniform TextureProcessParamsBuffer
{
    TextureProcessParams texture_process_params;
} _48;

layout(set = 0, binding = 3) uniform sampler2D sSource;
layout(set = 0, binding = 2, rgba16f) uniform writeonly image2D imDest;

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    vec2 texel_size = vec2(_48.texture_process_params.width_inv, _48.texture_process_params.height_inv);
    vec2 vTexCoord = vec2(pixel_pos) * texel_size;
    vec4 color = textureLod(sSource, vTexCoord, 0.0) * _38[0];
    for (int i = 1; i < 7; i++)
    {
        vec2 offset = vec2(float(i) * 2.0, 0.0) * texel_size;
        vec4 sample1 = textureLod(sSource, vTexCoord + offset, 0.0);
        vec4 sample2 = textureLod(sSource, vTexCoord - offset, 0.0);
        color += ((sample1 + sample2) * _38[i]);
    }
    imageStore(imDest, ivec2(pixel_pos), color);
}

 