#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
#extension GL_EXT_buffer_reference2 : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct ParticleEmitterGeometry_Params
{
    int constrained;
    int debug_counter;
    int debug_counter2;
    int debug_counter3;
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec4 particle_color;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    float surface_distance;
    int pending;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    int alpha_to_modifier_factor;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ParticleModifierVoxelCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
    int material_index;
    int transformed_data_location_idx;
    int transformed_data_location_num;
};

struct ParticleLifecycleParams
{
    float time_step;
    float life_time_step;
    float max_lifetime;
    uint reset;
    uint capacity;
    uint has_previous;
};

struct ModifierFactorFromParticleProperty_Params
{
    uint property;
    uint modifier_function;
    float property_scale;
    int _pad2;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct ParticleModifierAttractor_Params
{
    vec3 position;
    float radius;
    float velocity;
};

struct ParticleModifierGeometryAttractorParams
{
    float strength;
    float strength_modifier_factor;
    float min_distance;
    float min_distance_modifier_factor;
    float search_distance;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    int iteration;
    float probability_of_reattach;
    int _pad1;
    int _pad2;
    uint nearest_face_buffer_size;
};

struct ParticleModifierColorize_Params
{
    vec4 color;
    int mode;
    int blend_mode;
    int color_gradient_idx;
    float randomness;
    float blend_from_previous;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct VM6Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 velocity;
    float time_step;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _517;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _548;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _571;

layout(set = 0, binding = 4, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _1365;

layout(set = 0, binding = 5, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _1419;

layout(set = 0, binding = 6, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _1490;

layout(set = 0, binding = 10, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _2147;

layout(set = 0, binding = 11, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _3007;

layout(set = 0, binding = 7, std430) buffer VM0
{
    ParticleEmitterGeometry_Params VM0_params;
} _3336;

layout(set = 0, binding = 12, std140) uniform VM1
{
    ParticleModifierVoxelCurl_Params VM1_params;
} _3371;

layout(set = 0, binding = 13, std140) uniform VM2
{
    ParticleModifierVoxelCurl_Params VM2_params;
} _3398;

layout(set = 0, binding = 14, std140) uniform VM3
{
    ModifierFactorFromParticleProperty_Params VM3_params;
} _3427;

layout(set = 0, binding = 15, std140) uniform VM4
{
    ModifierFactorMulAdd_Params VM4_params;
} _3442;

layout(set = 0, binding = 16, std140) uniform VM5
{
    ModifierFactorClamp_Params VM5_params;
} _3455;

layout(set = 0, binding = 17, std140) uniform VM6
{
    VM6Params VM6_params;
} _3469;

layout(set = 0, binding = 8, std430) buffer VM7
{
    ParticleModifierAttractor_Params VM7_params;
} _3494;

layout(set = 0, binding = 9, std430) buffer VM8
{
    ParticleModifierGeometryAttractorParams VM8_params;
    uint VM8_closest_face_idx[];
} _3523;

layout(set = 0, binding = 18, std140) uniform VM9
{
    ParticleModifierColorize_Params VM9_params;
} _3566;

layout(set = 0, binding = 19, std140) uniform VM10
{
    ParticleModifierCurl_Params VM10_params;
} _3590;

layout(set = 0, binding = 20) uniform sampler2D s_Gradients;

uint64_t g_buff_grid_markers_ptr;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_571.prt_prev_positions[(id * 3u) + 0u], _571.prt_prev_positions[(id * 3u) + 1u], _571.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _523;
    _523.life_time = _517.prt_states[id].life_time;
    _523.life_span = _517.prt_states[id].life_span;
    _523.generation_id = _517.prt_states[id].generation_id;
    _523.color = _517.prt_states[id].color;
    ParticleState _522 = _523;
    return _522;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _530;
    _530.life_time = state.life_time;
    _530.life_span = state.life_span;
    _530.generation_id = state.generation_id;
    _530.color = state.color;
    _517.prt_states[id] = _530;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

uint particle_emitter_geometry_get_first_face_idx(ParticleEmitterGeometry_Params emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _1490.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_emitter_geometry_get_last_face_idx(ParticleEmitterGeometry_Params emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _1490.transformed_data_location[tdl_idx].last_face_idx;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _497 = hash(param);
    uint param_1 = _497;
    float _499 = floatConstruct(param_1);
    return _499;
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _1419.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _1419.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _1419.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_1365.in_vtx_data[coord_offset + 0u], _1365.in_vtx_data[coord_offset + 1u], _1365.in_vtx_data[coord_offset + 2u]);
    return p;
}

vec4 rt_get_vertex_color(uint idx)
{
    uint color_offset = (idx * 1u) + 70000000u;
    uint packed_color = floatBitsToUint(_1365.in_vtx_data[color_offset + 0u]);
    vec4 p = vec4(float((packed_color >> uint(24)) & 255u), float((packed_color >> uint(16)) & 255u), float((packed_color >> uint(8)) & 255u), float((packed_color >> uint(0)) & 255u)) * 0.0039215688593685626983642578125;
    return p;
}

ModifierFactor particle_emitter_geometry_emit_evaluate_modifier_VM0(ModifierFactor modifier_factor)
{
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    return modifier_factor;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _625 = color_convert_rgb_float3_uint(param);
    uint v = _625;
    state.color = v;
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    float generation_id = state.generation_id + 1.0;
    if (generation_id > 65536.0)
    {
        generation_id = 0.0;
    }
    state.generation_id = generation_id;
}

void particle_emitter_geometry_emit_VM0(ParticleEmitterGeometry_Params emitter_params, inout ModifierFactor modifier_factor, inout Particle p, uint id, uint pending_id)
{
    ParticleEmitterGeometry_Params param = emitter_params;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    ParticleEmitterGeometry_Params param_1 = emitter_params;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    float seed = emitter_params.seed;
    bool emitted = false;
    vec3 bc;
    for (int iteration = 0; iteration < 5; iteration++)
    {
        float fid = float((id + uint(iteration * 45827)) & 16777215u);
        float fid_seed = ((fid * 0.0131700001657009124755859375) + seed) * 0.00113200000487267971038818359375;
        float param_2 = fid_seed * 5.131999969482421875;
        float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * random(param_2)));
        float param_3 = fid_seed;
        uint face_idx = uint(float((last_face_idx - first_face_idx) - 1u) * random(param_3));
        face_idx += first_face_idx;
        uint param_4 = face_idx;
        RTFace rt_face = rt_get_face(param_4);
        uint p0_idx = rt_face.v0;
        uint p1_idx = rt_face.v1;
        uint p2_idx = rt_face.v2;
        uint param_5 = p0_idx;
        vec3 p0 = rt_get_vertex(param_5);
        uint param_6 = p1_idx;
        vec3 p1 = rt_get_vertex(param_6);
        uint param_7 = p2_idx;
        vec3 p2 = rt_get_vertex(param_7);
        uint param_8 = p0_idx;
        vec4 c0 = rt_get_vertex_color(param_8);
        uint param_9 = p1_idx;
        vec4 c1 = rt_get_vertex_color(param_9);
        uint param_10 = p2_idx;
        vec4 c2 = rt_get_vertex_color(param_10);
        float param_11 = fid_seed * 0.34130001068115234375;
        bc.x = random(param_11);
        float param_12 = fid_seed * 0.1412999927997589111328125;
        bc.y = random(param_12);
        if ((bc.x + bc.y) >= 1.0)
        {
            bc.x = 1.0 - bc.x;
            bc.y = 1.0 - bc.y;
        }
        vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
        vec4 color = ((c0 * bc.x) + (c1 * bc.y)) + (c2 * ((1.0 - bc.x) - bc.y));
        ModifierFactor local_modifier_factor = modifier_factor_defaults();
        local_modifier_factor.factor = 1.0;
        local_modifier_factor.hash = floatBitsToUint(fid_seed);
        local_modifier_factor.id = id;
        local_modifier_factor.position = pos;
        local_modifier_factor.is_spawned = true;
        local_modifier_factor.color = color;
        ModifierFactor param_13 = local_modifier_factor;
        local_modifier_factor = particle_emitter_geometry_emit_evaluate_modifier_VM0(param_13);
        if (local_modifier_factor.factor <= 9.9999997473787516355514526367188e-05)
        {
            continue;
        }
        float particle_emitter_dist = length((emitter_params.position - pos) / (emitter_params.radius * 0.5));
        if ((emitter_params.constrained == 0) || (particle_emitter_dist <= 1.0))
        {
            if (emitter_params.surface_distance > 0.0)
            {
                vec3 n = normalize(cross(p0 - p1, p0 - p2));
                pos += (n * emitter_params.surface_distance);
            }
            if (pos.x == 1234566.0)
            {
                pos += vec3(fid_seed);
            }
            if (pos.x == 1234567.0)
            {
                pos += vec3(fid_seed * 5.131999969482421875);
            }
            p.pos = pos;
            ParticleState param_14 = p.state;
            vec3 param_15 = emitter_params.particle_color.xyz;
            prt_set_color(param_14, param_15);
            p.state = param_14;
            ParticleState param_16 = p.state;
            float param_17 = lifetime;
            prt_spawn(param_16, param_17);
            p.state = param_16;
            if (emitter_params.alpha_to_modifier_factor != 0)
            {
                modifier_factor.factor = color.w;
            }
            emitted = true;
            break;
        }
    }
}

uint particle_modifier_voxel_curl_get_first_face_idx(ParticleModifierVoxelCurl_Params params)
{
    uint tdl_idx = uint(params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _1490.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint article_modifier_voxel_curl_get_last_face_idx(ParticleModifierVoxelCurl_Params params)
{
    uint tdl_idx = uint((params.transformed_data_location_idx + params.transformed_data_location_num) - 1);
    return _1490.transformed_data_location[tdl_idx].last_face_idx;
}

float pointSegmentDistanceSquared(vec3 p, vec3 a, vec3 b)
{
    vec3 ab = b - a;
    float t = dot(p - a, ab) / dot(ab, ab);
    t = clamp(t, 0.0, 1.0);
    vec3 projection = a + (ab * t);
    return dot(p - projection, p - projection);
}

float point_triangle_distance(vec3 p, vec3 a, vec3 b, vec3 c)
{
    vec3 ab = b - a;
    vec3 ac = c - a;
    vec3 normal = normalize(cross(ab, ac));
    float distanceToPlane = dot(p - a, normal);
    vec3 projected = p - (normal * distanceToPlane);
    vec3 ap = projected - a;
    float d00 = dot(ab, ab);
    float d01 = dot(ab, ac);
    float d11 = dot(ac, ac);
    float d20 = dot(ap, ab);
    float d21 = dot(ap, ac);
    float denom = (d00 * d11) - (d01 * d01);
    float v = ((d11 * d20) - (d01 * d21)) / denom;
    float w = ((d00 * d21) - (d01 * d20)) / denom;
    float u = (1.0 - v) - w;
    if (((u >= 0.0) && (v >= 0.0)) && (w >= 0.0))
    {
        return abs(distanceToPlane);
    }
    else
    {
        vec3 param = p;
        vec3 param_1 = a;
        vec3 param_2 = b;
        float d1 = pointSegmentDistanceSquared(param, param_1, param_2);
        vec3 param_3 = p;
        vec3 param_4 = b;
        vec3 param_5 = c;
        float d2 = pointSegmentDistanceSquared(param_3, param_4, param_5);
        vec3 param_6 = p;
        vec3 param_7 = c;
        vec3 param_8 = a;
        float d3 = pointSegmentDistanceSquared(param_6, param_7, param_8);
        return sqrt(min(min(d1, d2), d3));
    }
}

int find_closest_face(ParticleModifierVoxelCurl_Params params, vec3 p)
{
    ParticleModifierVoxelCurl_Params param = params;
    int f0 = int(particle_modifier_voxel_curl_get_first_face_idx(param));
    ParticleModifierVoxelCurl_Params param_1 = params;
    int f1 = int(article_modifier_voxel_curl_get_last_face_idx(param_1));
    float closest_d = 0.0;
    int closest_fi = -1;
    for (int fi = f0; fi <= f1; fi++)
    {
        uint param_2 = uint(fi);
        RTFace rt_face = rt_get_face(param_2);
        uint p0_idx = rt_face.v0;
        uint p1_idx = rt_face.v1;
        uint p2_idx = rt_face.v2;
        uint param_3 = p0_idx;
        vec3 p0 = rt_get_vertex(param_3);
        uint param_4 = p1_idx;
        vec3 p1 = rt_get_vertex(param_4);
        uint param_5 = p2_idx;
        vec3 p2 = rt_get_vertex(param_5);
        vec3 param_6 = p;
        vec3 param_7 = p0;
        vec3 param_8 = p1;
        vec3 param_9 = p2;
        float d = point_triangle_distance(param_6, param_7, param_8, param_9);
        if (d >= 0.0)
        {
            if ((d < closest_d) || (closest_fi == (-1)))
            {
                closest_fi = fi;
                closest_d = d;
            }
        }
    }
    return closest_fi;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

vec4 snoise_grad(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    vec4 j = p - (floor(p / vec4(49.0)) * 49.0);
    vec4 x_ = floor(j / vec4(7.0));
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (((x_ * 2.0) + vec4(0.5)) / vec4(7.0)) - vec4(1.0);
    vec4 y = (((y_ * 2.0) + vec4(0.5)) / vec4(7.0)) - vec4(1.0);
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 g0 = vec3(a0.xy, h.x);
    vec3 g1 = vec3(a0.zw, h.y);
    vec3 g2 = vec3(a1.xy, h.z);
    vec3 g3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(g0, g0), dot(g1, g1), dot(g2, g2), dot(g3, g3));
    vec4 norm = taylorInvSqrt(param_4);
    g0 *= norm.x;
    g1 *= norm.y;
    g2 *= norm.z;
    g3 *= norm.w;
    vec4 m = max(vec4(0.60000002384185791015625) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    vec4 m2 = m * m;
    vec4 m3 = m2 * m;
    vec4 m4 = m2 * m2;
    vec3 grad = ((((((((x0 * ((-6.0) * m3.x)) * dot(x0, g0)) + (g0 * m4.x)) + ((x1 * ((-6.0) * m3.y)) * dot(x1, g1))) + (g1 * m4.y)) + ((x2 * ((-6.0) * m3.z)) * dot(x2, g2))) + (g2 * m4.z)) + ((x3 * ((-6.0) * m3.w)) * dot(x3, g3))) + (g3 * m4.w);
    vec4 px = vec4(dot(x0, g0), dot(x1, g1), dot(x2, g2), dot(x3, g3));
    return vec4(grad, dot(m4, px)) * 42.0;
}

void particle_modifier_voxel_curl(ParticleModifierVoxelCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    if (modifier_params.transformed_data_location_num == 0)
    {
        return;
    }
    ParticleModifierVoxelCurl_Params param = modifier_params;
    vec3 param_1 = p.pos;
    int fi = find_closest_face(param, param_1);
    if (fi == (-1))
    {
        return;
    }
    uint param_2 = uint(fi);
    RTFace rt_face = rt_get_face(param_2);
    uint p0_idx = rt_face.v0;
    uint p1_idx = rt_face.v1;
    uint p2_idx = rt_face.v2;
    uint param_3 = p0_idx;
    vec3 p0 = rt_get_vertex(param_3);
    uint param_4 = p1_idx;
    vec3 p1 = rt_get_vertex(param_4);
    uint param_5 = p2_idx;
    vec3 p2 = rt_get_vertex(param_5);
    vec3 param_6 = p.pos;
    vec3 param_7 = p0;
    vec3 param_8 = p1;
    vec3 param_9 = p2;
    float d = point_triangle_distance(param_6, param_7, param_8, param_9);
    vec3 n = normalize(cross(p1 - p0, p2 - p0));
    vec3 df_p = p.pos;
    vec3 sn_p = (p.pos * modifier_params.noise_scale) + (vec3(_2147.globals.time, _2147.globals.time * 0.3014999926090240478515625, (-_2147.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_10 = sn_p;
    vec4 sn1 = snoise_grad(param_10);
    vec3 param_11 = sn_p + vec3(10.31840038299560546875, -7.012340068817138671875, 11.70139980316162109375);
    vec4 sn2 = snoise_grad(param_11);
    float df_e = 1.0;
    vec4 df_s;
    df_s.w = d;
    df_s.x = n.x;
    df_s.y = n.y;
    df_s.z = n.z;
    vec3 df_attraction = n;
    if (dot(p.pos - p0, n) < 0.0)
    {
        df_attraction *= (-1.0);
    }
    vec4 df;
    df.w = d;
    df.x = n.x;
    df.y = n.y;
    df.z = n.z;
    vec3 curl_dir = cross(sn1.xyz, normalize(n)) * 3.2000000476837158203125;
    vec3 attraction_dir = df_attraction * 0.100000001490116119384765625;
    float attraction_min_range = 5.0;
    float attraction_smooth_range = 7.0;
    if (d < attraction_min_range)
    {
        attraction_dir *= 0.0;
    }
    else
    {
        float f = (d - attraction_min_range) / attraction_smooth_range;
        attraction_dir *= min(1.0, f * f);
    }
    vec3 dir = ((-attraction_dir) * 2.099999904632568359375) + curl_dir;
    p.pos += (((dir * modifier_params.noise_strength) * modifier_factor.factor) * min(0.0333333350718021392822265625, lifecycle_params.time_step));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_from_particle_property(ModifierFactorFromParticleProperty_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    uint id = modifier_factor.id;
    uint param = id;
    ParticleState state = prt_get_state(param);
    ParticleState param_1 = state;
    if (prt_is_alive(param_1) == false)
    {
        return;
    }
    float v = 0.0;
    if (modifier_params.property == 0u)
    {
        v = state.life_time;
    }
    else
    {
        if (modifier_params.property == 1u)
        {
            v = max(0.0, state.life_span - state.life_time);
        }
        else
        {
            if (modifier_params.property == 2u)
            {
                v = state.generation_id;
            }
        }
    }
    v *= modifier_params.property_scale;
    ModifierFactor param_2 = modifier_factor;
    uint param_3 = modifier_params.modifier_function;
    float param_4 = v;
    modifier_process_modifier_factor(param_2, param_3, param_4);
    modifier_factor = param_2;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

void particle_modifier_attractor(ParticleModifierAttractor_Params modifier_params, ModifierFactor modifier_factor, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    vec3 pos = p.pos;
    vec3 dir = normalize(modifier_params.position - pos);
    vec3 up = vec3(0.0, 1.0, 0.0);
    float param = float(id) * 0.3172299861907958984375;
    vec3 right = (cross(dir, up) * modifier_params.radius) * (random(param) - 0.5);
    dir = normalize((modifier_params.position + right) - pos);
    pos += (((dir * lifecycle_params.time_step) * modifier_params.velocity) * modifier_factor.factor);
    p.pos = pos;
}

uint particle_modifier_geometry_attractor_get_first_face_idx(ParticleModifierGeometryAttractorParams emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _1490.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_modifier_geometry_attractor_get_last_face_idx(ParticleModifierGeometryAttractorParams emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _1490.transformed_data_location[tdl_idx].last_face_idx;
}

void particle_modifier_geometry_attractor(ParticleModifierGeometryAttractorParams modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id, inout uint closest_face_idx)
{
    ParticleModifierGeometryAttractorParams param = modifier_params;
    uint first_face_idx = particle_modifier_geometry_attractor_get_first_face_idx(param);
    ParticleModifierGeometryAttractorParams param_1 = modifier_params;
    uint last_face_idx = particle_modifier_geometry_attractor_get_last_face_idx(param_1);
    if (first_face_idx >= last_face_idx)
    {
        return;
    }
    float fid = float((id * 45827u) & 16777215u);
    float param_2 = fid * 0.34130001068115234375;
    vec2 bc;
    bc.x = random(param_2);
    float param_3 = fid * 0.1412999927997589111328125;
    bc.y = random(param_3);
    if ((bc.x + bc.y) >= 1.0)
    {
        bc.x = 1.0 - bc.x;
        bc.y = 1.0 - bc.y;
    }
    float closest_face_distance = 100000000.0;
    vec3 o = p.pos;
    float param_4 = fid + float(modifier_params.iteration & 4095);
    bool do_reattach = random(param_4) < modifier_params.probability_of_reattach;
    if (do_reattach)
    {
        ParticleState param_5 = p.state;
        vec3 param_6 = vec3(0.0, 1.0, 0.0);
        prt_set_color(param_5, param_6);
        p.state = param_5;
    }
    vec3 dir;
    for (int iteration = 0; iteration < 2; iteration++)
    {
        float min_distance = mix(modifier_params.min_distance, modifier_params.min_distance * modifier_factor.factor, modifier_params.min_distance_modifier_factor);
        if (((closest_face_idx != 0u) && (iteration == 0)) && (do_reattach == false))
        {
            uint param_7 = (first_face_idx + closest_face_idx) - 1u;
            RTFace rt_face = rt_get_face(param_7);
            uint p0_idx = rt_face.v0;
            uint p1_idx = rt_face.v1;
            uint p2_idx = rt_face.v2;
            uint param_8 = p0_idx;
            vec3 p0 = rt_get_vertex(param_8);
            uint param_9 = p1_idx;
            vec3 p1 = rt_get_vertex(param_9);
            uint param_10 = p2_idx;
            vec3 p2 = rt_get_vertex(param_10);
            vec3 closest_pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
            closest_face_distance = length(closest_pos - o);
            dir = (closest_pos - o) / vec3(closest_face_distance + 9.9999997473787516355514526367188e-05);
        }
        bool _2605 = closest_face_idx != 0u;
        bool _2612;
        if (_2605)
        {
            _2612 = closest_face_distance > modifier_params.search_distance;
        }
        else
        {
            _2612 = _2605;
        }
        if (_2612)
        {
            float param_11 = fid + float(modifier_params.iteration & 4095);
            do_reattach = (random(param_11) * 0.25) < modifier_params.probability_of_reattach;
        }
        if ((closest_face_idx != 0u) && (closest_face_distance < min_distance))
        {
            float param_12 = fid + float(modifier_params.iteration & 4095);
            do_reattach = (random(param_12) * 0.25) < modifier_params.probability_of_reattach;
        }
        if (((closest_face_idx == 0u) || (iteration > 0)) || do_reattach)
        {
            uint face_idx_range = last_face_idx - first_face_idx;
            float param_13 = fid;
            uint face_idx = uint(float(face_idx_range - 1u) * random(param_13));
            if (do_reattach || (closest_face_idx == 0u))
            {
                face_idx += uint(modifier_params.iteration);
                face_idx %= face_idx_range;
            }
            uint param_14 = first_face_idx + face_idx;
            RTFace rt_face_1 = rt_get_face(param_14);
            uint p0_idx_1 = rt_face_1.v0;
            uint p1_idx_1 = rt_face_1.v1;
            uint p2_idx_1 = rt_face_1.v2;
            uint param_15 = p0_idx_1;
            vec3 p0_1 = rt_get_vertex(param_15);
            uint param_16 = p1_idx_1;
            vec3 p1_1 = rt_get_vertex(param_16);
            uint param_17 = p2_idx_1;
            vec3 p2_1 = rt_get_vertex(param_17);
            if (length(cross(p0_1 - p1_1, p0_1 - p2_1)) < 1.10000002384185791015625)
            {
                continue;
            }
            vec3 closest_pos_1 = ((p0_1 * bc.x) + (p1_1 * bc.y)) + (p2_1 * ((1.0 - bc.x) - bc.y));
            dir = normalize(closest_pos_1 - o);
            float d = length(closest_pos_1 - p.pos);
            if (d < modifier_params.search_distance)
            {
                bool _2765 = (d < closest_face_distance) && (d > min_distance);
                bool _2776;
                if (!_2765)
                {
                    _2776 = (d > closest_face_distance) && (d < min_distance);
                }
                else
                {
                    _2776 = _2765;
                }
                if (_2776)
                {
                    closest_face_distance = d;
                    closest_face_idx = face_idx + 1u;
                    ParticleState param_18 = p.state;
                    vec3 param_19 = vec3(1.0, 0.0, 0.0);
                    prt_set_color(param_18, param_19);
                    p.state = param_18;
                }
            }
        }
    }
    if (closest_face_idx > 0u)
    {
        uint param_20 = (first_face_idx + closest_face_idx) - 1u;
        RTFace rt_face_2 = rt_get_face(param_20);
        uint p0_idx_2 = rt_face_2.v0;
        uint p1_idx_2 = rt_face_2.v1;
        uint p2_idx_2 = rt_face_2.v2;
        uint param_21 = p0_idx_2;
        vec3 p0_2 = rt_get_vertex(param_21);
        uint param_22 = p1_idx_2;
        vec3 p1_2 = rt_get_vertex(param_22);
        uint param_23 = p2_idx_2;
        vec3 p2_2 = rt_get_vertex(param_23);
        vec3 closest_pos_2 = ((p0_2 * bc.x) + (p1_2 * bc.y)) + (p2_2 * ((1.0 - bc.x) - bc.y));
        vec3 d_1 = closest_pos_2 - p.pos;
        float time_step = min(1.0, lifecycle_params.time_step);
        float strength = mix(modifier_params.strength * time_step, (modifier_params.strength * time_step) * modifier_factor.factor, modifier_params.strength_modifier_factor);
        float d_length = length(d_1);
        bool _2871 = d_length > 0.0;
        bool _2878;
        if (_2871)
        {
            _2878 = d_length < modifier_params.search_distance;
        }
        else
        {
            _2878 = _2871;
        }
        if (_2878)
        {
            d_1 = (d_1 / vec3(d_length)) * min(strength, d_length);
            p.pos += d_1;
        }
    }
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(ParticleState state)
{
    vec4 c = vec4(1.0);
    uint param = state.color;
    vec3 _612 = color_convert_uint_to_float3(param);
    c.x = _612.x;
    c.y = _612.y;
    c.z = _612.z;
    return c;
}

void particle_modifier_colorize(ParticleModifierColorize_Params modifier_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    float v = 0.0;
    if (uint(modifier_params.mode) == 0u)
    {
        v = float(id) * modifier_params.randomness;
    }
    if (uint(modifier_params.mode) == 1u)
    {
        vec3 param = p.pos * modifier_params.randomness;
        v = snoise(param);
    }
    if (uint(modifier_params.mode) == 2u)
    {
        if (p.state.life_time == 0.0)
        {
            vec3 param_1 = p.pos * modifier_params.randomness;
            v = snoise(param_1);
        }
        else
        {
            return;
        }
    }
    if (uint(modifier_params.mode) == 3u)
    {
        v = 1.0;
    }
    v = fract(v);
    vec3 color;
    if (modifier_params.color_gradient_idx != (-1))
    {
        int param_2 = modifier_params.color_gradient_idx;
        float param_3 = v;
        color = gradient_sample(param_2, param_3).xyz * modifier_params.color.xyz;
    }
    else
    {
        color = modifier_params.color.xyz;
    }
    if (uint(modifier_params.blend_mode) == 0u)
    {
        ParticleState param_4 = p.state;
        vec4 color_previous = prt_get_color(param_4);
        color = mix(color_previous.xyz, color, vec3((modifier_params.blend_from_previous * modifier_factor.factor) * _3007.lifecycle_params.time_step));
    }
    else
    {
        if (uint(modifier_params.blend_mode) == 2u)
        {
            color = mix(vec3(1.0), color, vec3((modifier_params.blend_from_previous * modifier_factor.factor) * _3007.lifecycle_params.time_step));
        }
        else
        {
            if (uint(modifier_params.blend_mode) == 1u)
            {
                color = mix(vec3(0.0), color, vec3((modifier_params.blend_from_previous * modifier_factor.factor) * _3007.lifecycle_params.time_step));
            }
        }
    }
    ParticleState param_5 = p.state;
    vec3 param_6 = color;
    prt_set_color(param_5, param_6);
    p.state = param_5;
}

vec3 pm_curl_snoiseVec3(vec3 x)
{
    vec3 param = vec3(x);
    float s = snoise(param);
    vec3 param_1 = vec3(x.y - 19.1000003814697265625, x.z + 33.40000152587890625, x.x + 47.200000762939453125);
    float s1 = snoise(param_1);
    vec3 param_2 = vec3(x.z + 74.1999969482421875, x.x - 124.5, x.y + 99.40000152587890625);
    float s2 = snoise(param_2);
    vec3 c = vec3(s, s1, s2);
    return c;
}

vec3 pm_curl_curlNoise(vec3 p, out vec3 gradient, out float out_scale)
{
    vec3 dx = vec3(0.100000001490116119384765625, 0.0, 0.0);
    vec3 dy = vec3(0.0, 0.100000001490116119384765625, 0.0);
    vec3 dz = vec3(0.0, 0.0, 0.100000001490116119384765625);
    vec3 param = p - dx;
    vec3 p_x0 = pm_curl_snoiseVec3(param);
    vec3 param_1 = p + dx;
    vec3 p_x1 = pm_curl_snoiseVec3(param_1);
    vec3 param_2 = p - dy;
    vec3 p_y0 = pm_curl_snoiseVec3(param_2);
    vec3 param_3 = p + dy;
    vec3 p_y1 = pm_curl_snoiseVec3(param_3);
    vec3 param_4 = p - dz;
    vec3 p_z0 = pm_curl_snoiseVec3(param_4);
    vec3 param_5 = p + dz;
    vec3 p_z1 = pm_curl_snoiseVec3(param_5);
    float x = ((p_y1.z - p_y0.z) - p_z1.y) + p_z0.y;
    float y = ((p_z1.x - p_z0.x) - p_x1.z) + p_x0.z;
    float z = ((p_x1.y - p_x0.y) - p_y1.x) + p_y0.x;
    gradient = vec3(p_x0.x, p_y0.y, p_z0.z) * 3.1400001049041748046875;
    out_scale = p_x0.x;
    return normalize(vec3(x, y, z));
}

void particle_modifier_curl(ParticleModifierCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 param = (p.pos * modifier_params.noise_scale) + (vec3(_2147.globals.time, _2147.globals.time * 0.3014999926090240478515625, (-_2147.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_1;
    float param_2;
    vec3 _3230 = pm_curl_curlNoise(param, param_1, param_2);
    vec3 gradient = param_1;
    float out_scale = param_2;
    p.pos += (((_3230 * modifier_params.noise_strength) * modifier_factor.factor) * lifecycle_params.time_step);
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_position(uint id, vec3 p)
{
    _548.prt_positions[(id * 3u) + 0u] = p.x;
    _548.prt_positions[(id * 3u) + 1u] = p.y;
    _548.prt_positions[(id * 3u) + 2u] = p.z;
}

void prt_set_prev_position(uint id, vec3 p)
{
    _571.prt_prev_positions[(id * 3u) + 0u] = p.x;
    _571.prt_prev_positions[(id * 3u) + 1u] = p.y;
    _571.prt_prev_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    g_buff_grid_markers_ptr = 0ul;
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    float prev_generation_id = p.state.generation_id;
    if (_3007.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    if (id >= _3007.lifecycle_params.capacity)
    {
        ParticleState param_3 = p.state;
        prt_kill(param_3);
        p.state = param_3;
        uint param_4 = id;
        ParticleState param_5 = p.state;
        prt_set_state(param_4, param_5);
        return;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    ParticleState param_6 = p.state;
    vec3 _3309;
    if (prt_is_alive(param_6))
    {
        _3309 = p.pos;
    }
    else
    {
        _3309 = vec3(0.0);
    }
    modifier_factor.position = _3309;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_7 = p.state;
    if (!prt_is_alive(param_7))
    {
        int _3340 = atomicAdd(_3336.VM0_params.pending, -1);
        int pending = _3340;
        if (pending > 0)
        {
            ParticleEmitterGeometry_Params _3351;
            _3351.constrained = _3336.VM0_params.constrained;
            _3351.debug_counter = _3336.VM0_params.debug_counter;
            _3351.debug_counter2 = _3336.VM0_params.debug_counter2;
            _3351.debug_counter3 = _3336.VM0_params.debug_counter3;
            _3351.position = _3336.VM0_params.position;
            _3351.falloff_mode = _3336.VM0_params.falloff_mode;
            _3351.radius = _3336.VM0_params.radius;
            _3351.falloff_inverse = _3336.VM0_params.falloff_inverse;
            _3351.particle_color = _3336.VM0_params.particle_color;
            _3351.particle_lifetime = _3336.VM0_params.particle_lifetime;
            _3351.particle_lifetime_randomness = _3336.VM0_params.particle_lifetime_randomness;
            _3351.rate = _3336.VM0_params.rate;
            _3351.seed = _3336.VM0_params.seed;
            _3351.surface_distance = _3336.VM0_params.surface_distance;
            _3351.pending = _3336.VM0_params.pending;
            _3351.transformed_data_location_idx = _3336.VM0_params.transformed_data_location_idx;
            _3351.transformed_data_location_num = _3336.VM0_params.transformed_data_location_num;
            _3351.alpha_to_modifier_factor = _3336.VM0_params.alpha_to_modifier_factor;
            ParticleEmitterGeometry_Params param_8 = _3351;
            ModifierFactor param_9 = modifier_factor;
            Particle param_10 = p;
            uint param_11 = id;
            uint param_12 = uint(pending);
            particle_emitter_geometry_emit_VM0(param_8, param_9, param_10, param_11, param_12);
            modifier_factor = param_9;
            p = param_10;
        }
    }
    ParticleState param_13 = p.state;
    if (prt_is_alive(param_13))
    {
        ParticleModifierVoxelCurl_Params _3376;
        _3376.position = _3371.VM1_params.position;
        _3376.falloff_mode = _3371.VM1_params.falloff_mode;
        _3376.radius = _3371.VM1_params.radius;
        _3376.falloff_inverse = _3371.VM1_params.falloff_inverse;
        _3376.noise_strength = _3371.VM1_params.noise_strength;
        _3376.noise_speed = _3371.VM1_params.noise_speed;
        _3376.noise_scale = _3371.VM1_params.noise_scale;
        _3376.material_index = _3371.VM1_params.material_index;
        _3376.transformed_data_location_idx = _3371.VM1_params.transformed_data_location_idx;
        _3376.transformed_data_location_num = _3371.VM1_params.transformed_data_location_num;
        ParticleModifierVoxelCurl_Params param_14 = _3376;
        ParticleLifecycleParams _3381;
        _3381.time_step = _3007.lifecycle_params.time_step;
        _3381.life_time_step = _3007.lifecycle_params.life_time_step;
        _3381.max_lifetime = _3007.lifecycle_params.max_lifetime;
        _3381.reset = _3007.lifecycle_params.reset;
        _3381.capacity = _3007.lifecycle_params.capacity;
        _3381.has_previous = _3007.lifecycle_params.has_previous;
        ParticleLifecycleParams param_15 = _3381;
        ModifierFactor param_16 = modifier_factor;
        Particle param_17 = p;
        uint param_18 = id;
        particle_modifier_voxel_curl(param_14, param_15, param_16, param_17, param_18);
        p = param_17;
    }
    ParticleState param_19 = p.state;
    if (prt_is_alive(param_19))
    {
        ParticleModifierVoxelCurl_Params _3402;
        _3402.position = _3398.VM2_params.position;
        _3402.falloff_mode = _3398.VM2_params.falloff_mode;
        _3402.radius = _3398.VM2_params.radius;
        _3402.falloff_inverse = _3398.VM2_params.falloff_inverse;
        _3402.noise_strength = _3398.VM2_params.noise_strength;
        _3402.noise_speed = _3398.VM2_params.noise_speed;
        _3402.noise_scale = _3398.VM2_params.noise_scale;
        _3402.material_index = _3398.VM2_params.material_index;
        _3402.transformed_data_location_idx = _3398.VM2_params.transformed_data_location_idx;
        _3402.transformed_data_location_num = _3398.VM2_params.transformed_data_location_num;
        ParticleModifierVoxelCurl_Params param_20 = _3402;
        ParticleLifecycleParams _3406;
        _3406.time_step = _3007.lifecycle_params.time_step;
        _3406.life_time_step = _3007.lifecycle_params.life_time_step;
        _3406.max_lifetime = _3007.lifecycle_params.max_lifetime;
        _3406.reset = _3007.lifecycle_params.reset;
        _3406.capacity = _3007.lifecycle_params.capacity;
        _3406.has_previous = _3007.lifecycle_params.has_previous;
        ParticleLifecycleParams param_21 = _3406;
        ModifierFactor param_22 = modifier_factor;
        Particle param_23 = p;
        uint param_24 = id;
        particle_modifier_voxel_curl(param_20, param_21, param_22, param_23, param_24);
        p = param_23;
    }
    ParticleState param_25 = p.state;
    if (prt_is_alive(param_25))
    {
        modifier_factor.position = p.pos;
    }
    ModifierFactorFromParticleProperty_Params _3432;
    _3432.property = _3427.VM3_params.property;
    _3432.modifier_function = _3427.VM3_params.modifier_function;
    _3432.property_scale = _3427.VM3_params.property_scale;
    _3432._pad2 = _3427.VM3_params._pad2;
    ModifierFactorFromParticleProperty_Params param_26 = _3432;
    ModifierFactor param_27 = modifier_factor;
    CoordinateSystemTrasforms param_28 = cs_transforms;
    modifier_factor_from_particle_property(param_26, param_27, param_28);
    modifier_factor = param_27;
    ModifierFactorMulAdd_Params _3447;
    _3447.multiply_value = _3442.VM4_params.multiply_value;
    _3447.add_value = _3442.VM4_params.add_value;
    ModifierFactorMulAdd_Params param_29 = _3447;
    ModifierFactor param_30 = modifier_factor;
    modifier_factor_mul_add(param_29, param_30);
    modifier_factor = param_30;
    ModifierFactorClamp_Params _3460;
    _3460.clamp_min = _3455.VM5_params.clamp_min;
    _3460.clamp_max = _3455.VM5_params.clamp_max;
    _3460.clamp_min_enable = _3455.VM5_params.clamp_min_enable;
    _3460.clamp_max_enable = _3455.VM5_params.clamp_max_enable;
    ModifierFactorClamp_Params param_31 = _3460;
    ModifierFactor param_32 = modifier_factor;
    modifier_factor_clamp(param_31, param_32);
    modifier_factor = param_32;
    vec3 modifier_position = _3469.VM6_params.position;
    p.pos += ((_3469.VM6_params.velocity * _3007.lifecycle_params.time_step) * modifier_factor.factor);
    ParticleState param_33 = p.state;
    if (prt_is_alive(param_33))
    {
        ParticleModifierAttractor_Params _3499;
        _3499.position = _3494.VM7_params.position;
        _3499.radius = _3494.VM7_params.radius;
        _3499.velocity = _3494.VM7_params.velocity;
        ParticleModifierAttractor_Params param_34 = _3499;
        ModifierFactor param_35 = modifier_factor;
        ParticleLifecycleParams _3505;
        _3505.time_step = _3007.lifecycle_params.time_step;
        _3505.life_time_step = _3007.lifecycle_params.life_time_step;
        _3505.max_lifetime = _3007.lifecycle_params.max_lifetime;
        _3505.reset = _3007.lifecycle_params.reset;
        _3505.capacity = _3007.lifecycle_params.capacity;
        _3505.has_previous = _3007.lifecycle_params.has_previous;
        ParticleLifecycleParams param_36 = _3505;
        Particle param_37 = p;
        uint param_38 = id;
        particle_modifier_attractor(param_34, param_35, param_36, param_37, param_38);
        p = param_37;
    }
    ParticleState param_39 = p.state;
    if (prt_is_alive(param_39))
    {
        if (id < _3523.VM8_params.nearest_face_buffer_size)
        {
            uint closest_face_idx = _3523.VM8_closest_face_idx[id];
            ParticleModifierGeometryAttractorParams _3537;
            _3537.strength = _3523.VM8_params.strength;
            _3537.strength_modifier_factor = _3523.VM8_params.strength_modifier_factor;
            _3537.min_distance = _3523.VM8_params.min_distance;
            _3537.min_distance_modifier_factor = _3523.VM8_params.min_distance_modifier_factor;
            _3537.search_distance = _3523.VM8_params.search_distance;
            _3537.transformed_data_location_idx = _3523.VM8_params.transformed_data_location_idx;
            _3537.transformed_data_location_num = _3523.VM8_params.transformed_data_location_num;
            _3537.iteration = _3523.VM8_params.iteration;
            _3537.probability_of_reattach = _3523.VM8_params.probability_of_reattach;
            _3537._pad1 = _3523.VM8_params._pad1;
            _3537._pad2 = _3523.VM8_params._pad2;
            _3537.nearest_face_buffer_size = _3523.VM8_params.nearest_face_buffer_size;
            ParticleModifierGeometryAttractorParams param_40 = _3537;
            ParticleLifecycleParams _3541;
            _3541.time_step = _3007.lifecycle_params.time_step;
            _3541.life_time_step = _3007.lifecycle_params.life_time_step;
            _3541.max_lifetime = _3007.lifecycle_params.max_lifetime;
            _3541.reset = _3007.lifecycle_params.reset;
            _3541.capacity = _3007.lifecycle_params.capacity;
            _3541.has_previous = _3007.lifecycle_params.has_previous;
            ParticleLifecycleParams param_41 = _3541;
            ModifierFactor param_42 = modifier_factor;
            Particle param_43 = p;
            uint param_44 = id;
            uint param_45 = closest_face_idx;
            particle_modifier_geometry_attractor(param_40, param_41, param_42, param_43, param_44, param_45);
            modifier_factor = param_42;
            p = param_43;
            closest_face_idx = param_45;
            _3523.VM8_closest_face_idx[id] = closest_face_idx;
        }
    }
    ParticleState param_46 = p.state;
    if (prt_is_alive(param_46))
    {
        ParticleModifierColorize_Params _3571;
        _3571.color = _3566.VM9_params.color;
        _3571.mode = _3566.VM9_params.mode;
        _3571.blend_mode = _3566.VM9_params.blend_mode;
        _3571.color_gradient_idx = _3566.VM9_params.color_gradient_idx;
        _3571.randomness = _3566.VM9_params.randomness;
        _3571.blend_from_previous = _3566.VM9_params.blend_from_previous;
        ParticleModifierColorize_Params param_47 = _3571;
        ModifierFactor param_48 = modifier_factor;
        Particle param_49 = p;
        uint param_50 = id;
        particle_modifier_colorize(param_47, param_48, param_49, param_50);
        modifier_factor = param_48;
        p = param_49;
    }
    ParticleState param_51 = p.state;
    if (prt_is_alive(param_51))
    {
        ParticleModifierCurl_Params _3595;
        _3595.position = _3590.VM10_params.position;
        _3595.falloff_mode = _3590.VM10_params.falloff_mode;
        _3595.radius = _3590.VM10_params.radius;
        _3595.falloff_inverse = _3590.VM10_params.falloff_inverse;
        _3595.noise_strength = _3590.VM10_params.noise_strength;
        _3595.noise_speed = _3590.VM10_params.noise_speed;
        _3595.noise_scale = _3590.VM10_params.noise_scale;
        ParticleModifierCurl_Params param_52 = _3595;
        ParticleLifecycleParams _3599;
        _3599.time_step = _3007.lifecycle_params.time_step;
        _3599.life_time_step = _3007.lifecycle_params.life_time_step;
        _3599.max_lifetime = _3007.lifecycle_params.max_lifetime;
        _3599.reset = _3007.lifecycle_params.reset;
        _3599.capacity = _3007.lifecycle_params.capacity;
        _3599.has_previous = _3007.lifecycle_params.has_previous;
        ParticleLifecycleParams param_53 = _3599;
        ModifierFactor param_54 = modifier_factor;
        Particle param_55 = p;
        uint param_56 = id;
        particle_modifier_curl(param_52, param_53, param_54, param_55, param_56);
        p = param_55;
    }
    ParticleState param_57 = p.state;
    float param_58 = _3007.lifecycle_params.life_time_step;
    float param_59 = _3007.lifecycle_params.max_lifetime;
    prt_advance_life(param_57, param_58, param_59);
    p.state = param_57;
    uint param_60 = id;
    ParticleState param_61 = p.state;
    prt_set_state(param_60, param_61);
    uint param_62 = id;
    vec3 param_63 = p.pos;
    prt_set_position(param_62, param_63);
    bool _3634 = _3007.lifecycle_params.has_previous != 0u;
    bool _3641;
    if (_3634)
    {
        _3641 = p.state.generation_id != prev_generation_id;
    }
    else
    {
        _3641 = _3634;
    }
    if (_3641)
    {
        uint param_64 = id;
        vec3 param_65 = p.pos;
        prt_set_prev_position(param_64, param_65);
    }
}

 