#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct DispatchDeferredParams
{
    mat4 mat_projection;
    mat4 mat_projection_previous;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 camera_projection_params_previous;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
    vec2 frustum_shift;
};

struct CompositeParams
{
    float ssr_scaling_factor;
    int composite_output_mode;
    float raytrace_scaling_factor;
    float _pad1;
};

const float _543[7] = float[](0.071303434669971466064453125, 0.13151411712169647216796875, 0.189879238605499267578125, 0.2146064341068267822265625, 0.189879238605499267578125, 0.13151411712169647216796875, 0.071303434669971466064453125);

struct DeferredCompositeSetup
{
    vec4 ambient_color;
    vec4 fill_color;
    vec4 fog_color;
    float fog_range;
    float fog_height;
    float fog_height_density;
    float occlusion_strength;
    float occlusion_specular_from_diffuse;
    float global_illumination_strength;
    float global_illumination_base_strength;
    float occlusion_base_strength;
    float ssr_strength;
    float sso_strength;
    float volumetric_fog_strength;
    float volumetric_fog_intensity;
    float volumetric_fog_luminance_ceiling;
    uint volumetric_fog_blend_function;
    float _pad1;
    float _pad2;
    vec4 volumetric_fog_tint;
    float rt_strength;
    float ibl_intensity;
    uint transparency_blend;
    float taa_blend;
    float taa_gamma;
    float volumetric_light_strength;
    float volumetric_light_fog_density;
    float volumetric_light_fog_height;
    vec2 taa_jitter;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

layout(set = 0, binding = 2, std140) uniform DeferredParams
{
    layout(row_major) DispatchDeferredParams dispatch_setup;
} _314;

layout(set = 0, binding = 3, std140) uniform CompositeParamsBuffer
{
    CompositeParams composite_params;
} _349;

layout(set = 0, binding = 4, std140) uniform DeferredCompositeSetupBuffer
{
    DeferredCompositeSetup composite_setup;
} _697;

layout(set = 0, binding = 1, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 0, binding = 5, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _2022;

layout(set = 0, binding = 11) uniform sampler2D sSSR;
layout(set = 0, binding = 12) uniform sampler2DArray s_BlueNoise;
layout(set = 0, binding = 13) uniform sampler2D sVolumetricFog;
layout(set = 0, binding = 14) uniform usampler2D sMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 15) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 16) uniform usampler2D sNormalMaterial;
layout(set = 0, binding = 17) uniform sampler2D sAlbedo;
layout(set = 0, binding = 18) uniform sampler2D sShadow;
layout(set = 0, binding = 19) uniform sampler2D sVoxelLighting;
layout(set = 0, binding = 20) uniform sampler2D sVoxelOcclusion;
layout(set = 0, binding = 21) uniform sampler2D sScreenSpaceOcclusion;
layout(set = 0, binding = 22) uniform sampler2D sParticles;
layout(set = 0, binding = 23) uniform sampler2D sVolumetricLight;
layout(set = 0, binding = 24) uniform sampler2D sEmissive;
layout(set = 0, binding = 25) uniform sampler2D sRaytrace;
layout(set = 0, binding = 26) uniform sampler2D sDebug;
layout(set = 0, binding = 6, rgba32f) uniform readonly image2D imRaytraceHitDirectionPrimitiveIdReflection;
layout(set = 0, binding = 7, rgba32f) uniform readonly image2D imRaytraceHitDirectionPrimitiveIdTransparency;
layout(set = 0, binding = 8, rgba16f) uniform readonly image2D imRaytraceShadedReflection;
layout(set = 0, binding = 9, rgba16f) uniform readonly image2D imRaytraceShadedTransparency;
layout(set = 0, binding = 27) uniform sampler2D sWireframeColor;
layout(set = 0, binding = 28) uniform sampler2D sWireframeDepth;
layout(set = 0, binding = 10, rgba16f) uniform writeonly image2D imTarget;

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _143;
    if (nor.x > 0.0)
    {
        _143 = -t;
    }
    else
    {
        _143 = t;
    }
    nor.x += _143;
    float _158;
    if (nor.y > 0.0)
    {
        _158 = -t;
    }
    else
    {
        _158 = t;
    }
    nor.y += _158;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

float linearizeDepth(float d)
{
    return _314.dispatch_setup.near_far_plane.z / ((_314.dispatch_setup.near_far_plane.y + _314.dispatch_setup.near_far_plane.x) - (d * _314.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepthCurrent(vec3 vDirection, float depth)
{
    return (_314.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

vec4 sample_ssr(inout vec2 p, float depth)
{
    p *= _349.composite_params.ssr_scaling_factor;
    float s = 0.0;
    vec4 v = vec4(0.0);
    float r = 10.5 * clamp(1.0 / depth, 0.5, 2.0);
    v = textureLod(sSSR, p, 0.0);
    s = v.w;
    vec4 _374 = v;
    vec3 _376 = _374.xyz * s;
    v.x = _376.x;
    v.y = _376.y;
    v.z = _376.z;
    for (int y = -2; y <= 2; y++)
    {
        for (int x = -2; x <= 2; x++)
        {
            if ((x == 0) && (y == 0))
            {
                continue;
            }
            if (s < 1.0)
            {
                ivec2 smpl_pos = ivec2(p * _314.dispatch_setup.resolution) + ivec2(x, y);
                vec3 blue_noise = texelFetch(s_BlueNoise, ivec3(smpl_pos % ivec2(128), 0), 0).xyz;
                vec4 pxl = textureLod(sSSR, vec2(smpl_pos) * _314.dispatch_setup.inv_resolution, 0.0);
                if (pxl.w > s)
                {
                    vec3 _463 = pxl.xyz * pxl.w;
                    v.x = _463.x;
                    v.y = _463.y;
                    v.z = _463.z;
                    s = pxl.w;
                }
            }
        }
    }
    return vec4(v.xyz, s);
}

vec4 calculate_lighting_fill(vec3 pos, vec3 normal, vec3 light_pos, vec3 cam_pos, float NdotL)
{
    float d = NdotL;
    if (d < 0.0)
    {
        d = 0.0;
    }
    vec3 specular = vec3(0.0);
    if (d > 0.0)
    {
        specular = _697.composite_setup.fill_color.xxx * pow(max(0.0, dot(reflect(-normalize(pos - light_pos), normalize(normal)), -normalize(cam_pos - pos))), 14.0);
    }
    return vec4((vec3(d) * _697.composite_setup.fill_color.xyz) + specular, 1.0);
}

vec4 sample_volumetric_fog(uvec2 pixel_pos, float ref_depth, float ref_depth_diff_tolerance, uint ref_material_idx, float luminance_ceiling)
{
    vec4 vc = vec4(0.0);
    float total_w = 0.92111837863922119140625;
    vec4 c0 = texelFetch(sVolumetricFog, ivec2(pixel_pos), 0);
    float alpha_w = 1.0;
    float alpha = c0.w * alpha_w;
    c0 *= total_w;
    for (int y = -3; y <= 3; y++)
    {
        for (int x = -3; x <= 3; x++)
        {
            if ((x == 0) && (y == 0))
            {
                continue;
            }
            ivec2 sampling_pos = ivec2(pixel_pos) + ivec2(x, y);
            float w = _543[x + 3] * _543[y + 3];
            uvec4 param = texelFetch(sMetalnessRoughnessMaterialTags, sampling_pos, 0);
            MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param);
            if (ref_material_idx != metalness_roughness_material_tags.material_index)
            {
                w = 0.0;
            }
            float depth = texelFetch(sTextureDepth, sampling_pos, 0).x;
            if (abs(depth - ref_depth) > ref_depth_diff_tolerance)
            {
                w = 0.0;
            }
            if (w > 0.0)
            {
                vec4 c = texelFetch(sVolumetricFog, sampling_pos, 0);
                vc += (c * w);
                total_w += w;
                alpha += (c.w * 1.0);
                alpha_w += 1.0;
            }
        }
    }
    if (alpha_w > 0.0)
    {
        alpha /= alpha_w;
        alpha = sqrt(alpha);
    }
    else
    {
        alpha = 0.0;
    }
    alpha = 1.0;
    vc += c0;
    vc *= (alpha / total_w);
    float peak_brightness = luminance_ceiling;
    vec4 _637 = vc;
    vec3 _640 = _637.xyz / vec3(peak_brightness);
    vc.x = _640.x;
    vc.y = _640.y;
    vc.z = _640.z;
    vec4 _648 = vc;
    vec4 _650 = vc;
    vec3 _655 = (_648.xyz / (_650.xyz + vec3(1.0))) * peak_brightness;
    vc.x = _655.x;
    vc.y = _655.y;
    vc.z = _655.z;
    return vc;
}

uint asuint(float v)
{
    return floatBitsToUint(v);
}

vec3 TurboColormap(inout float x)
{
    x = clamp(x, 0.0, 1.0);
    vec4 v4 = vec4(1.0, x, x * x, (x * x) * x);
    vec2 v2 = v4.zw * v4.z;
    return vec3(dot(v4, vec4(0.135721385478973388671875, 4.6153926849365234375, -42.6603240966796875, 132.1310882568359375)) + dot(v2, vec2(-152.9423980712890625, 59.286380767822265625)), dot(v4, vec4(0.091402612626552581787109375, 2.1941883563995361328125, 4.842966556549072265625, -14.1850337982177734375)) + dot(v2, vec2(4.277298450469970703125, 2.82956600189208984375)), dot(v4, vec4(0.106673300266265869140625, 12.64194583892822265625, -60.5820465087890625, 110.36277008056640625)) + dot(v2, vec2(-89.903106689453125, 27.3482494354248046875)));
}

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    uvec2 pixel_pos_inv_y = pixel_pos;
    pixel_pos_inv_y.y = uint(_314.dispatch_setup.resolution.y) - pixel_pos_inv_y.y;
    vec3 view_direction;
    view_direction.x = (-_314.dispatch_setup.camera_projection_params.z) + ((_314.dispatch_setup.camera_projection_params.x * float(pixel_pos.x)) * _314.dispatch_setup.inv_resolution.x);
    view_direction.y = (-_314.dispatch_setup.camera_projection_params.w) + ((_314.dispatch_setup.camera_projection_params.y * float(pixel_pos.y)) * _314.dispatch_setup.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    float dither = 0.0;
    uint encoded_normal_material = texelFetch(sNormalMaterial, ivec2(pixel_pos), 0).x;
    uint param = encoded_normal_material;
    vec3 _788 = decode_normal(param);
    vec3 normal = _788;
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    MaterialPropertiesGPU material;
    material.flags = 0u;
    bool is_background = false;
    float depth = 0.0;
    vec4 albedo;
    vec4 color;
    if ((materialId & 1) == 1)
    {
        is_background = true;
        albedo = texelFetch(sAlbedo, ivec2(pixel_pos), 0);
        color = albedo;
    }
    vec3 local_normal = vec3(0.0, 0.0, -1.0);
    vec4 shadow = vec4(1.0, 1.0, 1.0, 0.0);
    vec4 voxel_light = vec4(0.0);
    float voxel_occlusion_diffuse = 0.0;
    float voxel_occlusion_specular = 0.0;
    float voxel_occlusion_combined = 0.0;
    albedo = texelFetch(sAlbedo, ivec2(pixel_pos), 0);
    if (is_background == false)
    {
        local_normal.x = dot(normal, _314.dispatch_setup.mat_model[0].xyz);
        local_normal.y = dot(normal, _314.dispatch_setup.mat_model[1].xyz);
        local_normal.z = dot(normal, _314.dispatch_setup.mat_model[2].xyz);
        depth = texelFetch(sTextureDepth, ivec2(pixel_pos), 0).x;
        shadow = texelFetch(sShadow, ivec2(pixel_pos), 0);
        voxel_light = texelFetch(sVoxelLighting, ivec2(pixel_pos), 0);
        voxel_occlusion_combined = voxel_light.w;
        vec2 voxel_occlusion = texelFetch(sVoxelOcclusion, ivec2(pixel_pos), 0).xy;
        voxel_occlusion_diffuse = voxel_occlusion.x;
        voxel_occlusion_specular = voxel_occlusion.y;
        vec4 color_1 = vec4(0.0);
        vec3 _886 = abs(local_normal);
        color_1.x = _886.x;
        color_1.y = _886.y;
        color_1.z = _886.z;
    }
    float param_2 = depth;
    float linear_depth = linearizeDepth(param_2);
    float hbao = max(texelFetch(sScreenSpaceOcclusion, ivec2(pixel_pos), 0).x, 0.0);
    if (_697.composite_setup.sso_strength > 0.0)
    {
        hbao = pow(hbao, _697.composite_setup.sso_strength);
    }
    vec4 ssr = vec4(0.0);
    vec4 particles = texelFetch(sParticles, ivec2(pixel_pos), 0);
    float ssr_factor = 0.0;
    vec3 param_3 = view_direction;
    float param_4 = linear_depth;
    vec3 world = positionFromDepthCurrent(param_3, param_4);
    uvec4 param_5 = texelFetch(sMetalnessRoughnessMaterialTags, ivec2(pixel_pos), 0);
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param_5);
    uint materialIndex = metalness_roughness_material_tags.material_index;
    if (is_background == false)
    {
        MaterialPropertiesGPU _956;
        _956.diffuse = materials.material_properties[materialIndex].diffuse;
        _956.transparency = materials.material_properties[materialIndex].transparency;
        _956.emissive = materials.material_properties[materialIndex].emissive;
        _956.roughness = materials.material_properties[materialIndex].roughness;
        _956.triplanar_factor = materials.material_properties[materialIndex].triplanar_factor;
        _956.refraction = materials.material_properties[materialIndex].refraction;
        _956.normal_factor = materials.material_properties[materialIndex].normal_factor;
        _956.emissive_factor = materials.material_properties[materialIndex].emissive_factor;
        _956.temporal_accumulation_factor = materials.material_properties[materialIndex].temporal_accumulation_factor;
        _956.shadowmap_bias = materials.material_properties[materialIndex].shadowmap_bias;
        _956.metalness = materials.material_properties[materialIndex].metalness;
        _956.albedo_sampler = materials.material_properties[materialIndex].albedo_sampler;
        _956.emissive_sampler = materials.material_properties[materialIndex].emissive_sampler;
        _956.normal_sampler = materials.material_properties[materialIndex].normal_sampler;
        _956.metalic_roughness_sampler = materials.material_properties[materialIndex].metalic_roughness_sampler;
        _956.flags = materials.material_properties[materialIndex].flags;
        _956._pad0 = materials.material_properties[materialIndex]._pad0;
        _956._pad1 = materials.material_properties[materialIndex]._pad1;
        material = _956;
    }
    vec4 _957 = shadow;
    vec4 _965 = shadow;
    vec3 _967 = _965.xyz + ((_957.xyz * voxel_light.xyz) * _697.composite_setup.global_illumination_strength);
    shadow.x = _967.x;
    shadow.y = _967.y;
    shadow.z = _967.z;
    vec4 _979 = shadow;
    vec3 _981 = _979.xyz + (voxel_light.xyz * _697.composite_setup.global_illumination_base_strength);
    shadow.x = _981.x;
    shadow.y = _981.y;
    shadow.z = _981.z;
    if ((material.flags & 8u) != 0u)
    {
        vec2 param_6 = vec2(pixel_pos) * _314.dispatch_setup.inv_resolution;
        float param_7 = depth;
        vec4 _1002 = sample_ssr(param_6, param_7);
        ssr = _1002;
        ssr_factor = 1.0;
    }
    vec3 param_8 = world;
    vec3 param_9 = local_normal;
    vec3 param_10 = vec3(0.0);
    vec3 param_11 = vec3(0.0);
    float param_12 = dot(local_normal, normalize(-world));
    vec4 fill_color = calculate_lighting_fill(param_8, param_9, param_10, param_11, param_12);
    vec4 _1019 = shadow;
    vec3 _1021 = _1019.xyz + fill_color.xyz;
    shadow.x = _1021.x;
    shadow.y = _1021.y;
    shadow.z = _1021.z;
    color.w = 1.0;
    if (is_background == false)
    {
        vec3 _1044 = (vec3(max(0.0, 1.0 - shadow.w)) * shadow.xyz) + _697.composite_setup.ambient_color.xyz;
        color.x = _1044.x;
        color.y = _1044.y;
        color.z = _1044.z;
    }
    shadow.w = pow((shadow.w * linear_depth) / 10.0, 2.0);
    vec4 _1063 = color;
    vec3 _1065 = _1063.xyz + (ssr.xyz * 4.0);
    color.x = _1065.x;
    color.y = _1065.y;
    color.z = _1065.z;
    vec4 _1074 = color;
    vec3 _1077 = _1074.xyz + vec3(shadow.w);
    color.x = _1077.x;
    color.y = _1077.y;
    color.z = _1077.z;
    if (_349.composite_params.composite_output_mode == 0)
    {
        float fog_density = linear_depth;
        if (_697.composite_setup.fog_range > 0.0)
        {
            fog_density /= _697.composite_setup.fog_range;
        }
        else
        {
            fog_density = 0.0;
        }
        float fog_height_density = (1.0 - clamp(abs(world.y) / _697.composite_setup.fog_height, 0.0, 1.0)) * _697.composite_setup.fog_height_density;
        fog_density = exp(fog_density + fog_height_density) - 1.0;
        float fog_density_margin = 0.00999999977648258209228515625;
        fog_density = clamp(fog_density, fog_density_margin, 1.0 - fog_density_margin);
        vec3 fog_color = _697.composite_setup.fog_color.xyz;
        vec4 _1131 = color;
        vec3 _1136 = mix(_1131.xyz, fog_color, vec3(fog_density));
        color.x = _1136.x;
        color.y = _1136.y;
        color.z = _1136.z;
        uvec2 param_13 = pixel_pos;
        float param_14 = depth;
        float param_15 = is_background ? 1000000.0 : 0.00999999977648258209228515625;
        uint param_16 = materialIndex;
        float param_17 = _697.composite_setup.volumetric_fog_luminance_ceiling;
        vec4 volumetric_fog_color = sample_volumetric_fog(param_13, param_14, param_15, param_16, param_17);
        vec4 _1162 = volumetric_fog_color;
        vec3 _1164 = _1162.xyz * _697.composite_setup.volumetric_fog_tint.xyz;
        volumetric_fog_color.x = _1164.x;
        volumetric_fog_color.y = _1164.y;
        volumetric_fog_color.z = _1164.z;
        if (_697.composite_setup.volumetric_fog_intensity > 0.0)
        {
            vec4 _1177 = volumetric_fog_color;
            vec3 _1182 = _1177.xyz * vec3(_697.composite_setup.volumetric_fog_intensity);
            volumetric_fog_color.x = _1182.x;
            volumetric_fog_color.y = _1182.y;
            volumetric_fog_color.z = _1182.z;
        }
        float volumetric_fog_blend = 0.0;
        if (_697.composite_setup.volumetric_fog_strength > 0.0)
        {
            volumetric_fog_blend = volumetric_fog_color.w;
            volumetric_fog_blend = 1.0 - volumetric_fog_blend;
            if (_697.composite_setup.volumetric_fog_blend_function == 0u)
            {
                volumetric_fog_blend = exp((-volumetric_fog_blend) / _697.composite_setup.volumetric_fog_strength);
            }
            else
            {
                volumetric_fog_blend = 1.0 - clamp((1.0 - volumetric_fog_blend) * _697.composite_setup.volumetric_fog_strength, 0.0, volumetric_fog_blend);
            }
        }
        vec4 _1222 = color;
        vec3 _1228 = mix(_1222.xyz, volumetric_fog_color.xyz, vec3(volumetric_fog_blend));
        color.x = _1228.x;
        color.y = _1228.y;
        color.z = _1228.z;
        if (_697.composite_setup.transparency_blend == 0u)
        {
            vec4 _1246 = color;
            vec3 _1248 = _1246.xyz + (particles.xyz * (1.0 - volumetric_fog_blend));
            color.x = _1248.x;
            color.y = _1248.y;
            color.z = _1248.z;
        }
        if (_697.composite_setup.transparency_blend == 1u)
        {
            vec4 _1260 = color;
            vec3 _1268 = mix(_1260.xyz, particles.xyz, vec3(1.0 - particles.w));
            color.x = _1268.x;
            color.y = _1268.y;
            color.z = _1268.z;
        }
        vec4 volumetric_light = texelFetch(sVolumetricLight, ivec2(pixel_pos), 0);
        float blend = clamp(pow(volumetric_light.w, 0.20000000298023223876953125), 0.0, 1.0);
        vec4 _1288 = color;
        vec3 _1298 = mix(_1288.xyz, volumetric_light.xyz * _697.composite_setup.volumetric_light_strength, vec3(blend));
        color.x = _1298.x;
        color.y = _1298.y;
        color.z = _1298.z;
    }
    else
    {
        if (_349.composite_params.composite_output_mode == 1)
        {
            color.x = albedo.xyz.x;
            color.y = albedo.xyz.y;
            color.z = albedo.xyz.z;
        }
        else
        {
            if (_349.composite_params.composite_output_mode == 2)
            {
                vec3 _1331 = texelFetch(sEmissive, ivec2(pixel_pos), 0).xyz;
                color.x = _1331.x;
                color.y = _1331.y;
                color.z = _1331.z;
            }
            else
            {
                if (_349.composite_params.composite_output_mode == 3)
                {
                    vec3 _1347 = (normal * 0.5) + vec3(0.5);
                    color.x = _1347.x;
                    color.y = _1347.y;
                    color.z = _1347.z;
                }
                else
                {
                    if (_349.composite_params.composite_output_mode == 4)
                    {
                        vec3 _1362 = vec3(metalness_roughness_material_tags.roughness);
                        color.x = _1362.x;
                        color.y = _1362.y;
                        color.z = _1362.z;
                    }
                    else
                    {
                        if (_349.composite_params.composite_output_mode == 5)
                        {
                            vec3 _1380 = texelFetch(sShadow, ivec2(pixel_pos), 0).xyz;
                            color.x = _1380.x;
                            color.y = _1380.y;
                            color.z = _1380.z;
                        }
                        else
                        {
                            if (_349.composite_params.composite_output_mode == 7)
                            {
                                vec3 _1407 = max(texelFetch(sShadow, ivec2(pixel_pos), 0).xyz, (albedo.xyz * voxel_light.xyz) * _697.composite_setup.global_illumination_strength);
                                color.x = _1407.x;
                                color.y = _1407.y;
                                color.z = _1407.z;
                            }
                            else
                            {
                                if (_349.composite_params.composite_output_mode == 6)
                                {
                                    vec3 _1425 = voxel_light.xyz * _697.composite_setup.global_illumination_strength;
                                    color.x = _1425.x;
                                    color.y = _1425.y;
                                    color.z = _1425.z;
                                }
                                else
                                {
                                    if (_349.composite_params.composite_output_mode == 8)
                                    {
                                        float vx_ao = 1.0 - max(voxel_occlusion_diffuse, 0.0);
                                        vx_ao = 0.1500000059604644775390625 + (vx_ao * 0.85000002384185791015625);
                                        vec3 _1448 = vec3(vx_ao);
                                        color.x = _1448.x;
                                        color.y = _1448.y;
                                        color.z = _1448.z;
                                    }
                                    else
                                    {
                                        if (_349.composite_params.composite_output_mode == 9)
                                        {
                                            float ao = 1.0 - max(voxel_occlusion_specular, 0.0);
                                            vec3 _1466 = vec3(ao);
                                            color.x = _1466.x;
                                            color.y = _1466.y;
                                            color.z = _1466.z;
                                        }
                                        else
                                        {
                                            if (_349.composite_params.composite_output_mode == 11)
                                            {
                                                float ss_ao = max(texelFetch(sScreenSpaceOcclusion, ivec2(pixel_pos), 0).x, 0.0);
                                                float vx_ao_1 = 1.0 - max(voxel_occlusion_diffuse, 0.0);
                                                vx_ao_1 = 0.1500000059604644775390625 + (vx_ao_1 * 0.85000002384185791015625);
                                                ss_ao = 1.0 - clamp((1.0 - ss_ao) * _697.composite_setup.occlusion_strength, 0.0, 1.0);
                                                vx_ao_1 = 1.0 - clamp((1.0 - vx_ao_1) * _697.composite_setup.occlusion_strength, 0.0, 1.0);
                                                float ao_1 = min(ss_ao, vx_ao_1);
                                                vec3 _1513 = vec3(ao_1);
                                                color.x = _1513.x;
                                                color.y = _1513.y;
                                                color.z = _1513.z;
                                            }
                                            else
                                            {
                                                if (_349.composite_params.composite_output_mode == 10)
                                                {
                                                    float hbao_1 = max(texelFetch(sScreenSpaceOcclusion, ivec2(pixel_pos), 0).x, 0.0);
                                                    vec3 _1535 = vec3(hbao_1);
                                                    color.x = _1535.x;
                                                    color.y = _1535.y;
                                                    color.z = _1535.z;
                                                }
                                                else
                                                {
                                                    if (_349.composite_params.composite_output_mode == 12)
                                                    {
                                                        vec3 _1550 = vec3(float(materialIndex));
                                                        color.x = _1550.x;
                                                        color.y = _1550.y;
                                                        color.z = _1550.z;
                                                    }
                                                    else
                                                    {
                                                        if (_349.composite_params.composite_output_mode == 13)
                                                        {
                                                            uint material_flags = material.flags;
                                                            if ((metalness_roughness_material_tags.material_flag_overrides & 2u) != 0u)
                                                            {
                                                                material_flags &= 4294967280u;
                                                                material_flags |= (metalness_roughness_material_tags.material_flag_overrides & 15u);
                                                            }
                                                            vec4 _1580 = color;
                                                            vec3 _1585 = clamp(_1580.xyz, vec3(0.0), vec3(1.0)) * 0.1500000059604644775390625;
                                                            color.x = _1585.x;
                                                            color.y = _1585.y;
                                                            color.z = _1585.z;
                                                            if ((material_flags & 1u) != 0u)
                                                            {
                                                                color.x = 1.0;
                                                            }
                                                            if ((material_flags & 32u) != 0u)
                                                            {
                                                                color.y = 1.0;
                                                            }
                                                        }
                                                        else
                                                        {
                                                            if (_349.composite_params.composite_output_mode == 14)
                                                            {
                                                                vec3 _1621 = texelFetch(sRaytrace, ivec2(vec2(pixel_pos) * _349.composite_params.raytrace_scaling_factor), 0).xyz;
                                                                color.x = _1621.x;
                                                                color.y = _1621.y;
                                                                color.z = _1621.z;
                                                            }
                                                            else
                                                            {
                                                                if (_349.composite_params.composite_output_mode == 15)
                                                                {
                                                                    vec3 _1643 = texelFetch(sRaytrace, ivec2(vec2(pixel_pos) * _349.composite_params.raytrace_scaling_factor), 0).www;
                                                                    color.x = _1643.x;
                                                                    color.y = _1643.y;
                                                                    color.z = _1643.z;
                                                                }
                                                                else
                                                                {
                                                                    if (_349.composite_params.composite_output_mode == 16)
                                                                    {
                                                                        uvec2 param_18 = pixel_pos;
                                                                        float param_19 = depth;
                                                                        float param_20 = is_background ? 1000000.0 : 0.00999999977648258209228515625;
                                                                        uint param_21 = materialIndex;
                                                                        float param_22 = _697.composite_setup.volumetric_fog_luminance_ceiling;
                                                                        vec4 f = sample_volumetric_fog(param_18, param_19, param_20, param_21, param_22);
                                                                        float blend_1 = exp((-f.w) / _697.composite_setup.volumetric_fog_strength);
                                                                        color.x = f.xyz.x;
                                                                        color.y = f.xyz.y;
                                                                        color.z = f.xyz.z;
                                                                    }
                                                                    else
                                                                    {
                                                                        if (_349.composite_params.composite_output_mode == 17)
                                                                        {
                                                                            vec3 _1695 = abs(particles.xyz);
                                                                            color.x = _1695.x;
                                                                            color.y = _1695.y;
                                                                            color.z = _1695.z;
                                                                        }
                                                                        else
                                                                        {
                                                                            if (_349.composite_params.composite_output_mode == 18)
                                                                            {
                                                                                vec3 _1715 = vec3(fract(float(metalness_roughness_material_tags.component_tags) / 16.0));
                                                                                color.x = _1715.x;
                                                                                color.y = _1715.y;
                                                                                color.z = _1715.z;
                                                                            }
                                                                            else
                                                                            {
                                                                                if (_349.composite_params.composite_output_mode == 19)
                                                                                {
                                                                                    vec3 _1734 = texelFetch(sDebug, ivec2(pixel_pos), 0).xyz;
                                                                                    color.x = _1734.x;
                                                                                    color.y = _1734.y;
                                                                                    color.z = _1734.z;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (false)
    {
        vec4 hit_direction_primitiveID = imageLoad(imRaytraceHitDirectionPrimitiveIdReflection, ivec2(pixel_pos));
        float param_23 = hit_direction_primitiveID.w;
        uint hit_primitiveID = asuint(param_23);
        if (hit_primitiveID != 4294967295u)
        {
            float param_24 = fract(float(hit_primitiveID) * 0.13452999293804168701171875);
            vec3 _1767 = TurboColormap(param_24);
            vec3 _1771 = vec3(_1767);
            color.x = _1771.x;
            color.y = _1771.y;
            color.z = _1771.z;
        }
    }
    if (false)
    {
        vec4 hit_direction_primitiveID_1 = imageLoad(imRaytraceHitDirectionPrimitiveIdTransparency, ivec2(pixel_pos));
        float param_25 = hit_direction_primitiveID_1.w;
        uint hit_primitiveID_1 = asuint(param_25);
        if (hit_primitiveID_1 != 4294967295u)
        {
            float param_26 = fract(float(hit_primitiveID_1) * 0.13452999293804168701171875);
            vec3 _1800 = TurboColormap(param_26);
            vec3 _1804 = vec3(_1800);
            color.x = _1804.x;
            color.y = _1804.y;
            color.z = _1804.z;
        }
        else
        {
            color.x = 0.0;
        }
    }
    if (false)
    {
        vec4 rt_shaded_reflection = imageLoad(imRaytraceShadedReflection, ivec2(pixel_pos));
        if (rt_shaded_reflection.w != 0.0)
        {
            color.x = rt_shaded_reflection.xyz.x;
            color.y = rt_shaded_reflection.xyz.y;
            color.z = rt_shaded_reflection.xyz.z;
        }
    }
    if (false)
    {
        vec4 rt_shaded_transparency = imageLoad(imRaytraceShadedTransparency, ivec2(pixel_pos));
        if (rt_shaded_transparency.w != 0.0)
        {
            color.x = rt_shaded_transparency.xyz.x;
            color.y = rt_shaded_transparency.xyz.y;
            color.z = rt_shaded_transparency.xyz.z;
        }
    }
    if (false)
    {
        vec4 rt_shaded_reflection_1 = imageLoad(imRaytraceShadedReflection, ivec2(pixel_pos));
        vec4 rt_shaded_transparency_1 = imageLoad(imRaytraceShadedTransparency, ivec2(pixel_pos));
        if (rt_shaded_transparency_1.w != 0.0)
        {
            color.x = rt_shaded_transparency_1.xyz.x;
            color.y = rt_shaded_transparency_1.xyz.y;
            color.z = rt_shaded_transparency_1.xyz.z;
            vec4 _1884 = color;
            vec3 _1886 = _1884.xyz + rt_shaded_reflection_1.xyz;
            color.x = _1886.x;
            color.y = _1886.y;
            color.z = _1886.z;
        }
        else
        {
            color.x = 1.0;
            color.y = 1.0;
            color.z = 1.0;
        }
    }
    if (true)
    {
        int search_dist = 1;
        vec4 wc = texelFetch(sWireframeColor, ivec2(pixel_pos), 0);
        float wd = texelFetch(sWireframeDepth, ivec2(pixel_pos), 0).x;
        int _1921 = -search_dist;
        for (int iy = _1921; iy < search_dist; iy++)
        {
            int _1932 = -search_dist;
            for (int ix = _1932; ix < search_dist; ix++)
            {
                if ((ix == 0) && (iy == 0))
                {
                    continue;
                }
                float wd_neighborhood = texelFetch(sWireframeDepth, ivec2(pixel_pos) + ivec2(ix, iy), 0).x;
                if (wd_neighborhood < wd)
                {
                    wd = wd_neighborhood;
                    wc = texelFetch(sWireframeColor, ivec2(pixel_pos) + ivec2(ix, iy), 0);
                }
            }
        }
        if (wd < 1.0)
        {
            bool _1985 = wd < depth;
            bool _1994;
            if (!_1985)
            {
                _1994 = (wd >= depth) && is_background;
            }
            else
            {
                _1994 = _1985;
            }
            if (_1994)
            {
                vec4 _1997 = color;
                vec3 _2006 = mix(_1997.xyz, wc.xyz, vec3(0.89999997615814208984375 * wc.w));
                color.x = _2006.x;
                color.y = _2006.y;
                color.z = _2006.z;
            }
            else
            {
                if (wd < 1.0)
                {
                    float t = float(_2022.globals.monotonic & 65535) * 1.10000002384185791015625;
                    float pattern = step(0.5, fract(t + (((float(pixel_pos.x) * _314.dispatch_setup.inv_resolution.x) + (float(pixel_pos.y) * _314.dispatch_setup.inv_resolution.y)) * 60.009998321533203125)));
                    pattern = (pattern * 0.4000000059604644775390625) + 0.60000002384185791015625;
                    vec4 _2055 = color;
                    vec3 _2069 = mix(_2055.xyz, ((wc.xyz * pattern) * 0.5) * vec3(1.0, 0.300000011920928955078125, 0.300000011920928955078125), vec3(0.89999997615814208984375 * wc.w));
                    color.x = _2069.x;
                    color.y = _2069.y;
                    color.z = _2069.z;
                }
            }
        }
    }
    imageStore(imTarget, ivec2(pixel_pos), color);
}

 