#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ParticleRibbonSegmentInfo
{
    uint segments;
    uint first;
    uint previous;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleSnapshotParams
{
    uint particles_per_segment;
    uint max_segments;
    int source_buffer_size;
    int new_snapshot;
};

struct ParticleRibbonState
{
    float generation_id;
    uint segment_info;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _39;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _56;

layout(set = 0, binding = 5, std140) uniform ParticleSnapshotParamsBuffer
{
    ParticleSnapshotParams snapshot_params;
} _106;

layout(set = 0, binding = 3, std430) buffer RibbonStatesData
{
    ParticleRibbonState states[];
} prt_states_snapshots;

layout(set = 0, binding = 4, std430) buffer RibbonPositionsData
{
    float position[];
} prt_position_snapshots;

ParticleRibbonSegmentInfo ribbon_decode_segment_info(uint segment_info)
{
    ParticleRibbonSegmentInfo si;
    si.segments = segment_info & 65535u;
    si.first = segment_info >> uint(16);
    si.previous = si.first - 1u;
    if (si.first == 0u)
    {
        si.previous = _106.snapshot_params.max_segments - 1u;
    }
    return si;
}

bool prt_is_alive(uint id)
{
    return _39.prt_states[id].life_time < _39.prt_states[id].life_span;
}

vec3 prt_get_position(uint id)
{
    return vec3(_56.prt_positions[(id * 3u) + 0u], _56.prt_positions[(id * 3u) + 1u], _56.prt_positions[(id * 3u) + 2u]);
}

float prt_get_generation_id(uint id)
{
    return _39.prt_states[id].generation_id;
}

uint ribbon_encode_segment_info(ParticleRibbonSegmentInfo si)
{
    uint segment_info = si.segments & 65535u;
    segment_info |= ((si.first & 65535u) << uint(16));
    return segment_info;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = prt_states_snapshots.states[id].segment_info;
    ParticleRibbonSegmentInfo si = ribbon_decode_segment_info(param);
    bool _152 = id < uint(_106.snapshot_params.source_buffer_size);
    bool _158;
    if (_152)
    {
        uint param_1 = id;
        _158 = prt_is_alive(param_1);
    }
    else
    {
        _158 = _152;
    }
    if (_158)
    {
        uint param_2 = id;
        vec3 pos = prt_get_position(param_2);
        uint param_3 = id;
        float generation_id = prt_get_generation_id(param_3);
        if (generation_id != prt_states_snapshots.states[id].generation_id)
        {
            prt_states_snapshots.states[id].generation_id = generation_id;
            si.segments = 2u;
            si.first = 1u;
            si.previous = 0u;
            prt_position_snapshots.position[((id + (_106.snapshot_params.particles_per_segment * si.previous)) * 3u) + 0u] = pos.x;
            prt_position_snapshots.position[((id + (_106.snapshot_params.particles_per_segment * si.previous)) * 3u) + 1u] = pos.y;
            prt_position_snapshots.position[((id + (_106.snapshot_params.particles_per_segment * si.previous)) * 3u) + 2u] = pos.z;
        }
        else
        {
            if (_106.snapshot_params.new_snapshot != 0)
            {
                vec3 pos_previous;
                pos_previous.x = prt_position_snapshots.position[((id + (_106.snapshot_params.particles_per_segment * si.previous)) * 3u) + 0u];
                pos_previous.y = prt_position_snapshots.position[((id + (_106.snapshot_params.particles_per_segment * si.previous)) * 3u) + 1u];
                pos_previous.z = prt_position_snapshots.position[((id + (_106.snapshot_params.particles_per_segment * si.previous)) * 3u) + 2u];
                si.first++;
                si.segments++;
                if (si.first == _106.snapshot_params.max_segments)
                {
                    si.first = 0u;
                }
                if (si.segments > _106.snapshot_params.max_segments)
                {
                    si.segments = _106.snapshot_params.max_segments;
                }
            }
        }
        prt_position_snapshots.position[((id + (_106.snapshot_params.particles_per_segment * si.first)) * 3u) + 0u] = pos.x;
        prt_position_snapshots.position[((id + (_106.snapshot_params.particles_per_segment * si.first)) * 3u) + 1u] = pos.y;
        prt_position_snapshots.position[((id + (_106.snapshot_params.particles_per_segment * si.first)) * 3u) + 2u] = pos.z;
    }
    else
    {
        si.segments = 0u;
        si.first = 0u;
    }
    ParticleRibbonSegmentInfo param_4 = si;
    prt_states_snapshots.states[id].segment_info = ribbon_encode_segment_info(param_4);
}

 