#version 460

#include <shaders/materials/commons.glsl>
#include <shaders/commons_hlsl.glsl>

// tess control. for now only static tesselation factor. 

layout(vertices = 3) out;

layout(location = 1) in Vertex
{
	vec3 vCoords;
	vec3 vNorm;
	vec3 vWorldNorm;
	vec3 vLocalPos;
	vec3 vCameraRelativeWorldPos;
	vec4 vColor;
	vec2 vUV0;
} vtx_inputs[];

layout(location = 0) in uint instanceID_inputs[];

layout(location = 1) out Vertex
{
	vec3 vCoords;
	vec3 vNorm;
	vec3 vWorldNorm;
	vec3 vLocalPos;
	vec3 vCameraRelativeWorldPos;
	vec4 vColor;
	vec2 vUV0;
} vtx_outputs[];

layout(location = 0) out uint instanceID_outputs[];

layout(std140, row_major) uniform TransformParamsBuffer{
	EntityTransformParams transform_params;
};

void main()
{
	if (gl_InvocationID == 0)
	{
		// distance-based modifier
		float d = length(vtx_inputs[gl_InvocationID].vCameraRelativeWorldPos);
		d = 1.0 - (min(d, transform_params.tesselationMaxDistance) / transform_params.tesselationMaxDistance);
		d = pow(d, 3.0);

		// area-based modifier
		float a = abs(0.5 * length(cross(vtx_inputs[2].vLocalPos - vtx_inputs[0].vLocalPos, vtx_inputs[1].vLocalPos - vtx_inputs[0].vLocalPos)));
		a = max(0.0, a - transform_params.tesselationMinArea) * transform_params.tesselationAreaFactor;

		float s = clamp((d + a) * transform_params.tesselationMaxFactor, 1.0, 16.0);

		gl_TessLevelInner[0] = s;
		gl_TessLevelOuter[0] = s;
		gl_TessLevelOuter[1] = s;
		gl_TessLevelOuter[2] = s;
	}

	vtx_outputs[gl_InvocationID].vCoords                 = vtx_inputs[gl_InvocationID].vCoords;
	vtx_outputs[gl_InvocationID].vNorm                   = vtx_inputs[gl_InvocationID].vNorm;
	vtx_outputs[gl_InvocationID].vWorldNorm              = vtx_inputs[gl_InvocationID].vWorldNorm;
	vtx_outputs[gl_InvocationID].vLocalPos               = vtx_inputs[gl_InvocationID].vLocalPos;
	vtx_outputs[gl_InvocationID].vCameraRelativeWorldPos = vtx_inputs[gl_InvocationID].vCameraRelativeWorldPos;
	vtx_outputs[gl_InvocationID].vColor                  = vtx_inputs[gl_InvocationID].vColor;
	vtx_outputs[gl_InvocationID].vUV0                    = vtx_inputs[gl_InvocationID].vUV0;

	instanceID_outputs[gl_InvocationID]                  = instanceID_inputs[gl_InvocationID];

	gl_out[gl_InvocationID].gl_Position = gl_in[gl_InvocationID].gl_Position;
}

