#version 460

#define GEOMETRY_INFORMATION_STATIC 1

#include <shaders/materials/commons.glsl>
#include <shaders/materials/commons_gradient.glsl>

#include <shaders/materials/mapping/triplanar.glsl>

uniform sampler2D s_NoiseRGBA;

#ifndef GEOMETRY_PASS
layout(location = 1) in struct
{
	vec3 vCoords;
	vec3 vNorm;
	vec3 vWorldNorm;
	vec3 vLocalPos;
	vec3 vCameraRelativeWorldPos;
	vec4 vColor;
	vec2 vUV0;
} vtx_input;
layout(location = 0) in flat uint instanceID;

#endif

layout(std140, row_major) uniform TransformParamsBuffer{
	EntityTransformParams transform_params;
};


// output for 2 buffers
#ifdef DEFERRED_PASS
layout(location = 0) out vec4 outAlbedo;
#ifndef DEFERRED_PASS_ALBEDO_ONLY
layout(location = 1) out uint outNormalMaterial;
layout(location = 2) out uvec4 outMetalnessRoughnessMeterialTags;
layout(location = 3) out vec4 outEmissive;
#endif
#endif

layout(std140, row_major) uniform BaseMaterialPropertiesBuffer
{
	vec4 colorDiffuse;
	int gUseDerivedNormal;
	int gMaterialMode;
	int materialId;
	int materialIndex;
	int componentTags;
};

#ifdef INLINE_FRAGMENT_MODIFIERS_PARAMS_BLOCK
#inline <INLINE_FRAGMENT_MODIFIERS_PARAMS_BLOCK>
#endif

#if !defined(GEOMETRY_PASS)
#include <shaders/materials/material_overrides.glsl>
#endif

#ifdef MATERIAL_OVERRIDE_V2

void material_evaluate_sample_textures(MaterialPropertiesGPU material, inout MaterialEval material_eval, inout MaterialEvalInput eval_input)
{
	vec2 uv0  = eval_input.uv0;
	vec3 norm = eval_input.normal;

	#ifdef MATERIAL_PROPERTIES_BINDING
#if MATERIAL_EVALUATE_ALBEDO_TEXTURE == 1
	if (material.albedo_sampler >= 0 && material.albedo_sampler < 16)
	{
		if ((material.flags & MaterialFlag_TriPlanarMapping) != 0)
			material_eval.albedo_texture = mapping_triplanar(material_textures[material.albedo_sampler], vtx_input.vLocalPos.xyz, norm, material.triplanar_factor).rgba;
		else
			material_eval.albedo_texture = texture(material_textures[material.albedo_sampler], uv0).rgba;
	}
#endif

	if (material.emissive_sampler >= 0 && material.emissive_sampler < 16)
	{
		if ((material.flags & MaterialFlag_TriPlanarMapping) != 0)
			material_eval.emissive_texture= mapping_triplanar(material_textures[material.emissive_sampler], vtx_input.vLocalPos.xyz, norm, material.triplanar_factor).rgb;
		else
			material_eval.emissive_texture= texture(material_textures[material.emissive_sampler], uv0).rgb;
	}

#if MATERIAL_EVALUATE_METALIC_ROUGHNESS_TEXTURE == 1
	if (material.metalic_roughness_sampler >= 0 && material.metalic_roughness_sampler < 16)
	{
		vec2 metalic_roughness = vec2(1.0);
		if ((material.flags & MaterialFlag_TriPlanarMapping) != 0)
			metalic_roughness = mapping_triplanar(material_textures[material.metalic_roughness_sampler], vtx_input.vLocalPos.xyz, norm, material.triplanar_factor).rg;
		else
			metalic_roughness = texture(material_textures[material.metalic_roughness_sampler], uv0).rg;

		material_eval.metalness_texture = clamp(metalic_roughness.r, 0.0, 1.0);
		material_eval.roughness_texture = clamp(metalic_roughness.g, 0.0, 1.0);
	}
#endif

	#endif // MATERIAL_PROPERTIES_BINDING

}

#endif

void main() {

#if defined(GEOMETRY_PASS)
#endif

#if defined(SHADOWMAP_PASS)
#ifdef MATERIAL_PROPERTIES_BINDING
	MaterialPropertiesGPU material = materials.material_properties[materialIndex];
#else
	MaterialPropertiesGPU material;
	material.diffuse      = colorDiffuse.rgb;
	material.emissive     = vec3(0.0f);
	material.metalness    = 0.0f;
	material.roughness    = 0.5f;
	material.transparency = 0.0f;
	material.refraction   = 0.0f;
	material.flags = 0;

#endif
	vec3 worldPos = vtx_input.vCameraRelativeWorldPos + transform_params.vCameraPosition;

// new workflow

	float factor = 1.0;
#ifdef INLINE_FRAGMENT_MODIFIERS_TRANSFORM_LOCAL_BLOCK
	{
		ModifierFactor modifier_factor = modifier_factor_defaults();
		modifier_factor.factor      = 1.0;
		modifier_factor.hash        = uint(0);
		modifier_factor.id          = uint(0);
		modifier_factor.instance_id = uint(0);
		modifier_factor.position    = vtx_input.vLocalPos;
		modifier_factor.is_spawned  = false;
		modifier_factor.has_world_position = true;
		modifier_factor.world_position     = worldPos;

		CoordinateSystemTrasforms cs_transforms;
		cs_transforms.mat_local_to_model     = transform_params.mModel;
		cs_transforms.mat_local_to_instance  = mat_identity();
		cs_transforms.mat_local_to_model_inv = transform_params.mModelInv;

#inline <INLINE_FRAGMENT_MODIFIERS_TRANSFORM_LOCAL_BLOCK>

		factor = modifier_factor.factor;
	}

#endif

	MaterialEval material_eval;
	material_eval.albedo            = vec4(material.diffuse.rgb, colorDiffuse.a);
	material_eval.emissive          = vec3(0.0);
	material_eval.roughness         = 0.0;
	material_eval.metalness         = 0.0;
	material_eval.transparency      = 0.0;
	material_eval.is_discarded      = false;		// only this one matters
	material_eval.normal            = vec3(0.0);	// hack, don't really feel the need to sample normal map, especially triplanar...
	material_eval.albedo_texture    = vec4(1.0);
	material_eval.emissive_texture  = vec3(1.0);
	material_eval.roughness_texture = 1.0;
	material_eval.metalness_texture = 1.0;

	MaterialEvalInput eval_input;
	eval_input.uv0                  = vtx_input.vUV0;
	eval_input.normal               = vtx_input.vNorm;
	eval_input.color                = vtx_input.vColor;
	eval_input.world_coords         = worldPos.xyz;
	eval_input.local_coords         = vtx_input.vLocalPos.xyz;
	eval_input.world_normal         = vtx_input.vWorldNorm;
	eval_input.local_normal         = vtx_input.vNorm;
	eval_input.modifier_factor      = factor;
	eval_input.primitiveID          = gl_PrimitiveID;

// new workflow
#ifdef MATERIAL_OVERRIDE_V2

	material_evaluate(material, material_eval, eval_input);

	if (material_eval.is_discarded)
	{
		discard;
		return;
	}

#else // MATERIAL_OVERRIDE_V2, old workflow
	bool to_discard = getMaterialDiscard(material, worldPos, vtx_input.vLocalPos.xyz, vtx_input.vNorm, vtx_input.vWorldNorm);
	if (to_discard)
	{
		// NOTE: yeah, this will break derivatives...
		discard;
		return;
	}
#endif

#endif // SHADOWMAP_PASS

#ifdef DEFERRED_PASS

#ifdef DEFERRED_PASS_ALBEDO_ONLY
	uint outNormalMaterial;
	uvec4 outMetalnessRoughnessMeterialTags;
	vec4 outEmissive;
#endif

#ifdef MATERIAL_PROPERTIES_BINDING
	MaterialPropertiesGPU material = materials.material_properties[materialIndex];
#else
	MaterialPropertiesGPU material;
	material.diffuse = colorDiffuse.rgb;
	material.emissive = vec3(0.0f);
	material.metalness = 0.0f;
	material.roughness = 0.5f;
	material.transparency = 0.0f;
	material.refraction = 0.0f;
	material.flags = 0;

#endif

	vec3 worldPos = vtx_input.vCameraRelativeWorldPos + transform_params.vCameraPosition;

	// output normal only
	//gl_FragColor = vec4(vNorm * 0.5 + 0.5, 0.0);
	float g = vtx_input.vNorm.z * 0.5 + 0.5;
	//outColor = vec4(vec3(vCoords.z/vCoords.w) * 0.5 + 0.5, 0.0);
	//outColor = vec4(vec3(vWorldPos.z/10.0) + 1.0, 0.0);
	//outColor = vec4(vec3(vWorldPos.y/5.0) + 0.5, 0.0);
	//gl_FragColor = vec4(g);
	//gl_FragColor = vec4(0.5, 0.6, 0.7, 0.0);
	vec3 worldNorm = vtx_input.vWorldNorm;
	vec3 norm = vtx_input.vNorm;

	if ((material.flags & MaterialFlag_Flat) != 0)
	{
#if MATERIAL_EVALUATE_FLAT == 1
		vec3 dFdxPos;
		vec3 dFdyPos;
		dFdxPos = dFdxFine(vtx_input.vCameraRelativeWorldPos.xyz);
		dFdyPos = dFdyFine(vtx_input.vCameraRelativeWorldPos.xyz);

		worldNorm = cross(dFdyPos, dFdxPos);

		dFdxPos = dFdxFine(vtx_input.vLocalPos.xyz);
		dFdyPos = dFdyFine(vtx_input.vLocalPos.xyz);
		norm = cross(dFdyPos, dFdxPos);

		worldNorm = -worldNorm;
		norm = -norm;
#endif
	}
	else
	{
		if (gl_FrontFacing)
		{
			worldNorm = -worldNorm;
			norm      = -norm;
		}
	}

	

	worldNorm = normalize(worldNorm);
	norm      = normalize(norm);

	vec3 normal = worldNorm;
#ifdef MATERIAL_PROPERTIES_BINDING
	normal = getMaterialNormal(material, normal, worldPos.xyz, vtx_input.vLocalPos.xyz, vtx_input.vNorm, vtx_input.vWorldNorm);

	bool to_discard = getMaterialDiscard(material, worldPos.xyz, vtx_input.vLocalPos.xyz, vtx_input.vNorm, vtx_input.vWorldNorm);
	if (to_discard)
	{
		// NOTE: yeah, this will break derivatives...
		discard;
		return;
	}

#if MATERIAL_EVALUATE_NORMAL_TEXTURE == 1
	if (material.normal_sampler >= 0 && material.normal_sampler < 16)
	{
		if ((material.flags & MaterialFlag_TriPlanarMapping) == 0)
		{
			// we need full transformation frame
			vec3 pos_dx = dFdxFine(worldPos);
			vec3 pos_dy = dFdyFine(worldPos);
			//vec3 pos_dx = dFdxFine(vtx_input.vCameraRelativeWorldPos.xyz);
			//vec3 pos_dy = dFdyFine(vtx_input.vCameraRelativeWorldPos.xyz);

			vec3 tex_dx = dFdxFine(vec3(vtx_input.vUV0, 0.0));
			vec3 tex_dy = dFdyFine(vec3(vtx_input.vUV0, 0.0));

			float denom = tex_dx.x * tex_dy.y - tex_dy.x * tex_dx.y;
			if (abs(denom) >= 0.0000000001)
			{
				vec3 t = (tex_dy.y * pos_dx - tex_dx.y * pos_dy) / denom;
				vec3 ng = normal;

				t = normalize(t - ng * dot(ng, t));
				vec3 b = normalize(cross(ng, t));
				mat3 tbn = mat3(t, b, ng);

				vec3 n = texture(material_textures[material.normal_sampler], vtx_input.vUV0).rgb * 2.0 - 1.0;

				n = normalize( n * transpose(tbn) );
				n = mix(normal, n, material.normal_factor);

				normal.rgb = n;
			}
			else
			{
				// this is for the cases of degenerate tangents? no idea if we want to keep this as this can look really crappy (rotated normal) for smooth surfaces
				vec3 n = texture(material_textures[material.normal_sampler], vtx_input.vUV0).rgb * 2.0 - 1.0;
				n = mix(normal, n, material.normal_factor);

				normal.rgb = n;
			}
		}
		else
		{
			vec3 n = mapping_triplanar_normal(
				material_textures[material.normal_sampler],
				vtx_input.vLocalPos.xyz,
				norm,
				material.triplanar_factor
			).rgb;

			n = vector_transform_by_mat33(n, transform_params.mModelNormal);

			// This is required to normalize properly for the meshes with non-uniform scaling...
			// Seems costly, so maybe we could push this into the const buffer? We don't respect
			// instance scaling anyway:(
			vec3 scale;
			mat4 m = transform_params.mModelNormal;
			//scale.x = length(vec3(m[0][0], m[1][0], m[2][0]));
			//scale.y = length(vec3(m[0][1], m[1][1], m[2][1]));
			//scale.z = length(vec3(m[0][2], m[1][2], m[2][2]));
			//scale.x = length(vec3(m[0][0], m[0][1], m[0][2]));
			//scale.y = length(vec3(m[1][0], m[1][1], m[1][2]));
			//scale.z = length(vec3(m[2][0], m[2][1], m[2][2]));
			//scale.x = 1.0;
			//scale.y = 1.0;
			//scale.z = 1.0;
			//n *= vec3(1.0) / scale;
			//n = normalize(n); // NOTE: do we need to normalize here? probably not
			n = normalize(mix(normal, n, material.normal_factor));
			normal.rgb = n;
		}
	}
#endif // MATERIAL_EVALUATE_NORMAL_TEXTURE == "1"
#endif

	vec2 uv0 = vtx_input.vUV0;
	uint material_flag_overrides = 0;

	outNormalMaterial = encode_normal_material(normal, materialId);

	float factor = 1.0;
#ifdef INLINE_FRAGMENT_MODIFIERS_TRANSFORM_LOCAL_BLOCK
	{
		ModifierFactor modifier_factor = modifier_factor_defaults();
		modifier_factor.factor             = 1.0;
		modifier_factor.hash               = uint(0);
		modifier_factor.id                 = uint(0);
		modifier_factor.instance_id        = uint(0);
		modifier_factor.position           = vtx_input.vLocalPos;
		modifier_factor.is_spawned         = false;
		modifier_factor.has_world_position = true;
		modifier_factor.world_position     = worldPos;

		CoordinateSystemTrasforms cs_transforms;
		cs_transforms.mat_local_to_model     = transform_params.mModel;
		cs_transforms.mat_local_to_instance  = mat_identity();
		cs_transforms.mat_local_to_model_inv = transform_params.mModelInv;

#inline <INLINE_FRAGMENT_MODIFIERS_TRANSFORM_LOCAL_BLOCK>

		factor = modifier_factor.factor;
	}

#endif

	MaterialEval material_eval;
	material_eval.albedo            = vec4(material.diffuse.rgb, colorDiffuse.a);
	material_eval.emissive          = vec3(0.0);
	material_eval.roughness         = material.roughness;
	material_eval.metalness         = material.metalness;
	material_eval.transparency      = material.transparency;
	material_eval.is_discarded      = false;
	material_eval.normal            = normal;
	material_eval.albedo_texture    = vec4(1.0);
	material_eval.emissive_texture  = vec3(1.0);
	material_eval.roughness_texture = 1.0;
	material_eval.metalness_texture = 1.0;
	material_eval.flag_overrides    = 0;

	MaterialEvalInput eval_input;
	eval_input.uv0                  = uv0;
	eval_input.normal               = norm;
	eval_input.color                = vtx_input.vColor;
	eval_input.world_coords         = worldPos.xyz;
	eval_input.local_coords         = vtx_input.vLocalPos.xyz;
	eval_input.world_normal         = vtx_input.vWorldNorm;
	eval_input.local_normal         = vtx_input.vNorm;
	eval_input.modifier_factor      = factor;
	eval_input.primitiveID          = gl_PrimitiveID;

// new workflow
#ifdef MATERIAL_OVERRIDE_V2

	material_evaluate(material, material_eval, eval_input);
	if ((material_eval.flag_overrides & MaterialFlag_OverrideFlags) != 0)
		material_flag_overrides = material_eval.flag_overrides;

	if (material_eval.is_discarded)
	{
		discard;
		return;
	}

	outAlbedo       = material_eval.albedo * material_eval.albedo_texture;
	outEmissive.rgb = material_eval.emissive * material_eval.emissive_texture;
	outEmissive.a   = material_eval.transparency;
	float roughness = material_eval.roughness * material_eval.roughness_texture;
	float metalness = material_eval.metalness * material_eval.metalness_texture;

#else // MATERIAL_OVERRIDE_V2, old workflow

	outAlbedo = vec4(material.diffuse.rgb, colorDiffuse.a);

	// In case we don't really have a material lets use the diffuse here.
	// this is mostly for some aux rendering, like UI elements
#ifndef MATERIAL_PROPERTIES_BINDING
	outAlbedo.rgb = colorDiffuse.rgb;
#endif

#ifdef MATERIAL_PROPERTIES_BINDING
	outAlbedo = getMaterialAlbedo(material, outAlbedo, worldPos.xyz, vtx_input.vLocalPos.xyz, vtx_input.vNorm, vtx_input.vWorldNorm);

#if MATERIAL_EVALUATE_ALBEDO_TEXTURE == 1
	if (material.albedo_sampler >= 0 && material.albedo_sampler < 16)
	{
		if ((material.flags & MaterialFlag_TriPlanarMapping) != 0)
			outAlbedo.rgba *= mapping_triplanar(material_textures[material.albedo_sampler], vtx_input.vLocalPos.xyz, norm, material.triplanar_factor).rgba;
		else
			outAlbedo.rgba *= texture(material_textures[material.albedo_sampler], uv0).rgba;
	}
#endif // MATERIAL_EVALUATE_ALBEDO_TEXTURE == 1
#endif

	outAlbedo.rgb *= vtx_input.vColor.rgb;
	//outAlbedo.rgb = 0.5 + normal * 0.5;
	
	outEmissive = vec4(0.0);
	outEmissive.a = material.transparency;

#ifdef MATERIAL_PROPERTIES_BINDING
	outEmissive.rgb = getMaterialEmissive(material, outEmissive.rgb, worldPos.xyz, vtx_input.vLocalPos.xyz, vtx_input.vNorm, vtx_input.vWorldNorm);

	if (material.emissive_sampler >= 0 && material.emissive_sampler < 16)
	{
		if ((material.flags & MaterialFlag_TriPlanarMapping) != 0)
			outEmissive.rgb *= mapping_triplanar(material_textures[material.emissive_sampler], vtx_input.vLocalPos.xyz, norm, material.triplanar_factor).rgb;
		else
			outEmissive.rgb *= texture(material_textures[material.emissive_sampler], uv0).rgb;
	}
#endif

	float roughness = material.roughness;

#ifdef MATERIAL_PROPERTIES_BINDING
	roughness = getMaterialRoughness(material, roughness, worldPos.xyz, vtx_input.vLocalPos.xyz, vtx_input.vNorm, vtx_input.vWorldNorm);

#if MATERIAL_EVALUATE_METALIC_ROUGHNESS_TEXTURE == 1
	if (material.metalic_roughness_sampler >= 0 && material.metalic_roughness_sampler < 16)
	{
		//	roughness *= texture(material_textures[material.metalic_roughness_sampler], uv0);

		if ((material.flags & MaterialFlag_TriPlanarMapping) != 0)
			roughness *= mapping_triplanar(material_textures[material.metalic_roughness_sampler], vtx_input.vLocalPos.xyz, norm, material.triplanar_factor).g;
		else
			roughness *= texture(material_textures[material.metalic_roughness_sampler], uv0).g;
	}
#endif // MATERIAL_EVALUATE_METALIC_ROUGHNESS_TEXTURE == 1
#endif

	float metalness = material.metalness;

#ifdef MATERIAL_PROPERTIES_BINDING
	metalness = getMaterialMetalness(material, metalness, worldPos.xyz, vtx_input.vLocalPos.xyz, vtx_input.vNorm, vtx_input.vWorldNorm);

#if MATERIAL_EVALUATE_METALIC_ROUGHNESS_TEXTURE == 1
	if (material.metalic_roughness_sampler >= 0 && material.metalic_roughness_sampler < 16)
	{
		//	roughness *= texture(material_textures[material.metalic_roughness_sampler], uv0);

		if ((material.flags & MaterialFlag_TriPlanarMapping) != 0)
			metalness *= mapping_triplanar(material_textures[material.metalic_roughness_sampler], vtx_input.vLocalPos.xyz, norm, material.triplanar_factor).r;
		else
			metalness *= texture(material_textures[material.metalic_roughness_sampler], uv0).r;
	}
#endif // MATERIAL_EVALUATE_METALIC_ROUGHNESS_TEXTURE == 1
#endif

#endif // MATERIAL_OVERRIDE_V2

	MetalnessRoughnessMeterialTags metalness_roughness_material_tags;
	metalness_roughness_material_tags.metalness = metalness;
	metalness_roughness_material_tags.roughness = roughness;
	metalness_roughness_material_tags.material_index = materialIndex;
	metalness_roughness_material_tags.component_tags = componentTags;
	metalness_roughness_material_tags.material_flag_overrides = material_flag_overrides;

	outMetalnessRoughnessMeterialTags.rgba = encode_metalness_roughness_material_tags(metalness_roughness_material_tags);

	// simple debugging
	#if 0
	outAlbedo.rgb = normal.xyz * 0.5 + 0.5;
	//outAlbedo.rgb = (length(normal).xxx - 1.0) * 10000.0;
	//outAlbedo.rgb = fract((vtx_input.vCameraRelativeWorldPos.xyz + transform_params.vCameraPosition.xyz) * 0.01);
	//outAlbedo.rgb = fract((vtx_input.vCameraRelativeWorldPos.xyz) * 0.01);
	//outAlbedo.b = 0.0;
	#endif

#endif // DEFERRED_PASS
}