#version 460
#extension GL_EXT_debug_printf : enable

uniform sampler2D      s_LTC1;
uniform sampler2D      s_LTC2;
uniform sampler2D      s_BRDF;
uniform sampler2DArray s_BlueNoise;

uniform samplerCube    sEnviromentMap;

#include <shaders/materials/commons.glsl>
#include <shaders/materials/commons_sampling.glsl>
#include <shaders/geometry_partitioning/raytrace_buffers.glsl>
#include <shaders/geometry_partitioning/raytrace_commons.glsl>

#include <shaders/deferred/lighting/lighting_support.glsl>

struct VoxelizationDispatchParams
{
	int  lights_num;
	uint component_tags;
	float env_map_intensity;
};

layout (std140, row_major) uniform VoxelizationDispatchParamsBuffer
{
	VoxelizationDispatchParams dispatch_params;
};

layout (location = 1) in vec3 vGridCoords;
layout (location = 2) in f16vec2 vUV0;
layout (location = 5) in vec3 vPointCoords;
layout (location = 8) in vec4 vColor;

#include <shaders/geometry_partitioning/partition_commons.glsl>
#include <shaders/deferred/lighting/ltc_quad.glsl>

// ------------------------------------------------------------------------------------------------------------------

vec3 calculate_lighting_world(LightProperties light, in vec3 pos, in vec3 normal, in vec3 light_pos, in float NdotL)
{
	float d = NdotL;
	if (d < 0.0)
		d = 0.0;
	return vec3(vec3(d) * light.diffuse.xyz);
}

// ------------------------------------------------------------------------------------------------------------------

// 1 : mark cell as used
// 2 : if the cell was unmarked then initilize linked list. consume some constant amount of indices from the buffer
// 3 : if the cell was initialized then calculate brick in the cell and insert new triangle into it

// orientation index is to transform triangle into original coors space (0, 1, 2 -> YZ, XZ, XY)

// Thick mode has a problem that is overwrites cells which are shadowed. We should probably
// go with the 'min' mode for color and 'max' for occlusion

//#define VX_FRACTIONAL_OCCLUSION
// Following defines are set up in the voxelizer per user selection
//#define VX_FRACTIONAL_OCCLUSION_THICK
#define VX_AS_EMISSIVE

void main()
{
	vec3 bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
	vec3 bbox_grid_size = in_bbox_data.grid_size_voxelize.xyz;

	vec3 pos = vGridCoords;

	uint cx;// = uint(gl_FragCoord.x);
	uint cy;// = uint(gl_FragCoord.y);
	uint cz;// = uint(gl_FragCoord.z * GRID_RES);

	vec3 gc = gl_FragCoord.xyz / vec3(1.0, 1.0, 1.0/GRID_RES) + vec3(0.0, 0.0, 0.0);
#ifdef SPIRV_VULKAN
    gc.y = 255.5 - gc.y;
#endif
	//vec3 gc = vGridCoords;
	
	// triangle bbox

	ivec3 mi = ivec3(vPointCoords);
	ivec3 ma = mi;
	
	mi = clamp(mi, ivec3(0), ivec3(GRID_RES-1));
	ma = clamp(ma, ivec3(0), ivec3(GRID_RES-1));

	cx = uint(gc.x);
	cy = uint(gc.y);
	cz = uint(gc.z);
	
	const bool early_occlusion_store = true;

	// calculate color only once
	vec3 voxel_color = vec3(1.0, 1.0, 1.0);

	int sampling_r = 2;

	//int s = 0;

	for(int sz = -sampling_r; sz <= sampling_r; sz++)
	{
		for(int sy = -sampling_r; sy <= sampling_r; sy++)
		{
			for(int sx = -sampling_r; sx <= sampling_r; sx++)
			{
				uvec3 cc = ivec3(cx, cy, cz) + ivec3(sx, sy, sz);
				vec3 cellPos = vec3(cc);
				vec3 cellSize = vec3(1.0);

				vec3 sampling_pos = cellPos + cellSize * 0.5;
				float point_d = length(vPointCoords - sampling_pos);
				float max_d = cellSize.x * sampling_r;

				if (point_d < max_d)
				{
					float occ = 1.0 - point_d / max_d;
					rt_store_voxel_occlusion(cc.x, cc.y, cc.z, occ);
					rt_store_voxel_color_emissive(cc.x, cc.y, cc.z, vec4(voxel_color, 1.0) * occ);
				}
			}
		}
	}
}



