
#version 430

#define MATERIAL_PROPERTIES_BINDING 1
#include <shaders/materials/commons.glsl>

in vec2 vTexcoord0;
uniform sampler2D sDepth;

struct DownscaleDepthParams
{
	float source_width_inv;
	float source_height_inv;
	float scale_factor;
	float scale_factor_inv;
	float _pad0;
};

layout (std140, row_major) uniform DownscaleDepthParamsBuffer
{
	DownscaleDepthParams params;
};


void main() {

	#if 0
	ivec2 p = ivec2(gl_FragCoord.xy * params.scale_factor);

	// conservative. old codepath using fetches and only working properly with 2x2 downsampling
	float depth00 = texelFetch(sDepth, p + ivec2(0, 0), 0).r;
	float depth01 = texelFetch(sDepth, p + ivec2(0, 1), 0).r;
	float depth10 = texelFetch(sDepth, p + ivec2(1, 0), 0).r;
	float depth11 = texelFetch(sDepth, p + ivec2(1, 1), 0).r;

	float min_depth;
	min_depth = min(depth00, depth01);
	min_depth = min(min_depth, depth10);
	min_depth = min(min_depth, depth11);

	#else
	vec2 p = (gl_FragCoord.xy * params.scale_factor) * vec2(params.source_width_inv, params.source_height_inv);

	// conservative. provided sampler is a _MIN sampler, so gather 4 samples in one go
	float d = 2.0;
	vec4 depth00 = textureGather(sDepth, p + vec2(params.source_width_inv * 0.0, params.source_height_inv * 0.0));
	vec4 depth10 = textureGather(sDepth, p + vec2(params.source_width_inv *   d, params.source_height_inv * 0.0));
	vec4 depth01 = textureGather(sDepth, p + vec2(params.source_width_inv * 0.0, params.source_height_inv *   d));
	vec4 depth11 = textureGather(sDepth, p + vec2(params.source_width_inv *   d, params.source_height_inv *   d));

	float min_depth00 = min(depth00.r, min(depth00.g, min(depth00.b, depth00.a)));
	float min_depth10 = min(depth10.r, min(depth10.g, min(depth10.b, depth10.a)));
	float min_depth01 = min(depth01.r, min(depth01.g, min(depth01.b, depth01.a)));
	float min_depth11 = min(depth11.r, min(depth11.g, min(depth11.b, depth11.a)));

	float min_depth = min(min_depth00, min(min_depth10, min(min_depth01, min_depth11)));
	#endif
	gl_FragDepth = min_depth;

}
