#version 460

#include <shaders/materials/commons_deferred.glsl>
#include <shaders/materials/commons_gradient.glsl>
#include <shaders/materials/commons.glsl>

#include <shaders/materials/noise/noise3d.glsl>

in vec2 vTexcoord0;

struct CustomPostprocessParams
{
	float param1;
	float param2;
	float param3;
	float param4;
	vec4  param_color1;
	vec4  param_color2;

	int   txt1_flip_y;
	int   txt2_flip_y;
	int   txt3_flip_y;
	int   _pad0;
};

layout (std140, row_major) uniform CustomPostprocessParamsBuffer {
	CustomPostprocessParams params;
};

layout(std140, row_major) uniform BasicDeferredParamsBuffer {
	BasicDeferredParams basic_params;
};

uniform sampler2D  s_texture0;

uniform sampler2D  sImage1;
uniform sampler2D  sImage2;
uniform sampler2D  sImage3;

uniform sampler2D  sAlbedo;
uniform sampler2D  sTextureDepth;
uniform usampler2D sNormalMaterial;
uniform usampler2D sMetalnessRoughnessMaterialTags;
uniform sampler2D  sShadow;

layout(location = 0) out vec4 outColor;

float get_d(vec2 p)
{
	float m = max(0.0, sin(params.param1 + p.y * params.param2));
	return m;
}

vec4 get_c(vec2 p, float m)
{
	vec2 p_quant = p;
	p_quant = vec2(ivec2(p_quant * 64.0)) / 64.0;

	vec2 p_quant_coarse = p;
	p_quant_coarse = vec2(ivec2(p_quant_coarse * 12.0)) / 12.0;
	p_quant_coarse += p_quant;

	vec2 p_quant_fine = p;
	p_quant_fine = vec2(ivec2(p_quant_fine * 256)) / 256;
	p_quant_fine.x = 0.0;

	float n = snoise(vec3(p_quant * 10.0, 0.231 + params.param4)) * 0.1 * m;
	float n_coarse = snoise(vec3(p_quant_coarse * 4.0, 0.121 + params.param4 * 10.0 + p_quant_coarse.y)) * 2.0;
	n_coarse = max(0.0, n_coarse - params.param3) * m;
	

	float n_fine = snoise(vec3(p_quant_fine * 40.0, 0.72121 + params.param4)) * 0.1 * m;

	vec4 c = texture(s_texture0, p + n);
	vec4 c_1 = texture(s_texture0, p + vec2(n_fine.x, 0.0));
	vec4 c_coarse = texture(s_texture0, p + n_coarse);

	return mix(c_1, c, c.r) * 0.3 + c_coarse * 0.7;
	//return mix(c_1, c_1 + c, c_coarse);
	//return c_1 + c + c_coarse * 0.4;
}

vec4 blur(vec2 p, float r)
{
	const int sr = 3;
	vec4 c = vec4(0.0);

	for(int iy = -sr; iy <= sr; iy++)
	{
		for(int ix = -sr; ix <= sr; ix++)
		{
			// naive box?
			vec4 c_s = texture(s_texture0, p + vec2(ix, iy) * vec2(1.0/1920.0, 1.0/1080.0) * r);
			c += c_s;
		}
	}

	c *= 1.0 / ((sr * 2 + 1) * (sr * 2 + 1));

	return c;
}

vec4 get_c_fast(vec2 p, vec2 off, float m)
{
	vec2 p_quant = p;
	p_quant = vec2(ivec2(p_quant * 64.0)) / 64.0;

	vec2 p_quant_coarse = p;
	p_quant_coarse = vec2(ivec2(p_quant_coarse * 12.0)) / 12.0;
	p_quant_coarse += p_quant;

	vec2 p_quant_fine = p;
	p_quant_fine = vec2(ivec2(p_quant_fine * 256)) / 256;
	p_quant_fine.x = 0.0;

	float n = snoise(vec3(p_quant * 10.0, 0.231 + params.param4)) * 0.1 * m;
	float n_coarse = snoise(vec3(p_quant_coarse * 4.0, 0.121 + params.param4 * 10.0 + p_quant_coarse.y)) * 2.0;
	n_coarse = max(0.0, n_coarse - params.param3) * m;
	

	float n_fine = snoise(vec3(p_quant_fine * 40.0, 0.72121 + params.param4)) * 0.1 * m;

	vec4 c = texture(s_texture0, p + off + n);
	vec4 c_1 = texture(s_texture0, p + off + vec2(n_fine.x, 0.0));
	vec4 c_coarse = texture(s_texture0, p + off + n_coarse);

	return mix(c_1, c, c.r) * 0.3 + c_coarse * 0.7;
	//return mix(c_1, c_1 + c, c_coarse);
	//return c_1 + c + c_coarse * 0.4;
}


void main()
{
	vec2 p = vTexcoord0;

	vec4 c = vec4(0.0);
	float m = get_d(p);

	int n = 10;
	for(int i = 0; i < 10; i+=1)
	{
		float t = 0.001 * m;

		#if 0
		c.r += get_c(p + vec2(i, 0) * t * 1.0, m).r;
		c.g += get_c(p + vec2(i, 0) * t * 2.2, m).g;
		c.b += get_c(p + vec2(i, 0) * t * 4.4, m).b;
		#else
		c.r += get_c_fast(p, vec2(i, 0) * t * 1.0, m).r;
		c.g += get_c_fast(p, vec2(i, 0) * t * 2.2, m).g;
		c.b += get_c_fast(p, vec2(i, 0) * t * 4.4, m).b;
		#endif
		
		//c.rgb += get_c(p + vec2(i, 0) * t * 1.0).rgb * 0.1;
		//c.rgb += get_c(p + vec2(i, 0) * t * 1.2).rgb * 0.1;
		//c.rgb += get_c(p + vec2(i, 0) * t * 1.4).rgb * 0.1;
	}

	c *= (1.0/10.0);


	float vf;
	{
		vec2 uv = p * (1.0 - p.yx);   //vec2(1.0)- uv.yx; -> 1.-u.yx; Thanks FabriceNeyret !
	    vf = uv.x * uv.y * 15.0; // multiply with sth for intensity
		vf = pow(vf, 0.25); // change pow for modifying the extend of the  vignette
	}

	//float vf_blur = min(1.0, vf + 0.2);
	//vec4 c_blur = blur(p, max(0.0, 2.0 - vf_blur * 2.0));
	//c = c_blur;
	c = c * vf;

	//c *= 0.5;
	outColor = max(vec4(0.0), c * (1.0 + m * params.param_color1));
	//outColor = clamp(c * (m + 1.0), vec4(0.0), vec4(1.0));
	//outColor.a = 0.0;
}



