// This is probably the most important uniform, transforming a model-space
// coordinate into a clip-space (ie. relative to the window) coordinate.  This
// is usually used in the vertex shader to transform p3d_Vertex and store the
// result in gl_Position.
uniform mat4 p3d_ModelViewProjectionMatrix;

// These are parts of the above matrix.
uniform mat4 p3d_ModelViewMatrix;
uniform mat4 p3d_ProjectionMatrix;
uniform mat4 p3d_ModelMatrix;
uniform mat4 p3d_ViewMatrix;
uniform mat4 p3d_ViewProjectionMatrix;

// This is the upper 3x3 of the inverse transpose of the ModelViewMatrix.  It is
// used to transform the normal vector into view-space coordinates.
uniform mat3 p3d_NormalMatrix;

// It's possible to append Inverse, Transpose, or InverseTranspose to any of the
// above matrix names to get an inverse and/or transpose version of that matrix:
uniform mat4 p3d_ProjectionMatrixInverse;
uniform mat4 p3d_ProjectionMatrixTranspose;
uniform mat4 p3d_ModelViewMatrixInverseTranspose;

// These access the Nth texture applied to the model.  The index matches up with
// the index used by p3d_MultiTexCoordN, p3d_TangentN, and p3d_BinormalN.
// The sampler type should be adjusted to match the type of the texture.
uniform sampler2D p3d_Texture0;
uniform sampler2D p3d_Texture1;
uniform sampler2D p3d_Texture2;
uniform sampler2D p3d_Texture3;
//uniform sampler2DArray p3d_Texture1;
//uniform sampler3D p3d_Texture2;
//uniform samplerCube p3d_Texture3;

//uniform sampler2D p3d_Texture4;

// As above, but "Shadow" should be appended if the texture has a shadow filter.
//uniform sampler2DShadow p3d_Texture0;

// Experimental inputs, new in 1.10.8, containing textures assigned using a
// particular TextureStage mode.  If no such texture has been assigned, a dummy
// texture is instead provided containing an appropriate default color.
uniform sampler2D p3d_TextureModulate[]; // default color: (1, 1, 1, 1)
uniform sampler2D p3d_TextureAdd[];      // default color: (0, 0, 0, 1)
uniform sampler2D p3d_TextureNormal[];   // default color: (0.5, 0.5, 1, 0)
uniform sampler2D p3d_TextureHeight[];   // default color: (0.5, 0.5, 1, 0)
uniform sampler2D p3d_TextureGloss[];    // default color: (1, 1, 1, 1)
uniform sampler2D p3d_TextureSelector[];

// New in 1.10.0.  Contains the matrix generated from texture pos and scale.
uniform mat4 p3d_TextureMatrix[];

// Access the color scale applied to the node.
uniform vec4 p3d_ColorScale;

// Access the material attributes assigned via a Material object.
// Unused struct parameters may be omitted without consequence.
uniform struct p3d_MaterialParameters {
  vec4 ambient;
  vec4 diffuse;
  vec4 emission;
  vec3 specular;
  float shininess;

  // These properties are new in 1.10.
  vec4 baseColor;
  float roughness;
  float metallic;
  float refractiveIndex;
} p3d_Material;

// The sum of all active ambient light colors.
uniform struct p3d_LightModelParameters {
  vec4 ambient;
} p3d_LightModel;

// Active clip planes, in apiview space.  If there is no clip plane for a given
// index, it is guaranteed to contain vec4(0, 0, 0, 0).
//uniform vec4 p3d_ClipPlane[...];

// Reports the frame time of the current frame, for animations.
uniform float osg_FrameTime;
// The time elapsed since the previous frame.
uniform float osg_DeltaFrameTime;
// New in 1.10.0. Contains the number of frames elapsed since program start.
uniform int osg_FrameNumber;

// If hardware skinning is enabled, this contains the transform of each joint.
// Superfluous array entries will contain the identity matrix.
//uniform mat4 p3d_TransformTable[...];

// New in 1.10.  Contains information for each non-ambient light.
// May also be used to access a light passed as a shader input.
uniform struct p3d_LightSourceParameters {
  // Primary light color.
  vec4 color;

  // Light color broken up into components, for compatibility with legacy
  // shaders.  These are now deprecated.
  vec4 ambient;
  vec4 diffuse;
  vec4 specular;

  // View-space position.  If w=0, this is a directional light, with the xyz
  // being -direction.
  vec4 position;

  // Spotlight-only settings
  vec3 spotDirection;
  float spotExponent;
  float spotCutoff;
  float spotCosCutoff;

  // Individual attenuation constants
  float constantAttenuation;
  float linearAttenuation;
  float quadraticAttenuation;

  // constant, linear, quadratic attenuation in one vector
  vec3 attenuation;

  // Shadow map for this light source
  sampler2DShadow shadowMap;
//  samplerCube shadowMap;

  // Transforms view-space coordinates to shadow map coordinates
  mat4 shadowViewMatrix;
} p3d_LightSource[MAX_LIGHTS];

// New in 1.10.  Contains fog state.
uniform struct p3d_FogParameters {
  vec4 color;
  float density;
  float start;
  float end;
  float scale; // 1.0 / (end - start)
} p3d_Fog;