#version 410


#pragma include "vertex.glsl"
#pragma include "spect.glsl"
#pragma include "effects.glsl"
#pragma include "colors.glsl"


#define Q0 0.0
#define Q1 HALF_PI
#define Q2 PI
#define Q3 3.0 * HALF_PI

//uniform float u_Alpha;  // Alpha effect

uniform float u_Accommodation;  // Accommodation effect
uniform float u_Blue;  // Blue effect
uniform bool u_Cool;
uniform bool u_CCC;
uniform float u_Alpha;
uniform bool u_Curvature;

void main() {

    BEGIN;

//    vertPosition = (p3d_Vertex + vec4(u_VertPositionOffset, 0.0)) * u_Scale;
//    vertColor = p3d_Color;


//    vertPosition *= 2.0;

//    vertPosition = p3d_Vertex;

//    vertColor = p3d_Color;
//    vertColor = vec4(vec3(brightness(vertColor.rgb)), 1.0);
//    vertColor = vec4(0.4, 0.0, 0.0, 1.0);
//    vertColor = vec4(1.0);
//    vertColor = vec4(vec3(length(vertMultiTexCoord0) * 10.), 1.0); // Default color

//    vertColor.a = u_Alpha;


//    vertPosition *= 20.;
//    vertPosition.z -= length(vertPosition.xy) * 0.2;

//    vertColor.rgb = vec3(1.0) * 2.0; // Default color


    if (u_Curvature) {
        #define CURVATURE_RADIUS 1.4
        float r = length(vertPosition.xy);
        vertPosition.z += sqrt(max(0.0, CURVATURE_RADIUS * CURVATURE_RADIUS - r * r)) - CURVATURE_RADIUS - 0.010;
    }


    END_TRIANGLE;

    vertColor.rgb = vec3(1.0); // Default color
    vertColor.a = u_CCC ? smoothstep(-0.5, 0.5, p3d_Vertex.x) * u_Alpha : 1.0;

    vec3 eyeColor = u_Cool ? COOL : AMBER_ORANGE;

    if (u_Accommodation > 0.0) {
        vec2 centCoord = vertMultiTexCoord0 - 0.5;
        float r = length(centCoord);
        vertMultiTexCoord0 = centCoord * (1.0 + smoothstep(0.261, 0.0, r) * u_Accommodation * 0.5) + 0.5;
        vertColor.rgb = mix(vec3(1.0), 1.0 * eyeColor, smoothstep(0.261, 0.1, r) * u_Blue * 1.0);
    }



    // Transform the vertex position by the Model-View matrix
    vertNormal = normalize(p3d_NormalMatrix * p3d_Normal);
    tangent = normalize(p3d_NormalMatrix * p3d_Tangent);
//    binormal = normalize(p3d_NormalMatrix * p3d_Binormal);
    binormal = cross(vertNormal, tangent);
}
