; Vintage Computing Christmas Challenge 2025 - v1c
; Jose Moreno Prieto 'Xeleh' - 05/12/2025

main:
            org     100h
            mov     bl,-9           ; initial row
.row        mov     dl,-9           ; initial column
.col        cmp     dl,9            ; right side overflow?
            jg      .space          ; yes -> print space
            mov     al,bl           ; al = row
            mul     bl              ; al = row * row
            je      .star           ; if central row -> print * char
            mov     cl,al           ; cl = row * row
            mov     al,dl           ; al = column
            mul     dl              ; al = column * column
            je      .star           ; if central column -> print * char
            mov     ah,al           ; ah = column * column
            add     al,cl           ; al = (col * col) + (row * row)
            js      .space          ; if diagonal excedent -> print space
            cmp     cl,ah           ; diagonal?
            je      .star           ; yes -> print * char
            mov     di,data         ; set data pointer
            mov     cl,end-data     ; set data length
            repne   scasb           ; find determinant in data
            je      .star           ; found? -> print * char
.space      mov     al,' '          ; space char
            jmp     .print          ; print
.star       mov     al,'*'          ; '*' char
.print      int     29h             ; print char in al
            inc     dx              ; next column
            cmp     dl,80-9         ; end column?
            jne     .col            ; no -> loop
            inc     bx              ; next row
            cmp     bl,9+1          ; end row?
            jne     .row            ; no -> loop

%ifdef      debug
            waitkey
            ret
%endif

data        db      17,29,50,61,68,74
end: