org   16514   
        ds   127,$55	; filler of $55, untouched by code
bitmap:                 ; Prefix the code with the bitmap data
        defb   $fd,$ae,$cf,$8d,$f6,$fb,$6d,$b6
start:              	
        push bc     	; At startup “start” is in BC, so C = 9
        pop hl      	; copy BC to HL, use as bitmap pointer
col:
        ld b, 9     	; start each col on the 9th row, and first
rotate:			; plot 4 asterisks
        push hl     	; save HL as it gets used to print
        push bc     	; save BC as it gets destroyed 
        call $8f5   	; point HL at (col C, row B)
        pop bc      	; retrieve BC
        ld a, 18     	; load rotation constant
        cp (hl)     	; use it to check if all 4 plots are done
        ld (hl), 23  	; plot a *
        pop hl      	; retrieve HL
        jr c, xloop 	; if all 4 plots already done, x-it the loop
        sub b       	; otherwise A = 18-B
        ld b,c      	; B = C and
        ld c,a      	; C = 18-B => rotate 90º clockwise
        ret z	 	; If col = 0 then exit
check:
        jr nc, rotate  	; if bit clear then plot it
xloop:
        srl (hl)    	; grab 1 bit from bitmap
        djnz check	; use this bit for next row, until we run out
        dec c       	; otherwise, move on to next col
        dec hl      	; iterate bitmap pointer
        jr col      	; print the next col and its rotations
end: