; Snowflake VCCC 2025 : http://logiker.com/Vintage-Computing-Christmas-Challenge-2025
; Andre Miller - 69 bytes [C64 PRG = 73 bytes, minus 2 bytes for load address and minus 2 bytes for autorun vector]

* = $032c              ; CLALL vector - for autorun, two bytes not part of code
    !word entry

zp_pat = $fb            ; zero page variable - store byte of bitmap (one byte per half row)
zp_lc  = $fe            ; zero page variable - counter for left side of row
zp_rc  = $ff            ; zero page variable - counter for right side of row
SCRPTR = $d1            ; pointer to memory address of current screen line
CRLF   = $aad7          ; kernal routine to print CR/LF

entry:
    ldx #18             ; loop counter (19 rows)
row:                    ; loop through rows in bitmap array
    lda bitmap,x        ; load and store bitmap pattern for one side
    sta zp_pat
    cmp #$FF            ; special case, if this is middle horizontal row, draw a * at the edge
    php                 ; push flags for 'edge'
    sec                 ; set carry, first character (center column) is always *
    php                 ; push flags on stack for center column
    lda #9              ; init left and right counters
    sta zp_lc 
    sta zp_rc 
edge:                   ; pop carry for center first time through, then for edge
    plp
bitp:                   ; loop through bits, use carry flag to determine what should be printed
    lda #' '            ; default to printing space
    bcc +               
    lda #'*'            ; set to print * if carry is set
+   ldy zp_rc
    sta (SCRPTR),y      ; print right column, use screen pointer plus y offset
    ldy zp_lc
    sta (SCRPTR),y      ; print left column
    lsr zp_pat          ; shift next bit to set carry flag
    inc zp_rc           ; increment/dec column counters
    dec zp_lc
    beq edge            ; counter is 0, last bit, branch to edge
    bpl bitp            ; more bits, continue loop
    jsr CRLF            ; newline, dec counter, next row
    dex
    bpl row
    rts

bitmap:
    !byte $00, $02, $51, $30, $72, $09, $04, $92, $49, $FF
    !byte $49, $92, $04, $09, $72, $30, $51, $02, $00

