struct Uniforms {
    color: vec4<f32>,
    debug: f32,
}

@group(1) @binding(0) var<uniform> uniforms: Uniforms;
@group(1) @binding(1) var tex: texture_2d<f32>;
@group(1) @binding(2) var tex_sampler: sampler;

struct VertexOutput {
    @location(0) uv: vec2<f32>,
}

@fragment
fn main(input: VertexOutput) -> @location(0) vec4<f32> {
    if (uniforms.debug > 0.0) {
        let tex_sample = textureSample(tex, tex_sampler, input.uv).r;
        return vec4<f32>(uniforms.color.rgb * vec3<f32>(0.4, 0.0, 0.1), uniforms.color.a * tex_sample + 0.4);
    }
    let tex_sample = textureSample(tex, tex_sampler, input.uv).r;
    return vec4<f32>(uniforms.color.rgb, uniforms.color.a * tex_sample);
}