const WIDTH   = 1920;
const HEIGHT  = 1080;
const N_BYTES = WIDTH * HEIGHT * 4;

inline fn open(path: [*:0]const u8, flags: usize) usize {
    return asm volatile ("ecall"
        : [ret] "={a0}" (-> usize),
        : [_] "{a7}" (56),
          [_] "{a0}" (@as(usize, @intCast(-100))),
          [_] "{a1}" (path),
          [_] "{a2}" (flags),
    );
}

inline fn mmap(addr: ?*anyopaque, length: usize, prot: usize, flags: usize, fd: usize, offset: isize) ?*anyopaque {
    return asm volatile ("ecall"
        : [ret] "={a0}" (-> ?*anyopaque),
        : [_] "{a7}" (222),
          [_] "{a0}" (addr),
          [_] "{a1}" (length),
          [_] "{a2}" (prot),
          [_] "{a3}" (flags),
          [_] "{a4}" (fd),
          [_] "{a5}" (offset),
    );
}

inline fn exit(status: usize) noreturn {
    asm volatile ("ecall" ::
        [_] "{a7}" (93),
        [_] "{a0}" (status)
    );

    unreachable;
}

export fn draw() noreturn {
    //const fd = open("/dev/fb0", 2);
    const fd = asm ("" : [ret] "={a4}" (-> usize) : );
    const x1 = asm ("" : [ret] "={a3}" (-> usize) : );
    const x3 = asm ("" : [ret] "={a2}" (-> usize) : );

    const ptr = mmap(null, N_BYTES, x3, x1, fd, 0);
    const buf = @as([*]u8, @ptrCast(ptr));

    for (0..HEIGHT) |row| {
        for (0..WIDTH) |col| {
            const x: isize = @intCast(col);
            const y: isize = HEIGHT - @as(isize, @intCast(row));
            const u: isize = x + y - HEIGHT;
            const v: isize = x - y;
            const w: isize = u ^ v;
            const t: isize = @divTrunc(w * u, v) ^ w ^ x;
            const r: isize = if (@rem(t, 709) < w) 0xff else 0;
            const g: isize = if (@rem(t, 651) < w) 0xff else 0;
            const b: isize = r;

            const off = 4 * (col + WIDTH * row);
            buf[off+2] = @intCast(r);
            buf[off+1] = @intCast(g);
            buf[off+0] = @intCast(b);
        }
    }

    exit(0);
}
